/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.utilities.misc.Generated;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BooleanUtilities {
    private static final Logger LOG = LogManager.getLogger(BooleanUtilities.class);
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final ApplicationProperties APPLICATIONPROPERTIES;

    @Autowired
    public BooleanUtilities(LocalizationManager injectedLocalizationManager, ApplicationProperties injectedApplicationProperties) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
    }

    public boolean convertToBoolean(String stringBoolean) {
        if (stringBoolean.matches("[Tt]rue") || stringBoolean.matches("1") || stringBoolean.matches("[Yy]es") || stringBoolean.matches("[Yy]") || stringBoolean.matches(this.LOCALIZATIONMANAGER.getLocalizedString("cli.input.true")) || stringBoolean.matches(this.LOCALIZATIONMANAGER.getLocalizedString("cli.input.yes")) || stringBoolean.matches(this.LOCALIZATIONMANAGER.getLocalizedString("cli.input.yes.short"))) {
            return true;
        }
        if (stringBoolean.matches("[Ff]alse") || stringBoolean.matches("0") || stringBoolean.matches("[Nn]o") || stringBoolean.matches("[Nn]") || stringBoolean.matches(this.LOCALIZATIONMANAGER.getLocalizedString("cli.input.false")) || stringBoolean.matches(this.LOCALIZATIONMANAGER.getLocalizedString("cli.input.no")) || stringBoolean.matches(this.LOCALIZATIONMANAGER.getLocalizedString("cli.input.no.short"))) {
            return false;
        }
        LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.converttoboolean.warn"));
        return false;
    }

    @Generated
    public boolean readBoolean() {
        Scanner readerBoolean = new Scanner(System.in);
        String boolRead = readerBoolean.nextLine();
        return this.convertToBoolean(boolRead);
    }
}

