/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing;

import de.griefed.serverpackcreator.ApplicationPlugins;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ServerPackHandler;
import de.griefed.serverpackcreator.VersionLister;
import de.griefed.serverpackcreator.curseforge.CurseCreateModpack;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.plugins.swinggui.TabExtension;
import de.griefed.serverpackcreator.swing.MenuBar;
import de.griefed.serverpackcreator.swing.TabAddonsHandlerLog;
import de.griefed.serverpackcreator.swing.TabCreateServerPack;
import de.griefed.serverpackcreator.swing.TabModloaderInstallerLog;
import de.griefed.serverpackcreator.swing.TabServerPackCreatorLog;
import de.griefed.serverpackcreator.swing.themes.DarkTheme;
import de.griefed.serverpackcreator.swing.themes.LightTheme;
import de.griefed.serverpackcreator.swing.utilities.BackgroundPanel;
import de.griefed.serverpackcreator.utilities.BooleanUtilities;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.ListUtilities;
import de.griefed.serverpackcreator.utilities.StringUtilities;
import de.griefed.serverpackcreator.utilities.SystemUtilities;
import de.griefed.serverpackcreator.utilities.UpdateChecker;
import de.griefed.serverpackcreator.utilities.misc.Generated;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import mdlaf.MaterialLookAndFeel;
import mdlaf.components.textpane.MaterialTextPaneUI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Generated
public class SwingGuiInitializer
extends JPanel {
    private static final Logger LOG = LogManager.getLogger(SwingGuiInitializer.class);
    private final ImageIcon ICON_SERVERPACKCREATOR_BANNER = new ImageIcon(Objects.requireNonNull(SwingGuiInitializer.class.getResource("/de/griefed/resources/gui/banner.png")));
    private final Image ICON_SERVERPACKCREATOR = Toolkit.getDefaultToolkit().getImage(Objects.requireNonNull(SwingGuiInitializer.class.getResource("/de/griefed/resources/gui/app.png")));
    private final Dimension DIMENSION_WINDOW = new Dimension(1050, 800);
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final CurseCreateModpack CURSECREATEMODPACK;
    private final ServerPackHandler CREATESERVERPACK;
    private final VersionLister VERSIONLISTER;
    private final BooleanUtilities BOOLEANUTILITIES;
    private final ListUtilities LISTUTILITIES;
    private final StringUtilities STRINGUTILITIES;
    private final ConfigUtilities CONFIGUTILITIES;
    private final SystemUtilities SYSTEMUTILITIES;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ApplicationPlugins APPLICATIONPLUGINS;
    private final UpdateChecker UPDATECHECKER;
    private final LightTheme LIGHTTHEME = new LightTheme();
    private final DarkTheme DARKTHEME = new DarkTheme();
    private final MaterialLookAndFeel LAF_LIGHT = new MaterialLookAndFeel(this.LIGHTTHEME);
    private final MaterialLookAndFeel LAF_DARK = new MaterialLookAndFeel(this.DARKTHEME);
    private final BackgroundPanel BACKGROUNDPANEL;
    private final JFrame FRAME_SERVERPACKCREATOR;
    private final TabCreateServerPack TAB_CREATESERVERPACK;
    private final TabServerPackCreatorLog TAB_LOG_SERVERPACKCREATOR;
    private final TabModloaderInstallerLog TAB_LOG_MODLOADERINSTALLER;
    private final TabAddonsHandlerLog TAB_LOG_ADDONSHANDLER;
    private final JTabbedPane TABBEDPANE;
    private final MenuBar MENUBAR;
    private BufferedImage bufferedImage;

    public SwingGuiInitializer(LocalizationManager injectedLocalizationManager, ConfigurationHandler injectedConfigurationHandler, CurseCreateModpack injectedCurseCreateModpack, ServerPackHandler injectedServerPackHandler, ApplicationProperties injectedApplicationProperties, VersionLister injectedVersionLister, BooleanUtilities injectedBooleanUtilities, ListUtilities injectedListUtilities, StringUtilities injectedStringUtilities, ConfigUtilities injectedConfigUtilities, SystemUtilities injectedSystemUtilities, UpdateChecker injectedUpdateChecker, ApplicationPlugins injectedPluginManager) {
        super(new GridLayout(1, 1));
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        this.VERSIONLISTER = injectedVersionLister == null ? new VersionLister(this.APPLICATIONPROPERTIES) : injectedVersionLister;
        this.BOOLEANUTILITIES = injectedBooleanUtilities == null ? new BooleanUtilities(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES) : injectedBooleanUtilities;
        this.LISTUTILITIES = injectedListUtilities == null ? new ListUtilities() : injectedListUtilities;
        this.STRINGUTILITIES = injectedStringUtilities == null ? new StringUtilities() : injectedStringUtilities;
        this.SYSTEMUTILITIES = injectedSystemUtilities == null ? new SystemUtilities() : injectedSystemUtilities;
        this.CONFIGUTILITIES = injectedConfigUtilities == null ? new ConfigUtilities(this.LOCALIZATIONMANAGER, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.APPLICATIONPROPERTIES, this.STRINGUTILITIES, this.VERSIONLISTER) : injectedConfigUtilities;
        this.CURSECREATEMODPACK = injectedConfigurationHandler == null ? new CurseCreateModpack(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES, this.VERSIONLISTER, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.STRINGUTILITIES, this.CONFIGUTILITIES, this.SYSTEMUTILITIES) : injectedCurseCreateModpack;
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler == null ? new ConfigurationHandler(this.LOCALIZATIONMANAGER, this.CURSECREATEMODPACK, this.VERSIONLISTER, this.APPLICATIONPROPERTIES, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.STRINGUTILITIES, this.SYSTEMUTILITIES, this.CONFIGUTILITIES) : injectedConfigurationHandler;
        this.APPLICATIONPLUGINS = injectedPluginManager == null ? new ApplicationPlugins() : injectedPluginManager;
        this.CREATESERVERPACK = injectedServerPackHandler == null ? new ServerPackHandler(this.LOCALIZATIONMANAGER, this.CURSECREATEMODPACK, this.CONFIGURATIONHANDLER, this.APPLICATIONPROPERTIES, this.VERSIONLISTER, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.STRINGUTILITIES, this.SYSTEMUTILITIES, this.CONFIGUTILITIES, this.APPLICATIONPLUGINS) : injectedServerPackHandler;
        this.UPDATECHECKER = injectedUpdateChecker == null ? new UpdateChecker(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES) : injectedUpdateChecker;
        try {
            this.bufferedImage = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/de/griefed/resources/gui/tile.png")));
        }
        catch (IOException ex) {
            LOG.error("Could not read image for tiling.", (Throwable)ex);
        }
        this.FRAME_SERVERPACKCREATOR = new JFrame(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createandshowgui") + " - " + this.APPLICATIONPROPERTIES.getServerPackCreatorVersion());
        this.TAB_CREATESERVERPACK = new TabCreateServerPack(this.LOCALIZATIONMANAGER, this.CONFIGURATIONHANDLER, this.CURSECREATEMODPACK, this.CREATESERVERPACK, this.VERSIONLISTER, this.APPLICATIONPROPERTIES, this.FRAME_SERVERPACKCREATOR, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.STRINGUTILITIES, this.CONFIGUTILITIES, this.SYSTEMUTILITIES, this.APPLICATIONPLUGINS);
        this.TAB_LOG_SERVERPACKCREATOR = new TabServerPackCreatorLog(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES);
        this.TAB_LOG_MODLOADERINSTALLER = new TabModloaderInstallerLog(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES);
        this.TAB_LOG_ADDONSHANDLER = new TabAddonsHandlerLog(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES);
        this.BACKGROUNDPANEL = new BackgroundPanel(this.bufferedImage, 1, 0.0f, 0.0f);
        this.TABBEDPANE = new JTabbedPane(1);
        this.TABBEDPANE.addTab(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.createserverpack.title"), null, this.TAB_CREATESERVERPACK.createServerPackTab(), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.createserverpack.tip"));
        this.TABBEDPANE.setMnemonicAt(0, 49);
        this.TABBEDPANE.addTab(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.serverpackcreatorlog.title"), null, this.TAB_LOG_SERVERPACKCREATOR.create(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.serverpackcreatorlog.tooltip")), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.serverpackcreatorlog.tip"));
        this.TABBEDPANE.setMnemonicAt(1, 50);
        this.TABBEDPANE.addTab(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.modloaderinstallerlog.title"), null, this.TAB_LOG_MODLOADERINSTALLER.create(null), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.modloaderinstallerlog.tip"));
        this.TABBEDPANE.setMnemonicAt(2, 51);
        this.TABBEDPANE.addTab(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.addonshandlerlog.title"), null, this.TAB_LOG_ADDONSHANDLER.create(null), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.tabbedpane.addonshandlerlog.tip"));
        this.TABBEDPANE.setMnemonicAt(3, 52);
        if (this.APPLICATIONPLUGINS.PLUGINS_TABBEDPANE.size() > 0) {
            for (TabExtension pane : this.APPLICATIONPLUGINS.PLUGINS_TABBEDPANE) {
                this.TABBEDPANE.addTab(pane.getTabTitle(), pane.getTabIcon(), pane.getTab(), pane.getTabTooltip());
            }
        } else {
            LOG.info("No TabbedPane addons to add.");
        }
        this.add(this.TABBEDPANE);
        this.TABBEDPANE.setTabLayoutPolicy(1);
        this.MENUBAR = new MenuBar(this.LOCALIZATIONMANAGER, this.LIGHTTHEME, this.DARKTHEME, this.FRAME_SERVERPACKCREATOR, this.LAF_LIGHT, this.LAF_DARK, this.TAB_CREATESERVERPACK, this.TABBEDPANE, this.APPLICATIONPROPERTIES);
        this.FRAME_SERVERPACKCREATOR.setJMenuBar(this.MENUBAR.createMenuBar());
    }

    public void mainGUI() {
        SwingUtilities.invokeLater(() -> {
            try {
                if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.gui.darkmode").equals("true")) {
                    UIManager.setLookAndFeel(this.LAF_DARK);
                    MaterialLookAndFeel.changeTheme(this.DARKTHEME);
                } else {
                    UIManager.setLookAndFeel(this.LAF_LIGHT);
                    MaterialLookAndFeel.changeTheme(this.LIGHTTHEME);
                }
            }
            catch (UnsupportedLookAndFeelException ex) {
                LOG.error("Error: There was an error setting the look and feel.", (Throwable)ex);
            }
            this.createAndShowGUI();
        });
    }

    private void createAndShowGUI() {
        this.FRAME_SERVERPACKCREATOR.setDefaultCloseOperation(3);
        this.FRAME_SERVERPACKCREATOR.setContentPane(this.BACKGROUNDPANEL);
        this.FRAME_SERVERPACKCREATOR.setIconImage(this.ICON_SERVERPACKCREATOR);
        JLabel serverPackCreatorBanner = new JLabel(this.ICON_SERVERPACKCREATOR_BANNER);
        serverPackCreatorBanner.setOpaque(false);
        this.FRAME_SERVERPACKCREATOR.add((Component)serverPackCreatorBanner, "First");
        this.FRAME_SERVERPACKCREATOR.add((Component)this.TABBEDPANE, "Center");
        this.FRAME_SERVERPACKCREATOR.setSize(this.DIMENSION_WINDOW);
        this.FRAME_SERVERPACKCREATOR.setPreferredSize(this.DIMENSION_WINDOW);
        this.FRAME_SERVERPACKCREATOR.setMinimumSize(this.DIMENSION_WINDOW);
        this.FRAME_SERVERPACKCREATOR.setResizable(true);
        this.FRAME_SERVERPACKCREATOR.pack();
        SwingUtilities.updateComponentTreeUI(this.FRAME_SERVERPACKCREATOR);
        this.TABBEDPANE.setOpaque(true);
        this.FRAME_SERVERPACKCREATOR.setVisible(true);
        this.displayUpdateDialog();
    }

    private void displayUpdateDialog() {
        String updater = this.UPDATECHECKER.checkForUpdate(this.APPLICATIONPROPERTIES.getServerPackCreatorVersion(), this.APPLICATIONPROPERTIES.checkForAvailablePreReleases());
        if (updater.contains(";")) {
            String version = updater.split(";")[0];
            String url = updater.split(";")[1];
            String textContent = String.format(this.LOCALIZATIONMANAGER.getLocalizedString("update.dialog.new"), url);
            DefaultStyledDocument styledDocument = new DefaultStyledDocument();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            MaterialTextPaneUI materialTextPaneUI = new MaterialTextPaneUI();
            JTextPane jTextPane = new JTextPane(styledDocument);
            StyleConstants.setBold(simpleAttributeSet, true);
            StyleConstants.setFontSize(simpleAttributeSet, 14);
            jTextPane.setCharacterAttributes(simpleAttributeSet, true);
            StyleConstants.setAlignment(simpleAttributeSet, 0);
            styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
            jTextPane.addHierarchyListener(e1 -> {
                Dialog dialog;
                Window window = SwingUtilities.getWindowAncestor(jTextPane);
                if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                    dialog.setResizable(true);
                }
            });
            jTextPane.setOpaque(false);
            jTextPane.setEditable(false);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Object[] options = new String[]{this.LOCALIZATIONMANAGER.getLocalizedString("update.dialog.yes"), this.LOCALIZATIONMANAGER.getLocalizedString("update.dialog.no"), this.LOCALIZATIONMANAGER.getLocalizedString("update.dialog.clipboard")};
            try {
                styledDocument.insertString(0, textContent, simpleAttributeSet);
            }
            catch (BadLocationException ex) {
                LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
            }
            materialTextPaneUI.installUI(jTextPane);
            switch (JOptionPane.showOptionDialog(this.FRAME_SERVERPACKCREATOR, jTextPane, this.LOCALIZATIONMANAGER.getLocalizedString("update.dialog.available"), -1, 1, UIManager.getIcon("OptionPane.informationIcon"), options, options[0])) {
                case 0: {
                    try {
                        if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) break;
                        Desktop.getDesktop().browse(URI.create(url));
                    }
                    catch (IOException ex) {
                        LOG.error("Error opening browser.", (Throwable)ex);
                    }
                    break;
                }
                case 1: {
                    clipboard.setContents(new StringSelection(url), null);
                    break;
                }
            }
        }
    }
}

