/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.Main;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.swing.SwingGuiInitializer;
import de.griefed.serverpackcreator.swing.TabCreateServerPack;
import de.griefed.serverpackcreator.swing.themes.DarkTheme;
import de.griefed.serverpackcreator.swing.themes.LightTheme;
import de.griefed.serverpackcreator.utilities.misc.Generated;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import mdlaf.MaterialLookAndFeel;
import mdlaf.components.combobox.MaterialComboBoxUI;
import mdlaf.components.textfield.MaterialTextFieldUI;
import mdlaf.components.textpane.MaterialTextPaneUI;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.system.ApplicationHome;

@Generated
public class MenuBar
extends Component {
    private static final Logger LOG = LogManager.getLogger(MenuBar.class);
    private final ApplicationHome APPLICATIONHOME = new ApplicationHome(Main.class);
    private final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final LightTheme LIGHTTHEME;
    private final DarkTheme DARKTHEME;
    private final JFrame FRAME_SERVERPACKCREATOR;
    private final TabCreateServerPack TAB_CREATESERVERPACK;
    private final JTabbedPane TABBEDPANE;
    private final WindowEvent CLOSEEVENT;
    private final MaterialLookAndFeel LAF_DARK;
    private final MaterialLookAndFeel LAF_LIGHT;
    private final Dimension CHOOSERDIMENSION = new Dimension(750, 450);
    private final Dimension JAVAARGSDIMENSION = new Dimension(750, 25);
    private final Dimension ABOUTDIMENSION = new Dimension(925, 520);
    private final Dimension FILETOOLARGEDIMENSION = new Dimension(200, 10);
    private final Dimension HELPDIMENSION = new Dimension(750, 300);
    private final ImageIcon HELPICON = new ImageIcon(Objects.requireNonNull(SwingGuiInitializer.class.getResource("/de/griefed/resources/gui/help.png")));
    private final ImageIcon ICON_HASTEBIN = new ImageIcon(Objects.requireNonNull(SwingGuiInitializer.class.getResource("/de/griefed/resources/gui/hastebin.png")));
    private final JMenuBar MENUBAR = new JMenuBar();
    private final String HELPWINDOWTEXT;
    private final String ABOUTWINDOWTEXT;
    private final String FILETOOLARGETEXT;
    private final String FILETOOLARGETITLE;
    private final String[] JAVAARGSOPTIONS = new String[4];
    private final String[] JAVAARGSSELECTIONS = new String[2];
    private final String[] HASTEOPTIONS = new String[3];
    private final String[] HELPTEXTS = new String[13];
    private final String[] HELPSELECTIONS = new String[13];
    private final JTextField JAVAARGS = new JTextField();
    private final StyledDocument HELPWINDOWDOCUMENT = new DefaultStyledDocument();
    private final StyledDocument ABOUTWINDOWDOCUMENT = new DefaultStyledDocument();
    private final StyledDocument CONFIGWINDOWDOCUMENT = new DefaultStyledDocument();
    private final StyledDocument SPCLOGWINDOWDOCUMENT = new DefaultStyledDocument();
    private final StyledDocument FILETOOLARGEWINDOWDOCUMENT = new DefaultStyledDocument();
    private final SimpleAttributeSet ABOUTATTRIBUTESET = new SimpleAttributeSet();
    private final SimpleAttributeSet HELPATTRIBUTESET = new SimpleAttributeSet();
    private final SimpleAttributeSet CONFIGATTRIBUTESET = new SimpleAttributeSet();
    private final SimpleAttributeSet SPCLOGATTRIBUTESET = new SimpleAttributeSet();
    private final SimpleAttributeSet FILETOOLARGEATTRIBUTESET = new SimpleAttributeSet();
    private final JTextPane HELPWINDOWTEXTPANE = new JTextPane(this.HELPWINDOWDOCUMENT);
    private final JTextPane ABOUTWINDOWTEXTPANE = new JTextPane(this.ABOUTWINDOWDOCUMENT);
    private final JTextPane CONFIGWINDOWTEXTPANE = new JTextPane(this.CONFIGWINDOWDOCUMENT);
    private final JTextPane SPCLOGWINDOWTEXTPANE = new JTextPane(this.SPCLOGWINDOWDOCUMENT);
    private final JTextPane FILETOOLARGEWINDOWTEXTPANE = new JTextPane();
    private final MaterialTextPaneUI MATERIALTEXTPANEUI = new MaterialTextPaneUI();
    private final MaterialTextFieldUI MATERIALTEXTFIELDUI = new MaterialTextFieldUI();
    private final MaterialComboBoxUI MATERIALCOMBOBOXUI = new MaterialComboBoxUI();
    private final JTextArea HELPTEXTAREA = new JTextArea();
    private final JPanel HELPPANEL = new JPanel();
    private boolean isDarkTheme;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu viewMenu;
    private JMenu aboutMenu;
    private JMenuItem file_NewConfigurationMenuItem;
    private JMenuItem file_LoadConfigMenuItem;
    private JMenuItem file_SaveConfigMenuItem;
    private JMenuItem file_SaveAsConfigMenuItem;
    private JMenuItem file_UploadConfigurationToHasteBin;
    private JMenuItem file_UploadServerPackCreatorLogToHasteBin;
    private JMenuItem file_ExitConfigMenuItem;
    private JMenuItem edit_SwitchTheme;
    private JMenuItem edit_ChangeJavaArgs;
    private JMenuItem edit_OpenInEditorServerProperties;
    private JMenuItem edit_OpenInEditorServerIcon;
    private JMenuItem view_OpenServerPackCreatorDirectoryMenuItem;
    private JMenuItem view_OpenServerPacksDirectoryMenuItem;
    private JMenuItem view_OpenServerFilesDirectoryMenuItem;
    private JMenuItem view_OpenAddonsDirectoryMenuItem;
    private JMenuItem view_ExampleAddonRepositoryMenuItem;
    private JMenuItem about_OpenAboutWindowMenuItem;
    private JMenuItem about_OpenGitHubPageMenuItem;
    private JMenuItem about_OpenGitHubIssuesPageMenuItem;
    private JMenuItem about_OpenDonationsPageMenuItem;
    private JMenuItem about_OpenReleasesPageMenuItem;
    private JMenuItem about_OpenDiscordLinkMenuItem;
    private JMenuItem help_OpenHelpWindowMenuItem;
    private JFileChooser configChooser;
    private DefaultComboBoxModel<String> helpComboBoxModel;
    private JComboBox<String> helpComboBox;
    private File lastLoadedConfigurationFile = null;

    public MenuBar(LocalizationManager injectedLocalizationManager, LightTheme injectedLightTheme, DarkTheme injectedDarkTheme, JFrame injectedJFrame, MaterialLookAndFeel injectedLAF_Light, MaterialLookAndFeel injectedLAF_Dark, TabCreateServerPack injectedTabCreateServerPack, JTabbedPane injectedTabbedPane, ApplicationProperties injectedApplicationProperties) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        this.LIGHTTHEME = injectedLightTheme;
        this.DARKTHEME = injectedDarkTheme;
        this.FRAME_SERVERPACKCREATOR = injectedJFrame;
        this.LAF_LIGHT = injectedLAF_Light;
        this.LAF_DARK = injectedLAF_Dark;
        this.TAB_CREATESERVERPACK = injectedTabCreateServerPack;
        this.TABBEDPANE = injectedTabbedPane;
        try {
            this.isDarkTheme = Boolean.parseBoolean(this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.gui.darkmode"));
        }
        catch (NullPointerException ex) {
            LOG.error("No setting for darkmode found in properties-file. Using true.");
            this.isDarkTheme = true;
            this.APPLICATIONPROPERTIES.put("de.griefed.serverpackcreator.gui.darkmode", "true");
        }
        this.CLOSEEVENT = new WindowEvent(this.FRAME_SERVERPACKCREATOR, 201);
        this.ABOUTWINDOWTEXT = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.about.text");
        this.ABOUTWINDOWTEXTPANE.setEditable(false);
        this.ABOUTWINDOWTEXTPANE.setOpaque(false);
        this.ABOUTWINDOWTEXTPANE.setMinimumSize(this.ABOUTDIMENSION);
        this.ABOUTWINDOWTEXTPANE.setPreferredSize(this.ABOUTDIMENSION);
        this.ABOUTWINDOWTEXTPANE.setMaximumSize(this.ABOUTDIMENSION);
        StyleConstants.setBold(this.ABOUTATTRIBUTESET, true);
        StyleConstants.setFontSize(this.ABOUTATTRIBUTESET, 14);
        this.ABOUTWINDOWTEXTPANE.setCharacterAttributes(this.ABOUTATTRIBUTESET, true);
        StyleConstants.setAlignment(this.ABOUTATTRIBUTESET, 1);
        this.ABOUTWINDOWDOCUMENT.setParagraphAttributes(0, this.ABOUTWINDOWDOCUMENT.getLength(), this.ABOUTATTRIBUTESET, false);
        try {
            this.ABOUTWINDOWDOCUMENT.insertString(0, this.ABOUTWINDOWTEXT, this.ABOUTATTRIBUTESET);
        }
        catch (BadLocationException ex) {
            LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
        }
        this.ABOUTWINDOWTEXTPANE.addHierarchyListener(e1 -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.ABOUTWINDOWTEXTPANE);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
        this.HELPWINDOWTEXT = String.format("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s", this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.modpackdir"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.clientsidemods"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.directories"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.pathtojava"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.minecraftversion"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.modloader"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.modloaderversion"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.installserver"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.copypropertires"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.copyicon"), this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.createzip"));
        this.HELPWINDOWTEXTPANE.setEditable(false);
        this.HELPWINDOWTEXTPANE.setOpaque(false);
        StyleConstants.setBold(this.HELPATTRIBUTESET, true);
        StyleConstants.setFontSize(this.HELPATTRIBUTESET, 14);
        this.HELPWINDOWTEXTPANE.setCharacterAttributes(this.HELPATTRIBUTESET, true);
        StyleConstants.setAlignment(this.HELPATTRIBUTESET, 0);
        this.HELPWINDOWDOCUMENT.setParagraphAttributes(0, this.HELPWINDOWDOCUMENT.getLength(), this.HELPATTRIBUTESET, false);
        try {
            this.HELPWINDOWDOCUMENT.insertString(0, this.HELPWINDOWTEXT, this.HELPATTRIBUTESET);
        }
        catch (BadLocationException ex) {
            LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
        }
        this.HELPWINDOWTEXTPANE.addHierarchyListener(e1 -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.HELPWINDOWTEXTPANE);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
        this.HASTEOPTIONS[0] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.about.hastebin.dialog.yes");
        this.HASTEOPTIONS[1] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.about.hastebin.dialog.clipboard");
        this.HASTEOPTIONS[2] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.about.hastebin.dialog.no");
        this.CONFIGWINDOWTEXTPANE.setOpaque(false);
        this.CONFIGWINDOWTEXTPANE.setEditable(false);
        StyleConstants.setBold(this.CONFIGATTRIBUTESET, true);
        StyleConstants.setFontSize(this.CONFIGATTRIBUTESET, 14);
        this.CONFIGWINDOWTEXTPANE.setCharacterAttributes(this.CONFIGATTRIBUTESET, true);
        StyleConstants.setAlignment(this.CONFIGATTRIBUTESET, 0);
        this.CONFIGWINDOWDOCUMENT.setParagraphAttributes(0, this.CONFIGWINDOWDOCUMENT.getLength(), this.CONFIGATTRIBUTESET, false);
        this.CONFIGWINDOWTEXTPANE.addHierarchyListener(e1 -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.CONFIGWINDOWTEXTPANE);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
        this.SPCLOGWINDOWTEXTPANE.setOpaque(false);
        this.SPCLOGWINDOWTEXTPANE.setEditable(false);
        StyleConstants.setBold(this.SPCLOGATTRIBUTESET, true);
        StyleConstants.setFontSize(this.SPCLOGATTRIBUTESET, 14);
        this.SPCLOGWINDOWTEXTPANE.setCharacterAttributes(this.SPCLOGATTRIBUTESET, true);
        StyleConstants.setAlignment(this.SPCLOGATTRIBUTESET, 0);
        this.SPCLOGWINDOWDOCUMENT.setParagraphAttributes(0, this.SPCLOGWINDOWDOCUMENT.getLength(), this.SPCLOGATTRIBUTESET, false);
        this.SPCLOGWINDOWTEXTPANE.addHierarchyListener(e1 -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.SPCLOGWINDOWTEXTPANE);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
        this.FILETOOLARGETEXT = this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.filetoolarge");
        this.FILETOOLARGETITLE = this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.filetoolargetitle");
        this.FILETOOLARGEWINDOWTEXTPANE.setOpaque(false);
        this.FILETOOLARGEWINDOWTEXTPANE.setEditable(false);
        this.FILETOOLARGEWINDOWTEXTPANE.setMinimumSize(this.FILETOOLARGEDIMENSION);
        this.FILETOOLARGEWINDOWTEXTPANE.setPreferredSize(this.FILETOOLARGEDIMENSION);
        this.FILETOOLARGEWINDOWTEXTPANE.setMaximumSize(this.FILETOOLARGEDIMENSION);
        StyleConstants.setBold(this.FILETOOLARGEATTRIBUTESET, true);
        StyleConstants.setFontSize(this.FILETOOLARGEATTRIBUTESET, 14);
        this.FILETOOLARGEWINDOWTEXTPANE.setCharacterAttributes(this.FILETOOLARGEATTRIBUTESET, true);
        StyleConstants.setAlignment(this.FILETOOLARGEATTRIBUTESET, 0);
        this.FILETOOLARGEWINDOWDOCUMENT.setParagraphAttributes(0, this.FILETOOLARGEWINDOWDOCUMENT.getLength(), this.FILETOOLARGEATTRIBUTESET, false);
        try {
            this.FILETOOLARGEWINDOWDOCUMENT.insertString(0, this.FILETOOLARGETEXT, this.FILETOOLARGEATTRIBUTESET);
        }
        catch (BadLocationException ex) {
            LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
        }
        this.FILETOOLARGEWINDOWTEXTPANE.addHierarchyListener(e1 -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.FILETOOLARGEWINDOWTEXTPANE);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
        this.JAVAARGSOPTIONS[0] = this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.javaargs.ok");
        this.JAVAARGSOPTIONS[1] = this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.javaargs.aikar");
        this.JAVAARGSOPTIONS[2] = this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.javaargs.empty");
        this.JAVAARGSOPTIONS[3] = this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.javaargs.cancel");
        this.JAVAARGSSELECTIONS[0] = "empty";
        this.JAVAARGSSELECTIONS[1] = "-Xms4G -Xmx4G -XX:+UseG1GC -XX:+ParallelRefProcEnabled -XX:MaxGCPauseMillis=200 -XX:+UnlockExperimentalVMOptions -XX:+DisableExplicitGC -XX:+AlwaysPreTouch -XX:G1HeapWastePercent=5 -XX:G1MixedGCCountTarget=4 -XX:G1MixedGCLiveThresholdPercent=90 -XX:G1RSetUpdatingPauseTimePercent=5 -XX:SurvivorRatio=32 -XX:+PerfDisableSharedMem -XX:MaxTenuringThreshold=1 -XX:G1NewSizePercent=30 -XX:G1MaxNewSizePercent=40 -XX:G1HeapRegionSize=8M -XX:G1ReservePercent=20 -XX:InitiatingHeapOccupancyPercent=15 -Dusing.aikars.flags=https://mcflags.emc.gs -Daikars.new.flags=true";
        this.JAVAARGS.setMinimumSize(this.JAVAARGSDIMENSION);
        this.JAVAARGS.setMaximumSize(this.JAVAARGSDIMENSION);
        this.JAVAARGS.setPreferredSize(this.JAVAARGSDIMENSION);
        this.HELPTEXTS[0] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.modpackdir");
        this.HELPTEXTS[1] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.clientsidemods");
        this.HELPTEXTS[2] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.directories");
        this.HELPTEXTS[3] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.pathtojava");
        this.HELPTEXTS[4] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.minecraftversion");
        this.HELPTEXTS[5] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.modloader");
        this.HELPTEXTS[6] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.modloaderversion");
        this.HELPTEXTS[7] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.installserver");
        this.HELPTEXTS[8] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.copypropertires");
        this.HELPTEXTS[9] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.copyicon");
        this.HELPTEXTS[10] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.createzip");
        this.HELPTEXTS[11] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.javaargs");
        this.HELPSELECTIONS[0] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.labelmodpackdir");
        this.HELPSELECTIONS[1] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.labelclientmods");
        this.HELPSELECTIONS[2] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.labelcopydirs");
        this.HELPSELECTIONS[3] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.labeljavapath");
        this.HELPSELECTIONS[4] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.labelminecraft");
        this.HELPSELECTIONS[5] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.labelmodloader");
        this.HELPSELECTIONS[6] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.labelmodloaderversion");
        this.HELPSELECTIONS[7] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.checkboxserver");
        this.HELPSELECTIONS[8] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.checkboxproperties");
        this.HELPSELECTIONS[9] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.checkboxicon");
        this.HELPSELECTIONS[10] = this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.checkboxzip");
        this.HELPSELECTIONS[11] = this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.javaargs");
        this.HELPTEXTAREA.setEditable(false);
        this.HELPPANEL.setLayout(new BoxLayout(this.HELPPANEL, 1));
        this.HELPPANEL.setMinimumSize(this.HELPDIMENSION);
        this.HELPPANEL.setPreferredSize(this.HELPDIMENSION);
        this.HELPPANEL.setMaximumSize(this.HELPDIMENSION);
    }

    public JMenuBar createMenuBar() {
        this.fileMenu = new JMenu(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menu.file"));
        this.editMenu = new JMenu(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menu.edit"));
        this.viewMenu = new JMenu(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menu.view"));
        this.aboutMenu = new JMenu(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menu.about"));
        this.help_OpenHelpWindowMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menu.help"));
        this.file_NewConfigurationMenuItem = new JMenuItem("New configuration");
        this.file_LoadConfigMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.loadconfig"));
        this.file_SaveConfigMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.saveconfig"));
        this.file_SaveAsConfigMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.saveas"));
        this.file_UploadConfigurationToHasteBin = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.uploadconfig"));
        this.file_UploadServerPackCreatorLogToHasteBin = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.uploadlog"));
        this.file_ExitConfigMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.exit"));
        this.edit_SwitchTheme = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.theme"));
        this.edit_ChangeJavaArgs = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.javaargs"));
        this.edit_OpenInEditorServerProperties = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.serverproperties"));
        this.edit_OpenInEditorServerIcon = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.servericon"));
        this.view_OpenAddonsDirectoryMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.addonsdir"));
        this.view_ExampleAddonRepositoryMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.exampleaddonrepo"));
        this.view_OpenServerPackCreatorDirectoryMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.spcdir"));
        this.view_OpenServerPacksDirectoryMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.serverpacksdir"));
        this.view_OpenServerFilesDirectoryMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.serverfilesdir"));
        this.about_OpenAboutWindowMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.about"));
        this.about_OpenGitHubPageMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.repository"));
        this.about_OpenGitHubIssuesPageMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.issues"));
        this.about_OpenReleasesPageMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.releases"));
        this.about_OpenDiscordLinkMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.discord"));
        this.about_OpenDonationsPageMenuItem = new JMenuItem(this.LOCALIZATIONMANAGER.getLocalizedString("menubar.gui.menuitem.donate"));
        this.file_NewConfigurationMenuItem.addActionListener(this::actionEventNewConfiguration);
        this.file_LoadConfigMenuItem.addActionListener(this::actionEventLoadConfigurationFromFileMenuItem);
        this.file_SaveConfigMenuItem.addActionListener(this::actionEventSaveConfigToFileMenuItem);
        this.file_SaveAsConfigMenuItem.addActionListener(this::actionEventSaveAsConfigToFileMenuItem);
        this.file_UploadConfigurationToHasteBin.addActionListener(this::actionEventUploadConfigurationToHasteBinMenuItem);
        this.file_UploadServerPackCreatorLogToHasteBin.addActionListener(this::actionEventUploadServerPackCreatorLogToHasteBinMenuItem);
        this.file_ExitConfigMenuItem.addActionListener(this::actionEventExitMenuItem);
        this.edit_SwitchTheme.addActionListener(this::actionEventSwitchThemeMenuItem);
        this.edit_ChangeJavaArgs.addActionListener(this::actionEventChangeJavaArgsMenuItem);
        this.edit_OpenInEditorServerProperties.addActionListener(this::actionEventOpenInEditorServerProperties);
        this.edit_OpenInEditorServerIcon.addActionListener(this::actionEventOpenServerIcon);
        this.view_OpenServerPackCreatorDirectoryMenuItem.addActionListener(this::actionEventOpenSPCDirectoryMenuItem);
        this.view_OpenServerPacksDirectoryMenuItem.addActionListener(this::actionEventOpenServerPacksDirectoryMenuItem);
        this.view_OpenServerFilesDirectoryMenuItem.addActionListener(this::actionEventOpenServerFilesDirectoryMenuItem);
        this.view_OpenAddonsDirectoryMenuItem.addActionListener(this::actionEventOpenAddonsDirectoryMenuItem);
        this.view_ExampleAddonRepositoryMenuItem.addActionListener(this::actionEventViewExampleAddonMenuItem);
        this.about_OpenAboutWindowMenuItem.addActionListener(this::actionEventOpenAboutSPCMenuItem);
        this.about_OpenGitHubPageMenuItem.addActionListener(this::actionEventOpenGitHubMenuItem);
        this.about_OpenGitHubIssuesPageMenuItem.addActionListener(this::actionEventOpenIssuesMenuItem);
        this.about_OpenReleasesPageMenuItem.addActionListener(this::actionEventOpenReleaseMenuItem);
        this.about_OpenDiscordLinkMenuItem.addActionListener(this::actionEventOpenDiscordLinkMenuItem);
        this.about_OpenDonationsPageMenuItem.addActionListener(this::actionEventOpenDonateMenuItem);
        this.help_OpenHelpWindowMenuItem.addActionListener(this::actionEventOpenHelpMenuItem);
        this.helpComboBoxModel = new DefaultComboBoxModel<String>(this.HELPSELECTIONS);
        this.helpComboBox = new JComboBox<String>(this.helpComboBoxModel);
        this.helpComboBox.setSelectedIndex(0);
        this.HELPTEXTAREA.setText(this.HELPTEXTS[0]);
        this.HELPPANEL.add(this.HELPTEXTAREA);
        this.HELPPANEL.add(this.helpComboBox);
        this.helpComboBox.addActionListener(this::actionEventSetHelpText);
        this.fileMenu.add(this.file_NewConfigurationMenuItem);
        this.fileMenu.add(this.file_LoadConfigMenuItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.file_SaveConfigMenuItem);
        this.fileMenu.add(this.file_SaveAsConfigMenuItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.file_UploadConfigurationToHasteBin);
        this.fileMenu.add(this.file_UploadServerPackCreatorLogToHasteBin);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.file_ExitConfigMenuItem);
        this.editMenu.add(this.edit_ChangeJavaArgs);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.edit_OpenInEditorServerProperties);
        this.editMenu.add(this.edit_OpenInEditorServerIcon);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.edit_SwitchTheme);
        this.viewMenu.add(this.view_OpenServerPackCreatorDirectoryMenuItem);
        this.viewMenu.add(this.view_OpenServerPacksDirectoryMenuItem);
        this.viewMenu.add(this.view_OpenServerFilesDirectoryMenuItem);
        this.viewMenu.add(this.view_OpenAddonsDirectoryMenuItem);
        this.viewMenu.add(new JSeparator());
        this.viewMenu.add(this.view_ExampleAddonRepositoryMenuItem);
        this.aboutMenu.add(this.about_OpenAboutWindowMenuItem);
        this.aboutMenu.add(new JSeparator());
        this.aboutMenu.add(this.about_OpenGitHubPageMenuItem);
        this.aboutMenu.add(this.about_OpenGitHubIssuesPageMenuItem);
        this.aboutMenu.add(this.about_OpenReleasesPageMenuItem);
        this.aboutMenu.add(new JSeparator());
        this.aboutMenu.add(this.about_OpenDiscordLinkMenuItem);
        this.aboutMenu.add(new JSeparator());
        this.aboutMenu.add(this.about_OpenDonationsPageMenuItem);
        this.MENUBAR.add(this.fileMenu);
        this.MENUBAR.add(this.editMenu);
        this.MENUBAR.add(this.viewMenu);
        this.MENUBAR.add(this.aboutMenu);
        this.MENUBAR.add(this.help_OpenHelpWindowMenuItem);
        return this.MENUBAR;
    }

    private void actionEventNewConfiguration(ActionEvent actionEvent) {
        LOG.debug("Clearing GUI...");
        this.TAB_CREATESERVERPACK.clearInterface();
        this.lastLoadedConfigurationFile = null;
    }

    private void actionEventOpenDiscordLinkMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Join Discord.");
        try {
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(URI.create("https://discord.griefed.de"));
            }
        }
        catch (IOException ex) {
            LOG.error("Error opening browser.", (Throwable)ex);
        }
    }

    private void actionEventOpenIssuesMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Open Issues page on GitHub.");
        try {
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(URI.create("https://github.com/Griefed/ServerPackCreator/issues"));
            }
        }
        catch (IOException ex) {
            LOG.error("Error opening browser.", (Throwable)ex);
        }
    }

    private void actionEventUploadServerPackCreatorLogToHasteBinMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Upload ServerPackCreator Log to HasteBin.");
        if (this.checkFileSize(new File("logs/serverpackcreator.log"))) {
            String urltoHasteBin = this.createHasteBinFromFile(new File("logs/serverpackcreator.log"));
            String textContent = String.format("URL: %s", urltoHasteBin);
            try {
                this.SPCLOGWINDOWDOCUMENT.insertString(0, textContent, this.SPCLOGATTRIBUTESET);
            }
            catch (BadLocationException ex) {
                LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
            }
            this.MATERIALTEXTPANEUI.installUI(this.SPCLOGWINDOWTEXTPANE);
            switch (JOptionPane.showOptionDialog(this.FRAME_SERVERPACKCREATOR, this.SPCLOGWINDOWTEXTPANE, this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.about.hastebin.dialog"), -1, 1, this.ICON_HASTEBIN, this.HASTEOPTIONS, this.HASTEOPTIONS[0])) {
                case 0: {
                    try {
                        if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                            Desktop.getDesktop().browse(URI.create(urltoHasteBin));
                        }
                    }
                    catch (IOException ex) {
                        LOG.error("Error opening browser.", (Throwable)ex);
                    }
                    break;
                }
                case 1: {
                    this.CLIPBOARD.setContents(new StringSelection(urltoHasteBin), null);
                    break;
                }
            }
        } else {
            this.fileTooLargeDialog();
        }
    }

    private void actionEventUploadConfigurationToHasteBinMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Upload Configuration to HasteBin.");
        if (this.checkFileSize(new File("serverpackcreator.conf"))) {
            String urltoHasteBin = this.createHasteBinFromFile(new File("serverpackcreator.conf"));
            String textContent = String.format("URL: %s", urltoHasteBin);
            try {
                this.CONFIGWINDOWDOCUMENT.insertString(0, textContent, this.CONFIGATTRIBUTESET);
            }
            catch (BadLocationException ex) {
                LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
            }
            this.MATERIALTEXTPANEUI.installUI(this.CONFIGWINDOWTEXTPANE);
            switch (JOptionPane.showOptionDialog(this.FRAME_SERVERPACKCREATOR, this.CONFIGWINDOWTEXTPANE, this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.about.hastebin.dialog"), -1, 1, this.ICON_HASTEBIN, this.HASTEOPTIONS, this.HASTEOPTIONS[0])) {
                case 0: {
                    try {
                        if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                            Desktop.getDesktop().browse(URI.create(urltoHasteBin));
                        }
                    }
                    catch (IOException ex) {
                        LOG.error("Error opening browser.", (Throwable)ex);
                    }
                    break;
                }
                case 1: {
                    this.CLIPBOARD.setContents(new StringSelection(urltoHasteBin), null);
                    break;
                }
            }
        } else {
            this.fileTooLargeDialog();
        }
    }

    private void fileTooLargeDialog() {
        this.MATERIALTEXTPANEUI.installUI(this.FILETOOLARGEWINDOWTEXTPANE);
        JOptionPane.showConfirmDialog(this.FRAME_SERVERPACKCREATOR, this.FILETOOLARGEWINDOWTEXTPANE, this.FILETOOLARGETITLE, -1, 2, this.ICON_HASTEBIN);
    }

    private void actionEventOpenInEditorServerProperties(ActionEvent actionEvent) {
        LOG.debug("Clicked Open server.properties in Editor.");
        if (new File(this.TAB_CREATESERVERPACK.getServerPropertiesPath()).isFile()) {
            try {
                if (Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
                    Desktop.getDesktop().open(new File(this.TAB_CREATESERVERPACK.getServerPropertiesPath()));
                }
            }
            catch (IOException ex) {
                LOG.error("Error opening custom server.properties.", (Throwable)ex);
            }
        } else {
            try {
                if (Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
                    Desktop.getDesktop().open(new File(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").replace(this.APPLICATIONHOME.getSource().toString().substring(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").lastIndexOf("/") + 1), "").replace("\\", "/") + "/server_files/server.properties"));
                }
            }
            catch (IOException ex) {
                LOG.error("Error opening default server.properties.", (Throwable)ex);
            }
        }
    }

    private void actionEventOpenServerIcon(ActionEvent actionEvent) {
        LOG.debug("Clicked Open server-icon.png in Editor.");
        if (new File(this.TAB_CREATESERVERPACK.getServerIconPath()).isFile()) {
            try {
                if (Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
                    Desktop.getDesktop().open(new File(this.TAB_CREATESERVERPACK.getServerIconPath()));
                }
            }
            catch (IOException ex) {
                LOG.error("Error opening custom server-icon.png.", (Throwable)ex);
            }
        } else {
            try {
                if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                    Desktop.getDesktop().open(new File(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").replace(this.APPLICATIONHOME.getSource().toString().substring(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").lastIndexOf("/") + 1), "").replace("\\", "/") + "/server_files/server-icon.png"));
                }
            }
            catch (IOException ex) {
                LOG.error("Error opening default server-icon.png.", (Throwable)ex);
            }
        }
    }

    private void actionEventChangeJavaArgsMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Edit Start-Scripts Java Args.");
        if (this.TAB_CREATESERVERPACK.getJavaArgs().equalsIgnoreCase("empty")) {
            this.JAVAARGS.setText("");
        } else {
            this.JAVAARGS.setText(this.TAB_CREATESERVERPACK.getJavaArgs());
        }
        new MaterialTextFieldUI().installUI(this.JAVAARGS);
        switch (JOptionPane.showOptionDialog(this.FRAME_SERVERPACKCREATOR, this.JAVAARGS, "Java Arguments", 1, -1, null, this.JAVAARGSOPTIONS, this.JAVAARGSOPTIONS[3])) {
            case 0: {
                if (this.JAVAARGS.getText().equals("")) {
                    this.TAB_CREATESERVERPACK.setJavaArgs("empty");
                    break;
                }
                this.TAB_CREATESERVERPACK.setJavaArgs(this.JAVAARGS.getText());
                break;
            }
            case 1: {
                this.TAB_CREATESERVERPACK.setJavaArgs(this.JAVAARGSSELECTIONS[1]);
                break;
            }
            case 2: {
                this.TAB_CREATESERVERPACK.setJavaArgs("empty");
                break;
            }
        }
        LOG.debug("Java args set to: " + this.TAB_CREATESERVERPACK.getJavaArgs());
    }

    private void actionEventExitMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Exit.");
        this.FRAME_SERVERPACKCREATOR.dispatchEvent(this.CLOSEEVENT);
    }

    private void actionEventSaveAsConfigToFileMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Save As...");
        this.configChooser = new JFileChooser();
        this.configChooser.setCurrentDirectory(new File("."));
        this.configChooser.setDialogTitle("Store current configuration");
        this.configChooser.setFileSelectionMode(0);
        this.configChooser.setFileFilter(new FileNameExtensionFilter(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.buttonloadconfig.filter"), "conf"));
        this.configChooser.setAcceptAllFileFilterUsed(false);
        this.configChooser.setMultiSelectionEnabled(false);
        this.configChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (this.configChooser.showOpenDialog(this.FRAME_SERVERPACKCREATOR) == 0) {
            try {
                this.TAB_CREATESERVERPACK.saveConfig(new File(this.configChooser.getSelectedFile().getCanonicalPath()));
                LOG.debug("Saved configuration to: " + this.configChooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException ex) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.buttonloadconfigfromfile"), (Throwable)ex);
            }
        }
    }

    private void actionEventSaveConfigToFileMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Save.");
        LOG.debug("Saving serverpackcreator.conf");
        this.TAB_CREATESERVERPACK.saveConfig(new File("./serverpackcreator.conf"));
        if (this.lastLoadedConfigurationFile != null && this.APPLICATIONPROPERTIES.getSaveLoadedConfiguration()) {
            LOG.debug("Saving " + this.lastLoadedConfigurationFile.getName());
            this.TAB_CREATESERVERPACK.saveConfig(this.lastLoadedConfigurationFile);
        }
    }

    private void actionEventSwitchThemeMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Toggle light/dark-mode.");
        if (!this.isDarkTheme) {
            try {
                UIManager.setLookAndFeel(this.LAF_DARK);
                MaterialLookAndFeel.changeTheme(this.DARKTHEME);
                SwingUtilities.updateComponentTreeUI(this.FRAME_SERVERPACKCREATOR);
                this.TABBEDPANE.setOpaque(true);
                this.isDarkTheme = true;
                try (FileOutputStream outputStream2 = new FileOutputStream(this.APPLICATIONPROPERTIES.FILE_SERVERPACKCREATOR_PROPERTIES);){
                    this.APPLICATIONPROPERTIES.setProperty("de.griefed.serverpackcreator.gui.darkmode", String.valueOf(true));
                    this.APPLICATIONPROPERTIES.store(outputStream2, null);
                }
                catch (IOException ex) {
                    LOG.error("Couldn't write properties-file.", (Throwable)ex);
                }
            }
            catch (UnsupportedLookAndFeelException ex) {
                LOG.error("Couldn't change theme.", (Throwable)ex);
            }
        } else {
            try {
                UIManager.setLookAndFeel(this.LAF_LIGHT);
                MaterialLookAndFeel.changeTheme(this.LIGHTTHEME);
                SwingUtilities.updateComponentTreeUI(this.FRAME_SERVERPACKCREATOR);
                this.TABBEDPANE.setOpaque(true);
                this.isDarkTheme = false;
                try (FileOutputStream outputStream3 = new FileOutputStream(this.APPLICATIONPROPERTIES.FILE_SERVERPACKCREATOR_PROPERTIES);){
                    this.APPLICATIONPROPERTIES.setProperty("de.griefed.serverpackcreator.gui.darkmode", String.valueOf(false));
                    this.APPLICATIONPROPERTIES.store(outputStream3, null);
                }
                catch (IOException ex) {
                    LOG.error("Couldn't write properties-file.", (Throwable)ex);
                }
            }
            catch (UnsupportedLookAndFeelException ex) {
                LOG.error("Couldn't change theme.", (Throwable)ex);
            }
        }
    }

    private void actionEventLoadConfigurationFromFileMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked load configuration from file.");
        this.configChooser = new JFileChooser();
        this.configChooser.setCurrentDirectory(new File("."));
        this.configChooser.setDialogTitle(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.buttonloadconfig.title"));
        this.configChooser.setFileSelectionMode(0);
        this.configChooser.setFileFilter(new FileNameExtensionFilter(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.buttonloadconfig.filter"), "conf"));
        this.configChooser.setAcceptAllFileFilterUsed(false);
        this.configChooser.setMultiSelectionEnabled(false);
        this.configChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (this.configChooser.showOpenDialog(this.FRAME_SERVERPACKCREATOR) == 0) {
            try {
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.buttonloadconfigfromfile"), this.configChooser.getSelectedFile().getCanonicalPath()));
                this.TAB_CREATESERVERPACK.loadConfig(new File(this.configChooser.getSelectedFile().getCanonicalPath().replace("\\", "/")));
                this.lastLoadedConfigurationFile = new File(this.configChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
            }
            catch (IOException ex) {
                LOG.error("Error loading configuration from selected file.", (Throwable)ex);
            }
            LOG.debug("Configuration successfully loaded.");
        }
    }

    private void actionEventOpenAddonsDirectoryMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open addons directory.");
        try {
            Desktop.getDesktop().open(new File(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").replace(this.APPLICATIONHOME.getSource().toString().substring(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").lastIndexOf("/") + 1), "").replace("\\", "/") + "/addons"));
        }
        catch (IOException ex) {
            LOG.error("Error opening file explorer for addons-directory.", (Throwable)ex);
        }
    }

    private void actionEventViewExampleAddonMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked view example addon");
        try {
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(URI.create("https://github.com/Griefed/ServerPackCreatorExampleAddon"));
            }
        }
        catch (IOException ex) {
            LOG.error("Error opening browser for example-addon repository.", (Throwable)ex);
        }
    }

    private void actionEventOpenSPCDirectoryMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open installation directory.");
        try {
            Desktop.getDesktop().open(new File(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").replace(this.APPLICATIONHOME.getSource().toString().substring(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").lastIndexOf("/") + 1), "").replace("\\", "/") + "/"));
        }
        catch (IOException ex) {
            LOG.error("Error opening file explorer for ServerPackCreator base-directory.", (Throwable)ex);
        }
    }

    private void actionEventOpenServerPacksDirectoryMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open server packs directory.");
        try {
            Desktop.getDesktop().open(new File(this.APPLICATIONPROPERTIES.getDirectoryServerPacks()));
        }
        catch (IOException ex) {
            LOG.error("Error opening file explorer for server-packs.", (Throwable)ex);
        }
    }

    private void actionEventOpenServerFilesDirectoryMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open server files directory.");
        try {
            Desktop.getDesktop().open(new File(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").replace(this.APPLICATIONHOME.getSource().toString().substring(this.APPLICATIONHOME.getSource().toString().replace("\\", "/").lastIndexOf("/") + 1), "").replace("\\", "/") + "/server_files"));
        }
        catch (IOException ex) {
            LOG.error("Error opening file explorer for server_files.", (Throwable)ex);
        }
    }

    private void actionEventOpenAboutSPCMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open about window.");
        this.MATERIALTEXTPANEUI.installUI(this.ABOUTWINDOWTEXTPANE);
        JOptionPane.showMessageDialog(this.FRAME_SERVERPACKCREATOR, this.ABOUTWINDOWTEXTPANE, this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.title"), 1, this.HELPICON);
    }

    private void actionEventOpenHelpMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open help window.");
        this.MATERIALCOMBOBOXUI.installUI(this.helpComboBox);
        this.MATERIALTEXTFIELDUI.installUI(this.HELPTEXTAREA);
        JOptionPane.showMessageDialog(this.FRAME_SERVERPACKCREATOR, this.HELPPANEL, this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.gui.createserverpack.help.title"), 1, this.HELPICON);
    }

    private void actionEventSetHelpText(ActionEvent actionEvent) {
        LOG.debug("Selected helpItem: " + this.helpComboBox.getSelectedIndex());
        this.HELPTEXTAREA.setText(this.HELPTEXTS[this.helpComboBox.getSelectedIndex()]);
    }

    private void actionEventOpenGitHubMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open GitHub repository link.");
        try {
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(URI.create("https://github.com/Griefed/ServerPackCreator"));
            }
        }
        catch (IOException ex) {
            LOG.error("Error opening browser for ServerPackCreator GitHub repository.", (Throwable)ex);
        }
    }

    private void actionEventOpenDonateMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open donations link.");
        try {
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(URI.create("https://github.com/sponsors/Griefed"));
            }
        }
        catch (IOException ex) {
            LOG.error("Error opening browser for donations page.", (Throwable)ex);
        }
    }

    private void actionEventOpenReleaseMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open releases link");
        try {
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(URI.create("https://github.com/Griefed/ServerPackCreator/releases"));
            }
        }
        catch (IOException ex) {
            LOG.error("Error opening browser for releases page.", (Throwable)ex);
        }
    }

    private boolean checkFileSize(File fileToCheck) {
        long fileSize = FileUtils.sizeOf(fileToCheck);
        if (fileSize < 10000000L) {
            LOG.debug("Smaller. " + fileSize + " byte.");
            return true;
        }
        LOG.debug("Bigger. " + fileSize + " byte.");
        return false;
    }

    private String createHasteBinFromFile(File textFile) {
        String text = null;
        String requestURL = this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.configuration.hastebinserver", "https://haste.zneix.eu/documents");
        String response = null;
        URL url = null;
        HttpsURLConnection conn = null;
        try {
            url = new URL(requestURL);
        }
        catch (IOException ex) {
            LOG.error("Error during acquisition of request URL.", (Throwable)ex);
        }
        try {
            text = FileUtils.readFileToString(textFile, "UTF-8");
        }
        catch (IOException ex) {
            LOG.error("Error reading text from file.", (Throwable)ex);
        }
        byte[] postData = Objects.requireNonNull(text).getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        try {
            conn = (HttpsURLConnection)Objects.requireNonNull(url).openConnection();
        }
        catch (IOException ex) {
            LOG.error("Error during opening of connection to URL.", (Throwable)ex);
        }
        Objects.requireNonNull(conn).setDoOutput(true);
        conn.setInstanceFollowRedirects(false);
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException ex) {
            LOG.error("Error during request of POST method.", (Throwable)ex);
        }
        conn.setRequestProperty("User-Agent", "HasteBin-Creator for ServerPackCreator");
        conn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        conn.setUseCaches(false);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(conn.getOutputStream());
            dataOutputStream.write(postData);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            response = bufferedReader.readLine();
        }
        catch (IOException ex) {
            LOG.error("Error encountered when acquiring curseResponse from URL.", (Throwable)ex);
        }
        if (((String)Objects.requireNonNull(response)).contains("\"key\"")) {
            response = "https://haste.zneix.eu/" + response.substring(response.indexOf(":") + 2, response.length() - 2);
        }
        if (response.contains("https://haste.zneix.eu")) {
            return response;
        }
        return this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.abouttab.hastebin.response");
    }
}

