/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.task;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ServerPackHandler;
import de.griefed.serverpackcreator.spring.curseforge.GenerateCurseProject;
import de.griefed.serverpackcreator.spring.curseforge.ScanCurseProject;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackService;
import de.griefed.serverpackcreator.spring.task.Task;
import de.griefed.serverpackcreator.spring.task.TaskSubmitter;
import de.griefed.serverpackcreator.spring.zip.GenerateZip;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
public class TaskHandler {
    private static final Logger LOG = LogManager.getLogger(TaskHandler.class);
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final ServerPackHandler SERVERPACKHANDLER;
    private final ServerPackService SERVERPACKSERVICE;
    private final TaskSubmitter TASKSUBMITTER;
    private final StopWatch STOPWATCH;

    @Autowired
    public TaskHandler(ConfigurationHandler injectedConfigurationHandler, ServerPackHandler injectedServerPackHandler, ServerPackService injectedServerPackService, TaskSubmitter injectedTaskSubmitter, ApplicationProperties injectedApplicationProperties) {
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler;
        this.SERVERPACKHANDLER = injectedServerPackHandler;
        this.SERVERPACKSERVICE = injectedServerPackService;
        this.TASKSUBMITTER = injectedTaskSubmitter;
        this.STOPWATCH = new StopWatch();
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
    }

    @JmsListener(destination="tasks.background", selector="type = 'scan'")
    public void handleScan(Task task) {
        block9: {
            LOG.info("Executing task: " + task);
            try {
                if (task instanceof ScanCurseProject) {
                    LOG.info("Instance of ScanCurseProject " + task.uniqueId());
                    String[] project = ((ScanCurseProject)task).getProjectIDAndFileID().split(",");
                    int projectID = Integer.parseInt(project[0]);
                    int fileID = Integer.parseInt(project[1]);
                    ServerPackModel serverPackModel = new ServerPackModel();
                    try {
                        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
                        if (!this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID).isPresent() && this.CONFIGURATIONHANDLER.checkCurseForge(projectID + "," + fileID, serverPackModel, encounteredErrors)) {
                            serverPackModel.setModpackDir(projectID + "," + fileID);
                            serverPackModel.setStatus("Queued");
                            this.SERVERPACKSERVICE.insert(serverPackModel);
                            this.TASKSUBMITTER.generateCurseProject(projectID + "," + fileID);
                        } else if (this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID).isPresent() && (serverPackModel = this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID).get()).getStatus().equals("Generating") && new Timestamp(new Date().getTime()).getTime() - serverPackModel.getLastModified().getTime() >= 1800000L && this.CONFIGURATIONHANDLER.checkCurseForge(projectID + "," + fileID, serverPackModel, encounteredErrors)) {
                            serverPackModel.setModpackDir(projectID + "," + fileID);
                            serverPackModel.setStatus("Queued");
                            this.SERVERPACKSERVICE.updateServerPackByProjectIDAndFileID(projectID, fileID, serverPackModel);
                            this.TASKSUBMITTER.generateCurseProject(projectID + "," + fileID);
                        }
                        break block9;
                    }
                    catch (Exception ex) {
                        LOG.error("An error occurred submitting the task for generation for " + projectID + ", " + fileID, (Throwable)ex);
                        if (this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID).isPresent()) {
                            this.SERVERPACKSERVICE.deleteByProjectIDAndFileID(projectID, fileID);
                        }
                        break block9;
                    }
                }
                LOG.info("This is not the queue you are looking for: " + task.uniqueId());
            }
            catch (Exception ex) {
                LOG.error("Error submitting generationTask", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JmsListener(destination="tasks.background", selector="type = 'generation'")
    public void handleGeneration(Task task) {
        LOG.info("Executing task: " + task);
        if (task instanceof GenerateCurseProject) {
            LOG.info("Instance of GenerateCurseProject: " + task.uniqueId());
            String[] project = ((GenerateCurseProject)task).getProjectIDAndFileID().split(",");
            int projectID = Integer.parseInt(project[0]);
            int fileID = Integer.parseInt(project[1]);
            ServerPackModel serverPackModel = this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID).get();
            serverPackModel.setStatus("Generating");
            serverPackModel.setDownloads(0);
            serverPackModel.setConfirmedWorking(0);
            this.SERVERPACKSERVICE.updateServerPackByID(serverPackModel.getId(), serverPackModel);
            serverPackModel.setModpackDir(projectID + "," + fileID);
            ServerPackModel pack = null;
            this.STOPWATCH.reset();
            this.STOPWATCH.start();
            try {
                this.CONFIGURATIONHANDLER.checkConfiguration(serverPackModel, true, true);
                pack = this.SERVERPACKHANDLER.run(serverPackModel);
                if (pack == null) return;
                this.SERVERPACKSERVICE.updateServerPackByID(serverPackModel.getId(), pack);
                return;
            }
            catch (Exception ex) {
                LOG.error("An error occurred generating the server pack for " + projectID + ", " + fileID, (Throwable)ex);
                if (!this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID).isPresent()) return;
                this.SERVERPACKSERVICE.deleteServerPack(serverPackModel.getId());
                return;
            }
            finally {
                this.STOPWATCH.stop();
                LOG.info("Generation took " + this.STOPWATCH);
                this.STOPWATCH.reset();
            }
        } else if (task instanceof GenerateZip) {
            LOG.info("Instance of GenerateZip: " + task.uniqueId());
            String[] parameters = ((GenerateZip)task).getZipGenerationProperties().split("&");
            ServerPackModel serverPackModel = new ServerPackModel();
            serverPackModel.setStatus("Generating");
            serverPackModel.setProjectID(0);
            serverPackModel.setFileID(0);
            serverPackModel.setDownloads(0);
            serverPackModel.setConfirmedWorking(0);
            serverPackModel.setFileDiskName(parameters[0]);
            serverPackModel.setModpackDir("./work/modpacks/" + parameters[0]);
            serverPackModel.setMinecraftVersion(parameters[2]);
            serverPackModel.setModLoader(parameters[3]);
            serverPackModel.setModLoaderVersion(parameters[4]);
            serverPackModel.setClientMods(Arrays.asList(parameters[1].split(",")));
            serverPackModel.setIncludeServerInstallation(Boolean.parseBoolean(parameters[5]));
            ServerPackModel pack = null;
            this.STOPWATCH.reset();
            this.STOPWATCH.start();
            ArrayList<String> encounteredErrors = new ArrayList<String>(100);
            try {
                if (!this.CONFIGURATIONHANDLER.checkConfiguration(serverPackModel, encounteredErrors, false, false)) {
                    serverPackModel.setFileName(serverPackModel.getModpackDir().substring(serverPackModel.getModpackDir().lastIndexOf("/") + 1));
                    this.SERVERPACKSERVICE.insert(serverPackModel);
                    pack = this.SERVERPACKHANDLER.run(serverPackModel);
                    if (pack == null) return;
                    this.SERVERPACKSERVICE.updateServerPackByID(serverPackModel.getId(), pack);
                    return;
                }
                LOG.error("Configuration check for ZIP-archive " + parameters[0] + " failed.");
                if (encounteredErrors.isEmpty()) return;
                LOG.error("Encountered errors: ");
                for (String error : encounteredErrors) {
                    LOG.error(error);
                }
                return;
            }
            catch (Exception ex) {
                LOG.error("An error occurred generating the server pack for ZIP-archive: " + parameters[0], (Throwable)ex);
                this.SERVERPACKSERVICE.deleteServerPack(serverPackModel.getId());
                if (encounteredErrors.isEmpty()) return;
                LOG.error("Encountered errors: ");
                for (String error : encounteredErrors) {
                    LOG.error(error);
                }
                return;
            }
            finally {
                FileUtils.deleteQuietly(new File("./work/modpacks/" + parameters[0]));
                this.STOPWATCH.stop();
                LOG.info("Generation took " + this.STOPWATCH);
                this.STOPWATCH.reset();
            }
        } else {
            LOG.info("This is not the queue you are looking for: " + task.uniqueId());
        }
    }
}

