/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.serverpack;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackRepository;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ServerPackService {
    private static final Logger LOG = LogManager.getLogger(ServerPackService.class);
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ServerPackRepository SERVERPACKREPOSITORY;

    @Autowired
    public ServerPackService(ApplicationProperties injectedApplicationProperties, ServerPackRepository injectedServerPackRepository) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.SERVERPACKREPOSITORY = injectedServerPackRepository;
    }

    public Optional<ServerPackModel> findByProjectIDAndFileID(int projectID, int fileID) {
        return this.SERVERPACKREPOSITORY.findByProjectIDAndFileID(projectID, fileID);
    }

    public void deleteByProjectIDAndFileID(int projectID, int fileID) {
        this.SERVERPACKREPOSITORY.deleteByProjectIDAndFileID(projectID, fileID);
    }

    public Optional<ServerPackModel> findByFileID(int fileID) {
        return this.SERVERPACKREPOSITORY.findByFileID(fileID);
    }

    public ResponseEntity<Resource> downloadServerPackById(int id) {
        if (this.SERVERPACKREPOSITORY.findById(id).isPresent() && ((ServerPackModel)this.SERVERPACKREPOSITORY.findById(id).get()).getStatus().matches("Available")) {
            ServerPackModel serverPackModel = (ServerPackModel)this.SERVERPACKREPOSITORY.findById(id).get();
            Path path = Paths.get(serverPackModel.getPath(), new String[0]);
            UrlResource resource = null;
            String contentType = "application/zip";
            try {
                resource = new UrlResource(path.toUri());
            }
            catch (MalformedURLException ex) {
                LOG.error("Error generating download for server pack with ID" + id + ".", (Throwable)ex);
            }
            this.updateDownloadCounter(id);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType(contentType)).header("Content-Disposition", "attachment; filename=\"" + serverPackModel.getFileDiskName().replace(".zip", "") + "_server_pack.zip\"")).body(resource);
        }
        return ResponseEntity.notFound().build();
    }

    public ResponseEntity<Object> voteForServerPack(String voting) {
        String[] vote = voting.split(",");
        int id = Integer.parseInt(vote[0]);
        if (this.SERVERPACKREPOSITORY.findById(id).isPresent() && ((ServerPackModel)this.SERVERPACKREPOSITORY.findById(id).get()).getStatus().equals("Available")) {
            if (vote[1].equalsIgnoreCase("up")) {
                this.updateConfirmedCounter(id, 1);
                return ResponseEntity.ok().build();
            }
            if (vote[1].equalsIgnoreCase("down")) {
                this.updateConfirmedCounter(id, -1);
                return ResponseEntity.ok().build();
            }
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.notFound().build();
    }

    public List<ServerPackModel> getServerPacks() {
        ArrayList<ServerPackModel> serverPackModels = new ArrayList<ServerPackModel>();
        this.SERVERPACKREPOSITORY.findAll().forEach(serverPackModels::add);
        return serverPackModels;
    }

    public List<ServerPackModel> getServerPacksByProjectID(int projectID) {
        if (this.SERVERPACKREPOSITORY.findAllByProjectID(projectID).isPresent()) {
            return new ArrayList<ServerPackModel>((Collection)this.SERVERPACKREPOSITORY.findAllByProjectID(projectID).get());
        }
        return new ArrayList<ServerPackModel>();
    }

    public void insert(ServerPackModel serverPackModel) {
        this.SERVERPACKREPOSITORY.save(serverPackModel);
    }

    public void updateServerPackByID(int id, ServerPackModel serverPackModel) {
        if (this.SERVERPACKREPOSITORY.findById(id).isPresent()) {
            ServerPackModel serverPackModelFromDB = (ServerPackModel)this.SERVERPACKREPOSITORY.findById(id).get();
            LOG.debug("Updating database with: " + serverPackModel.repositoryToString());
            serverPackModelFromDB.setProjectName(serverPackModel.getProjectName());
            serverPackModelFromDB.setFileName(serverPackModel.getFileName());
            serverPackModelFromDB.setFileDiskName(serverPackModel.getFileDiskName());
            serverPackModelFromDB.setSize(serverPackModel.getSize());
            serverPackModelFromDB.setDownloads(serverPackModel.getDownloads());
            serverPackModelFromDB.setConfirmedWorking(serverPackModel.getConfirmedWorking());
            serverPackModelFromDB.setStatus(serverPackModel.getStatus());
            serverPackModelFromDB.setLastModified(new Timestamp(new Date().getTime()));
            serverPackModelFromDB.setPath(serverPackModel.getPath());
            this.SERVERPACKREPOSITORY.save(serverPackModelFromDB);
        }
    }

    public void updateDownloadCounter(int id) {
        if (this.SERVERPACKREPOSITORY.findById(id).isPresent()) {
            ServerPackModel serverPackModelFromDB = (ServerPackModel)this.SERVERPACKREPOSITORY.findById(id).get();
            serverPackModelFromDB.setDownloads(serverPackModelFromDB.getDownloads() + 1);
            this.SERVERPACKREPOSITORY.save(serverPackModelFromDB);
        }
    }

    public void updateConfirmedCounter(int id, int vote) {
        if (this.SERVERPACKREPOSITORY.findById(id).isPresent()) {
            ServerPackModel serverPackModelFromDB = (ServerPackModel)this.SERVERPACKREPOSITORY.findById(id).get();
            serverPackModelFromDB.setConfirmedWorking(serverPackModelFromDB.getConfirmedWorking() + vote);
            this.SERVERPACKREPOSITORY.save(serverPackModelFromDB);
        }
    }

    public void updateServerPackByProjectIDAndFileID(int projectID, int fileID, ServerPackModel serverPackModel) {
        if (this.SERVERPACKREPOSITORY.findByProjectIDAndFileID(projectID, fileID).isPresent()) {
            ServerPackModel serverPackModelFromDB = this.SERVERPACKREPOSITORY.findByProjectIDAndFileID(projectID, fileID).get();
            LOG.debug("Updating database with: " + serverPackModel.repositoryToString());
            serverPackModelFromDB.setProjectName(serverPackModel.getProjectName());
            serverPackModelFromDB.setFileName(serverPackModel.getFileName());
            serverPackModelFromDB.setFileDiskName(serverPackModel.getFileDiskName());
            serverPackModelFromDB.setSize(serverPackModel.getSize());
            serverPackModelFromDB.setDownloads(serverPackModel.getDownloads());
            serverPackModelFromDB.setConfirmedWorking(serverPackModel.getConfirmedWorking());
            serverPackModelFromDB.setStatus(serverPackModel.getStatus());
            serverPackModelFromDB.setLastModified(new Timestamp(new Date().getTime()));
            serverPackModelFromDB.setPath(serverPackModel.getPath());
            this.SERVERPACKREPOSITORY.save(serverPackModelFromDB);
        }
    }

    public void deleteServerPack(int id) {
        this.SERVERPACKREPOSITORY.deleteById(id);
    }

    public void deleteServerPack(int projectID, int fileID) {
        this.SERVERPACKREPOSITORY.deleteByProjectIDAndFileID(projectID, fileID);
    }
}

