/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.serverpack;

import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v1/packs"})
public class ServerPackController {
    private static final Logger LOG = LogManager.getLogger(ServerPackController.class);
    private final ServerPackService SERVERPACKSERVICE;

    @Autowired
    public ServerPackController(ServerPackService injectedServerPackService) {
        this.SERVERPACKSERVICE = injectedServerPackService;
    }

    @GetMapping(value={"/download/{id}"}, produces={"application/zip"})
    public ResponseEntity<Resource> downloadServerPack(@PathVariable int id) {
        return this.SERVERPACKSERVICE.downloadServerPackById(id);
    }

    @GetMapping(value={"project/{projectid}"})
    public ResponseEntity<List<ServerPackModel>> getByProjectID(@PathVariable(value="projectid") int projectID) {
        if (this.SERVERPACKSERVICE.getServerPacksByProjectID(projectID).isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body(this.SERVERPACKSERVICE.getServerPacksByProjectID(projectID));
    }

    @GetMapping(value={"file/{fileid}"})
    public ResponseEntity<ServerPackModel> getByFileID(@PathVariable(value="fileid") int fileID) {
        if (this.SERVERPACKSERVICE.findByFileID(fileID).isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body(this.SERVERPACKSERVICE.findByFileID(fileID).get());
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"all"})
    public ResponseEntity<List<ServerPackModel>> getAllServerPacks() {
        if (this.SERVERPACKSERVICE.getServerPacks().isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body(this.SERVERPACKSERVICE.getServerPacks());
    }

    @GetMapping(value={"specific/{specific}"})
    public ResponseEntity<ServerPackModel> getByFileID(@PathVariable(value="specific") String specific) {
        int fileID;
        String[] project = specific.split(",");
        int projectID = Integer.parseInt(project[0]);
        if (this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID = Integer.parseInt(project[1])).isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body(this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID).get());
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"vote/{voting}"})
    public ResponseEntity<Object> voteForServerPack(@PathVariable(value="voting") String voting) {
        return this.SERVERPACKSERVICE.voteForServerPack(voting);
    }
}

