/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.curseforge;

import com.therandomlabs.curseapi.CurseException;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.curseforge.InvalidFileException;
import de.griefed.serverpackcreator.curseforge.InvalidModpackException;
import de.griefed.serverpackcreator.spring.NotificationResponse;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackService;
import de.griefed.serverpackcreator.spring.task.TaskSubmitter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CurseService {
    private static final Logger LOG = LogManager.getLogger(CurseService.class);
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final NotificationResponse CURSERESPONSEMODEL;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ServerPackService SERVERPACKSERVICE;
    private final TaskSubmitter TASKSUBMITTER;

    @Autowired
    public CurseService(ConfigurationHandler injectedConfigurationHandler, NotificationResponse injectedNotificationResponse, ApplicationProperties injectedApplicationProperties, ServerPackService injectedServerPackService, TaskSubmitter injectedTaskSubmitter) {
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler;
        this.CURSERESPONSEMODEL = injectedNotificationResponse;
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.SERVERPACKSERVICE = injectedServerPackService;
        this.TASKSUBMITTER = injectedTaskSubmitter;
    }

    public String createFromCurseModpack(int projectID, int fileID) throws CurseException {
        if (this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID).isPresent()) {
            ServerPackModel pack = this.SERVERPACKSERVICE.findByProjectIDAndFileID(projectID, fileID).get();
            if (pack.getStatus().equals("Available")) {
                return this.CURSERESPONSEMODEL.curseResponse(pack.getProjectName(), 0, "The modpack you requested a server pack for has already been generated. Check the downloads-section!", 5000, "info", "info");
            }
            if (pack.getStatus().equals("Queued")) {
                return this.CURSERESPONSEMODEL.curseResponse(pack.getProjectName(), 1, "The modpack you requested a server pack for has already been queued!", 5000, "info", "info");
            }
            if (pack.getStatus().equals("Generating") && new Timestamp(new Date().getTime()).getTime() - pack.getLastModified().getTime() < 1800000L) {
                return this.CURSERESPONSEMODEL.curseResponse(pack.getProjectName(), 1, "The modpack you requested a server pack for is currently being generated!", 5000, "info", "info");
            }
        }
        try {
            ServerPackModel serverPackModel = new ServerPackModel();
            ArrayList<String> encounteredErrors = new ArrayList<String>(100);
            if (this.CONFIGURATIONHANDLER.checkCurseForge(projectID + "," + fileID, serverPackModel, encounteredErrors)) {
                this.TASKSUBMITTER.scanCurseProject(projectID + "," + fileID);
                return this.CURSERESPONSEMODEL.curseResponse(serverPackModel.getProjectName(), 1, "Queued! Come back later and check the downloads-section to see whether your server pack for " + serverPackModel.getProjectName() + " is ready for download!", 7000, "done", "positive");
            }
            return this.CURSERESPONSEMODEL.curseResponse(projectID + "," + fileID, 2, "Project or file could not be found!", 3000, "error", "negative");
        }
        catch (InvalidModpackException ex) {
            LOG.error("Couldn't generate server pack for project: " + projectID + "," + fileID, (Throwable)ex);
            return this.CURSERESPONSEMODEL.curseResponse(projectID, 2, "The specified project is not a Minecraft modpack!", 3000, "error", "negative");
        }
        catch (InvalidFileException ex) {
            LOG.error("The specified file is not a file of project: " + projectID + "," + fileID, (Throwable)ex);
            return this.CURSERESPONSEMODEL.curseResponse(projectID, 2, "The specified file could not be found for this project!", 3000, "error", "negative");
        }
        catch (CurseException ex) {
            LOG.error("The specified project does not exist: " + projectID + "," + fileID, (Throwable)ex);
            return this.CURSERESPONSEMODEL.curseResponse(projectID, 2, "The specified project does not exist!", 3000, "error", "negative");
        }
    }

    public String regenerateFromCurseModpack(String modpack) {
        if (this.APPLICATIONPROPERTIES.getCurseControllerRegenerationEnabled()) {
            ServerPackModel serverPackModel = this.SERVERPACKSERVICE.findByProjectIDAndFileID(Integer.parseInt(modpack.split(",")[0]), Integer.parseInt(modpack.split(",")[1])).get();
            serverPackModel.setModpackDir(modpack);
            serverPackModel.setStatus("Queued");
            this.SERVERPACKSERVICE.updateServerPackByID(serverPackModel.getId(), serverPackModel);
            this.TASKSUBMITTER.generateCurseProject(modpack);
            return this.CURSERESPONSEMODEL.curseResponse(modpack, 1, "Regenerating server pack.", 3000, "done", "positive");
        }
        return this.CURSERESPONSEMODEL.curseResponse(modpack, 2, "Regeneration is disabled on this instance!", 4000, "info", "warning");
    }
}

