/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.curseforge;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.spring.NotificationResponse;
import de.griefed.serverpackcreator.spring.curseforge.CurseService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v1/curse"})
public class CurseController {
    private static final Logger LOG = LogManager.getLogger(CurseController.class);
    private final CurseService CURSESERVICE;
    private final NotificationResponse CURSERESPONSEMODEL;
    private final ApplicationProperties APPLICATIONPROPERTIES;

    @Autowired
    public CurseController(CurseService injectedCurseService, NotificationResponse injectedNotificationResponse, ApplicationProperties injectedApplicationProperties) {
        this.CURSESERVICE = injectedCurseService;
        this.CURSERESPONSEMODEL = injectedNotificationResponse;
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"task"})
    public String task(@RequestParam(value="modpack", defaultValue="10,60018") String modpack) {
        LOG.info("IMPORTANT!!! - Modpack directory matches CurseForge projectID and fileID format. However, the CurseForge module is currently disabled due to CurseForge changing their API and the way one can access it.");
        LOG.info("IMPORTANT!!! - Downloading and installing a modpack is disabled until further notice.");
        return this.CURSERESPONSEMODEL.curseResponse(modpack, 2, "The CurseForge module is currently disabled due to CurseForge changing their API and the way one can access it.", 7000, "error", "negative");
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/regenerate"})
    public String regenerate(@RequestParam(value="modpack", defaultValue="10,60018") String modpack) {
        LOG.info("IMPORTANT!!! - Modpack directory matches CurseForge projectID and fileID format. However, the CurseForge module is currently disabled due to CurseForge changing their API and the way one can access it.");
        LOG.info("IMPORTANT!!! - Downloading and installing a modpack is disabled until further notice.");
        return this.CURSERESPONSEMODEL.curseResponse(modpack, 2, "The CurseForge module is currently disabled due to CurseForge changing their API and the way one can access it.", 7000, "error", "negative");
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(value={"/regenerate/active"})
    public String regenerateActivated() {
        return "{\"regenerationActivated\": " + this.APPLICATIONPROPERTIES.getCurseControllerRegenerationEnabled() + "}";
    }
}

