/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring;

import de.griefed.serverpackcreator.VersionLister;
import de.griefed.serverpackcreator.utilities.ListUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v1/versions"})
public class VersionsController {
    private static final Logger LOG = LogManager.getLogger(VersionsController.class);
    private final VersionLister VERSIONLISTER;
    private final ListUtilities LISTUTILITIES;

    @Autowired
    public VersionsController(VersionLister injectedVersionLister, ListUtilities injectedListUtilities) {
        this.VERSIONLISTER = injectedVersionLister;
        this.LISTUTILITIES = injectedListUtilities;
    }

    @GetMapping(value={"/minecraft"})
    public ResponseEntity<String> getAvailableMinecraftVersions() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"minecraft\":" + this.LISTUTILITIES.encapsulateListElements(this.VERSIONLISTER.getMinecraftReleaseVersions()) + "}");
    }

    @GetMapping(value={"/forge/{minecraftversion}"})
    public ResponseEntity<String> getAvailableForgeVersions(@PathVariable(value="minecraftversion") String minecraftVersion) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"forge\":" + this.LISTUTILITIES.encapsulateListElements(this.VERSIONLISTER.reverseOrderList(this.VERSIONLISTER.getForgeVersionsAsList(minecraftVersion))) + "}");
    }

    @GetMapping(value={"/fabric"})
    public ResponseEntity<String> getAvailableFabricVersions() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"fabric\":" + this.LISTUTILITIES.encapsulateListElements(this.VERSIONLISTER.reverseOrderList(this.VERSIONLISTER.getFabricVersions())) + "}");
    }

    @GetMapping(value={"/fabric/installer"}, produces={"application/json"})
    public ResponseEntity<String> getAvailableFabricInstallerVersions() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body("{\"release\":\"" + this.VERSIONLISTER.getFabricReleaseInstallerVersion() + "\",\"latest\":\"" + this.VERSIONLISTER.getFabricLatestInstallerVersion() + "\"}");
    }
}

