/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring;

import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class NotificationResponse {
    private static final Logger LOG = LogManager.getLogger(NotificationResponse.class);

    public String curseResponse(String projectName, int status, String message, int timeout, String icon, String colour) {
        return "{\"project\": \"" + projectName + "\",\"status\": " + status + ",\"message\": \"" + message + "\",\"timeout\": " + timeout + ",\"icon\": \"" + icon + "\",\"colour\": \"" + colour + "\"}";
    }

    public String curseResponse(int projectID, int status, String message, int timeout, String icon, String colour) {
        try {
            return this.curseResponse(CurseAPI.project(projectID).orElseThrow(NullPointerException::new).name(), status, message, timeout, icon, colour);
        }
        catch (CurseException | NullPointerException ex) {
            LOG.error("Project name could not be acquired", (Throwable)ex);
            return this.curseResponse(String.valueOf(projectID), status, message, timeout, icon, colour);
        }
    }

    public String zipResponse(List<String> messages, int timeout, String icon, String colour, String file, boolean success) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String message : messages) {
            stringBuilder.append(message);
        }
        return this.zipResponse(stringBuilder.toString(), timeout, icon, colour, file, success);
    }

    public String zipResponse(String message, int timeout, String icon, String colour, String file, boolean success) {
        return "{\"timeout\": " + timeout + ",\"icon\":\"" + icon + "\",\"color\":\"" + colour + "\",\"message\":\"" + message + "\",\"file\":\"" + file + "\",\"success\":" + success + "}";
    }
}

