/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.utilities.ListUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v1/settings"})
public class ApplicationPropertiesController {
    private static final Logger LOG = LogManager.getLogger(ApplicationPropertiesController.class);
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ListUtilities LISTUTILITIES;

    @Autowired
    public ApplicationPropertiesController(ApplicationProperties injectedApplicationProperties, ListUtilities injectedListUtilities) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.LISTUTILITIES = injectedListUtilities;
    }

    @GetMapping(produces={"application/json"})
    public String getConfiguration() {
        return "{\"listFallbackMods\":" + this.LISTUTILITIES.encapsulateListElements(this.APPLICATIONPROPERTIES.getListFallbackMods()) + ",\"listDirectoriesExclude\":" + this.LISTUTILITIES.encapsulateListElements(this.APPLICATIONPROPERTIES.getListOfDirectoriesToExclude()) + ",\"curseControllerRegenerationEnabled\": " + this.APPLICATIONPROPERTIES.getCurseControllerRegenerationEnabled() + ",\"serverPackCreatorVersion\":\"" + this.APPLICATIONPROPERTIES.getServerPackCreatorVersion() + "\",\"isCurseForgeActivated\": " + this.APPLICATIONPROPERTIES.isCurseForgeActivated() + "}";
    }
}

