/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.i18n;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.i18n.IncorrectLanguageException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocalizationManager {
    private static final Logger LOG = LogManager.getLogger(LocalizationManager.class);
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ResourceBundle FALLBACKRESOURCES = ResourceBundle.getBundle("de/griefed/resources/lang/lang_en_us", new Locale("en", "us"));
    private final Map<String, String> CURRENT_LANGUAGE = new HashMap<String, String>();
    private final File PROPERTIESFILE = new File("serverpackcreator.properties");
    private final String MAP_PATH_LANGUAGE = "language";
    private final String MAP_PATH_COUNTRY = "country";
    private final List<String> SUPPORTED_LANGUAGES = new ArrayList<String>(Arrays.asList("en_us", "uk_ua", "de_de"));
    private ResourceBundle filesystemResources;
    private ResourceBundle jarResources = null;

    @Autowired
    public LocalizationManager(ApplicationProperties injectedApplicationProperties) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        try {
            this.initialize(this.APPLICATIONPROPERTIES);
        }
        catch (IncorrectLanguageException ex) {
            this.initialize();
        }
    }

    public LocalizationManager(ApplicationProperties injectedApplicationProperties, String locale) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        try {
            this.initialize(locale);
            this.writeLocaleToFile(locale);
        }
        catch (IncorrectLanguageException ex) {
            try {
                this.initialize(this.APPLICATIONPROPERTIES);
            }
            catch (IncorrectLanguageException e) {
                this.initialize();
            }
        }
    }

    public LocalizationManager() {
        this.APPLICATIONPROPERTIES = new ApplicationProperties();
        this.initialize();
    }

    public void initialize() {
        try {
            this.initialize("en_us");
        }
        catch (IncorrectLanguageException e) {
            LOG.error("Error during default localization initialization.");
        }
    }

    public void initialize(File propertiesFile) throws IncorrectLanguageException {
        ApplicationProperties applicationProperties = new ApplicationProperties();
        try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
            applicationProperties.load(bufferedReader);
            LOG.debug("Properties-file used for i18n: " + applicationProperties);
        }
        catch (Exception ex) {
            LOG.error("Couldn't load properties-file for i18n: " + applicationProperties, (Throwable)ex);
        }
        this.initialize(applicationProperties);
    }

    public void initialize(ApplicationProperties applicationProperties) throws IncorrectLanguageException {
        this.initialize(applicationProperties.getProperty("de.griefed.serverpackcreator.language", "en_us"));
    }

    public void initialize(String locale) throws IncorrectLanguageException {
        boolean doesLanguageExist = false;
        if (this.SUPPORTED_LANGUAGES.contains(locale)) {
            doesLanguageExist = true;
        } else {
            LOG.warn("The specified language is not officially supported. You may provide your own definitions and translations.");
            LOG.warn("Beware: When doing this, you are on your own and will receive no support. Errors and problems may occur when loading and working with custom language definitions and translations which are not officially supported yet.");
            LOG.warn("When you are satisfied with your translations, feel free to open an issue on GitHub and submit them so they can get officially added and supported to and by ServerPackCreator!");
            LOG.warn("GitHub issues available at: https://github.com/Griefed/ServerPackCreator/issues");
        }
        if (!locale.contains("_")) {
            LOG.error("Locales must be formatted like this: \"en_us\",\"uk_ua\",\"de_de\"");
            throw new IncorrectLanguageException();
        }
        String[] langCode = locale.split("_");
        this.CURRENT_LANGUAGE.put("language", langCode[0]);
        this.CURRENT_LANGUAGE.put("country", langCode[1]);
        try (FileInputStream inputStream2 = FileUtils.openInputStream(new File(String.format("lang/lang_%s.properties", locale)));){
            this.filesystemResources = new PropertyResourceBundle(inputStream2);
            LOG.debug("Using language-definitions from file on filesystem.");
        }
        catch (IOException ex) {
            LOG.error("Local language-definitions corrupted, not present or otherwise unreadable. Using definitions from JAR-file.");
            try {
                this.filesystemResources = ResourceBundle.getBundle(String.format("de/griefed/resources/lang/lang_%s", locale), new Locale(this.CURRENT_LANGUAGE.get("language"), this.CURRENT_LANGUAGE.get("country")));
            }
            catch (Exception ex2) {
                LOG.error("Locale resource for " + locale + " not found in JAR-file. Falling back to en_us.", (Throwable)ex2);
                this.filesystemResources = ResourceBundle.getBundle("de/griefed/resources/lang/lang_en_us", new Locale("en", "us"));
                locale = "en_us";
            }
        }
        if (doesLanguageExist && !locale.equals("en_us")) {
            try {
                this.jarResources = ResourceBundle.getBundle(String.format("de/griefed/resources/lang/lang_%s", locale), new Locale(this.CURRENT_LANGUAGE.get("language"), this.CURRENT_LANGUAGE.get("country")));
            }
            catch (Exception ex) {
                LOG.error("Locale resource for " + locale + " not found in JAR-file.", (Throwable)ex);
                this.jarResources = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalizedString(String languageKey) {
        String text = null;
        String value = null;
        try {
            value = this.filesystemResources.getString(languageKey);
        }
        catch (MissingResourceException ex) {
            if (this.jarResources != null) {
                try {
                    value = this.jarResources.getString(languageKey);
                    LOG.debug(String.format("Language key \"%s\" not found in local file resource \"%s_%s\". Using fallback from JAR-resources.", languageKey, this.CURRENT_LANGUAGE.get("language"), this.CURRENT_LANGUAGE.get("country")));
                }
                catch (MissingResourceException ex2) {
                    value = this.FALLBACKRESOURCES.getString(languageKey);
                    LOG.debug(String.format("Language key \"%s\" not found in JAR-locale-resource \"%s_%s\". Using fallback from \"en_US\".", ex2.getKey(), this.CURRENT_LANGUAGE.get("language"), this.CURRENT_LANGUAGE.get("country")));
                }
            } else {
                value = this.FALLBACKRESOURCES.getString(languageKey);
                LOG.debug(String.format("Language key \"%s\" not found for locale \"%s_%s\". Using JAR-resources fallback from \"en_US\".", ex.getKey(), this.CURRENT_LANGUAGE.get("language"), this.CURRENT_LANGUAGE.get("country")));
            }
        }
        finally {
            text = value != null ? new String(value.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8) : "i18n: No value found for key " + languageKey + " , Locale: " + this.CURRENT_LANGUAGE.get("language") + "_" + this.CURRENT_LANGUAGE.get("country");
        }
        return text;
    }

    void writeLocaleToFile(String locale) {
        try (FileOutputStream outputStream2 = new FileOutputStream(this.PROPERTIESFILE);){
            this.APPLICATIONPROPERTIES.setProperty("de.griefed.serverpackcreator.language", locale);
            this.APPLICATIONPROPERTIES.store(outputStream2, null);
        }
        catch (IOException ex) {
            LOG.error("Couldn't write properties-file.", (Throwable)ex);
        }
    }
}

