/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.curseforge;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.VersionLister;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.utilities.BooleanUtilities;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.ListUtilities;
import de.griefed.serverpackcreator.utilities.ReticulatingSplines;
import de.griefed.serverpackcreator.utilities.StringUtilities;
import de.griefed.serverpackcreator.utilities.SystemUtilities;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CurseCreateModpack {
    private static final Logger LOG = LogManager.getLogger(CurseCreateModpack.class);
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final VersionLister VERSIONLISTER;
    private final BooleanUtilities BOOLEANUTILITIES;
    private final ListUtilities LISTUTILITIES;
    private final StringUtilities STRINGUTILITIES;
    private final ConfigUtilities CONFIGUTILITIES;
    private final SystemUtilities SYSTEMUTILITIES;
    private final ReticulatingSplines reticulatingSplines = new ReticulatingSplines();
    private final Random randInt = new Random();

    @Autowired
    public CurseCreateModpack(LocalizationManager injectedLocalizationManager, ApplicationProperties injectedApplicationProperties, VersionLister injectedVersionLister, BooleanUtilities injectedBooleanUtilities, ListUtilities injectedListUtilities, StringUtilities injectedStringUtilities, ConfigUtilities injectedConfigUtilities, SystemUtilities injectedSystemUtilities) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        this.VERSIONLISTER = injectedVersionLister == null ? new VersionLister(this.APPLICATIONPROPERTIES) : injectedVersionLister;
        this.BOOLEANUTILITIES = injectedBooleanUtilities == null ? new BooleanUtilities(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES) : injectedBooleanUtilities;
        this.LISTUTILITIES = injectedListUtilities == null ? new ListUtilities() : injectedListUtilities;
        this.STRINGUTILITIES = injectedStringUtilities == null ? new StringUtilities() : injectedStringUtilities;
        this.CONFIGUTILITIES = injectedConfigUtilities == null ? new ConfigUtilities(this.LOCALIZATIONMANAGER, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.APPLICATIONPROPERTIES, this.STRINGUTILITIES, this.VERSIONLISTER) : injectedConfigUtilities;
        this.SYSTEMUTILITIES = injectedSystemUtilities == null ? new SystemUtilities() : injectedSystemUtilities;
    }

    public String retrieveProjectName(int newProjectID) {
        try {
            return CurseAPI.project(newProjectID).orElseThrow(NullPointerException::new).name();
        }
        catch (CurseException | NullPointerException cex) {
            LOG.error("Name for project " + newProjectID + " not found. Using projectID instead.", (Throwable)cex);
            return String.valueOf(newProjectID);
        }
    }

    public String retrieveFileDiskName(int newProjectID, int newFileID) {
        try {
            return CurseAPI.file(newProjectID, newFileID).orElseThrow(NullPointerException::new).nameOnDisk();
        }
        catch (CurseException | NullPointerException ex) {
            LOG.error("Filediskname for file " + newFileID + " not found. Using fileID.", (Throwable)ex);
            return String.valueOf(newFileID);
        }
    }

    public String retrieveFileName(int projectID, int fileID) {
        try {
            return CurseAPI.file(projectID, fileID).orElseThrow(NullPointerException::new).displayName();
        }
        catch (CurseException | NullPointerException ex) {
            LOG.warn(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.warn.filename.notfound.displayname"), fileID));
            try {
                return CurseAPI.file(projectID, fileID).orElseThrow(NullPointerException::new).nameOnDisk();
            }
            catch (CurseException | NullPointerException ex2) {
                LOG.warn(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.warn.filename.notfound.filename"), fileID));
                return String.valueOf(fileID);
            }
        }
    }

    String setModloaderCase(String modloader) {
        if (modloader.equalsIgnoreCase("Forge")) {
            return "Forge";
        }
        if (modloader.equalsIgnoreCase("Fabric")) {
            return "Fabric";
        }
        LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.warn.modloader.fallback"));
        return "Forge";
    }

    ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return objectMapper;
    }

    public void curseForgeModpack(ConfigurationModel configurationModel, Integer projectID, Integer fileID) {
        try {
            if (CurseAPI.project(projectID).isPresent()) {
                configurationModel.setProjectName(this.retrieveProjectName(projectID));
                configurationModel.setFileName(this.retrieveFileName(projectID, fileID));
                configurationModel.setFileDiskName(this.retrieveFileDiskName(projectID, fileID));
                configurationModel.setModpackDir(String.format("./work/modpacks/%s/%s", projectID, fileID));
            }
        }
        catch (CurseException cex) {
            LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.error.curseforgemodpack"), projectID, fileID), (Throwable)cex);
        }
        if (!(this.checkCurseForgeDir(configurationModel.getModpackDir()) || configurationModel.getProjectName().equals(String.valueOf(projectID)) || configurationModel.getFileDiskName().equals(String.valueOf(fileID)))) {
            this.initializeModpack(configurationModel.getModpackDir(), projectID, fileID, configurationModel);
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.iscurse.replace"));
            this.CONFIGUTILITIES.writeConfigToFile(configurationModel, this.APPLICATIONPROPERTIES.FILE_CONFIG);
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.overwrite"));
        }
    }

    void initializeModpack(String modpackDir, Integer projectID, Integer fileID, ConfigurationModel configurationModel) {
        try {
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.initializemodpack.download"), configurationModel.getProjectName(), configurationModel.getFileName()));
            CurseAPI.downloadFileToDirectory(projectID, fileID, Paths.get(modpackDir, new String[0]));
            this.SYSTEMUTILITIES.unzipArchive(CurseAPI.downloadFileToDirectory(projectID, fileID, Paths.get(modpackDir, new String[0])).orElseThrow(NullPointerException::new).toString(), modpackDir);
        }
        catch (CurseException | NullPointerException cex) {
            LOG.error(String.format("Error: Could not download file %s for project %s to directory %s.", configurationModel.getFileName(), configurationModel.getProjectName(), modpackDir));
        }
        try {
            if (Files.deleteIfExists(Paths.get(String.format("%s/%s", modpackDir, configurationModel.getFileDiskName()), new String[0]))) {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.initializemodpack.deletezip"));
            }
        }
        catch (IOException cex) {
            // empty catch block
        }
        if (new File(String.format("%s/manifest.json", modpackDir)).exists()) {
            try {
                this.CONFIGUTILITIES.updateConfigModelFromCurseManifest(configurationModel, new File(String.format("%s/manifest.json", modpackDir)));
                configurationModel.setCopyDirs(this.CONFIGUTILITIES.suggestCopyDirs(configurationModel.getModpackDir()));
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.initializemodpack.infoheader"));
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.initializemodpack.modpackname"), configurationModel.getCurseModpack().get("name").asText()));
                try {
                    LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.initializemodpack.modpackversion"), configurationModel.getCurseModpack().get("version").asText()));
                }
                catch (NullPointerException cex) {
                    // empty catch block
                }
                try {
                    LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.initializemodpack.modpackauthor"), configurationModel.getCurseModpack().get("author").asText()));
                }
                catch (NullPointerException cex) {
                    // empty catch block
                }
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.initializemodpack.modpackminecraftversion"), configurationModel.getMinecraftVersion()));
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.initializemodpack.modloader"), configurationModel.getModLoader()));
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.initializemodpack.modloaderversion"), configurationModel.getModLoaderVersion()));
            }
            catch (IOException ex) {
                LOG.error("Error: There was a fault during json parsing.", (Throwable)ex);
            }
            this.copyOverride(modpackDir);
            if (new File(String.format("%s/overrides", modpackDir)).isDirectory()) {
                try {
                    FileUtils.deleteDirectory(new File(String.format("%s/overrides", modpackDir)));
                }
                catch (IOException | IllegalArgumentException ex) {
                    LOG.debug("Couldn't delete overrides directory.", (Throwable)ex);
                }
            }
            this.downloadMods(modpackDir, configurationModel);
        }
    }

    void downloadMods(String modpackDir, ConfigurationModel configurationModel) {
        int i2;
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.downloadmods.info"));
        ArrayList<String> failedDownloads = new ArrayList<String>();
        for (i2 = 0; i2 < configurationModel.getCurseModpack().get("files").size(); ++i2) {
            if (this.randInt.nextInt(configurationModel.getCurseModpack().get("files").size()) == this.randInt.nextInt(configurationModel.getCurseModpack().get("files").size())) {
                LOG.info(this.reticulatingSplines.reticulate());
            }
            String modName = this.retrieveProjectName(configurationModel.getCurseModpack().get("files").get(i2).get("projectID").asInt());
            String modFileName = this.retrieveFileName(configurationModel.getCurseModpack().get("files").get(i2).get("projectID").asInt(), configurationModel.getCurseModpack().get("files").get(i2).get("fileID").asInt());
            try {
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.downloadmods.specificmod"), i2 + 1, configurationModel.getCurseModpack().get("files").size(), modName, modFileName));
                CurseAPI.downloadFileToDirectory(configurationModel.getCurseModpack().get("files").get(i2).get("projectID").asInt(), configurationModel.getCurseModpack().get("files").get(i2).get("fileID").asInt(), Paths.get(String.format("%s/mods", modpackDir), new String[0]));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException iex) {
                    LOG.debug("Error during interruption event.", (Throwable)iex);
                }
                continue;
            }
            catch (CurseException cex) {
                LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.error.downloadmods.errordownload"), modName, configurationModel.getCurseModpack().get("files").get(i2).get("projectID").asInt(), modFileName, configurationModel.getCurseModpack().get("files").get(i2).get("fileID").asInt()));
                try {
                    LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.downloadmods.tryagain"), modName, configurationModel.getCurseModpack().get("files").get(i2).get("projectID").asInt(), modFileName, configurationModel.getCurseModpack().get("files").get(i2).get("fileID").asInt()));
                    CurseAPI.downloadFileToDirectory(configurationModel.getCurseModpack().get("files").get(i2).get("projectID").asInt(), configurationModel.getCurseModpack().get("files").get(i2).get("fileID").asInt(), Paths.get(String.format("%s/mods", modpackDir), new String[0]));
                    continue;
                }
                catch (CurseException cex2) {
                    LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.error.downloadmods.retryfail"), modName, configurationModel.getCurseModpack().get("files").get(i2).get("projectID").asInt(), modFileName, configurationModel.getCurseModpack().get("files").get(i2).get("fileID").asInt()));
                    try {
                        failedDownloads.add(String.format("Mod: %s, ID: %d. File: %s, ID: %d, URL: %s", modName, configurationModel.getCurseModpack().get("files").get(i2).get("projectID").asInt(), modFileName, configurationModel.getCurseModpack().get("files").get(i2).get("fileID").asInt(), CurseAPI.fileDownloadURL(configurationModel.getCurseModpack().get("files").get(i2).get("projectID").asInt(), configurationModel.getCurseModpack().get("files").get(i2).get("fileID").asInt())));
                        continue;
                    }
                    catch (CurseException cex3) {
                        LOG.error("Error: An error occurred during URL retrieval.", (Throwable)cex3);
                    }
                }
            }
        }
        if (failedDownloads.size() != 0) {
            for (i2 = 0; i2 <= failedDownloads.size(); ++i2) {
                LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.error.downloadmods.urllist"), failedDownloads.get(i2)));
            }
        }
    }

    void copyOverride(String modpackDir) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.copyoverrides.info"));
        try {
            FileUtils.copyDirectory(new File(String.format("%s/overrides", modpackDir)), new File(modpackDir));
        }
        catch (IOException | IllegalArgumentException | NullPointerException ex) {
            LOG.error("An error occurred copying files from overrides to parent directory.", (Throwable)ex);
        }
    }

    boolean checkCurseForgeDir(String modpackDir) {
        boolean isModpackPresent = false;
        if (!new File(modpackDir).isDirectory() && !new File(String.format("%s/manifest.json", modpackDir)).exists()) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.checkcurseforgedir.create"));
        } else if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.curseforge.cleanup.enabled").equalsIgnoreCase("true")) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.checkcurseforgedir"));
            this.cleanupEnvironment(modpackDir);
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.info.cleanup"));
            isModpackPresent = true;
        }
        return isModpackPresent;
    }

    public void cleanupEnvironment(String modpackDir) {
        FileUtils.deleteQuietly(new File(modpackDir));
    }
}

