/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import de.griefed.serverpackcreator.ApplicationProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component
public class VersionLister {
    private static final Logger LOG = LogManager.getLogger(VersionLister.class);
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private String minecraftReleaseVersion;
    private List<String> minecraftReleaseVersions;
    private String minecraftSnapshotVersion;
    private List<String> minecraftSnapshotVersions;
    private List<String> fabricVersions;
    private String fabricLatestVersion;
    private String fabricReleaseVersion;
    private String fabricLatestInstallerVersion;
    private String fabricReleaseInstallerVersion;
    private HashMap<String, String[]> forgeMeta;

    @Autowired
    public VersionLister(ApplicationProperties injectedApplicationProperties) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.minecraftReleaseVersion = this.setMinecraftSpecificVersion("release");
        this.minecraftReleaseVersions = this.getMinecraftVersionsList("release");
        this.minecraftSnapshotVersion = this.setMinecraftSpecificVersion("snapshot");
        this.minecraftSnapshotVersions = this.getMinecraftVersionsList("snapshot");
        this.fabricVersions = this.setFabricVersionList();
        this.fabricLatestVersion = this.setFabricSpecificVersion("latest", this.getXml(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FABRIC));
        this.fabricReleaseVersion = this.setFabricSpecificVersion("release", this.getXml(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FABRIC));
        this.fabricLatestInstallerVersion = this.setFabricSpecificVersion("latest", this.getXml(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FABRIC_INSTALLER));
        this.fabricReleaseInstallerVersion = this.setFabricSpecificVersion("release", this.getXml(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FABRIC_INSTALLER));
        this.forgeMeta = this.setForgeMeta();
    }

    public void refreshVersions() {
        this.minecraftReleaseVersion = this.setMinecraftSpecificVersion("release");
        this.minecraftReleaseVersions = this.getMinecraftVersionsList("release");
        this.minecraftSnapshotVersion = this.setMinecraftSpecificVersion("snapshot");
        this.minecraftSnapshotVersions = this.getMinecraftVersionsList("snapshot");
        this.fabricVersions = this.setFabricVersionList();
        this.fabricLatestVersion = this.setFabricSpecificVersion("latest", this.getXml(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FABRIC));
        this.fabricReleaseVersion = this.setFabricSpecificVersion("release", this.getXml(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FABRIC));
        this.fabricLatestInstallerVersion = this.setFabricSpecificVersion("latest", this.getXml(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FABRIC_INSTALLER));
        this.fabricReleaseInstallerVersion = this.setFabricSpecificVersion("release", this.getXml(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FABRIC_INSTALLER));
        this.forgeMeta = this.setForgeMeta();
    }

    public String getMinecraftReleaseVersion() {
        return this.minecraftReleaseVersion;
    }

    public List<String> getMinecraftReleaseVersions() {
        return this.minecraftReleaseVersions;
    }

    public String getMinecraftSnapshotVersion() {
        return this.minecraftSnapshotVersion;
    }

    public List<String> getMinecraftSnapshotVersions() {
        return this.minecraftSnapshotVersions;
    }

    public List<String> getFabricVersions() {
        return this.fabricVersions;
    }

    public String getFabricLatestVersion() {
        return this.fabricLatestVersion;
    }

    public String getFabricReleaseVersion() {
        return this.fabricReleaseVersion;
    }

    public HashMap<String, String[]> getForgeMeta() {
        return this.forgeMeta;
    }

    private HashMap<String, String[]> setForgeMeta() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (String version : this.minecraftReleaseVersions) {
            hashMap.put(version, this.reverseOrderArray(this.getForgeVersionsAsArray(version)));
        }
        return hashMap;
    }

    public String getFabricLatestInstallerVersion() {
        return this.fabricLatestInstallerVersion;
    }

    public String getFabricReleaseInstallerVersion() {
        return this.fabricReleaseInstallerVersion;
    }

    public List<String> reverseOrderList(List<String> listToReverse) {
        return Lists.reverse(listToReverse);
    }

    public String[] reverseOrderArray(String[] arrayToReverse) {
        int arrayLength = arrayToReverse.length;
        for (int i2 = 0; i2 < arrayLength / 2; ++i2) {
            String entry = arrayToReverse[i2];
            arrayToReverse[i2] = arrayToReverse[arrayLength - i2 - 1];
            arrayToReverse[arrayLength - i2 - 1] = entry;
        }
        return arrayToReverse;
    }

    public String[] getMinecraftReleaseVersionsAsArray() {
        String[] array = new String[this.minecraftReleaseVersions.size()];
        array = this.minecraftReleaseVersions.toArray(array);
        return array;
    }

    public String[] getFabricVersionsAsArray() {
        String[] array = new String[this.fabricVersions.size()];
        array = this.fabricVersions.toArray(array);
        return array;
    }

    public String[] getForgeVersionsAsArray(String selectedMinecraftVersion) {
        String[] array = new String[this.getForgeVersionsList(selectedMinecraftVersion).size()];
        array = this.getForgeVersionsList(selectedMinecraftVersion).toArray(array);
        return array;
    }

    public List<String> getForgeVersionsAsList(String selectedMinecraftVersion) {
        ArrayList<String> versions = new ArrayList<String>(1000);
        versions.addAll(Arrays.asList(this.getForgeVersionsAsArray(selectedMinecraftVersion)));
        return versions;
    }

    private JsonNode getJson(File manifestFile) throws IOException {
        byte[] jsonData = Files.readAllBytes(manifestFile.toPath());
        return this.getObjectMapper().readTree(jsonData);
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return objectMapper;
    }

    @NotNull
    private Document getXml(File manifest) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document xml = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            assert (documentBuilder != null);
            xml = documentBuilder.parse(manifest);
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
        }
        assert (xml != null);
        xml.normalize();
        return xml;
    }

    private List<String> getMinecraftVersionsList(String type) {
        ArrayList<String> minecraftReleases = new ArrayList<String>();
        try {
            JsonNode minecraftJson = this.getJson(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_MINECRAFT);
            JsonNode versions = minecraftJson.get("versions");
            for (JsonNode version : versions) {
                try {
                    if (!version.get("type").asText().equals(type)) continue;
                    minecraftReleases.add(version.get("id").asText());
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        catch (IOException ex) {
            LOG.error("Couldn't read Minecraft manifest.", (Throwable)ex);
        }
        return minecraftReleases;
    }

    private String setMinecraftSpecificVersion(String type) {
        String minecraftVersion = null;
        try {
            JsonNode minecraftJson = this.getJson(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_MINECRAFT);
            minecraftVersion = minecraftJson.get("latest").get(type).asText();
        }
        catch (IOException ex) {
            LOG.error("Couldn't read Minecraft manifest.", (Throwable)ex);
        }
        return minecraftVersion;
    }

    private List<String> getForgeVersionsList(String selectedMinecraftVersion) {
        ArrayList<String> forgeReleases = new ArrayList<String>();
        try {
            JsonNode forgeJson = this.getJson(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FORGE);
            try {
                JsonNode versions = forgeJson.get(selectedMinecraftVersion);
                for (JsonNode version : versions) {
                    forgeReleases.add(version.asText().replace(selectedMinecraftVersion + "-", ""));
                }
            }
            catch (NullPointerException ignored) {
                forgeReleases.add("None");
            }
        }
        catch (IOException ex) {
            LOG.error("Couldn't read Forge manifest.", (Throwable)ex);
        }
        return forgeReleases;
    }

    private List<String> setFabricVersionList() {
        ArrayList<String> fabricReleases = new ArrayList<String>();
        Document fabricXml = this.getXml(this.APPLICATIONPROPERTIES.PATH_FILE_MANIFEST_FABRIC);
        NodeList versions = fabricXml.getElementsByTagName("version");
        for (int i2 = 0; i2 < versions.getLength(); ++i2) {
            fabricReleases.add(versions.item(i2).getChildNodes().item(0).getNodeValue());
        }
        LOG.debug("Fabric versions: " + fabricReleases);
        return fabricReleases;
    }

    private String setFabricSpecificVersion(String versionSpecifier, Document manifest) {
        return manifest.getElementsByTagName(versionSpecifier).item(0).getChildNodes().item(0).getNodeValue();
    }
}

