/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moandjiezana.toml.Toml;
import de.griefed.serverpackcreator.ApplicationPlugins;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.DefaultFiles;
import de.griefed.serverpackcreator.VersionLister;
import de.griefed.serverpackcreator.curseforge.CurseCreateModpack;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.plugins.serverpackhandler.PostGenExtension;
import de.griefed.serverpackcreator.plugins.serverpackhandler.PreGenExtension;
import de.griefed.serverpackcreator.plugins.serverpackhandler.PreZipExtension;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.utilities.BooleanUtilities;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.ListUtilities;
import de.griefed.serverpackcreator.utilities.StringUtilities;
import de.griefed.serverpackcreator.utilities.SystemUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ExcludeFileFilter;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerPackHandler {
    private static final Logger LOG = LogManager.getLogger(DefaultFiles.class);
    private static final Logger LOG_ADDONS = LogManager.getLogger("AddonsLogger");
    private static final Logger LOG_INSTALLER = LogManager.getLogger("InstallerLogger");
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final CurseCreateModpack CURSECREATEMODPACK;
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final VersionLister VERSIONLISTER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final BooleanUtilities BOOLEANUTILITIES;
    private final ConfigUtilities CONFIGUTILITIES;
    private final ListUtilities LISTUTILITIES;
    private final StringUtilities STRINGUTILITIES;
    private final SystemUtilities SYSTEMUTILITIES;
    private final ApplicationPlugins APPLICATIONPLUGINS;

    @Autowired
    public ServerPackHandler(LocalizationManager injectedLocalizationManager, CurseCreateModpack injectedCurseCreateModpack, ConfigurationHandler injectedConfigurationHandler, ApplicationProperties injectedApplicationProperties, VersionLister injectedVersionLister, BooleanUtilities injectedBooleanUtilities, ListUtilities injectedListUtilities, StringUtilities injectedStringUtilities, SystemUtilities injectedSystemUtilities, ConfigUtilities injectedConfigUtilities, ApplicationPlugins injectedPluginManager) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        this.VERSIONLISTER = injectedVersionLister == null ? new VersionLister(this.APPLICATIONPROPERTIES) : injectedVersionLister;
        this.BOOLEANUTILITIES = injectedBooleanUtilities == null ? new BooleanUtilities(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES) : injectedBooleanUtilities;
        this.LISTUTILITIES = injectedListUtilities == null ? new ListUtilities() : injectedListUtilities;
        this.STRINGUTILITIES = injectedStringUtilities == null ? new StringUtilities() : injectedStringUtilities;
        this.SYSTEMUTILITIES = injectedSystemUtilities == null ? new SystemUtilities() : injectedSystemUtilities;
        this.CONFIGUTILITIES = injectedConfigUtilities == null ? new ConfigUtilities(this.LOCALIZATIONMANAGER, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.APPLICATIONPROPERTIES, this.STRINGUTILITIES, this.VERSIONLISTER) : injectedConfigUtilities;
        this.CURSECREATEMODPACK = injectedCurseCreateModpack == null ? new CurseCreateModpack(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES, this.VERSIONLISTER, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.STRINGUTILITIES, this.CONFIGUTILITIES, this.SYSTEMUTILITIES) : injectedCurseCreateModpack;
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler == null ? new ConfigurationHandler(this.LOCALIZATIONMANAGER, this.CURSECREATEMODPACK, this.VERSIONLISTER, this.APPLICATIONPROPERTIES, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.STRINGUTILITIES, this.SYSTEMUTILITIES, this.CONFIGUTILITIES) : injectedConfigurationHandler;
        this.APPLICATIONPLUGINS = injectedPluginManager == null ? new ApplicationPlugins() : injectedPluginManager;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return objectMapper;
    }

    public ServerPackModel run(@NotNull ServerPackModel serverPackModel) {
        String destination = String.format("%s/%s", this.APPLICATIONPROPERTIES.getDirectoryServerPacks(), serverPackModel.getModpackDir().substring(serverPackModel.getModpackDir().lastIndexOf("/") + 1) + serverPackModel.getServerPackSuffix());
        this.run((ConfigurationModel)serverPackModel);
        this.cleanupEnvironment(false, destination);
        this.CURSECREATEMODPACK.cleanupEnvironment(serverPackModel.getModpackDir());
        serverPackModel.setStatus("Available");
        serverPackModel.setSize(Double.parseDouble(String.valueOf(FileUtils.sizeOfAsBigInteger(new File(destination + "_server_pack.zip")).divide(BigInteger.valueOf(0x100000L)))));
        serverPackModel.setPath(destination + "_server_pack.zip");
        return serverPackModel;
    }

    public boolean run(@NotNull ConfigurationModel configurationModel) {
        String destination = new File(String.format("%s/%s", this.APPLICATIONPROPERTIES.getDirectoryServerPacks(), configurationModel.getModpackDir().substring(configurationModel.getModpackDir().lastIndexOf("/") + 1) + configurationModel.getServerPackSuffix())).getAbsolutePath().replace("\\", "/");
        if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.serverpack.overwrite.enabled").equals("false") && new File(destination).exists()) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.overwrite"));
            return true;
        }
        this.cleanupEnvironment(true, destination);
        try {
            Files.createDirectories(Paths.get(destination, new String[0]), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.APPLICATIONPLUGINS.PLUGINS_SERVERPACKSTART.size() > 0) {
            LOG_ADDONS.info("Executing PreGenExtension addons");
            for (PreGenExtension start : this.APPLICATIONPLUGINS.PLUGINS_SERVERPACKSTART) {
                LOG_ADDONS.info("Executing plugin " + start.getName());
                try {
                    start.run(this.APPLICATIONPROPERTIES, configurationModel, destination);
                }
                catch (Exception ex) {
                    LOG_ADDONS.error(start.getName() + " encountered an error.", (Throwable)ex);
                }
            }
        } else {
            LOG.info("No PreGenExtension addons to execute.");
        }
        this.copyFiles(configurationModel.getModpackDir(), configurationModel.getCopyDirs(), configurationModel.getClientMods(), configurationModel.getMinecraftVersion(), destination);
        this.createStartScripts(configurationModel.getModLoader(), configurationModel.getJavaArgs(), configurationModel.getMinecraftVersion(), configurationModel.getModLoaderVersion(), destination);
        if (configurationModel.getIncludeServerInstallation()) {
            this.installServer(configurationModel.getModLoader(), configurationModel.getMinecraftVersion(), configurationModel.getModLoaderVersion(), configurationModel.getJavaPath(), destination);
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.server"));
        }
        if (configurationModel.getModLoader().equalsIgnoreCase("Fabric")) {
            this.provideImprovedFabricServerLauncher(configurationModel.getMinecraftVersion(), configurationModel.getModLoaderVersion(), destination);
        }
        if (configurationModel.getIncludeServerIcon()) {
            this.copyIcon(destination, configurationModel.getServerIconPath());
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.icon"));
        }
        if (configurationModel.getIncludeServerProperties()) {
            this.copyProperties(destination, configurationModel.getServerPropertiesPath());
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.properties"));
        }
        if (this.APPLICATIONPLUGINS.PLUGINS_SERVERPACKCREATED.size() > 0) {
            LOG_ADDONS.info("Executing PreZipExtension addons");
            for (PreZipExtension created : this.APPLICATIONPLUGINS.PLUGINS_SERVERPACKCREATED) {
                LOG_ADDONS.info("Executing plugin " + created.getName());
                try {
                    created.run(this.APPLICATIONPROPERTIES, configurationModel, destination);
                }
                catch (Exception ex) {
                    LOG_ADDONS.error(created.getName() + " encountered an error.", (Throwable)ex);
                }
            }
        } else {
            LOG.info("No PreZipExtension addons to execute.");
        }
        if (configurationModel.getIncludeZipCreation()) {
            this.zipBuilder(configurationModel.getMinecraftVersion(), configurationModel.getIncludeServerInstallation(), destination);
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.zip"));
        }
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.serverpack"), destination));
        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.archive"), destination));
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("main.log.info.runincli.finish"));
        if (this.APPLICATIONPLUGINS.PLUGINS_SERVERPACKARCHIVECREATED.size() > 0) {
            LOG_ADDONS.info("Executing PostGenExtension addons");
            for (PostGenExtension archive : this.APPLICATIONPLUGINS.PLUGINS_SERVERPACKARCHIVECREATED) {
                LOG_ADDONS.info("Executing plugin " + archive.getName());
                try {
                    archive.run(this.APPLICATIONPROPERTIES, configurationModel, destination);
                }
                catch (Exception ex) {
                    LOG_ADDONS.error(archive.getName() + " encountered an error.", (Throwable)ex);
                }
            }
        } else {
            LOG.info("No PostGenExtension addons to execute.");
        }
        return true;
    }

    private void provideImprovedFabricServerLauncher(String minecraftVersion, String modLoaderVersion, String destination) {
        URL downloadUrl;
        String fileDestination = String.format("%s/fabric-server-launcher.jar", destination);
        try {
            downloadUrl = new URL(String.format("https://meta.fabricmc.net/v2/versions/loader/%s/%s/%s/server/jar", minecraftVersion, modLoaderVersion, this.VERSIONLISTER.getFabricReleaseInstallerVersion()));
        }
        catch (Exception ex) {
            LOG.error("Couldn't create Fabric Server Launcher URL.", (Throwable)ex);
            downloadUrl = null;
        }
        if (downloadUrl != null && this.SYSTEMUTILITIES.downloadFile(fileDestination, downloadUrl)) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.fabric.improved"));
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/SERVER_PACK_INFO.txt", destination), new String[0]))));){
                writer.write("If you are using this server pack on a managed server, meaning you can not execute scripts, please use the fabric-server-launcher.jar instead of the fabric-server-launch.jar. Note the extra \"er\" at the end of \"launcher\".\n");
                writer.write("This is the improved Fabric Server Launcher, which will take care of downloading and installing the Minecraft server and any and all libraries needed for running the Fabric server.\n");
                writer.write("\n");
                writer.write("The downside of this method is the occasional incompatibility of mods with the Fabric version, as the new Fabric Server Launcher always uses the latest available Fabric version.\n");
                writer.write("If a mod is incompatible with said latest Fabric version, contact the mod-author and ask them to remedy the situation.\n");
                writer.write("The official Fabric Discord had the following to add to this:\n");
                writer.write("    Fabric loader however is cross version, so unless there is a mod incompatibility (which usually involves the mod being broken / using non-api internals)\n");
                writer.write("    there is no good reason to use anything but the latest. I.e. the latest loader on any Minecraft version works with the new server launcher.");
            }
            catch (IOException ex) {
                LOG.error("Error generating shell-script for Forge.", (Throwable)ex);
            }
        }
    }

    private void cleanupEnvironment(boolean deleteZip, String destination) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupenvironment.folder.enter"));
        FileUtils.deleteQuietly(new File(destination));
        if (deleteZip) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupenvironment.zip.enter"));
            FileUtils.deleteQuietly(new File(String.format("%s_server_pack.zip", destination)));
        }
    }

    private void createStartScripts(String modLoader, String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        if (javaArguments.equals("empty")) {
            javaArguments = "";
        }
        if (modLoader.equalsIgnoreCase("Forge")) {
            String[] minecraft = minecraftVersion.split("\\.");
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copystartscripts.forge"));
            if (Integer.parseInt(minecraft[1]) < 17) {
                this.forgeBatchScript(javaArguments, minecraftVersion, modloaderVersion, destination);
                this.forgeShellScript(javaArguments, minecraftVersion, modloaderVersion, destination);
            } else {
                this.forgeBatchScriptNewMC(javaArguments, minecraftVersion, modloaderVersion, destination);
                this.forgeShellScriptNewMC(javaArguments, minecraftVersion, modloaderVersion, destination);
                this.forgeJvmArgsTxt(javaArguments, destination);
            }
        } else if (modLoader.equalsIgnoreCase("Fabric")) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copystartscripts.fabric"));
            this.fabricBatchScript(javaArguments, minecraftVersion, modloaderVersion, destination);
            this.fabricShellScript(javaArguments, minecraftVersion, modloaderVersion, destination);
        } else {
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodloader"));
        }
    }

    private void fabricShellScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.FILE_LINUX), new String[0]))));){
            writer.write("#!/usr/bin/env bash\n");
            writer.write("# Start script generated by ServerPackCreator.\n");
            writer.write("# This script checks for the Minecraft and Forge JAR-Files, and if they are not found, they are downloaded and installed.\n");
            writer.write("# If everything is in order, the server is started.\n");
            writer.write("\n");
            writer.write("JAVA=\"java\"\n");
            writer.write("MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("FABRIC=\"" + modloaderVersion + "\"\n");
            writer.write("INSTALLER=\"" + this.VERSIONLISTER.getFabricReleaseInstallerVersion() + "\"\n");
            writer.write("ARGS=\"" + javaArguments + "\"\n");
            writer.write("OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"fabric-server-launch.jar\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Fabric Server JAR-file not found. Downloading installer...\";\n");
            writer.write("  wget -O fabric-installer.jar https://maven.fabricmc.net/net/fabricmc/fabric-installer/$INSTALLER/fabric-installer-$INSTALLER.jar;\n");
            writer.write("\n");
            writer.write("  if [[ -s \"fabric-installer.jar\" ]];then\n");
            writer.write("\n");
            writer.write("    echo \"Installer downloaded. Installing...\";\n");
            writer.write("    java -jar fabric-installer.jar server -mcversion $MINECRAFT -loader $FABRIC -downloadMinecraft;\n");
            writer.write("\n");
            writer.write("    if [[ -s \"fabric-server-launch.jar\" ]];then\n");
            writer.write("      rm -rf .fabric-installer;\n");
            writer.write("      rm -f fabric-installer.jar;\n");
            writer.write("      echo \"Installation complete. fabric-installer.jar deleted.\";\n");
            writer.write("    fi\n");
            writer.write("\n");
            writer.write("  else\n");
            writer.write("    echo \"fabric-installer.jar not found. Maybe the Fabric server are having trouble.\";\n");
            writer.write("    echo \"Please try again in a couple of minutes.\";\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"fabric-server-launch.jar present. Moving on...\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"server.jar\" ]];then\n");
            writer.write("  echo \"Minecraft Server JAR-file not found. Downloading...\";\n");
            writer.write("  wget -O server.jar " + this.getMinecraftServerJarUrl(minecraftVersion) + ";\n");
            writer.write("else\n");
            writer.write("  echo \"server.jar present. Moving on...\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"eula.txt\" ]];then\n");
            writer.write("  echo \"Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\"\n");
            writer.write("  echo \"Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\"\n");
            writer.write("  echo \"If you agree to Mojang's EULA then type 'I agree'\"\n");
            writer.write("  read ANSWER\n");
            writer.write("  if [[ \"$ANSWER\" = \"I agree\" ]]; then\n");
            writer.write("    echo \"User agreed to Mojang's EULA.\"\n");
            writer.write("    echo \"#By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).\" > eula.txt;\n");
            writer.write("    echo \"eula=true\" >> eula.txt;\n");
            writer.write("  else\n");
            writer.write("    echo \"User did not agree to Mojang's EULA.\"\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"eula.txt present. Moving on...\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("echo \"Starting server...\";\n");
            writer.write("echo \"Minecraft version: $MINECRAFT\";\n");
            writer.write("echo \"Fabric version: $FABRIC\";\n");
            writer.write("echo \"Java version:\"\n");
            writer.write("$JAVA -version\n");
            writer.write("echo \"Java args: $ARGS\";\n");
            writer.write("\n");
            writer.write("$JAVA $OTHERARGS $ARGS -jar fabric-server-launch.jar nogui");
        }
        catch (IOException ex) {
            LOG.error("Error generating shell-script for Forge.", (Throwable)ex);
        }
    }

    private void fabricBatchScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.FILE_WINDOWS), new String[0]))));){
            writer.write(":: Start script generated by ServerPackCreator.\n");
            writer.write(":: This script checks for the Minecraft and Fabric JAR-files, and if they are not found, they are downloaded and installed.\n");
            writer.write(":: If everything is in order, the server is started.\n");
            writer.write("@ECHO off\n");
            writer.write("\n");
            writer.write("SET JAVA=\"java\"\n");
            writer.write("SET MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("SET FABRIC=\"" + modloaderVersion + "\"\n");
            writer.write("SET INSTALLER=\"" + this.VERSIONLISTER.getFabricReleaseInstallerVersion() + "\"\n");
            writer.write("SET ARGS=" + javaArguments + "\n");
            writer.write("SET OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("SET AGREE=\"I agree\"\n");
            writer.write("\n");
            writer.write("IF NOT EXIST fabric-server-launch.jar (\n");
            writer.write("\n");
            writer.write("  ECHO Fabric Server JAR-file not found. Downloading installer...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('https://maven.fabricmc.net/net/fabricmc/fabric-installer/%INSTALLER%/fabric-installer-%INSTALLER%.jar', 'fabric-installer.jar')\"\n");
            writer.write("\n");
            writer.write("  IF EXIST fabric-installer.jar (\n");
            writer.write("\n");
            writer.write("    ECHO Installer downloaded. Installing...\n");
            writer.write("    java -jar fabric-installer.jar server -mcversion %MINECRAFT% -loader %FABRIC% -downloadMinecraft\n");
            writer.write("\n");
            writer.write("    IF EXIST fabric-server-launch.jar (\n");
            writer.write("      RMDIR /S /Q .fabric-installer\n");
            writer.write("      DEL fabric-installer.jar\n");
            writer.write("      ECHO Installation complete. fabric-installer.jar and installation files deleted.\n");
            writer.write("    )\n");
            writer.write("\n");
            writer.write("  ) ELSE (\n");
            writer.write("    ECHO fabric-installer.jar not found. Maybe the Fabric servers are having trouble.\n");
            writer.write("    ECHO Please try again in a couple of minutes.\n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO fabric-server-launch.jar present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST server.jar (\n");
            writer.write("  ECHO Minecraft Server JAR-file not found. Downloading...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('" + this.getMinecraftServerJarUrl(minecraftVersion) + "', 'server.jar')\"\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO server.jar present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST eula.txt (\n");
            writer.write("  ECHO Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\n");
            writer.write("  ECHO Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\n");
            writer.write("  ECHO If you agree to Mojang's EULA then type \"I agree\"\n");
            writer.write("  set /P \"Response=\"\n");
            writer.write("  IF \"%Response%\" == \"%AGREE%\" (\n");
            writer.write("    ECHO User agreed to Mojang's EULA.\n");
            writer.write("    ECHO #By changing the setting below to TRUE you are indicating your agreement to our EULA ^(https://account.mojang.com/documents/minecraft_eula^).> eula.txt\n");
            writer.write("    ECHO eula=true>> eula.txt\n");
            writer.write("  ) else (\n");
            writer.write("    ECHO User did not agree to Mojang's EULA. \n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO eula.txt present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("ECHO Starting server...\n");
            writer.write("ECHO Minecraft version: %MINECRAFT%\n");
            writer.write("ECHO Fabric version: %FABRIC%\n");
            writer.write("ECHO Java version:\n");
            writer.write("%JAVA% --version\n");
            writer.write("ECHO Java args: %ARGS%\n");
            writer.write("\n");
            writer.write("%JAVA% \"%OTHERARGS%\" %ARGS% -jar fabric-server-launch.jar nogui\n");
            writer.write("\n");
            writer.write("PAUSE");
        }
        catch (IOException ex) {
            LOG.error("Error generating batch-script for Forge.", (Throwable)ex);
        }
    }

    private void forgeJvmArgsTxt(String javaArguments, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.FILE_FORGE_ONE_SEVEN_USER_JVM_ARGS), new String[0]))));){
            writer.write("# Xmx and Xms set the maximum and minimum RAM usage, respectively.\n");
            writer.write("# They can take any number, followed by an M or a G.\n");
            writer.write("# M means Megabyte, G means Gigabyte.\n");
            writer.write("# For example, to set the maximum to 3GB: -Xmx3G\n");
            writer.write("# To set the minimum to 2.5GB: -Xms2500M\n");
            writer.write("\n");
            writer.write("# A good default for a modded server is 4GB.\n");
            writer.write("# Uncomment the next line to set it.\n");
            writer.write("# -Xmx4G\n");
            writer.write(javaArguments);
        }
        catch (IOException ex) {
            LOG.error("Error generating user_jvm_args.txt for Forge.", (Throwable)ex);
        }
    }

    private void forgeShellScriptNewMC(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.FILE_LINUX), new String[0]))));){
            writer.write("#!/usr/bin/env bash\n");
            writer.write("# Start script generated by ServerPackCreator.\n");
            writer.write("# This script checks for the Minecraft and Forge JAR-files, and if they are not found, they are downloaded and installed.\n");
            writer.write("# If everything is in order, the server is started.\n");
            writer.write("\n");
            writer.write("JAVA=\"java\"\n");
            writer.write("MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("FORGE=\"" + modloaderVersion + "\"\n");
            writer.write("ARGS=\"" + javaArguments + "\"\n");
            writer.write("OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"libraries/net/minecraftforge/forge/$MINECRAFT-$FORGE/forge-$MINECRAFT-$FORGE-server.jar\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Forge Server JAR-file not found. Downloading installer...\";\n");
            writer.write("  wget -O forge-installer.jar https://files.minecraftforge.net/maven/net/minecraftforge/forge/$MINECRAFT-$FORGE/forge-$MINECRAFT-$FORGE-installer.jar;\n");
            writer.write("\n");
            writer.write("  if [[ -s \"forge-installer.jar\" ]]; then\n");
            writer.write("\n");
            writer.write("    echo \"Installer downloaded. Installing...\";\n");
            writer.write("    java -jar forge-installer.jar --installServer;\n");
            writer.write("\n");
            writer.write("    if [[ -s \"libraries/net/minecraftforge/forge/$MINECRAFT-$FORGE/forge-$MINECRAFT-$FORGE-server.jar\" ]];then\n");
            writer.write("      rm -f forge-installer.jar;\n");
            writer.write("      echo \"Installation complete. forge-installer.jar deleted.\";\n");
            writer.write("    fi\n");
            writer.write("\n");
            writer.write("  else\n");
            writer.write("    echo \"forge-installer.jar not found. Maybe the Forges servers are having trouble.\";\n");
            writer.write("    echo \"Please try again in a couple of minutes.\";\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"Forge server present. Moving on...\"\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"libraries/net/minecraft/server/$MINECRAFT/server-$MINECRAFT.jar\" ]];then\n");
            writer.write("  echo \"Minecraft Server JAR-file not found. Downloading...\";\n");
            writer.write("  wget -O libraries/net/minecraft/server/$MINECRAFT/server-$MINECRAFT.jar " + this.getMinecraftServerJarUrl(minecraftVersion) + ";\n");
            writer.write("else\n");
            writer.write("  echo \"Minecraft server present. Moving on...\"\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ -s \"run.bat\" ]];then\n");
            writer.write("  rm -f run.bat;\n");
            writer.write("  echo \"Deleted run.bat as we already have start.bat\";\n");
            writer.write("fi\n");
            writer.write("if [[ -s \"run.sh\" ]];then\n");
            writer.write("  rm -f run.sh;\n");
            writer.write("  echo \"Deleted run.sh as we already have start.sh\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"eula.txt\" ]];then\n");
            writer.write("  echo \"Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\"\n");
            writer.write("  echo \"Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\"\n");
            writer.write("  echo \"If you agree to Mojang's EULA then type 'I agree'\"\n");
            writer.write("  read ANSWER\n");
            writer.write("  if [[ \"$ANSWER\" = \"I agree\" ]]; then\n");
            writer.write("    echo \"User agreed to Mojang's EULA.\"\n");
            writer.write("    echo \"#By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).\" > eula.txt;\n");
            writer.write("    echo \"eula=true\" >> eula.txt;\n");
            writer.write("  else\n");
            writer.write("    echo \"User did not agree to Mojang's EULA.\"\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"eula.txt present. Moving on...\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("echo \"Starting server...\";\n");
            writer.write("echo \"Minecraft version: $MINECRAFT\";\n");
            writer.write("echo \"Forge version: $FORGE\";\n");
            writer.write("echo \"Java version:\"\n");
            writer.write("$JAVA -version\n");
            writer.write("echo \"Java args in user_jvm_args.txt: $ARGS\";\n");
            writer.write("\n");
            writer.write("# Forge requires a configured set of both JVM and program arguments.\n");
            writer.write("# Add custom JVM arguments to the user_jvm_args.txt\n");
            writer.write("# Add custom program arguments {such as nogui} to this file in the next line before the \"$@\" or\n");
            writer.write("#  pass them to this script directly\n");
            writer.write("echo \"If you receive the error message 'Error: Could not find or load main class @user_jvm_args.txt' you may be using the wrong Java-version for this modded Minecraft server. Contact the modpack-developer or, if you made the server pack yourself, do a quick google-search for the used Minecraft version to find out which Java-version is required in order to run this server.\"\n");
            writer.write("\n");
            writer.write("$JAVA $OTHERARGS @user_jvm_args.txt @libraries/net/minecraftforge/forge/$MINECRAFT-$FORGE/unix_args.txt nogui \"$@\"");
        }
        catch (IOException ex) {
            LOG.error("Error generating shell-script for Forge.", (Throwable)ex);
        }
    }

    private void forgeBatchScriptNewMC(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.FILE_WINDOWS), new String[0]))));){
            writer.write(":: Start script generated by ServerPackCreator.\n");
            writer.write(":: This script checks for the Minecraft and Forge JAR-files, and if they are not found, they are downloaded and installed.\n");
            writer.write(":: If everything is in order, the server is started.\n");
            writer.write("@ECHO off\n");
            writer.write("SetLocal EnableDelayedExpansion\n");
            writer.write("\n");
            writer.write("SET JAVA=\"java\"\n");
            writer.write("SET MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("SET FORGE=\"" + modloaderVersion + "\"\n");
            writer.write("SET ARGS=" + javaArguments + "\n");
            writer.write("SET OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("SET AGREE=\"I agree\"\n");
            writer.write("\n");
            writer.write("IF NOT EXIST libraries/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/forge-%MINECRAFT%-%FORGE%-server.jar (\n");
            writer.write("\n");
            writer.write("  ECHO Forge Server JAR-file not found. Downloading installer...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('https://files.minecraftforge.net/maven/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/forge-%MINECRAFT%-%FORGE%-installer.jar', 'forge-installer.jar')\"\n");
            writer.write("\n");
            writer.write("  IF EXIST forge-installer.jar (\n");
            writer.write("\n");
            writer.write("    ECHO Installer downloaded. Installing...\n");
            writer.write("    java -jar forge-installer.jar --installServer\n");
            writer.write("\n");
            writer.write("    IF EXIST libraries/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/forge-%MINECRAFT%-%FORGE%-server.jar (\n");
            writer.write("      DEL forge-installer.jar\n");
            writer.write("      ECHO Installation complete. forge-installer.jar deleted.\n");
            writer.write("    )\n");
            writer.write("\n");
            writer.write("  ) ELSE (\n");
            writer.write("    ECHO forge-installer.jar not found. Maybe the Forges servers are having trouble.\n");
            writer.write("    ECHO Please try again in a couple of minutes.\n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO Forge server present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST libraries/net/minecraft/server/%MINECRAFT%/server-%MINECRAFT%.jar (\n");
            writer.write("  ECHO Minecraft Server JAR-file not found. Downloading...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('" + this.getMinecraftServerJarUrl(minecraftVersion) + "', 'libraries/net/minecraft/server/%MINECRAFT%/server-%MINECRAFT%.jar')\"\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO Minecraft server present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF EXIST run.bat (\n");
            writer.write("  DEL run.bat\n");
            writer.write("  ECHO Deleted run.bat as we already have start.bat\n");
            writer.write(")\n");
            writer.write("IF EXIST run.sh (\n");
            writer.write("  DEL run.sh\n");
            writer.write("  ECHO Deleted run.sh as we already have start.sh\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST eula.txt (\n");
            writer.write("  ECHO Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\n");
            writer.write("  ECHO Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\n");
            writer.write("  ECHO If you agree to Mojang's EULA then type \"I agree\"\n");
            writer.write("  set /P \"Response=\"\n");
            writer.write("  IF \"%Response%\" == \"%AGREE%\" (\n");
            writer.write("    ECHO User agreed to Mojang's EULA.\n");
            writer.write("    ECHO #By changing the setting below to TRUE you are indicating your agreement to our EULA ^(https://account.mojang.com/documents/minecraft_eula^).> eula.txt\n");
            writer.write("    ECHO eula=true>> eula.txt\n");
            writer.write("  ) else (\n");
            writer.write("    ECHO User did not agree to Mojang's EULA. \n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO eula.txt present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("ECHO Starting server...\n");
            writer.write("ECHO Minecraft version: %MINECRAFT%\n");
            writer.write("ECHO Forge version: %FORGE%\n");
            writer.write("ECHO Java version:\n");
            writer.write("%JAVA% --version\n");
            writer.write("ECHO Java args in user_jvm_args.txt: %ARGS%\n");
            writer.write("\n");
            writer.write("REM Forge requires a configured set of both JVM and program arguments.\n");
            writer.write("REM Add custom JVM arguments to the user_jvm_args.txt\n");
            writer.write("REM Add custom program arguments {such as nogui} to this file in the next line before the %* or\n");
            writer.write("REM  pass them to this script directly\n");
            writer.write("ECHO If you receive the error message \"Error: Could not find or load main class @user_jvm_args.txt\" you may be using the wrong Java-version for this modded Minecraft server. Contact the modpack-developer or, if you made the server pack yourself, do a quick google-search for the used Minecraft version to find out which Java-version is required in order to run this server.\n");
            writer.write("\n");
            writer.write("%JAVA% \"%OTHERARGS%\" @user_jvm_args.txt @libraries/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/win_args.txt nogui %*\n");
            writer.write("\n");
            writer.write("PAUSE");
        }
        catch (IOException ex) {
            LOG.error("Error generating batch-script for Forge.", (Throwable)ex);
        }
    }

    private void forgeShellScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.FILE_LINUX), new String[0]))));){
            writer.write("#!/usr/bin/env bash\n");
            writer.write("# Start script generated by ServerPackCreator.\n");
            writer.write("# This script checks for the Minecraft and Forge JAR-files, and if they are not found, they are downloaded and installed.\n");
            writer.write("# If everything is in order, the server is started.\n");
            writer.write("\n");
            writer.write("JAVA=\"java\"\n");
            writer.write("MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("FORGE=\"" + modloaderVersion + "\"\n");
            writer.write("ARGS=\"" + javaArguments + "\"\n");
            writer.write("OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"forge.jar\" ]];then\n");
            writer.write("\n");
            writer.write("  echo \"Forge Server JAR-file not found. Downloading installer...\";\n");
            writer.write("  wget -O forge-installer.jar https://files.minecraftforge.net/maven/net/minecraftforge/forge/$MINECRAFT-$FORGE/forge-$MINECRAFT-$FORGE-installer.jar;\n");
            writer.write("\n");
            writer.write("  if [[ -s \"forge-installer.jar\" ]]; then\n");
            writer.write("\n");
            writer.write("    echo \"Installer downloaded. Installing...\";\n");
            writer.write("    java -jar forge-installer.jar --installServer;\n");
            writer.write("    mv forge-$MINECRAFT-$FORGE.jar forge.jar;\n");
            writer.write("\n");
            writer.write("    if [[ -s \"forge.jar\" ]];then\n");
            writer.write("      rm -f forge-installer.jar;\n");
            writer.write("      echo \"Installation complete. forge-installer.jar deleted.\";\n");
            writer.write("    fi\n");
            writer.write("\n");
            writer.write("  else\n");
            writer.write("    echo \"forge-installer.jar not found. Maybe the Forges servers are having trouble.\";\n");
            writer.write("    echo \"Please try again in a couple of minutes.\";\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"forge.jar present. Moving on...\"\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"minecraft_server.$MINECRAFT.jar\" ]];then\n");
            writer.write("  echo \"Minecraft Server JAR-file not found. Downloading...\";\n");
            writer.write("  wget -O minecraft_server.$MINECRAFT.jar " + this.getMinecraftServerJarUrl(minecraftVersion) + ";\n");
            writer.write("else\n");
            writer.write("  echo \"minecraft_server.$MINECRAFT.jar present. Moving on...\"\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("if [[ ! -s \"eula.txt\" ]];then\n");
            writer.write("  echo \"Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\"\n");
            writer.write("  echo \"Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\"\n");
            writer.write("  echo \"If you agree to Mojang's EULA then type 'I agree'\"\n");
            writer.write("  read ANSWER\n");
            writer.write("  if [[ \"$ANSWER\" = \"I agree\" ]]; then\n");
            writer.write("    echo \"User agreed to Mojang's EULA.\"\n");
            writer.write("    echo \"#By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).\" > eula.txt;\n");
            writer.write("    echo \"eula=true\" >> eula.txt;\n");
            writer.write("  else\n");
            writer.write("    echo \"User did not agree to Mojang's EULA.\"\n");
            writer.write("  fi\n");
            writer.write("else\n");
            writer.write("  echo \"eula.txt present. Moving on...\";\n");
            writer.write("fi\n");
            writer.write("\n");
            writer.write("echo \"Starting server...\";\n");
            writer.write("echo \"Minecraft version: $MINECRAFT\";\n");
            writer.write("echo \"Forge version: $FORGE\";\n");
            writer.write("echo \"Java version:\"\n");
            writer.write("$JAVA -version\n");
            writer.write("echo \"Java args: $ARGS\";\n");
            writer.write("\n");
            writer.write("$JAVA $OTHERARGS $ARGS -jar forge.jar nogui");
        }
        catch (IOException ex) {
            LOG.error("Error generating shell-script for Forge.", (Throwable)ex);
        }
    }

    private void forgeBatchScript(String javaArguments, String minecraftVersion, String modloaderVersion, String destination) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.FILE_WINDOWS), new String[0]))));){
            writer.write(":: Start script generated by ServerPackCreator.\n");
            writer.write(":: This script checks for the Minecraft and Forge JAR-files, and if they are not found, they are downloaded and installed.\n");
            writer.write(":: If everything is in order, the server is started.\n");
            writer.write("@ECHO off\n");
            writer.write("SetLocal EnableDelayedExpansion\n");
            writer.write("\n");
            writer.write("SET JAVA=\"java\"\n");
            writer.write("SET MINECRAFT=\"" + minecraftVersion + "\"\n");
            writer.write("SET FORGE=\"" + modloaderVersion + "\"\n");
            writer.write("SET ARGS=" + javaArguments + "\n");
            writer.write("SET OTHERARGS=\"-Dlog4j2.formatMsgNoLookups=true\"\n");
            writer.write("\n");
            writer.write("SET AGREE=\"I agree\"\n");
            writer.write("\n");
            writer.write("IF NOT EXIST forge.jar (\n");
            writer.write("\n");
            writer.write("  ECHO Forge Server JAR-file not found. Downloading installer...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('https://files.minecraftforge.net/maven/net/minecraftforge/forge/%MINECRAFT%-%FORGE%/forge-%MINECRAFT%-%FORGE%-installer.jar', 'forge-installer.jar')\"\n");
            writer.write("\n");
            writer.write("  IF EXIST forge-installer.jar (\n");
            writer.write("\n");
            writer.write("    ECHO Installer downloaded. Installing...\n");
            writer.write("    java -jar forge-installer.jar --installServer\n");
            writer.write("    MOVE forge-%MINECRAFT%-%FORGE%.jar forge.jar\n");
            writer.write("\n");
            writer.write("    IF EXIST forge.jar (\n");
            writer.write("      DEL forge-installer.jar\n");
            writer.write("      ECHO Installation complete. forge-installer.jar deleted.\n");
            writer.write("    )\n");
            writer.write("\n");
            writer.write("  ) ELSE (\n");
            writer.write("    ECHO forge-installer.jar not found. Maybe the Forges servers are having trouble.\n");
            writer.write("    ECHO Please try again in a couple of minutes.\n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO forge.jar present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST minecraft_server.%MINECRAFT%.jar (\n");
            writer.write("  ECHO Minecraft Server JAR-file not found. Downloading...\n");
            writer.write("  powershell -Command \"(New-Object Net.WebClient).DownloadFile('" + this.getMinecraftServerJarUrl(minecraftVersion) + "', 'minecraft_server.%MINECRAFT%.jar')\"\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO minecraft_server.%MINECRAFT%.jar present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("IF NOT EXIST eula.txt (\n");
            writer.write("  ECHO Mojang's EULA has not yet been accepted. In order to run a Minecraft server, you must accept Mojang's EULA.\n");
            writer.write("  ECHO Mojang's EULA is available to read at https://account.mojang.com/documents/minecraft_eula\n");
            writer.write("  ECHO If you agree to Mojang's EULA then type \"I agree\"\n");
            writer.write("  set /P \"Response=\"\n");
            writer.write("  IF \"%Response%\" == \"%AGREE%\" (\n");
            writer.write("    ECHO User agreed to Mojang's EULA.\n");
            writer.write("    ECHO #By changing the setting below to TRUE you are indicating your agreement to our EULA ^(https://account.mojang.com/documents/minecraft_eula^).> eula.txt\n");
            writer.write("    ECHO eula=true>> eula.txt\n");
            writer.write("  ) else (\n");
            writer.write("    ECHO User did not agree to Mojang's EULA. \n");
            writer.write("  )\n");
            writer.write(") ELSE (\n");
            writer.write("  ECHO eula.txt present. Moving on...\n");
            writer.write(")\n");
            writer.write("\n");
            writer.write("ECHO Starting server...\n");
            writer.write("ECHO Minecraft version: %MINECRAFT%\n");
            writer.write("ECHO Forge version: %FORGE%\n");
            writer.write("ECHO Java version:\n");
            writer.write("%JAVA% --version\n");
            writer.write("ECHO Java args: %ARGS%\n");
            writer.write("\n");
            writer.write("%JAVA% \"%OTHERARGS%\" %ARGS% -jar forge.jar nogui\n");
            writer.write("\n");
            writer.write("PAUSE");
        }
        catch (IOException ex) {
            LOG.error("Error generating batch-script for Forge.", (Throwable)ex);
        }
    }

    private void copyFiles(String modpackDir, List<String> directoriesToCopy, List<String> clientMods, String minecraftVersion, String destination) {
        try {
            Files.createDirectories(Paths.get(destination, new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error(String.format("Failed to create directory %s", destination));
        }
        directoriesToCopy.removeIf(n -> n.startsWith("!"));
        if (directoriesToCopy.size() == 1 && directoriesToCopy.get(0).equals("lazy_mode")) {
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode0"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode1"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode2"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode3"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode0"));
            try {
                FileUtils.copyDirectory(new File(modpackDir), new File(destination));
            }
            catch (IOException ex) {
                LOG.error("An error occurred copying the modpack to the server pack in lazy mode.", (Throwable)ex);
            }
        } else {
            for (String directory : directoriesToCopy) {
                String clientDir = String.format("%s/%s", modpackDir, directory);
                String serverDir = String.format("%s/%s", destination, directory);
                LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copyfiles.setup"), directory));
                if (directory.contains(";")) {
                    String[] sourceFileDestinationFileCombination = directory.split(";");
                    if (new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).isFile()) {
                        try {
                            FileUtils.copyFile(new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])), new File(String.format("%s/%s", destination, sourceFileDestinationFileCombination[1])), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException ex) {
                            LOG.error("An error occurred during the copy-procedure to the server pack.", (Throwable)ex);
                        }
                        continue;
                    }
                    if (new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).isDirectory()) {
                        try {
                            FileUtils.copyDirectory(new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])), new File(String.format("%s/%s", destination, sourceFileDestinationFileCombination[1])));
                        }
                        catch (Exception ex) {
                            LOG.error("An error occurred during the copy-procedure to the server pack.", (Throwable)ex);
                        }
                        continue;
                    }
                    if (new File(sourceFileDestinationFileCombination[0]).isFile()) {
                        try {
                            FileUtils.copyFile(new File(sourceFileDestinationFileCombination[0]), new File(String.format("%s/%s", destination, sourceFileDestinationFileCombination[1])), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException ex) {
                            LOG.error("An error occurred during the copy-procedure to the server pack.", (Throwable)ex);
                        }
                        continue;
                    }
                    if (!new File(sourceFileDestinationFileCombination[0]).isDirectory()) continue;
                    try {
                        FileUtils.copyDirectory(new File(sourceFileDestinationFileCombination[0]), new File(String.format("%s/%s", destination, sourceFileDestinationFileCombination[1])));
                    }
                    catch (Exception ex) {
                        LOG.error("An error occurred during the copy-procedure to the server pack.", (Throwable)ex);
                    }
                    continue;
                }
                if (directory.startsWith("saves/")) {
                    try {
                        FileUtils.copyDirectory(new File(clientDir), new File(String.format("%s/%s", destination, directory.substring(6))));
                    }
                    catch (IOException ex) {
                        LOG.error("An error occurred copying the specified world.", (Throwable)ex);
                    }
                    continue;
                }
                if (directory.startsWith("mods") && clientMods.size() > 0) {
                    List<String> listOfFiles = this.excludeClientMods(clientDir, clientMods, minecraftVersion);
                    try {
                        Files.createDirectories(Paths.get(serverDir, new String[0]), new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    for (String file2 : listOfFiles) {
                        try {
                            Files.copy(Paths.get(file2, new String[0]), Paths.get(String.format("%s/%s", serverDir, new File(file2).getName()), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            LOG.debug(String.format("Copying: %s", file2));
                        }
                        catch (IOException ex) {
                            if (ex.toString().startsWith("java.nio.file.DirectoryNotEmptyException")) continue;
                            LOG.error("An error occurred copying files to the serverpack.", (Throwable)ex);
                        }
                    }
                    continue;
                }
                if (new File(directory).isFile() && !new File(directory).isDirectory()) {
                    File sourceFile = new File(String.format("%s/%s", modpackDir, directory));
                    File destinationFile = new File(String.format("%s/%s", destination, directory));
                    try {
                        FileUtils.copyFile(sourceFile, destinationFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException ex) {
                        LOG.error("An error occurred during the copy-procedure to the server pack.", (Throwable)ex);
                    }
                    continue;
                }
                try {
                    Stream<Path> files = Files.walk(Paths.get(clientDir, new String[0]), new FileVisitOption[0]);
                    Throwable throwable = null;
                    try {
                        files.forEach(file -> {
                            block4: {
                                if (this.excludeFileOrDirectory(file.toString().replace("\\", "/"))) {
                                    LOG.debug("Excluding " + file + " from server pack");
                                } else {
                                    try {
                                        Files.copy(file, Paths.get(serverDir, new String[0]).resolve(Paths.get(clientDir, new String[0]).relativize((Path)file)), StandardCopyOption.REPLACE_EXISTING);
                                        LOG.debug(String.format("Copying: %s", file.toAbsolutePath()));
                                    }
                                    catch (IOException ex) {
                                        if (ex.toString().startsWith("java.nio.file.DirectoryNotEmptyException")) break block4;
                                        LOG.error("An error occurred copying files to the serverpack.", (Throwable)ex);
                                    }
                                }
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (files == null) continue;
                        if (throwable != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        files.close();
                    }
                }
                catch (IOException ex) {
                    LOG.error("An error occurred during the copy-procedure to the server pack.", (Throwable)ex);
                }
            }
        }
    }

    private List<String> excludeClientMods(String modsDir, List<String> userSpecifiedClientMods, String minecraftVersion) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.excludeclientmods"));
        String[] extensions = new String[]{"jar"};
        Collection<File> filesInModsDir = FileUtils.listFiles(new File(modsDir), extensions, true);
        ArrayList<String> modsInModpack = new ArrayList<String>();
        ArrayList<String> autodiscoveredClientMods = new ArrayList<String>();
        if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.serverpack.autodiscoverenabled").equals("true") && filesInModsDir != null) {
            String[] split = minecraftVersion.split("\\.");
            if (Integer.parseInt(split[1]) > 12) {
                autodiscoveredClientMods.addAll(this.scanTomls(filesInModsDir));
            } else {
                autodiscoveredClientMods.addAll(this.scanAnnotations(filesInModsDir));
            }
        }
        if (filesInModsDir != null) {
            for (File mod : filesInModsDir) {
                if (!mod.isFile() || !mod.toString().endsWith("jar")) continue;
                modsInModpack.add(mod.getAbsolutePath());
            }
        }
        if (!userSpecifiedClientMods.get(0).equals("")) {
            for (int m3 = 0; m3 < userSpecifiedClientMods.size(); ++m3) {
                int i2 = m3;
                if (!modsInModpack.removeIf(n -> n.contains((CharSequence)userSpecifiedClientMods.get(i2)))) continue;
                LOG.debug("Removed user-specified mod from mods list as per input: " + userSpecifiedClientMods.get(i2));
            }
        }
        if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.serverpack.autodiscoverenabled").equals("true") && autodiscoveredClientMods.size() > 0) {
            for (int m4 = 0; m4 < autodiscoveredClientMods.size(); ++m4) {
                int i3 = m4;
                if (!modsInModpack.removeIf(n -> n.replace("\\", "/").contains((CharSequence)autodiscoveredClientMods.get(i3)))) continue;
                LOG.debug("Automatically excluding mod: " + (String)autodiscoveredClientMods.get(i3));
            }
        }
        return modsInModpack;
    }

    private boolean excludeFileOrDirectory(String fileToCheckFor) {
        boolean isPresentInList = false;
        for (String entry : this.APPLICATIONPROPERTIES.getListOfDirectoriesToExclude()) {
            if (!fileToCheckFor.contains(entry)) continue;
            isPresentInList = true;
            break;
        }
        return isPresentInList;
    }

    private void copyIcon(String destination, String pathToServerIcon) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copyicon"));
        File defaultIcon = new File(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.FILE_SERVER_ICON));
        if (new File(pathToServerIcon).exists()) {
            BufferedImage originalImage = null;
            Image scaledImage = null;
            try {
                originalImage = ImageIO.read(new File(pathToServerIcon));
            }
            catch (IOException ex) {
                LOG.error("Error reading server-icon image.", (Throwable)ex);
            }
            if (originalImage != null) {
                scaledImage = originalImage.getScaledInstance(64, 64, 4);
                BufferedImage outputImage = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 2);
                outputImage.getGraphics().drawImage(scaledImage, 0, 0, null);
                try {
                    ImageIO.write((RenderedImage)outputImage, "png", defaultIcon);
                }
                catch (IOException ex) {
                    LOG.error("Error scaling image.", (Throwable)ex);
                    LOG.error("Using default icon as fallback.");
                    try {
                        FileUtils.copyFile(new File(String.format("server_files/%s", this.APPLICATIONPROPERTIES.FILE_SERVER_ICON)), defaultIcon);
                    }
                    catch (IOException e) {
                        LOG.error("An error occurred trying to copy the server-icon.", (Throwable)e);
                    }
                }
            } else {
                LOG.error("originalImage is null. Check the source file. Was it wrongly converted to it's current file-format? Is it malformed? Corrupted?");
            }
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.icon"));
            try {
                FileUtils.copyFile(new File(String.format("server_files/%s", this.APPLICATIONPROPERTIES.FILE_SERVER_ICON)), defaultIcon);
            }
            catch (IOException ex) {
                LOG.error("An error occurred trying to copy the server-icon.", (Throwable)ex);
            }
        }
    }

    private void copyProperties(String destination, String pathToServerProperties) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.copyproperties"));
        File defaultProperties = new File(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.FILE_SERVER_PROPERTIES));
        if (new File(pathToServerProperties).exists()) {
            try {
                FileUtils.copyFile(new File(pathToServerProperties), defaultProperties);
            }
            catch (IOException ex) {
                LOG.error("An error occurred trying to copy the server.properties-file.", (Throwable)ex);
            }
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.properties"));
            try {
                FileUtils.copyFile(new File(String.format("server_files/%s", this.APPLICATIONPROPERTIES.FILE_SERVER_PROPERTIES)), defaultProperties);
            }
            catch (IOException ex) {
                LOG.error("An error occurred trying to copy the server.properties-file.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installServer(String modLoader, String minecraftVersion, String modLoaderVersion, String javaPath, String destination) {
        String fileDestination;
        ArrayList<String> commandArguments = new ArrayList<String>();
        Process process = null;
        BufferedReader bufferedReader = null;
        URL downloadUrl = null;
        if (modLoader.equalsIgnoreCase("Fabric")) {
            LOG_INSTALLER.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.fabric.enter"));
            try {
                downloadUrl = new URL(String.format("https://maven.fabricmc.net/net/fabricmc/fabric-installer/%s/fabric-installer-%s.jar", this.VERSIONLISTER.getFabricReleaseInstallerVersion(), this.VERSIONLISTER.getFabricReleaseInstallerVersion()));
            }
            catch (MalformedURLException ex) {
                LOG.error("Couldn't create Fabric URL.", (Throwable)ex);
            }
            fileDestination = String.format("%s/fabric-installer.jar", destination);
            if (downloadUrl != null && this.SYSTEMUTILITIES.downloadFile(fileDestination, downloadUrl)) {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.fabric.download"));
                commandArguments.add(javaPath);
                commandArguments.add("-jar");
                commandArguments.add("fabric-installer.jar");
                commandArguments.add("server");
                commandArguments.add("-mcversion");
                commandArguments.add(minecraftVersion);
                commandArguments.add("-loader");
                commandArguments.add(modLoaderVersion);
                commandArguments.add("-downloadMinecraft");
            } else {
                LOG.error("Something went wrong during the installation of Fabric. Maybe the Fabric server are down or unreachable? Skipping...");
            }
        } else if (modLoader.equalsIgnoreCase("Forge")) {
            LOG_INSTALLER.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.forge.enter"));
            try {
                downloadUrl = new URL(String.format("https://files.minecraftforge.net/maven/net/minecraftforge/forge/%s-%s/forge-%s-%s-installer.jar", minecraftVersion, modLoaderVersion, minecraftVersion, modLoaderVersion));
            }
            catch (MalformedURLException ex) {
                LOG.error("Couldn't create Forge URL.", (Throwable)ex);
            }
            fileDestination = String.format("%s/forge-installer.jar", destination);
            if (downloadUrl != null && this.SYSTEMUTILITIES.downloadFile(fileDestination, downloadUrl)) {
                LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.forge.download"));
                commandArguments.add(javaPath);
                commandArguments.add("-jar");
                commandArguments.add("forge-installer.jar");
                commandArguments.add("--installServer");
            } else {
                LOG.error("Something went wrong during the installation of Forge. Maybe the Forge servers are down or unreachable? Skipping...");
            }
        } else {
            LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodloader"), modLoader));
        }
        try {
            String line;
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.enter"), minecraftVersion, modLoader, modLoaderVersion));
            ProcessBuilder processBuilder = new ProcessBuilder(commandArguments).directory(new File(destination));
            LOG.debug("ProcessBuilder command: " + processBuilder.command());
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                LOG_INSTALLER.info(line);
            }
            LOG_INSTALLER.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver"), minecraftVersion, modLoader, modLoaderVersion));
            LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver"), minecraftVersion, modLoader, modLoaderVersion));
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.installserver.details"));
        }
        catch (IOException ex) {
            LOG.error("Something went wrong during the installation of Forge. Maybe the Forge servers are down or unreachable? Skipping...", (Throwable)ex);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
            try {
                process.destroy();
            }
            catch (Exception exception) {}
            commandArguments.clear();
        }
        if (this.APPLICATIONPROPERTIES.getProperty("de.griefed.serverpackcreator.serverpack.cleanup.enabled").equalsIgnoreCase("true")) {
            this.cleanUpServerPack(new File(String.format("%s/fabric-installer.jar", destination)), new File(String.format("%s/forge-installer.jar", destination)), modLoader, minecraftVersion, modLoaderVersion, destination);
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanup"));
        }
    }

    public void zipBuilder(String minecraftVersion, boolean includeServerInstallation, String destination) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.zipbuilder.enter"));
        ArrayList<File> filesToExclude = new ArrayList<File>(Arrays.asList(new File(String.format("%s/minecraft_server.%s.jar", destination, minecraftVersion)), new File(String.format("%s/server.jar", destination)), new File(String.format("%s/libraries/net/minecraft/server/%s/server-%s.jar", destination, minecraftVersion, minecraftVersion))));
        ExcludeFileFilter excludeFileFilter = filesToExclude::contains;
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setExcludeFileFilter(excludeFileFilter);
        zipParameters.setIncludeRootFolder(false);
        zipParameters.setFileComment("Server pack made with ServerPackCreator by Griefed.");
        try (ZipFile zip2 = new ZipFile(String.format("%s_server_pack.zip", destination));){
            zip2.addFolder(new File(destination), zipParameters);
        }
        catch (IOException ex) {
            LOG.error("There was an error during zip creation.", (Throwable)ex);
        }
        if (includeServerInstallation) {
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.warn.zipbuilder.minecraftjar1"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.warn.zipbuilder.minecraftjar2"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.warn.zipbuilder.minecraftjar3"));
        }
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.zipbuilder.finish"));
    }

    private String getMinecraftServerJarUrl(String minecraftVersion) {
        String minecraftVersionJarUrl = null;
        try {
            JsonNode minecraftJson = this.getObjectMapper().readTree(Files.readAllBytes(new File("./work/minecraft-manifest.json").toPath()));
            JsonNode versions = minecraftJson.get("versions");
            for (JsonNode version : versions) {
                try {
                    if (!version.get("id").asText().equals(minecraftVersion)) continue;
                    InputStream inputStream2 = new URL(version.get("url").asText()).openStream();
                    Throwable throwable = null;
                    try {
                        JsonNode serverNode = this.getObjectMapper().readTree(inputStream2);
                        minecraftVersionJarUrl = serverNode.get("downloads").get("server").get("url").asText();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream2 == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream2.close();
                    }
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        catch (IOException ex) {
            LOG.error("Couldn't read Minecraft manifest.", (Throwable)ex);
        }
        return minecraftVersionJarUrl;
    }

    private void cleanUpServerPack(File fabricInstaller, File forgeInstaller, String modLoader, String minecraftVersion, String modLoaderVersion, String destination) {
        block30: {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupserverpack.enter"));
            if (modLoader.equalsIgnoreCase("Fabric")) {
                try {
                    if (Files.deleteIfExists(fabricInstaller.toPath())) {
                        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupserverpack.deleted"), fabricInstaller.getName()));
                        break block30;
                    }
                    LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.error.cleanupserverpack.delete"), fabricInstaller.getName()));
                }
                catch (IOException ex) {
                    LOG.error("Couldn't delete Fabric installer.");
                }
            } else if (modLoader.equalsIgnoreCase("Forge")) {
                String[] minecraft = minecraftVersion.split("\\.");
                try {
                    if (Files.deleteIfExists(forgeInstaller.toPath())) {
                        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupserverpack.deleted"), forgeInstaller.getName()));
                    } else {
                        LOG.error(String.format("Could not delete %s.", forgeInstaller.getName()));
                    }
                }
                catch (IOException ex) {
                    LOG.error("Couldn't delete Forge installer.");
                }
                try {
                    if (Files.deleteIfExists(Paths.get(String.format("%s/installer.log", destination), new String[0]))) {
                        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupserverpack.forgelog"));
                    } else if (Files.deleteIfExists(Paths.get(String.format("%s/forge-installer.jar.log", destination), new String[0]))) {
                        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupserverpack.forgelog"));
                    }
                }
                catch (IOException ex) {
                    LOG.error("Couldn't delete Forge server installation log.");
                }
                if (Integer.parseInt(minecraft[1]) < 17) {
                    try {
                        Files.copy(Paths.get(String.format("%s/forge-%s-%s.jar", destination, minecraftVersion, modLoaderVersion), new String[0]), Paths.get(String.format("%s/forge.jar", destination), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException ex) {
                        LOG.error("Error during Forge cleanup.", (Throwable)ex);
                    }
                    try {
                        if (Files.deleteIfExists(Paths.get(String.format("%s/forge-%s-%s.jar", destination, minecraftVersion, modLoaderVersion), new String[0])) && new File(String.format("%s/forge.jar", destination)).exists()) {
                            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.cleanupserverpack.rename"));
                            break block30;
                        }
                        LOG.error("There was an error during renaming or deletion of the forge server jar.");
                    }
                    catch (IOException ex) {
                        LOG.error("Couldn't delete old Forge jar.");
                    }
                } else {
                    try {
                        if (Files.deleteIfExists(Paths.get(String.format("%s/run.bat", destination), new String[0]))) {
                            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.bat.delete"));
                        } else {
                            LOG.error("Could not delete run.bat.");
                        }
                    }
                    catch (IOException ex) {
                        LOG.error("An error occurred during the deletion of run.bat.", (Throwable)ex);
                    }
                    try {
                        if (Files.deleteIfExists(Paths.get(String.format("%s/run.sh", destination), new String[0]))) {
                            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.sh.delete"));
                            break block30;
                        }
                        LOG.error("Could not delete run.sh.");
                    }
                    catch (IOException ex) {
                        LOG.error("An error occurred during the deletion of run.sh.", (Throwable)ex);
                    }
                }
            } else {
                LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodloader"), modLoader));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> scanTomls(Collection<File> filesInModsDir) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.scantoml"));
        ArrayList<String> serverMods = new ArrayList<String>();
        ArrayList<String> modsDelta = new ArrayList<String>();
        for (File mod : filesInModsDir) {
            if (!mod.toString().endsWith("jar")) continue;
            JarFile jarFile = null;
            JarEntry jarEntry = null;
            InputStream inputStream2 = null;
            try {
                jarFile = new JarFile(mod);
                jarEntry = jarFile.getJarEntry("META-INF/mods.toml");
                inputStream2 = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                String modId;
                Toml modToml;
                block69: {
                    if (inputStream2 == null) continue;
                    modToml = new Toml().read(inputStream2);
                    modId = modToml.getString("mods[0].modId");
                    try {
                        if (modToml.getString("mods[0].side").toLowerCase().matches("(server|both)") && !serverMods.contains(modId)) {
                            LOG.debug("Adding modId to list of server mods: " + modId);
                            serverMods.add(modId);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        if (modToml.getList("dependencies." + modId) == null) break block69;
                        for (int i2 = 0; i2 < modToml.getList("dependencies." + modId).size(); ++i2) {
                            try {
                                if (modToml.getString("dependencies." + modId + "[" + i2 + "].modId").toLowerCase().matches("(forge|minecraft)")) {
                                    if (modToml.getString("dependencies." + modId + "[" + i2 + "].side") == null && !serverMods.contains(modId)) {
                                        LOG.debug("Adding modId to list of server mods: " + modId);
                                        serverMods.add(modId);
                                    }
                                    if (modToml.getString("dependencies." + modId + "[" + i2 + "].side").toLowerCase().matches("(server|both)") && !serverMods.contains(modId)) {
                                        LOG.debug("Adding modId to list of server mods: " + modId);
                                        serverMods.add(modId);
                                    }
                                } else if (!serverMods.contains(modId) && modToml.getString("mods[0].side") == null) {
                                    LOG.debug("Adding modId to list of server mods: " + modId);
                                    serverMods.add(modId);
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            try {
                                if (modToml.getString("dependencies." + modId + "[" + i2 + "].modId").toLowerCase().matches("(forge|minecraft)") || !modToml.getString("dependencies." + modId + "[" + i2 + "].side").toLowerCase().matches("(server|both)") || serverMods.contains(modToml.getString("dependencies." + modId + "[" + i2 + "].modId"))) continue;
                                LOG.debug("Adding modId to list of server mods: " + modToml.getString("dependencies." + modId + "[" + i2 + "].modId"));
                                serverMods.add(modToml.getString("dependencies." + modId + "[" + i2 + "].modId"));
                                continue;
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (ClassCastException | NullPointerException ex) {
                        try {
                            for (int i3 = 0; i3 < modToml.getList("dependencies").size(); ++i3) {
                                LOG.warn(modId + " does not contain valid dependency definitions. Please contact the mod maker and ask them to fix their shit. :D");
                                String subDependencyId = null;
                                String subDependencySide = null;
                                for (String element : modToml.getList("dependencies").get(i3).toString().replace("{", "").replace("}", "").split(",")) {
                                    if (element.contains("modId")) {
                                        subDependencyId = element.substring(element.lastIndexOf("=") + 1);
                                        continue;
                                    }
                                    if (!element.contains("side")) continue;
                                    subDependencySide = element.substring(element.lastIndexOf("=") + 1);
                                }
                                if (subDependencyId == null || subDependencySide == null) continue;
                                if (!subDependencyId.equalsIgnoreCase("minecraft") && !subDependencyId.equalsIgnoreCase("forge")) {
                                    if (!subDependencySide.equalsIgnoreCase("both") && !subDependencySide.equalsIgnoreCase("server") || serverMods.contains(subDependencyId)) continue;
                                    LOG.debug("Adding modId to list of server mods: " + subDependencyId);
                                    serverMods.add(subDependencyId);
                                    continue;
                                }
                                if (!subDependencySide.equalsIgnoreCase("both") && !subDependencySide.equalsIgnoreCase("server") || serverMods.contains(modId)) continue;
                                LOG.debug("Adding modId to list of server mods: " + modId);
                                serverMods.add(modId);
                            }
                        }
                        catch (ClassCastException | NullPointerException runtimeException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (modToml.getString("mods[0].side") != null) continue;
                    try {
                        block70: {
                            if (modToml.getList("dependencies." + modId) != null) continue;
                            try {
                                if (modToml.getList("dependencies") == null && !serverMods.contains(modId)) {
                                    LOG.debug("Adding modId to list of server mods: " + modId);
                                    serverMods.add(modId);
                                }
                            }
                            catch (ClassCastException ex) {
                                if (serverMods.contains(modId)) break block70;
                                LOG.debug("Adding modId to list of server mods: " + modId);
                                serverMods.add(modId);
                            }
                        }
                        if (serverMods.contains(modId)) continue;
                        LOG.debug("Adding modId to list of server mods: " + modId);
                        serverMods.add(modId);
                    }
                    catch (NullPointerException ex) {
                        if (serverMods.contains(modId)) continue;
                        LOG.debug("Adding modId to list of server mods: " + modId);
                        serverMods.add(modId);
                    }
                }
                catch (ClassCastException | NullPointerException ex) {
                    // empty catch block
                }
            }
            catch (Exception ex) {
                LOG.error("Error acquiring sideness from mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception ex) {}
                try {
                    inputStream2.close();
                }
                catch (Exception ex) {}
                jarEntry = null;
            }
        }
        for (File mod : filesInModsDir) {
            String modToCheck = mod.toString().replace("\\", "/");
            boolean addToDelta = true;
            JarFile jarFile = null;
            JarEntry jarEntry = null;
            InputStream inputStream3 = null;
            try {
                jarFile = new JarFile(mod);
                jarEntry = jarFile.getJarEntry("META-INF/mods.toml");
                inputStream3 = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                if (inputStream3 == null) continue;
                Toml modToml = new Toml().read(inputStream3);
                for (String modId : serverMods) {
                    if (!modToml.getString("mods[0].modId").toLowerCase().matches(modId)) continue;
                    addToDelta = false;
                }
                if (!addToDelta) continue;
                modsDelta.add(modToCheck);
            }
            catch (Exception ex) {
                LOG.error("Couldn't acquire modId for mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
                try {
                    inputStream3.close();
                }
                catch (Exception exception) {}
                jarEntry = null;
            }
        }
        return modsDelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> scanAnnotations(Collection<File> filesInModsDir) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("createserverpack.log.info.scanannotation"));
        ArrayList<String> modDependencies = new ArrayList<String>();
        ArrayList<String> clientMods = new ArrayList<String>();
        ArrayList<String> modsDelta = new ArrayList<String>();
        for (File mod : filesInModsDir) {
            if (!mod.toString().endsWith("jar")) continue;
            String modId = null;
            JarFile jarFile = null;
            JarEntry jarEntry = null;
            InputStream inputStream2 = null;
            try {
                jarFile = new JarFile(mod);
                jarEntry = jarFile.getJarEntry("META-INF/fml_cache_annotation.json");
                inputStream2 = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                if (inputStream2 == null) continue;
                JsonNode modJson = this.getObjectMapper().readTree(inputStream2);
                for (JsonNode node : modJson) {
                    try {
                        for (JsonNode child : node.get("annotations")) {
                            try {
                                if (!child.get("values").get("modid").get("value").asText().isEmpty()) {
                                    modId = child.get("values").get("modid").get("value").asText();
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            try {
                                if (child.get("values").get("clientSideOnly").get("value").asText().equalsIgnoreCase("true") && !clientMods.contains(modId)) {
                                    clientMods.add(modId);
                                    LOG.debug("Added clientMod: " + modId);
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            try {
                                String dependency;
                                if (child.get("values").get("dependencies").get("value").asText().isEmpty()) continue;
                                if (child.get("values").get("dependencies").get("value").asText().contains(";")) {
                                    String[] dependencies;
                                    for (String dependency2 : dependencies = child.get("values").get("dependencies").get("value").asText().split(";")) {
                                        if (!dependency2.matches("(before:.*|after:.*|)") || modDependencies.contains(dependency2 = dependency2.substring(dependency2.lastIndexOf(":") + 1).replaceAll("(@.*|\\[.*)", "")) || dependency2.equalsIgnoreCase("forge") || dependency2.equals("*")) continue;
                                        modDependencies.add(dependency2);
                                        LOG.debug("Added dependency " + dependency2);
                                    }
                                    continue;
                                }
                                if (!child.get("values").get("dependencies").get("value").asText().matches("(before:.*|after:.*|)") || modDependencies.contains(dependency = child.get("values").get("dependencies").get("value").asText().substring(child.get("values").get("dependencies").get("value").asText().lastIndexOf(":") + 1).replaceAll("(@.*|\\[.*)", "")) || dependency.equalsIgnoreCase("forge") || dependency.equals("*")) continue;
                                modDependencies.add(dependency);
                                LOG.debug("Added dependency " + dependency);
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("Couldn't acquire sideness for mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception ex) {}
                try {
                    inputStream2.close();
                }
                catch (Exception ex) {}
                jarEntry = null;
            }
        }
        for (String dependency : modDependencies) {
            clientMods.removeIf(n -> n.contains(dependency));
            LOG.debug("Removing " + dependency + " from list of clientmods as it is a dependency for another mod.");
        }
        for (File mod : filesInModsDir) {
            String modToCheck = mod.toString().replace("\\", "/");
            String modIdTocheck = null;
            boolean addToDelta = false;
            JarFile jarFile = null;
            JarEntry jarEntry = null;
            InputStream inputStream3 = null;
            try {
                jarFile = new JarFile(mod);
                jarEntry = jarFile.getJarEntry("META-INF/fml_cache_annotation.json");
                inputStream3 = jarFile.getInputStream(jarEntry);
            }
            catch (Exception ex) {
                LOG.error("Can not scan " + mod);
            }
            try {
                if (inputStream3 == null) continue;
                JsonNode modJson = this.getObjectMapper().readTree(inputStream3);
                for (JsonNode node : modJson) {
                    try {
                        for (JsonNode child : node.get("annotations")) {
                            try {
                                if (!child.get("values").get("modid").get("value").asText().isEmpty()) {
                                    modIdTocheck = child.get("values").get("modid").get("value").asText();
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            try {
                                if (!child.get("values").get("clientSideOnly").get("value").asText().equalsIgnoreCase("true") || !clientMods.contains(modIdTocheck)) continue;
                                addToDelta = true;
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                if (!addToDelta) continue;
                modsDelta.add(modToCheck);
            }
            catch (Exception ex) {
                LOG.error("Couldn't acquire modId for mod " + mod, (Throwable)ex);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
                try {
                    inputStream3.close();
                }
                catch (Exception exception) {}
                jarEntry = null;
            }
        }
        return modsDelta;
    }
}

