/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import de.griefed.serverpackcreator.ApplicationPlugins;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.DefaultFiles;
import de.griefed.serverpackcreator.MainSpringBoot;
import de.griefed.serverpackcreator.ServerPackHandler;
import de.griefed.serverpackcreator.VersionLister;
import de.griefed.serverpackcreator.curseforge.CurseCreateModpack;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.swing.SwingGuiInitializer;
import de.griefed.serverpackcreator.utilities.BooleanUtilities;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.ConfigurationCreator;
import de.griefed.serverpackcreator.utilities.FileWatcher;
import de.griefed.serverpackcreator.utilities.JarUtilities;
import de.griefed.serverpackcreator.utilities.ListUtilities;
import de.griefed.serverpackcreator.utilities.StringUtilities;
import de.griefed.serverpackcreator.utilities.SystemUtilities;
import de.griefed.serverpackcreator.utilities.UpdateChecker;
import de.griefed.serverpackcreator.utilities.misc.Generated;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Generated
public class Main {
    private static final Logger LOG = LogManager.getLogger(Main.class);
    private static final File log4j2xml = new File("log4j2.xml");
    private static final File properties = new File("serverpackcreator.properties");

    public static void main(String[] args2) {
        JarUtilities jarUtilities = new JarUtilities();
        HashMap<String, String> systemInformation = jarUtilities.systemInformation(jarUtilities.getApplicationHomeForClass(Main.class));
        jarUtilities.copyFileFromJar(log4j2xml);
        try {
            properties.createNewFile();
        }
        catch (IOException ex) {
            LOG.error("Couldn't create empty serverpackcreator.properties.");
        }
        try {
            String prefix = "BOOT-INF/classes";
            String langSource = "/de/griefed/resources/lang";
            if (systemInformation.get("jarName").endsWith(".exe")) {
                prefix = "";
                langSource = "de/griefed/resources/lang";
            }
            jarUtilities.copyFolderFromJar(systemInformation.get("jarPath"), langSource, "lang", prefix, ".properties");
        }
        catch (IOException ex) {
            LOG.error("Error copying \"/de/griefed/resources/lang\" from the JAR-file.");
        }
        ApplicationProperties APPLICATIONPROPERTIES = new ApplicationProperties();
        List<String> programArgs = Arrays.asList(args2);
        LocalizationManager LOCALIZATIONMANAGER = Arrays.asList(args2).contains("-lang") ? new LocalizationManager(APPLICATIONPROPERTIES, programArgs.get(programArgs.indexOf("-lang") + 1)) : new LocalizationManager(APPLICATIONPROPERTIES);
        LOG.debug("Gathering system information to include in log to make debugging easier.");
        APPLICATIONPROPERTIES.setProperty("homeDir", systemInformation.get("jarPath").substring(0, systemInformation.get("jarPath").replace("\\", "/").lastIndexOf("/")).replace("\\", "/"));
        LOG.debug(LOCALIZATIONMANAGER.getLocalizedString("main.log.debug.warning"));
        LOG.warn(LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip0"));
        LOG.warn(LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip1"));
        LOG.warn(LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip2"));
        LOG.warn(LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip3"));
        LOG.warn(LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip4"));
        LOG.warn(LOCALIZATIONMANAGER.getLocalizedString("main.log.warn.wip0"));
        LOG.info(LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.enter"));
        LOG.info("ServerPackCreator version: " + APPLICATIONPROPERTIES.getServerPackCreatorVersion());
        LOG.info(String.format(LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.jarpath"), systemInformation.get("jarPath")));
        LOG.info(String.format(LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.jarname"), systemInformation.get("jarName")));
        LOG.info(String.format(LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.java"), systemInformation.get("javaVersion")));
        LOG.info(String.format(LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.osarchitecture"), systemInformation.get("osArch")));
        LOG.info(String.format(LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.osname"), systemInformation.get("osName")));
        LOG.info(String.format(LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.osversion"), systemInformation.get("osVersion")));
        LOG.info(LOCALIZATIONMANAGER.getLocalizedString("main.log.info.system.include"));
        if (Arrays.asList(args2).contains("-help")) {
            LOG.debug("Issued printing of help.");
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help01"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help02"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help03"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help04"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help05"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help06"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help07"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help08"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help09"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help10"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help11"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help12"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help13"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help14"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help15"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help16"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help17"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help18"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help19"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help20"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help21"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help22"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help23"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help24"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help26"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help25"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help27"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help28"));
            System.out.println("#");
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help29"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help30"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help31"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help32"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help33"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help34"));
            System.out.println("#");
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help35"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help36"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help37"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help38"));
            System.out.println(LOCALIZATIONMANAGER.getLocalizedString("main.console.help39"));
            LOG.debug("Help printed. Exiting with code 0.");
            System.exit(0);
        }
        DefaultFiles DEFAULTFILES = new DefaultFiles(LOCALIZATIONMANAGER, APPLICATIONPROPERTIES);
        DEFAULTFILES.filesSetup();
        FileWatcher FILEWATCHER = new FileWatcher(APPLICATIONPROPERTIES, DEFAULTFILES);
        if (Arrays.asList(args2).contains("-web")) {
            Main.webservice(DEFAULTFILES, systemInformation, LOCALIZATIONMANAGER, args2);
        } else {
            Main.regular(APPLICATIONPROPERTIES, LOCALIZATIONMANAGER, args2);
        }
    }

    private static void regular(ApplicationProperties APPLICATIONPROPERTIES, LocalizationManager LOCALIZATIONMANAGER, String[] args2) {
        ListUtilities LISTUTILITIES = new ListUtilities();
        StringUtilities STRINGUTILITIES = new StringUtilities();
        SystemUtilities SYSTEMUTILITIES = new SystemUtilities();
        UpdateChecker UPDATECHECKER = new UpdateChecker(LOCALIZATIONMANAGER, APPLICATIONPROPERTIES);
        VersionLister VERSIONLISTER = new VersionLister(APPLICATIONPROPERTIES);
        BooleanUtilities BOOLEANUTILITIES = new BooleanUtilities(LOCALIZATIONMANAGER, APPLICATIONPROPERTIES);
        ConfigUtilities CONFIGUTILITIES = new ConfigUtilities(LOCALIZATIONMANAGER, BOOLEANUTILITIES, LISTUTILITIES, APPLICATIONPROPERTIES, STRINGUTILITIES, VERSIONLISTER);
        CurseCreateModpack CURSECREATEMODPACK = new CurseCreateModpack(LOCALIZATIONMANAGER, APPLICATIONPROPERTIES, VERSIONLISTER, BOOLEANUTILITIES, LISTUTILITIES, STRINGUTILITIES, CONFIGUTILITIES, SYSTEMUTILITIES);
        ConfigurationHandler CONFIGURATIONHANDLER = new ConfigurationHandler(LOCALIZATIONMANAGER, CURSECREATEMODPACK, VERSIONLISTER, APPLICATIONPROPERTIES, BOOLEANUTILITIES, LISTUTILITIES, STRINGUTILITIES, SYSTEMUTILITIES, CONFIGUTILITIES);
        ConfigurationCreator CONFIGURATIONCREATOR = new ConfigurationCreator(LOCALIZATIONMANAGER, CONFIGURATIONHANDLER, BOOLEANUTILITIES, APPLICATIONPROPERTIES, LISTUTILITIES, STRINGUTILITIES, CONFIGUTILITIES, SYSTEMUTILITIES, CURSECREATEMODPACK, VERSIONLISTER);
        ApplicationPlugins APPLICATIONPLUGINS = new ApplicationPlugins();
        ServerPackHandler SERVERPACKHANDLER = new ServerPackHandler(LOCALIZATIONMANAGER, CURSECREATEMODPACK, CONFIGURATIONHANDLER, APPLICATIONPROPERTIES, VERSIONLISTER, BOOLEANUTILITIES, LISTUTILITIES, STRINGUTILITIES, SYSTEMUTILITIES, CONFIGUTILITIES, APPLICATIONPLUGINS);
        if (Arrays.asList(args2).contains("-cgen")) {
            Main.checkForUpdate(LOCALIZATIONMANAGER, UPDATECHECKER, APPLICATIONPROPERTIES);
            CONFIGURATIONCREATOR.createConfigurationFile();
            Main.runHeadless(CONFIGURATIONHANDLER, SERVERPACKHANDLER, APPLICATIONPROPERTIES);
        } else if (Arrays.asList(args2).contains("-cli") || GraphicsEnvironment.isHeadless()) {
            Main.checkForUpdate(LOCALIZATIONMANAGER, UPDATECHECKER, APPLICATIONPROPERTIES);
            Main.runHeadlessWithPreChecks(CONFIGURATIONHANDLER, SERVERPACKHANDLER, APPLICATIONPROPERTIES, CONFIGURATIONCREATOR);
        } else if (GraphicsEnvironment.isHeadless()) {
            Main.checkForUpdate(LOCALIZATIONMANAGER, UPDATECHECKER, APPLICATIONPROPERTIES);
            Main.runHeadlessWithPreChecks(CONFIGURATIONHANDLER, SERVERPACKHANDLER, APPLICATIONPROPERTIES, CONFIGURATIONCREATOR);
        } else {
            SwingGuiInitializer swingGuiInitializer = new SwingGuiInitializer(LOCALIZATIONMANAGER, CONFIGURATIONHANDLER, CURSECREATEMODPACK, SERVERPACKHANDLER, APPLICATIONPROPERTIES, VERSIONLISTER, BOOLEANUTILITIES, LISTUTILITIES, STRINGUTILITIES, CONFIGUTILITIES, SYSTEMUTILITIES, UPDATECHECKER, APPLICATIONPLUGINS);
            swingGuiInitializer.mainGUI();
        }
    }

    private static void webservice(DefaultFiles defaultFiles, HashMap<String, String> systemInformation, LocalizationManager localizationManager, String[] args2) {
        defaultFiles.checkDatabase();
        if (systemInformation.get("osName").contains("windows") || systemInformation.get("osName").contains("Windows")) {
            Scanner reader = new Scanner(System.in);
            LOG.warn(localizationManager.getLocalizedString("main.log.warn.windows"));
            System.out.print(String.format(localizationManager.getLocalizedString("main.log.warn.windows.input"), "\"Yes\"", "\"No\""));
            String answer = "foobar";
            do {
                if ((answer = reader.nextLine()).equals("No")) {
                    LOG.info(localizationManager.getLocalizedString("main.log.warn.windows.no"));
                    System.exit(0);
                    continue;
                }
                if (!answer.equals("Yes")) continue;
                LOG.warn(localizationManager.getLocalizedString("main.log.warn.windows.yes"));
                MainSpringBoot.main(args2);
            } while (!answer.equals("No") && !answer.equals("Yes"));
        } else {
            MainSpringBoot.main(args2);
        }
    }

    private static void checkForUpdate(LocalizationManager LOCALIZATIONMANAGER, UpdateChecker UPDATECHECKER, ApplicationProperties APPLICATIONPROPERTIES) {
        String updater = UPDATECHECKER.checkForUpdate(APPLICATIONPROPERTIES.getServerPackCreatorVersion(), APPLICATIONPROPERTIES.checkForAvailablePreReleases());
        if (updater.contains(";")) {
            LOG.info(LOCALIZATIONMANAGER.getLocalizedString("update.dialog.available"));
            LOG.info("    " + updater.split(";")[0]);
            LOG.info("    " + updater.split(";")[1]);
        } else {
            LOG.info(LOCALIZATIONMANAGER.getLocalizedString("updates.log.info.none"));
        }
    }

    private static void preRunCheck(ConfigurationCreator CONFIGURATIONCREATOR) {
        if (!new File("creator.conf").exists() && !new File("serverpackcreator.conf").exists()) {
            CONFIGURATIONCREATOR.createConfigurationFile();
        }
    }

    private static void runHeadless(ConfigurationHandler CONFIGURATIONHANDLER, ServerPackHandler SERVERPACKHANDLER, ApplicationProperties APPLICATIONPROPERTIES) {
        ConfigurationModel configurationModel = new ConfigurationModel();
        if (CONFIGURATIONHANDLER.checkConfiguration(APPLICATIONPROPERTIES.FILE_CONFIG, configurationModel, false) && SERVERPACKHANDLER.run(configurationModel)) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static void runHeadlessWithPreChecks(ConfigurationHandler CONFIGURATIONHANDLER, ServerPackHandler SERVERPACKHANDLER, ApplicationProperties APPLICATIONPROPERTIES, ConfigurationCreator CONFIGURATIONCREATOR) {
        Main.preRunCheck(CONFIGURATIONCREATOR);
        Main.runHeadless(CONFIGURATIONHANDLER, SERVERPACKHANDLER, APPLICATIONPROPERTIES);
    }
}

