/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultFiles {
    private static final Logger LOG = LogManager.getLogger(DefaultFiles.class);
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final ApplicationProperties APPLICATIONPROPERTIES;

    @Autowired
    public DefaultFiles(LocalizationManager injectedLocalizationManager, ApplicationProperties injectedApplicationProperties) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
    }

    public URL getMinecraftManifestUrl() {
        URL minecraftURL = null;
        String minecraftManifest = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
        try {
            minecraftURL = new URL(minecraftManifest);
        }
        catch (IOException ex) {
            LOG.error("Error assigning the Minecraft manifest URL.", (Throwable)ex);
        }
        return minecraftURL;
    }

    public URL getForgeManifestUrl() {
        URL forgeURL = null;
        String forgeManifest = "https://files.minecraftforge.net/net/minecraftforge/forge/maven-metadata.json";
        try {
            forgeURL = new URL(forgeManifest);
        }
        catch (IOException ex) {
            LOG.error("Error assigning the Forge manifest URL.", (Throwable)ex);
        }
        return forgeURL;
    }

    public URL getFabricManifestUrl() {
        URL fabricURL = null;
        String fabricManifest = "https://maven.fabricmc.net/net/fabricmc/fabric-loader/maven-metadata.xml";
        try {
            fabricURL = new URL(fabricManifest);
        }
        catch (IOException ex) {
            LOG.error("Error assigning the Fabric manifest URL.", (Throwable)ex);
        }
        return fabricURL;
    }

    public URL getFabricInstallerManifestUrl() {
        URL downloadURL = null;
        String fabricInstallerManifest = "https://maven.fabricmc.net/net/fabricmc/fabric-installer/maven-metadata.xml";
        try {
            downloadURL = new URL(fabricInstallerManifest);
        }
        catch (IOException ex) {
            LOG.error("Error assigning the Fabric-Installer manifest URL.", (Throwable)ex);
        }
        return downloadURL;
    }

    public void filesSetup() {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.filessetup.enter"));
        try {
            Files.createDirectories(Paths.get("./server_files", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create server_files directory.", (Throwable)ex);
        }
        try {
            Files.createDirectories(Paths.get("./work", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create work directory.", (Throwable)ex);
        }
        try {
            Files.createDirectories(Paths.get("./work/temp", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create work/temp directory.", (Throwable)ex);
        }
        try {
            Files.createDirectories(Paths.get("./work/modpacks", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create work/temp directory.", (Throwable)ex);
        }
        try {
            Files.createDirectories(Paths.get("./server-packs", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create server-packs directory.", (Throwable)ex);
        }
        this.preparePluginsDir();
        this.refreshManifestFile(this.getMinecraftManifestUrl(), this.APPLICATIONPROPERTIES.FILE_MANIFEST_MINECRAFT);
        this.refreshManifestFile(this.getForgeManifestUrl(), this.APPLICATIONPROPERTIES.FILE_MANIFEST_FORGE);
        this.refreshManifestFile(this.getFabricManifestUrl(), this.APPLICATIONPROPERTIES.FILE_MANIFEST_FABRIC);
        this.refreshManifestFile(this.getFabricInstallerManifestUrl(), this.APPLICATIONPROPERTIES.FILE_MANIFEST_FABRIC_INSTALLER);
        boolean doesConfigExist = this.checkForConfig();
        boolean doesPropertiesExist = this.checkForFile(this.APPLICATIONPROPERTIES.FILE_SERVER_PROPERTIES);
        boolean doesIconExist = this.checkForFile(this.APPLICATIONPROPERTIES.FILE_SERVER_ICON);
        if (doesConfigExist || doesPropertiesExist || doesIconExist) {
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning0"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning1"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning2"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning3"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.warn.filessetup.warning0"));
        } else {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.filessetup.finish"));
        }
    }

    private void preparePluginsDir() {
        try {
            Files.createDirectories(Paths.get(System.getProperty("pf4j.pluginsDir", "./plugins"), new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error("Could not create plugins directory.", (Throwable)ex);
        }
        if (!new File(System.getProperty("pf4j.pluginsDir", "./plugins") + "/disabled.txt").isFile()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(Paths.get(System.getProperty("pf4j.pluginsDir", "./plugins"), new String[0]) + "/disabled.txt"));){
                writer.write("########################################\n");
                writer.write("# - Load all plugins except these.   - #\n");
                writer.write("# - Add one plugin-id per line.      - #\n");
                writer.write("########################################\n");
                writer.write("#example-plugin\n");
            }
            catch (IOException ex) {
                LOG.error("Error generating disable.txt in the plugins directory.", (Throwable)ex);
            }
        }
    }

    private boolean checkForConfig() {
        boolean firstRun;
        block8: {
            firstRun = false;
            if (this.APPLICATIONPROPERTIES.FILE_CONFIG_OLD.exists()) {
                try {
                    Files.copy(this.APPLICATIONPROPERTIES.FILE_CONFIG_OLD.getAbsoluteFile().toPath(), this.APPLICATIONPROPERTIES.FILE_CONFIG.getAbsoluteFile().toPath(), new CopyOption[0]);
                    boolean isOldConfigDeleted = this.APPLICATIONPROPERTIES.FILE_CONFIG_OLD.delete();
                    if (isOldConfigDeleted) {
                        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.checkforconfig.old"));
                    }
                    break block8;
                }
                catch (IOException ex) {
                    if (!ex.toString().startsWith("java.nio.file.FileAlreadyExistsException")) {
                        LOG.error("Error renaming creator.conf to serverpackcreator.conf.", (Throwable)ex);
                    }
                    break block8;
                }
            }
            if (!this.APPLICATIONPROPERTIES.FILE_CONFIG.exists()) {
                try {
                    FileUtils.copyInputStreamToFile(Objects.requireNonNull(DefaultFiles.class.getResourceAsStream(String.format("/de/griefed/resources/%s", this.APPLICATIONPROPERTIES.FILE_CONFIG.getName()))), this.APPLICATIONPROPERTIES.FILE_CONFIG);
                    LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.checkforconfig.config"));
                    firstRun = true;
                }
                catch (IOException ex) {
                    if (ex.toString().startsWith("java.nio.file.FileAlreadyExistsException")) break block8;
                    LOG.error("Could not extract default config-file.", (Throwable)ex);
                    firstRun = true;
                }
            }
        }
        return firstRun;
    }

    public boolean checkForFile(File fileToCheckFor) {
        boolean firstRun;
        block3: {
            firstRun = false;
            if (!new File(String.format("server_files/%s", fileToCheckFor)).exists()) {
                try {
                    FileUtils.copyInputStreamToFile(Objects.requireNonNull(DefaultFiles.class.getResourceAsStream(String.format("/de/griefed/resources/server_files/%s", fileToCheckFor))), new File(String.format("./server_files/%s", fileToCheckFor)));
                    LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.info.checkforfile"), fileToCheckFor));
                    firstRun = true;
                }
                catch (IOException ex) {
                    if (ex.toString().startsWith("java.nio.file.FileAlreadyExistsException")) break block3;
                    LOG.error(String.format("Could not extract default %s file.", fileToCheckFor), (Throwable)ex);
                    firstRun = true;
                }
            }
        }
        return firstRun;
    }

    public void refreshManifestFile(URL manifestUrl, File manifestToRefresh) {
        File fileName = new File(String.format("./work/%s", manifestToRefresh));
        if (fileName.delete()) {
            LOG.debug(String.format("Deleted %s.", manifestToRefresh));
        }
        try {
            FileOutputStream downloadManifestOutputStream;
            ReadableByteChannel readableByteChannel = Channels.newChannel(manifestUrl.openStream());
            try {
                downloadManifestOutputStream = new FileOutputStream(fileName);
            }
            catch (FileNotFoundException ex) {
                LOG.debug(String.format("Couldn't find %s.", fileName), (Throwable)ex);
                if (!fileName.exists()) {
                    LOG.debug(String.format("Creating Manifest %s.", fileName));
                    if (fileName.createNewFile()) {
                        LOG.info(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("defaultfiles.log.debug.manifest.created"), fileName));
                    } else {
                        LOG.error(String.format("Error: Could not create Manifest %s.", fileName));
                    }
                }
                downloadManifestOutputStream = new FileOutputStream(fileName);
            }
            FileChannel downloadManifestOutputStreamChannel = downloadManifestOutputStream.getChannel();
            downloadManifestOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            downloadManifestOutputStream.flush();
            downloadManifestOutputStream.close();
            readableByteChannel.close();
            downloadManifestOutputStreamChannel.close();
        }
        catch (Exception ex) {
            LOG.error(String.format("Error: Something went wrong during the download of the %s Manifest.", fileName), (Throwable)ex);
        }
    }

    public void checkDatabase() {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:sqlite:" + this.APPLICATIONPROPERTIES.FILE_SERVERPACKCREATOR_DATABASE);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            LOG.debug("Database driver name: " + databaseMetaData.getDriverName());
            LOG.debug("Database driver version: " + databaseMetaData.getDriverVersion());
            LOG.debug("Database product name: " + databaseMetaData.getDatabaseProductName());
            LOG.debug("Database product version: " + databaseMetaData.getDatabaseProductVersion());
        }
        catch (SQLException e) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

