/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import com.electronwill.nightconfig.core.file.FileConfig;
import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.typesafe.config.ConfigException;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.VersionLister;
import de.griefed.serverpackcreator.curseforge.CurseCreateModpack;
import de.griefed.serverpackcreator.curseforge.InvalidFileException;
import de.griefed.serverpackcreator.curseforge.InvalidModpackException;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.serverpackcreator.utilities.BooleanUtilities;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.ListUtilities;
import de.griefed.serverpackcreator.utilities.StringUtilities;
import de.griefed.serverpackcreator.utilities.SystemUtilities;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationHandler {
    private static final Logger LOG = LogManager.getLogger(ConfigurationHandler.class);
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final CurseCreateModpack CURSECREATEMODPACK;
    private final VersionLister VERSIONLISTER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final BooleanUtilities BOOLEANUTILITIES;
    private final ConfigUtilities CONFIGUTILITIES;
    private final ListUtilities LISTUTILITIES;
    private final StringUtilities STRINGUTILITIES;
    private final SystemUtilities SYSTEMUTILITIES;

    @Autowired
    public ConfigurationHandler(LocalizationManager injectedLocalizationManager, CurseCreateModpack injectedCurseCreateModpack, VersionLister injectedVersionLister, ApplicationProperties injectedApplicationProperties, BooleanUtilities injectedBooleanUtilities, ListUtilities injectedListUtilities, StringUtilities injectedStringUtilities, SystemUtilities injectedSystemUtilities, ConfigUtilities injectedConfigUtilities) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        this.VERSIONLISTER = injectedVersionLister == null ? new VersionLister(this.APPLICATIONPROPERTIES) : injectedVersionLister;
        this.BOOLEANUTILITIES = injectedBooleanUtilities == null ? new BooleanUtilities(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES) : injectedBooleanUtilities;
        this.LISTUTILITIES = injectedListUtilities == null ? new ListUtilities() : injectedListUtilities;
        this.STRINGUTILITIES = injectedStringUtilities == null ? new StringUtilities() : injectedStringUtilities;
        this.SYSTEMUTILITIES = injectedSystemUtilities == null ? new SystemUtilities() : injectedSystemUtilities;
        this.CONFIGUTILITIES = injectedConfigUtilities == null ? new ConfigUtilities(this.LOCALIZATIONMANAGER, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.APPLICATIONPROPERTIES, this.STRINGUTILITIES, this.VERSIONLISTER) : injectedConfigUtilities;
        this.CURSECREATEMODPACK = injectedCurseCreateModpack == null ? new CurseCreateModpack(this.LOCALIZATIONMANAGER, this.APPLICATIONPROPERTIES, this.VERSIONLISTER, this.BOOLEANUTILITIES, this.LISTUTILITIES, this.STRINGUTILITIES, this.CONFIGUTILITIES, this.SYSTEMUTILITIES) : injectedCurseCreateModpack;
    }

    public boolean checkConfiguration(@NotNull ConfigurationModel configurationModel, boolean quietCheck) {
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        return this.checkConfiguration(configurationModel, encounteredErrors, false, quietCheck);
    }

    public boolean checkConfiguration(@NotNull File configFile, boolean quietCheck) {
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        ConfigurationModel configurationModel = new ConfigurationModel();
        return this.checkConfiguration(configFile, configurationModel, encounteredErrors, false, quietCheck);
    }

    public boolean checkConfiguration(@NotNull File configFile, @NotNull List<String> encounteredErrors, boolean quietCheck) {
        ConfigurationModel configurationModel = new ConfigurationModel();
        return this.checkConfiguration(configFile, configurationModel, encounteredErrors, false, quietCheck);
    }

    public boolean checkConfiguration(@NotNull File configFile, @NotNull ConfigurationModel configurationModel, boolean quietCheck) {
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        return this.checkConfiguration(configFile, configurationModel, encounteredErrors, false, quietCheck);
    }

    public boolean checkConfiguration(@NotNull File configFile, boolean downloadAndCreateModpack, boolean quietCheck) {
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        ConfigurationModel configurationModel = new ConfigurationModel();
        return this.checkConfiguration(configFile, configurationModel, encounteredErrors, downloadAndCreateModpack, quietCheck);
    }

    public boolean checkConfiguration(@NotNull File configFile, @NotNull ConfigurationModel configurationModel, boolean downloadAndCreateModpack, boolean quietCheck) {
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        return this.checkConfiguration(configFile, configurationModel, encounteredErrors, downloadAndCreateModpack, quietCheck);
    }

    public boolean checkConfiguration(@NotNull ConfigurationModel configurationModel, boolean downloadAndCreateModpack, boolean quietCheck) {
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        return this.checkConfiguration(configurationModel, encounteredErrors, downloadAndCreateModpack, quietCheck);
    }

    public boolean checkConfiguration(@NotNull File configFile, @NotNull ConfigurationModel configurationModel, @NotNull List<String> encounteredErrors, boolean downloadAndCreateModpack, boolean quietCheck) {
        LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkconfig.start"));
        FileConfig config = null;
        try {
            config = FileConfig.of(configFile);
        }
        catch (ConfigException ex) {
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkconfig.start"));
        }
        if (config != null) {
            try {
                config.load();
            }
            catch (ConfigException ex) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkconfig.start"));
                encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkconfig.start"));
            }
            configurationModel.setClientMods(config.getOrElse("clientMods", Collections.singletonList("")));
            configurationModel.setCopyDirs(config.getOrElse("copyDirs", Collections.singletonList("")));
            configurationModel.setModpackDir(config.getOrElse("modpackDir", "").replace("\\", "/"));
            configurationModel.setJavaPath(config.getOrElse("javaPath", "").replace("\\", "/"));
            configurationModel.setMinecraftVersion(config.getOrElse("minecraftVersion", ""));
            configurationModel.setModLoader(config.getOrElse("modLoader", ""));
            configurationModel.setModLoaderVersion(config.getOrElse("modLoaderVersion", ""));
            configurationModel.setJavaArgs(config.getOrElse("javaArgs", "empty"));
            configurationModel.setServerPackSuffix(this.STRINGUTILITIES.pathSecureText(config.getOrElse("serverPackSuffix", "")));
            configurationModel.setServerIconPath(config.getOrElse("serverIconPath", "").replace("\\", "/"));
            configurationModel.setServerPropertiesPath(config.getOrElse("serverPropertiesPath", "").replace("\\", "/"));
            configurationModel.setIncludeServerInstallation(this.BOOLEANUTILITIES.convertToBoolean(String.valueOf(config.getOrElse("includeServerInstallation", "False"))));
            configurationModel.setIncludeServerIcon(this.BOOLEANUTILITIES.convertToBoolean(String.valueOf(config.getOrElse("includeServerIcon", "False"))));
            configurationModel.setIncludeServerProperties(this.BOOLEANUTILITIES.convertToBoolean(String.valueOf(config.getOrElse("includeServerProperties", "False"))));
            configurationModel.setIncludeZipCreation(this.BOOLEANUTILITIES.convertToBoolean(String.valueOf(config.getOrElse("includeZipCreation", "False"))));
        } else {
            encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkconfig.start"));
        }
        return this.checkConfiguration(configurationModel, encounteredErrors, downloadAndCreateModpack, quietCheck);
    }

    public boolean checkConfiguration(@NotNull ConfigurationModel configurationModel, @NotNull List<String> encounteredErrors, boolean downloadAndCreateModpack, boolean quietCheck) {
        boolean configHasError;
        block26: {
            configHasError = false;
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkconfig.start"));
            if (configurationModel.getClientMods().isEmpty()) {
                LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.clientmods"));
                configurationModel.setClientMods(this.APPLICATIONPROPERTIES.getListFallbackMods());
            } else {
                configurationModel.setClientMods(configurationModel.getClientMods());
            }
            configurationModel.setJavaPath(this.checkJavaPath(configurationModel.getJavaPath().replace("\\", "/")));
            if (!this.checkIconAndProperties(configurationModel.getServerIconPath())) {
                configHasError = true;
                encounteredErrors.add(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.servericon"), configurationModel.getServerIconPath()));
            }
            if (!this.checkIconAndProperties(configurationModel.getServerPropertiesPath())) {
                configHasError = true;
                encounteredErrors.add(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.serverproperties"), configurationModel.getServerPropertiesPath()));
            }
            if (new File(configurationModel.getModpackDir()).isDirectory()) {
                configHasError = this.isDir(configurationModel, encounteredErrors);
            } else if (this.APPLICATIONPROPERTIES.isCurseForgeActivated()) {
                try {
                    if (this.checkCurseForge(configurationModel.getModpackDir(), configurationModel, encounteredErrors) && downloadAndCreateModpack) {
                        configHasError = this.isCurse(configurationModel, encounteredErrors);
                        break block26;
                    }
                    LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkconfig.skipmodpackcreation"));
                }
                catch (InvalidModpackException ex) {
                    configHasError = true;
                    encounteredErrors.add("The specified project is not a valid Minecraft modpack!");
                    LOG.error("The specified project is not a valid Minecraft modpack!", (Throwable)ex);
                }
                catch (InvalidFileException ex) {
                    configHasError = true;
                    encounteredErrors.add("The specified file is not a file of this project.");
                    LOG.error("The specified file is not a file of this project.", (Throwable)ex);
                }
                catch (CurseException ex) {
                    configHasError = true;
                    encounteredErrors.add("The specified project does not exist.");
                    LOG.error("The specified project does not exist.", (Throwable)ex);
                }
            } else if (new File(configurationModel.getModpackDir()).isFile() && configurationModel.getModpackDir().substring(configurationModel.getModpackDir().length() - 3).equalsIgnoreCase("zip")) {
                try {
                    configHasError = this.isZip(configurationModel, encounteredErrors);
                }
                catch (IOException ex) {
                    configHasError = true;
                    LOG.error("An error occurred whilst working with the ZIP-archive.", (Throwable)ex);
                }
            } else {
                configHasError = true;
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodpackdir"));
                encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodpackdir"));
            }
        }
        if (this.checkModloader(configurationModel.getModLoader())) {
            if (this.isMinecraftVersionCorrect(configurationModel.getMinecraftVersion())) {
                LOG.debug(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.debug.isdir.minecraftversion"));
                LOG.debug(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.debug.isdir.modloader"));
                if (this.checkModloaderVersion(configurationModel.getModLoader(), configurationModel.getModLoaderVersion(), configurationModel.getMinecraftVersion())) {
                    LOG.debug(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.debug.isdir.modloaderversion"));
                } else {
                    configHasError = true;
                    LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.isdir.modloaderversion"));
                    encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodloaderversion"));
                }
            } else {
                configHasError = true;
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.isdir.minecraftversion"));
                encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.minecraft"));
            }
        } else {
            configHasError = true;
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.isdir.modloader"));
            encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodloader"));
        }
        if (quietCheck) {
            this.CONFIGUTILITIES.printConfigurationModel(configurationModel);
        }
        if (!configHasError) {
            LOG.info(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.info.checkconfig.success"));
        } else {
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkconfig.failure"));
            this.printEncounteredErrors(encounteredErrors);
        }
        return configHasError;
    }

    private boolean isDir(ConfigurationModel configurationModel, List<String> encounteredErrors) {
        boolean configHasError = false;
        if (this.checkCopyDirs(configurationModel.getCopyDirs(), configurationModel.getModpackDir(), encounteredErrors)) {
            LOG.debug(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.debug.isdir.copydirs"));
        } else {
            configHasError = true;
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.isdir.copydir"));
            encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.isdir.copydir"));
        }
        return configHasError;
    }

    private boolean isZip(ConfigurationModel configurationModel, List<String> encounteredErrors) throws IOException {
        boolean configHasError = false;
        String destination = String.format("./work/modpacks/%s", configurationModel.getModpackDir().substring(configurationModel.getModpackDir().lastIndexOf("/") + 1).substring(0, configurationModel.getModpackDir().substring(configurationModel.getModpackDir().lastIndexOf("/") + 1).length() - 4));
        if (this.checkZipArchive(Paths.get(configurationModel.getModpackDir(), new String[0]), encounteredErrors)) {
            return true;
        }
        if (new File(destination).isDirectory()) {
            int incrementation = 0;
            if (destination.matches(".*_\\d")) {
                incrementation = Integer.parseInt(destination.substring(destination.length() - 1));
                while (new File(destination.substring(0, destination.length() - 1) + "_" + incrementation).isDirectory()) {
                    ++incrementation;
                }
                destination = destination.substring(0, destination.length() - 1) + "_" + incrementation;
            } else {
                while (new File(destination + "_" + incrementation).isDirectory()) {
                    ++incrementation;
                }
                destination = destination + "_" + incrementation;
            }
        }
        this.SYSTEMUTILITIES.unzipArchive(configurationModel.getModpackDir(), destination);
        List<String> newCopyDirs = this.CONFIGUTILITIES.suggestCopyDirs(destination);
        for (String entry : configurationModel.getCopyDirs()) {
            if (newCopyDirs.contains(entry)) continue;
            newCopyDirs.add(entry);
        }
        configurationModel.setCopyDirs(newCopyDirs);
        String packName = null;
        if (new File(String.format("%s/manifest.json", destination)).exists()) {
            try {
                this.CONFIGUTILITIES.updateConfigModelFromCurseManifest(configurationModel, new File(String.format("%s/manifest.json", destination)));
                try {
                    packName = String.format("./work/modpacks/%s", configurationModel.getCurseModpack().get("name").asText());
                }
                catch (NullPointerException npe) {
                    packName = null;
                }
            }
            catch (IOException ex) {
                LOG.error("Error parsing CurseForge manifest.json from ZIP-file.", (Throwable)ex);
                encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.zip.manifest"));
                configHasError = true;
            }
        } else if (new File(String.format("%s/minecraftinstance.json", destination)).exists()) {
            try {
                this.CONFIGUTILITIES.updateConfigModelFromMinecraftInstance(configurationModel, new File(String.format("%s/minecraftinstance.json", destination)));
                try {
                    packName = String.format("./work/modpacks/%s", configurationModel.getCurseModpack().get("name").asText());
                }
                catch (NullPointerException npe) {
                    packName = null;
                }
            }
            catch (IOException ex) {
                LOG.error("Error parsing minecraftinstance.json from ZIP-file.", (Throwable)ex);
                encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.zip.instance"));
                configHasError = true;
            }
        } else if (new File(String.format("%s/config.json", destination)).exists()) {
            try {
                this.CONFIGUTILITIES.updateConfigModelFromConfigJson(configurationModel, new File(String.format("%s/config.json", destination)));
                try {
                    packName = String.format("./work/modpacks/%s", configurationModel.getCurseModpack().get("loader").get("sourceName").asText());
                }
                catch (NullPointerException npe) {
                    packName = null;
                }
            }
            catch (IOException ex) {
                LOG.error("Error parsing config.json from ZIP-file.", (Throwable)ex);
                encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.zip.config"));
                configHasError = true;
            }
        } else if (new File(String.format("%s/mmc-pack.json", destination)).exists()) {
            try {
                this.CONFIGUTILITIES.updateConfigModelFromMMCPack(configurationModel, new File(String.format("%s/mmc-pack.json", destination)));
            }
            catch (IOException ex) {
                LOG.error("Error parsing mmc-pack.json from ZIP-file.", (Throwable)ex);
                encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.zip.mmcpack"));
                configHasError = true;
            }
            try {
                String name;
                if (new File(String.format("%s/instance.cfg", destination)).exists() && (name = this.CONFIGUTILITIES.updateDestinationFromInstanceCfg(new File(String.format("%s/instance.cfg", destination)))) != null) {
                    packName = name;
                }
            }
            catch (IOException ex) {
                LOG.error("Couldn't read instance.cfg.", (Throwable)ex);
            }
        }
        if (packName == null) {
            packName = destination;
        }
        String wouldBeServerPack = new File(String.format("%s/%s", this.APPLICATIONPROPERTIES.getDirectoryServerPacks(), packName.substring(packName.lastIndexOf("/") + 1) + configurationModel.getServerPackSuffix())).getAbsolutePath().replace("\\", "/");
        int incrementation = 0;
        if (packName.matches(".*_\\d")) {
            if (wouldBeServerPack.matches(".*_\\d")) {
                while (new File(wouldBeServerPack.substring(0, wouldBeServerPack.length() - 1) + "_" + incrementation).isDirectory() || new File(packName.substring(0, packName.length() - 1) + "_" + incrementation).isDirectory()) {
                    ++incrementation;
                }
                packName = packName + "_" + incrementation;
            } else {
                while (new File(wouldBeServerPack + "_" + incrementation).isDirectory() || new File(packName.substring(0, packName.length() - 1) + "_" + incrementation).isDirectory()) {
                    ++incrementation;
                }
                packName = packName + "_" + incrementation;
            }
        } else if (wouldBeServerPack.matches(".*_\\d")) {
            while (new File(wouldBeServerPack.substring(0, wouldBeServerPack.length() - 1) + "_" + incrementation).isDirectory() || new File(packName + "_" + incrementation).isDirectory()) {
                ++incrementation;
            }
            packName = packName + "_" + incrementation;
        } else {
            while (new File(wouldBeServerPack + "_" + incrementation).isDirectory() || new File(packName + "_" + incrementation).isDirectory()) {
                ++incrementation;
            }
            packName = packName + "_" + incrementation;
        }
        FileUtils.moveDirectory(new File(destination), new File(packName));
        configurationModel.setModpackDir(packName);
        if (new File(packName + "/server-icon.png").exists()) {
            configurationModel.setServerIconPath(packName + "/server-icon.png");
        }
        if (new File(packName + "/server.properties").exists()) {
            configurationModel.setServerPropertiesPath(packName + "/server.properties");
        }
        return configHasError;
    }

    public boolean checkZipArchive(Path pathToZip, List<String> encounteredErrors) {
        try {
            List<String> foldersInModpackZip = this.CONFIGUTILITIES.directoriesInModpackZip(pathToZip);
            if (foldersInModpackZip.size() == 1) {
                LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.zip.overrides"), foldersInModpackZip.get(0)));
                encounteredErrors.add(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.zip.overrides"), foldersInModpackZip.get(0)));
                return true;
            }
            if (!foldersInModpackZip.contains("mods") || !foldersInModpackZip.contains("config")) {
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.zip.modsorconfig"));
                encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.zip.modsorconfig"));
                return true;
            }
        }
        catch (IOException ex) {
            LOG.error("Couldn't acquire directories in ZIP-file.", (Throwable)ex);
            encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.zip.directories"));
            return true;
        }
        return false;
    }

    private boolean isCurse(ConfigurationModel configurationModel, List<String> encounteredErrors) {
        boolean configHasError = false;
        try {
            if (CurseAPI.project(configurationModel.getProjectID()).isPresent() && CurseAPI.file(configurationModel.getProjectID(), configurationModel.getFileID()).isPresent()) {
                this.CURSECREATEMODPACK.curseForgeModpack(configurationModel, configurationModel.getProjectID(), configurationModel.getFileID());
            } else {
                configHasError = true;
                LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.error.notfound"));
                encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("cursecreatemodpack.log.error.notfound"));
            }
        }
        catch (CurseException | IllegalArgumentException ex) {
            configHasError = true;
            LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.iscurse.project"), configurationModel.getProjectID()), (Throwable)ex);
            encounteredErrors.add(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.iscurse.project"), configurationModel.getProjectID()));
        }
        return configHasError;
    }

    public boolean checkCurseForge(String modpackDir, ConfigurationModel configurationModel, List<String> encounteredErrors) throws InvalidModpackException, InvalidFileException, CurseException {
        boolean configCorrect = false;
        if (modpackDir.matches("[0-9]{2,},[0-9]{5,}") && Integer.parseInt(modpackDir.split(",")[0]) >= 10 && Integer.parseInt(modpackDir.split(",")[1]) >= 60018) {
            LOG.info("IMPORTANT!!! - Modpack directory matches CurseForge projectID and fileID format. However, the CurseForge module is currently disabled due to CurseForge changing their API and the way one can access it.");
            LOG.info("IMPORTANT!!! - Downloading and installing a modpack is disabled until further notice.");
            encounteredErrors.add("IMPORTANT!!! - Modpack directory matches CurseForge projectID and fileID format. However, the CurseForge module is currently disabled due to CurseForge changing their API and the way one can access it.");
            encounteredErrors.add("IMPORTANT!!! - Downloading and installing a modpack is disabled until further notice.");
            return false;
        }
        LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkcurseforge.warn2"));
        return configCorrect;
    }

    private void printEncounteredErrors(List<String> encounteredErrors) {
        LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.encountered"), encounteredErrors.size()));
        int encounteredErrorNumber = 0;
        for (int i2 = 0; i2 < encounteredErrors.size(); ++i2) {
            encounteredErrorNumber = i2 + 1;
            LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.encountered.specific"), encounteredErrorNumber, encounteredErrors.get(i2)));
        }
    }

    public boolean checkModpackDir(String modpackDir, List<String> encounteredErrors) {
        boolean configCorrect = false;
        if (modpackDir.equals("")) {
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodpackdir"));
            encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodpackdir"));
        } else if (!new File(modpackDir).isDirectory()) {
            LOG.warn(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkmodpackdir"), modpackDir));
            encounteredErrors.add(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.modpackdirectory"), modpackDir));
        } else {
            configCorrect = true;
        }
        return configCorrect;
    }

    public boolean checkCopyDirs(List<String> directoriesToCopy, String modpackDir, List<String> encounteredErrors) {
        boolean configCorrect = true;
        directoriesToCopy.removeIf(entry -> entry.matches("^\\s+$") || entry.length() == 0);
        if (directoriesToCopy.isEmpty()) {
            configCorrect = false;
            LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkcopydirs.empty"));
            encounteredErrors.add(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkcopydirs.empty"));
        } else if (directoriesToCopy.size() == 1 && directoriesToCopy.get(0).equals("lazy_mode")) {
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode0"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode1"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode2"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode3"));
            LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode0"));
        } else {
            if (directoriesToCopy.size() > 1 && directoriesToCopy.contains("lazy_mode")) {
                LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.warn.checkconfig.copydirs.lazymode.ignore"));
            }
            directoriesToCopy.removeIf(entry -> entry.equals("lazy_mode"));
            for (String directory : directoriesToCopy) {
                if (directory.contains(";")) {
                    String[] sourceFileDestinationFileCombination = directory.split(";");
                    File sourceFileToCheck = new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0]));
                    if (new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).isFile() || new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).isDirectory() || new File(sourceFileDestinationFileCombination[0]).isFile() || new File(sourceFileDestinationFileCombination[0]).isDirectory()) continue;
                    configCorrect = false;
                    LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkcopydirs.filenotfound"), sourceFileToCheck));
                    encounteredErrors.add(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkcopydirs.filenotfound"), sourceFileToCheck));
                    continue;
                }
                if (directory.startsWith("!")) {
                    File fileOrDirectory = new File(String.format("%s/%s", modpackDir, directory.substring(1)));
                    if (fileOrDirectory.isFile()) {
                        LOG.warn("File " + directory.substring(1) + " will be ignored.");
                    } else if (fileOrDirectory.isDirectory()) {
                        LOG.warn("Directory " + directory.substring(1) + " will be ignored.");
                    } else {
                        LOG.debug("What? " + fileOrDirectory + " is neither a file nor directory.");
                    }
                    this.APPLICATIONPROPERTIES.addToListOfDirectoriesToExclude(directory.substring(directory.lastIndexOf("!") + 1));
                    continue;
                }
                File dirToCheck = new File(String.format("%s/%s", modpackDir, directory));
                if (dirToCheck.exists()) continue;
                configCorrect = false;
                LOG.error(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkcopydirs.notfound"), dirToCheck.getAbsolutePath()));
                encounteredErrors.add(String.format(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkcopydirs.notfound"), dirToCheck.getAbsolutePath()));
            }
        }
        return configCorrect;
    }

    public boolean checkIconAndProperties(String iconOrPropertiesPath) {
        if (iconOrPropertiesPath.equals("")) {
            return true;
        }
        return new File(iconOrPropertiesPath).exists();
    }

    public String checkJavaPath(String pathToJava) {
        String checkedJavaPath = null;
        try {
            if (new File(pathToJava).exists() && pathToJava.endsWith("java.exe")) {
                checkedJavaPath = pathToJava;
            } else if (new File(pathToJava).exists() && pathToJava.endsWith("java")) {
                checkedJavaPath = pathToJava;
            } else if (!new File(pathToJava).exists() && new File(pathToJava + ".exe").exists()) {
                checkedJavaPath = pathToJava + ".exe";
                LOG.warn(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkjavapath.windows"));
            } else {
                LOG.debug("Acquiring path to Java installation from system properties...");
                checkedJavaPath = this.SYSTEMUTILITIES.acquireJavaPathFromSystem();
                LOG.debug("Automatically acquired path to Java installation: " + checkedJavaPath);
            }
        }
        catch (NullPointerException ex) {
            checkedJavaPath = this.SYSTEMUTILITIES.acquireJavaPathFromSystem();
            LOG.debug("Automatically acquired path to Java installation: " + checkedJavaPath);
        }
        return checkedJavaPath;
    }

    public boolean checkModloader(String modloader) {
        if (modloader.toLowerCase().contains("forge") || modloader.toLowerCase().contains("fabric")) {
            return true;
        }
        LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodloader"));
        return false;
    }

    public boolean checkModloaderVersion(String modloader, String modloaderVersion, String minecraftVersion) {
        if (modloader.equalsIgnoreCase("Forge") && this.isForgeVersionCorrect(modloaderVersion, minecraftVersion)) {
            return true;
        }
        if (modloader.equalsIgnoreCase("Fabric") && this.isFabricVersionCorrect(modloaderVersion)) {
            return true;
        }
        LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.checkmodloaderversion"));
        return false;
    }

    public boolean isMinecraftVersionCorrect(String minecraftVersion) {
        if (!minecraftVersion.equals("")) {
            return this.VERSIONLISTER.getMinecraftReleaseVersions().contains(minecraftVersion);
        }
        LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.isminecraftversioncorrect.empty"));
        return false;
    }

    public boolean isFabricVersionCorrect(String fabricVersion) {
        if (!fabricVersion.equals("")) {
            return this.VERSIONLISTER.getFabricVersions().contains(fabricVersion);
        }
        LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.isfabricversioncorrect.empty"));
        return false;
    }

    public boolean isForgeVersionCorrect(String forgeVersion, String minecraftVersion) {
        if (!forgeVersion.equals("")) {
            try {
                for (String version : this.VERSIONLISTER.getForgeMeta().get(minecraftVersion)) {
                    if (!version.equals(forgeVersion)) continue;
                    return true;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            return false;
        }
        LOG.error(this.LOCALIZATIONMANAGER.getLocalizedString("configuration.log.error.isforgeversioncorrect.empty"));
        return false;
    }
}

