/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class ApplicationProperties
extends Properties {
    private final Logger LOG = LogManager.getLogger(ApplicationProperties.class);
    public final File FILE_SERVERPACKCREATOR_PROPERTIES = new File("serverpackcreator.properties");
    public final File FILE_WINDOWS = new File("start.bat");
    public final File FILE_LINUX = new File("start.sh");
    public final File FILE_FORGE_ONE_SEVEN_USER_JVM_ARGS = new File("user_jvm_args.txt");
    private final String FALLBACK_MODS_DEFAULT_ASSTRING = "3dSkinLayers-,AdvancementPlaques-,AmbientSounds_,armorchroma-,backtools-,BetterAdvancements-,BetterAnimationsCollection-,BetterDarkMode-,BetterF3-,BetterF3-,BetterFoliage-,BetterPingDisplay-,BetterPlacement-,Blur-,catalogue-,cherishedworlds-,classicbar-,clickadv-,ClientTweaks_,configured-,Controlling-,CraftPresence-,CTM-,customdiscordrpc-,CustomMainMenu-,DefaultOptions_,defaultoptions-,desiredservers-,Ding-,drippyloadingscreen_,drippyloadingscreen-,Durability101-,dynamic-music-,DynamicSurroundings-,DynamicSurroundingsHuds-,dynmus-,EiraMoticons_,eiramoticons-,EnchantmentDescriptions-,EquipmentCompare-,extremesoundmuffler-,extremeSoundMuffler-,Fallingleaves-,fallingleaves-,fancymenu_,findme-,flickerfix-,FpsReducer-,FullscreenWindowed-,InventoryEssentials_,InventorySpam-,InventoryTweaks-,invtweaks-,ItemBorders-,itemzoom,itlt-,jeed-,jehc-,jeiintegration_,JEITweaker-,just-enough-harvestcraft-,justenoughbeacons-,JustEnoughCalculation-,JustEnoughProfessions-,JustEnoughProfessions-,JustEnoughResources-,keywizard-,konkrete_,lazydfu-,LegendaryTooltips-,light-overlay-,LightOverlay-,LLOverlayReloaded-,loadmyresources_,lootbeams-,mcbindtype-,medievalmusic-,modnametooltip_,modnametooltip-,moreoverlays-,MouseTweaks-,multihotbar-,MyServerIsCompatible-,Neat ,NotifMod-,OldJavaWarning-,OptiFine,OptiForge,ornaments-,overloadedarmorbar-,PackMenu-,PickUpNotifier-,Ping-,preciseblockplacing-,presencefootsteps-,PresenceFootsteps-,ReAuth-,ResourceLoader-,shutupexperimentalsettings-,SimpleDiscordRichPresence-,smoothboot-,sounddeviceoptions-,SpawnerFix-,spoticraft-,tconplanner-,timestamps-,Tips-,TipTheScales-,Toast Control-,Toast-Control-,ToastControl-,torchoptimizer-,torohealth-,toughnessbar-,TravelersTitles-,WindowedFullscreen-,WorldNameRandomizer-,yisthereautojump-";
    public final List<String> LIST_FALLBACK_MODS_DEFAULT = new ArrayList<String>(Arrays.asList("3dSkinLayers-,AdvancementPlaques-,AmbientSounds_,armorchroma-,backtools-,BetterAdvancements-,BetterAnimationsCollection-,BetterDarkMode-,BetterF3-,BetterF3-,BetterFoliage-,BetterPingDisplay-,BetterPlacement-,Blur-,catalogue-,cherishedworlds-,classicbar-,clickadv-,ClientTweaks_,configured-,Controlling-,CraftPresence-,CTM-,customdiscordrpc-,CustomMainMenu-,DefaultOptions_,defaultoptions-,desiredservers-,Ding-,drippyloadingscreen_,drippyloadingscreen-,Durability101-,dynamic-music-,DynamicSurroundings-,DynamicSurroundingsHuds-,dynmus-,EiraMoticons_,eiramoticons-,EnchantmentDescriptions-,EquipmentCompare-,extremesoundmuffler-,extremeSoundMuffler-,Fallingleaves-,fallingleaves-,fancymenu_,findme-,flickerfix-,FpsReducer-,FullscreenWindowed-,InventoryEssentials_,InventorySpam-,InventoryTweaks-,invtweaks-,ItemBorders-,itemzoom,itlt-,jeed-,jehc-,jeiintegration_,JEITweaker-,just-enough-harvestcraft-,justenoughbeacons-,JustEnoughCalculation-,JustEnoughProfessions-,JustEnoughProfessions-,JustEnoughResources-,keywizard-,konkrete_,lazydfu-,LegendaryTooltips-,light-overlay-,LightOverlay-,LLOverlayReloaded-,loadmyresources_,lootbeams-,mcbindtype-,medievalmusic-,modnametooltip_,modnametooltip-,moreoverlays-,MouseTweaks-,multihotbar-,MyServerIsCompatible-,Neat ,NotifMod-,OldJavaWarning-,OptiFine,OptiForge,ornaments-,overloadedarmorbar-,PackMenu-,PickUpNotifier-,Ping-,preciseblockplacing-,presencefootsteps-,PresenceFootsteps-,ReAuth-,ResourceLoader-,shutupexperimentalsettings-,SimpleDiscordRichPresence-,smoothboot-,sounddeviceoptions-,SpawnerFix-,spoticraft-,tconplanner-,timestamps-,Tips-,TipTheScales-,Toast Control-,Toast-Control-,ToastControl-,torchoptimizer-,torohealth-,toughnessbar-,TravelersTitles-,WindowedFullscreen-,WorldNameRandomizer-,yisthereautojump-".split(",")));
    public final File FILE_CONFIG = new File("serverpackcreator.conf");
    public final File FILE_CONFIG_OLD = new File("creator.conf");
    public final File FILE_SERVER_PROPERTIES = new File("server.properties");
    public final File FILE_SERVER_ICON = new File("server-icon.png");
    public final File FILE_MANIFEST_MINECRAFT = new File("minecraft-manifest.json");
    public final File FILE_MANIFEST_FORGE = new File("forge-manifest.json");
    public final File FILE_MANIFEST_FABRIC = new File("fabric-manifest.xml");
    public final File FILE_MANIFEST_FABRIC_INSTALLER = new File("fabric-installer-manifest.xml");
    public final File FILE_SERVERPACKCREATOR_DATABASE = new File("serverpackcreator.db");
    public final File PATH_FILE_MANIFEST_MINECRAFT = new File("./work/minecraft-manifest.json");
    public final File PATH_FILE_MANIFEST_FORGE = new File("./work/forge-manifest.json");
    public final File PATH_FILE_MANIFEST_FABRIC = new File("./work/fabric-manifest.xml");
    public final File PATH_FILE_MANIFEST_FABRIC_INSTALLER = new File("./work/fabric-installer-manifest.xml");
    private String directoryServerPacks = "server-packs";
    private List<String> listFallbackMods = this.LIST_FALLBACK_MODS_DEFAULT;
    private List<String> listDirectoriesExclude = new ArrayList<String>(Arrays.asList("overrides", "packmenu", "resourcepacks", "server_pack", "fancymenu", "downloads"));
    private boolean curseControllerRegenerationEnabled = false;
    private List<String> listCheckAgainstNewEntry = new ArrayList<String>(Arrays.asList("mods", "config", "defaultconfigs", "scripts", "saves", "seeds", "libraries", "kubejs"));
    private int queueMaxDiskUsage = 90;
    private boolean saveLoadedConfiguration = false;
    private String serverPackCreatorVersion = "dev";
    private boolean versioncheck_prerelease = false;
    private boolean isCurseForgeActivated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Autowired
    public ApplicationProperties() {
        Throwable throwable;
        InputStream inputStream2;
        try {
            inputStream2 = new ClassPathResource("serverpackcreator.properties").getInputStream();
            throwable = null;
            try {
                this.load(inputStream2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream2 != null) {
                    if (throwable != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream2.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            this.LOG.error("Couldn't read properties file.", (Throwable)ex);
        }
        try {
            inputStream2 = new FileInputStream("serverpackcreator.properties");
            throwable = null;
            try {
                new Properties();
                this.load(inputStream2);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (inputStream2 != null) {
                    if (throwable != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        inputStream2.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            this.LOG.error("Couldn't read properties file.", (Throwable)ex);
        }
        String tempDir = null;
        try {
            tempDir = this.getProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", "server-packs");
        }
        catch (NullPointerException npe) {
            this.setProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", "server-packs");
            tempDir = "server-packs";
        }
        finally {
            if (tempDir != null && !tempDir.equals("") && new File(tempDir).isDirectory()) {
                this.setProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", tempDir);
                this.directoryServerPacks = tempDir;
                try (FileOutputStream outputStream2 = new FileOutputStream(this.FILE_SERVERPACKCREATOR_PROPERTIES);){
                    this.store(outputStream2, null);
                }
                catch (IOException ex) {
                    this.LOG.error("Couldn't write properties-file.", (Throwable)ex);
                }
            } else {
                this.directoryServerPacks = "server-packs";
            }
        }
        if (this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist") == null) {
            this.listFallbackMods = this.LIST_FALLBACK_MODS_DEFAULT;
            this.LOG.debug("Fallbackmodslist property null. Using fallback: " + this.LIST_FALLBACK_MODS_DEFAULT);
        } else if (this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist").contains(",")) {
            this.listFallbackMods = new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist", this.FALLBACK_MODS_DEFAULT_ASSTRING).split(",")));
            this.LOG.debug("Fallbackmodslist set to: " + this.listFallbackMods);
        } else {
            this.listFallbackMods = Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist"));
            this.LOG.debug("Fallbackmodslist set to: " + this.listFallbackMods);
        }
        if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude") == null) {
            this.listDirectoriesExclude = new ArrayList<String>(Arrays.asList("overrides", "packmenu", "resourcepacks", "server_pack", "fancymenu"));
            this.LOG.debug("directories.shouldexclude-property null. Using fallback: " + this.listDirectoriesExclude);
        } else if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude").contains(",")) {
            this.listDirectoriesExclude = new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude", "overrides,packmenu,resourcepacks,server_pack,fancymenu").split(",")));
            this.LOG.debug("Directories to exclude set to: " + this.listDirectoriesExclude);
        } else {
            this.listDirectoriesExclude = Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude"));
            this.LOG.debug("Directories to exclude set to: " + this.listDirectoriesExclude);
        }
        if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude") == null) {
            this.listCheckAgainstNewEntry = new ArrayList<String>(Arrays.asList("overrides", "packmenu", "resourcepacks", "server_pack", "fancymenu"));
            this.LOG.debug("directories.mustinclude-property null. Using fallback: " + this.listCheckAgainstNewEntry);
        } else if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude").contains(",")) {
            this.listCheckAgainstNewEntry = new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude", "mods,config,defaultconfigs,scripts,saves,seeds,libraries").split(",")));
            this.LOG.debug("Directories which must always be included set to: " + this.listCheckAgainstNewEntry);
        } else {
            this.listCheckAgainstNewEntry = Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude"));
            this.LOG.debug("Directories which must always be included set to: " + this.listCheckAgainstNewEntry);
        }
        this.curseControllerRegenerationEnabled = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.spring.cursecontroller.regenerate.enabled", "false"));
        this.queueMaxDiskUsage = Integer.parseInt(this.getProperty("de.griefed.serverpackcreator.spring.artemis.queue.max_disk_usage", "90"));
        this.saveLoadedConfiguration = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.configuration.saveloadedconfig", "false"));
        this.versioncheck_prerelease = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.versioncheck.prerelease", "false"));
        String version = ApplicationProperties.class.getPackage().getImplementationVersion();
        this.serverPackCreatorVersion = version != null ? version : "dev";
        try {
            this.isCurseForgeActivated = this.testCurseApiToken();
            return;
        }
        catch (IOException ex) {
            this.LOG.error("CurseAPI check failed.", (Throwable)ex);
            this.isCurseForgeActivated = false;
            return;
        }
        finally {
            this.LOG.info("CurseForge API enabled: " + this.isCurseForgeActivated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationProperties reload() {
        try (FileInputStream inputStream2 = new FileInputStream("serverpackcreator.properties");){
            new Properties();
            this.load(inputStream2);
        }
        catch (IOException ex) {
            this.LOG.error("Couldn't read properties file.", (Throwable)ex);
        }
        String tempDir = null;
        try {
            tempDir = this.getProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", "server-packs");
        }
        catch (NullPointerException npe) {
            this.setProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", "server-packs");
            tempDir = "server-packs";
        }
        finally {
            if (tempDir != null && !tempDir.equals("") && new File(tempDir).isDirectory()) {
                this.setProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", tempDir);
                this.directoryServerPacks = tempDir;
                try (FileOutputStream outputStream2 = new FileOutputStream(this.FILE_SERVERPACKCREATOR_PROPERTIES);){
                    this.store(outputStream2, null);
                }
                catch (IOException ex) {
                    this.LOG.error("Couldn't write properties-file.", (Throwable)ex);
                }
            } else {
                this.directoryServerPacks = "server-packs";
            }
        }
        if (this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist") == null) {
            this.listFallbackMods = this.LIST_FALLBACK_MODS_DEFAULT;
            this.LOG.debug("Fallbackmodslist property null. Using fallback: " + this.LIST_FALLBACK_MODS_DEFAULT);
        } else if (this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist").contains(",")) {
            this.listFallbackMods = new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist", this.FALLBACK_MODS_DEFAULT_ASSTRING).split(",")));
            this.LOG.debug("Fallbackmodslist set to: " + this.listFallbackMods);
        } else {
            this.listFallbackMods = Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist"));
            this.LOG.debug("Fallbackmodslist set to: " + this.listFallbackMods);
        }
        if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude") == null) {
            this.listDirectoriesExclude = new ArrayList<String>(Arrays.asList("overrides", "packmenu", "resourcepacks", "server_pack", "fancymenu"));
            this.LOG.debug("directories.shouldexclude-property null. Using fallback: " + this.listDirectoriesExclude);
        } else if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude").contains(",")) {
            this.listDirectoriesExclude = new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude", "overrides,packmenu,resourcepacks,server_pack,fancymenu").split(",")));
            this.LOG.debug("Directories to exclude set to: " + this.listDirectoriesExclude);
        } else {
            this.listDirectoriesExclude = Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude"));
            this.LOG.debug("Directories to exclude set to: " + this.listDirectoriesExclude);
        }
        if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude") == null) {
            this.listCheckAgainstNewEntry = new ArrayList<String>(Arrays.asList("overrides", "packmenu", "resourcepacks", "server_pack", "fancymenu"));
            this.LOG.debug("directories.mustinclude-property null. Using fallback: " + this.listCheckAgainstNewEntry);
        } else if (this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude").contains(",")) {
            this.listCheckAgainstNewEntry = new ArrayList<String>(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude", "mods,config,defaultconfigs,scripts,saves,seeds,libraries").split(",")));
            this.LOG.debug("Directories which must always be included set to: " + this.listCheckAgainstNewEntry);
        } else {
            this.listCheckAgainstNewEntry = Collections.singletonList(this.getProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude"));
            this.LOG.debug("Directories which must always be included set to: " + this.listCheckAgainstNewEntry);
        }
        this.curseControllerRegenerationEnabled = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.spring.cursecontroller.regenerate.enabled", "false"));
        this.queueMaxDiskUsage = Integer.parseInt(this.getProperty("de.griefed.serverpackcreator.spring.artemis.queue.max_disk_usage", "90"));
        this.saveLoadedConfiguration = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.configuration.saveloadedconfig", "false"));
        this.versioncheck_prerelease = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.versioncheck.prerelease", "false"));
        try {
            this.isCurseForgeActivated = this.testCurseApiToken();
            return this;
        }
        catch (IOException ex) {
            this.LOG.error("CurseAPI check failed.", (Throwable)ex);
            this.isCurseForgeActivated = false;
            return this;
        }
        finally {
            this.LOG.info("CurseForge API enabled: " + this.isCurseForgeActivated);
        }
    }

    private boolean testCurseApiToken() throws IOException {
        URL curse = new URL("https://api.curseforge.com/v1/games");
        HttpURLConnection httpURLConnection = (HttpURLConnection)curse.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.setRequestProperty("x-api-key", this.getProperty("de.griefed.serverpackcreator.curseforge.api.token"));
        return httpURLConnection.getResponseCode() == 200;
    }

    public String getDirectoryServerPacks() {
        return this.directoryServerPacks;
    }

    public List<String> getListFallbackMods() {
        return this.listFallbackMods;
    }

    public List<String> getListOfDirectoriesToExclude() {
        return this.listDirectoriesExclude;
    }

    public void addToListOfDirectoriesToExclude(String entry) {
        if (!this.listDirectoriesExclude.contains(entry) && !this.listCheckAgainstNewEntry.contains(entry)) {
            this.LOG.debug("Adding " + entry + " to list of files or directories to exclude.");
            this.listDirectoriesExclude.add(entry);
        }
    }

    public boolean getCurseControllerRegenerationEnabled() {
        return this.curseControllerRegenerationEnabled;
    }

    public boolean getSaveLoadedConfiguration() {
        return this.saveLoadedConfiguration;
    }

    public int getQueueMaxDiskUsage() {
        return this.queueMaxDiskUsage;
    }

    public String getServerPackCreatorVersion() {
        return this.serverPackCreatorVersion;
    }

    public boolean checkForAvailablePreReleases() {
        return this.versioncheck_prerelease;
    }

    public boolean isCurseForgeActivated() {
        return this.isCurseForgeActivated;
    }

    @Override
    public String toString() {
        return "ApplicationProperties{FILE_SERVERPACKCREATOR_PROPERTIES=" + this.FILE_SERVERPACKCREATOR_PROPERTIES + ", FILE_WINDOWS=" + this.FILE_WINDOWS + ", FILE_LINUX=" + this.FILE_LINUX + ", FILE_FORGE_ONE_SEVEN_USER_JVM_ARGS=" + this.FILE_FORGE_ONE_SEVEN_USER_JVM_ARGS + ", LIST_FALLBACK_MODS_DEFAULT=" + this.LIST_FALLBACK_MODS_DEFAULT + ", FILE_CONFIG=" + this.FILE_CONFIG + ", FILE_CONFIG_OLD=" + this.FILE_CONFIG_OLD + ", FILE_SERVER_PROPERTIES=" + this.FILE_SERVER_PROPERTIES + ", FILE_SERVER_ICON=" + this.FILE_SERVER_ICON + ", FILE_MANIFEST_MINECRAFT=" + this.FILE_MANIFEST_MINECRAFT + ", FILE_MANIFEST_FORGE=" + this.FILE_MANIFEST_FORGE + ", FILE_MANIFEST_FABRIC=" + this.FILE_MANIFEST_FABRIC + ", FILE_MANIFEST_FABRIC_INSTALLER=" + this.FILE_MANIFEST_FABRIC_INSTALLER + ", FILE_SERVERPACKCREATOR_DATABASE=" + this.FILE_SERVERPACKCREATOR_DATABASE + ", PATH_FILE_MANIFEST_MINECRAFT=" + this.PATH_FILE_MANIFEST_MINECRAFT + ", PATH_FILE_MANIFEST_FORGE=" + this.PATH_FILE_MANIFEST_FORGE + ", PATH_FILE_MANIFEST_FABRIC=" + this.PATH_FILE_MANIFEST_FABRIC + ", PATH_FILE_MANIFEST_FABRIC_INSTALLER=" + this.PATH_FILE_MANIFEST_FABRIC_INSTALLER + ", directoryServerPacks='" + this.getDirectoryServerPacks() + '\'' + ", listFallbackMods=" + this.getListFallbackMods() + ", listDirectoriesExclude=" + this.getListOfDirectoriesToExclude() + ", curseControllerRegenerationEnabled=" + this.getCurseControllerRegenerationEnabled() + ", listCheckAgainstNewEntry=" + this.listCheckAgainstNewEntry + ", queueMaxDiskUsage=" + this.getQueueMaxDiskUsage() + ", saveLoadedConfiguration=" + this.getSaveLoadedConfiguration() + ", serverPackCreatorVersion='" + this.getServerPackCreatorVersion() + '\'' + ", versioncheck_prerelease=" + this.checkForAvailablePreReleases() + ", isCurseForgeActivated=" + this.isCurseForgeActivated() + '}';
    }
}

