/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import de.griefed.serverpackcreator.plugins.serverpackhandler.PostGenExtension;
import de.griefed.serverpackcreator.plugins.serverpackhandler.PreGenExtension;
import de.griefed.serverpackcreator.plugins.serverpackhandler.PreZipExtension;
import de.griefed.serverpackcreator.plugins.swinggui.TabExtension;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pf4j.ExtensionFactory;
import org.pf4j.JarPluginManager;
import org.pf4j.SingletonExtensionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationPlugins
extends JarPluginManager {
    private static final Logger LOG = LogManager.getLogger(ApplicationPlugins.class);
    public final List<PreGenExtension> PLUGINS_SERVERPACKSTART;
    public final List<PreZipExtension> PLUGINS_SERVERPACKCREATED;
    public final List<PostGenExtension> PLUGINS_SERVERPACKARCHIVECREATED;
    public final List<TabExtension> PLUGINS_TABBEDPANE;

    @Autowired
    public ApplicationPlugins() {
        LOG.info("Plugins directory: " + new File(System.getProperty("pf4j.pluginsDir", "plugins")).getAbsolutePath());
        this.loadPlugins();
        this.startPlugins();
        this.PLUGINS_SERVERPACKSTART = this.getExtensions(PreGenExtension.class);
        this.PLUGINS_SERVERPACKCREATED = this.getExtensions(PreZipExtension.class);
        this.PLUGINS_SERVERPACKARCHIVECREATED = this.getExtensions(PostGenExtension.class);
        this.PLUGINS_TABBEDPANE = this.getExtensions(TabExtension.class);
        this.availablePluginsAndExtensions();
    }

    @Override
    protected ExtensionFactory createExtensionFactory() {
        return new SingletonExtensionFactory(new String[0]);
    }

    private void availablePluginsAndExtensions() {
        if (this.PLUGINS_SERVERPACKSTART.size() > 0) {
            LOG.info("Available PreGenExtension plugins:");
            for (PreGenExtension start : this.PLUGINS_SERVERPACKSTART) {
                LOG.info("Name:       " + start.getName());
                LOG.info("Description:" + start.getDescription());
                LOG.info("Version:    " + start.getVersion());
                LOG.info("Author:     " + start.getAuthor());
            }
        } else {
            LOG.info("No PreGenExtensions installed.");
        }
        if (this.PLUGINS_SERVERPACKCREATED.size() > 0) {
            LOG.info("Available PreZipExtension plugins:");
            for (PreZipExtension created : this.PLUGINS_SERVERPACKCREATED) {
                LOG.info("Name:       " + created.getName());
                LOG.info("Description:" + created.getDescription());
                LOG.info("Version:    " + created.getVersion());
                LOG.info("Author:     " + created.getAuthor());
            }
        } else {
            LOG.info("No PreZipExtension installed.");
        }
        if (this.PLUGINS_SERVERPACKARCHIVECREATED.size() > 0) {
            LOG.info("Available PostGenExtension plugins:");
            for (PostGenExtension archive : this.PLUGINS_SERVERPACKARCHIVECREATED) {
                LOG.info("Name:       " + archive.getName());
                LOG.info("Description:" + archive.getDescription());
                LOG.info("Version:    " + archive.getVersion());
                LOG.info("Author:     " + archive.getAuthor());
            }
        } else {
            LOG.info("No PostGenExtension installed.");
        }
        if (this.PLUGINS_TABBEDPANE.size() > 0) {
            LOG.info("Available TabExtension plugins:");
            for (TabExtension pane : this.PLUGINS_TABBEDPANE) {
                LOG.info("Name:       " + pane.getName());
                LOG.info("Description:" + pane.getDescription());
                LOG.info("Version:    " + pane.getVersion());
                LOG.info("Author:     " + pane.getAuthor());
            }
        } else {
            LOG.info("No TabExtension installed.");
        }
    }
}

