/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.util;

import com.google.common.base.Preconditions;
import com.squareup.moshi.JsonDataException;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.util.JsoupUtils;
import com.therandomlabs.curseapi.util.MoshiUtils;
import com.therandomlabs.curseapi.util.OkHttpUtils;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.retrofit.CircuitBreakerCallAdapter;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.vavr.control.Try;
import java.io.IOException;
import java.time.Duration;
import java.util.function.Function;
import okhttp3.ResponseBody;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public final class RetrofitUtils {
    private static final Logger logger = LoggerFactory.getLogger(RetrofitUtils.class);
    private static final CircuitBreaker circuitBreaker = CircuitBreaker.ofDefaults("curseapi");
    private static Function<String, Retrofit> retrofitSupplier = baseURL -> new Retrofit.Builder().addCallAdapterFactory(CircuitBreakerCallAdapter.of(circuitBreaker, response -> response.isSuccessful() || response.code() == 404)).baseUrl((String)baseURL).client(OkHttpUtils.getClient()).addConverterFactory(MoshiConverterFactory.create(MoshiUtils.moshi)).build();
    private static Retry retry = Retry.ofDefaults("curseapi");

    private RetrofitUtils() {
    }

    public static Retrofit get(String baseURL) {
        Preconditions.checkNotNull(baseURL, "baseURL should not be null");
        return retrofitSupplier.apply(baseURL);
    }

    public static <T> @Nullable T execute(Call<T> call) throws CurseException {
        Preconditions.checkNotNull(call, "call should not be null");
        logger.debug("Executing request: {}", (Object)call.request());
        try {
            Response response = Try.of(Retry.decorateCheckedSupplier(retry, () -> call.clone().execute())).get();
            if (response.isSuccessful()) {
                return response.body();
            }
            if (response.code() == 400 || response.code() == 404) {
                return null;
            }
            ResponseBody errorBody = response.errorBody();
            Throwable throwable = null;
            try {
                try {
                    throw new CurseException(String.format("Failed to execute call. HTTP status: %s (%s). Response body: %s", response.message(), response.code(), errorBody == null ? null : errorBody.string()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (errorBody != null) {
                    if (throwable != null) {
                        try {
                            errorBody.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        errorBody.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (JsonDataException | IOException ex) {
            throw new CurseException("Failed to execute request: " + call.request(), ex);
        }
    }

    public static @Nullable String getString(Call<ResponseBody> call) throws CurseException {
        Preconditions.checkNotNull(call, "call should not be null");
        try {
            ResponseBody responseBody = RetrofitUtils.execute(call);
            return responseBody == null ? null : responseBody.string();
        }
        catch (IOException ex) {
            throw new CurseException("Failed to get string: " + call.request(), ex);
        }
    }

    public static @Nullable Element getElement(Call<ResponseBody> call) throws CurseException {
        Preconditions.checkNotNull(call, "call should not be null");
        String string = RetrofitUtils.getString(call);
        if (string == null) {
            return null;
        }
        return JsoupUtils.parseBody(string);
    }

    public static void setRetrofitSupplier(Function<String, Retrofit> supplier) {
        Preconditions.checkNotNull(supplier, "supplier should not be null");
        retrofitSupplier = supplier;
    }

    public static void setRetryConfig(Duration waitDuration, int maxAttempts) {
        Preconditions.checkArgument(waitDuration.toMillis() > 0L, "waitDuration should be positive");
        Preconditions.checkArgument(maxAttempts > 0, "maxAttempts should be positive");
        retry = Retry.of("curseapi", RetryConfig.custom().waitDuration(waitDuration).maxAttempts(maxAttempts).build());
    }
}

