/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.util;

import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.CurseException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import javax.imageio.ImageIO;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OkHttpUtils {
    private static final long DEFAULT_TIMEOUT_MILLIS = 2000L;
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMillis(2000L);
    private static final Logger logger = LoggerFactory.getLogger(OkHttpUtils.class);
    private static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(DEFAULT_TIMEOUT).readTimeout(DEFAULT_TIMEOUT).writeTimeout(DEFAULT_TIMEOUT).build();

    private OkHttpUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(HttpUrl url) throws CurseException {
        Preconditions.checkNotNull(url, "url should not be null");
        Request request = new Request.Builder().url(url).build();
        logger.debug("Executing request: {}", (Object)request);
        try (ResponseBody responseBody = client.newCall(request).execute().body();){
            if (responseBody == null) {
                throw new CurseException("Failed to execute request: " + request);
            }
            String string = responseBody.string();
            return string;
        }
        catch (IOException ex) {
            throw new CurseException("Failed to read from URL: " + url, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage readImage(HttpUrl url) throws CurseException {
        Preconditions.checkNotNull(url, "url should not be null");
        Request request = new Request.Builder().url(url).build();
        logger.debug("Executing request: {}", (Object)request);
        try (ResponseBody responseBody = client.newCall(request).execute().body();){
            if (responseBody == null) {
                throw new CurseException("Failed to execute request: " + request);
            }
            BufferedImage bufferedImage = ImageIO.read(responseBody.byteStream());
            return bufferedImage;
        }
        catch (IOException ex) {
            throw new CurseException("Failed to read image from URL: " + url, ex);
        }
    }

    public static void download(HttpUrl url, Path path) throws CurseException {
        Preconditions.checkNotNull(url, "url should not be null");
        Preconditions.checkNotNull(path, "path should not be null");
        Request request = new Request.Builder().url(url).build();
        logger.debug("Executing request: {}", (Object)request);
        try (ResponseBody responseBody = client.newCall(request).execute().body();
             BufferedSink sink2 = Okio.buffer(Okio.sink(path, new OpenOption[0]));){
            if (responseBody == null) {
                throw new CurseException("Failed to execute request: " + request);
            }
            sink2.writeAll(responseBody.source());
        }
        catch (IOException ex) {
            throw new CurseException("Failed to download " + url + " to: " + path, ex);
        }
    }

    public static Path downloadToDirectory(HttpUrl url, Path directory, String fileName) throws CurseException {
        Preconditions.checkNotNull(url, "url should not be null");
        Preconditions.checkNotNull(directory, "directory should not be null");
        Preconditions.checkArgument(!Files.isRegularFile(directory, new LinkOption[0]), "directory should not be a regular file");
        Preconditions.checkNotNull(fileName, "fileName should not be null");
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new CurseException("Failed to create directory: " + directory, ex);
        }
        Path path = directory.resolve(fileName);
        OkHttpUtils.download(url, path);
        return path;
    }

    public static String getFileNameFromURLPath(HttpUrl url) {
        Preconditions.checkNotNull(url, "url should not be null");
        List<String> pathSegments = url.encodedPathSegments();
        String path = pathSegments.get(pathSegments.size() - 1);
        try {
            return URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("UTF-8 encoding is not supported; this should never happen", ex);
        }
    }

    public static OkHttpClient getClient() {
        return client;
    }

    public static void setClient(OkHttpClient client) {
        Preconditions.checkNotNull(client, "client should not be null");
        OkHttpUtils.client = client;
    }
}

