/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.game;

import com.therandomlabs.curseapi.CursePreconditions;
import com.therandomlabs.curseapi.game.CurseGameVersion;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public abstract class CurseGameVersionGroup<V extends CurseGameVersion<?>> {
    public final int hashCode() {
        return Objects.hash(this.gameID(), this.versionString(), this.versions());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CurseGameVersionGroup)) {
            return false;
        }
        CurseGameVersionGroup group = (CurseGameVersionGroup)object;
        return this.gameID() == group.gameID() && this.versionString().equals(group.versionString()) && this.versions().equals(group.versions());
    }

    public String toString() {
        return this.versionString();
    }

    public abstract int gameID();

    public abstract String versionString();

    public abstract Set<V> versions();

    public Set<String> versionStrings() {
        return this.versions().stream().map(CurseGameVersion::versionString).collect(Collectors.toCollection(TreeSet::new));
    }

    @SafeVarargs
    public final boolean containsAny(V ... versions) {
        return this.containsAny((Collection<V>)Arrays.asList(versions));
    }

    public boolean containsAny(Collection<V> versions) {
        return !Collections.disjoint(this.versions(), versions);
    }

    public boolean containsAnyStrings(String ... versionStrings) {
        return this.containsAnyStrings(Arrays.asList(versionStrings));
    }

    public boolean containsAnyStrings(Collection<String> versionStrings) {
        return !Collections.disjoint(this.versionStrings(), versionStrings);
    }

    public final boolean isNone() {
        return this instanceof None;
    }

    public static <V extends CurseGameVersion<?>> CurseGameVersionGroup<V> none(int gameID) {
        CursePreconditions.checkGameID(gameID, "gameID");
        return new None(gameID);
    }

    private static class None<V extends CurseGameVersion<?>>
    extends CurseGameVersionGroup<V> {
        private final int gameID;

        None(int gameID) {
            this.gameID = gameID;
        }

        @Override
        public int gameID() {
            return this.gameID;
        }

        @Override
        public String versionString() {
            return "*";
        }

        @Override
        public Set<V> versions() {
            return new HashSet();
        }
    }
}

