/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.forgesvc;

import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.game.CurseCategory;
import com.therandomlabs.curseapi.game.CurseCategorySection;
import com.therandomlabs.curseapi.game.CurseGame;
import java.util.Optional;
import java.util.Set;

final class ForgeSvcCategorySection
extends CurseCategorySection {
    private int gameId;
    private int gameCategoryId;
    private String name;
    private transient CurseGame game;
    private transient Set<CurseCategory> categories;
    private transient CurseCategory category;

    ForgeSvcCategorySection() {
    }

    @Override
    public int gameID() {
        return this.gameId;
    }

    @Override
    public CurseGame game() throws CurseException {
        if (this.game == null) {
            Optional<CurseGame> optionalGame = CurseAPI.game(this.gameId);
            if (!optionalGame.isPresent()) {
                throw new CurseException("Could not retrieve game for category section: " + this);
            }
            this.game = optionalGame.get();
        }
        return this.game;
    }

    @Override
    public CurseGame refreshGame() throws CurseException {
        this.game = null;
        return this.game();
    }

    @Override
    public int id() {
        return this.gameCategoryId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Set<CurseCategory> categories() throws CurseException {
        if (this.categories == null) {
            this.categories = CurseAPI.categories(this.gameCategoryId).orElse(null);
            if (this.categories == null) {
                throw new CurseException("Failed to retrieve categories in category section: " + this);
            }
        }
        return this.categories;
    }

    @Override
    public Set<CurseCategory> refreshCategories() throws CurseException {
        this.categories = null;
        return this.categories();
    }

    @Override
    public CurseCategory asCategory() throws CurseException {
        if (this.category == null) {
            this.category = CurseAPI.category(this.gameCategoryId).orElse(null);
            if (this.category == null) {
                throw new CurseException("Failed to retrieve category section as category: " + this);
            }
        }
        return this.category;
    }

    @Override
    public CurseCategory refreshAsCategory() throws CurseException {
        this.category = null;
        return this.asCategory();
    }
}

