/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.forgesvc;

import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.game.CurseCategory;
import com.therandomlabs.curseapi.game.CurseGame;
import java.util.List;
import java.util.Optional;
import okhttp3.HttpUrl;

final class ForgeSvcCategory
extends CurseCategory {
    private int gameId;
    private Integer rootGameCategoryId;
    private int rootId;
    private int id;
    private int categoryId;
    private String name;
    private String slug;
    private HttpUrl url;
    private HttpUrl avatarUrl;
    private transient CurseGame game;

    ForgeSvcCategory() {
    }

    @Override
    public int gameID() {
        return this.gameId;
    }

    @Override
    public CurseGame game() throws CurseException {
        if (this.game == null) {
            Optional<CurseGame> optionalGame = CurseAPI.game(this.gameId);
            if (!optionalGame.isPresent()) {
                throw new CurseException("Could not retrieve game for category: " + this);
            }
            this.game = optionalGame.get();
        }
        return this.game;
    }

    @Override
    public CurseGame refreshGame() throws CurseException {
        this.game = null;
        return this.game();
    }

    @Override
    public int sectionID() {
        if (this.rootId == 0) {
            return this.rootGameCategoryId == null ? 0 : this.rootGameCategoryId;
        }
        return this.rootId;
    }

    @Override
    public int id() {
        return this.id == 0 ? this.categoryId : this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String slug() {
        if (this.slug == null) {
            List<String> pathSegments = this.url.encodedPathSegments();
            this.slug = pathSegments.get(pathSegments.size() - 1);
        }
        return this.slug;
    }

    @Override
    public HttpUrl url() throws CurseException {
        if (this.url != null) {
            return this.url;
        }
        int sectionID = this.sectionID();
        if (sectionID == 0) {
            Optional<CurseGame> optionalGame = CurseAPI.game(this.gameId);
            if (!optionalGame.isPresent()) {
                throw new CurseException("Failed to retrieve URL for category: " + this);
            }
            this.url = HttpUrl.get(optionalGame.get().url() + "/" + this.slug);
            return this.url;
        }
        Optional<CurseCategory> optionalCategory = CurseAPI.category(sectionID);
        if (!optionalCategory.isPresent()) {
            throw new CurseException("Failed to retrieve URL for category: " + this);
        }
        this.url = HttpUrl.get(optionalCategory.get().url() + "/" + this.slug);
        return this.url;
    }

    @Override
    public HttpUrl logoURL() {
        return this.avatarUrl;
    }
}

