/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.file;

import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.CursePreconditions;
import com.therandomlabs.curseapi.file.BasicCurseFile;
import com.therandomlabs.curseapi.util.CheckedFunction;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CurseFiles<F extends BasicCurseFile>
extends TreeSet<F> {
    public static final Comparator<BasicCurseFile> SORT_BY_NEWEST = BasicCurseFile::compareTo;
    public static final Comparator<BasicCurseFile> SORT_BY_OLDEST = SORT_BY_NEWEST.reversed();
    private static final long serialVersionUID = 4762475826152943776L;

    public CurseFiles() {
    }

    public CurseFiles(Comparator<? super F> comparator) {
        super(comparator);
    }

    public CurseFiles(Collection<? extends F> files) {
        super(files);
    }

    public CurseFiles(Collection<? extends F> files, Comparator<? super F> comparator) {
        super(comparator);
        this.addAll(files);
    }

    @Override
    public CurseFiles<F> clone() {
        return (CurseFiles)super.clone();
    }

    public boolean filter(Predicate<? super F> filter2) {
        return this.removeIf(filter2.negate());
    }

    public @Nullable F fileWithID(int id) {
        CursePreconditions.checkFileID(id, "id");
        for (BasicCurseFile file : this) {
            if (id != file.id()) continue;
            return (F)file;
        }
        return null;
    }

    public CurseFiles<F> withComparator(Comparator<? super F> comparator) {
        return new CurseFiles<F>(this, comparator);
    }

    public <R, C> C parallelMap(CheckedFunction<? super F, ? extends R, CurseException> function, Collector<? super R, ?, C> collector) throws CurseException {
        return CurseAPI.parallelMap(this, function, collector);
    }

    public <K, V> Map<K, V> parallelMap(CheckedFunction<? super F, ? extends K, CurseException> keyMapper, CheckedFunction<? super F, ? extends V, CurseException> valueMapper) throws CurseException {
        return CurseAPI.parallelMap(this, keyMapper, valueMapper);
    }

    public static <F extends BasicCurseFile> Collector<F, ?, CurseFiles<F>> toCurseFiles() {
        return Collectors.toCollection(CurseFiles::new);
    }
}

