/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.Context;
import com.moandjiezana.toml.Results;
import com.moandjiezana.toml.ValueReader;
import com.moandjiezana.toml.ValueWriter;
import com.moandjiezana.toml.WriterContext;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class StringValueReaderWriter
implements ValueReader,
ValueWriter {
    static final StringValueReaderWriter STRING_VALUE_READER_WRITER = new StringValueReaderWriter();
    private static final Pattern UNICODE_REGEX = Pattern.compile("\\\\[uU](.{4})");
    private static final String[] specialCharacterEscapes = new String[93];

    @Override
    public boolean canRead(String s2) {
        return s2.startsWith("\"");
    }

    @Override
    public Object read(String s2, AtomicInteger index, Context context) {
        int startIndex = index.incrementAndGet();
        int endIndex = -1;
        int i2 = index.get();
        while (i2 < s2.length()) {
            char ch = s2.charAt(i2);
            if (ch == '\"' && s2.charAt(i2 - 1) != '\\') {
                endIndex = i2;
                break;
            }
            i2 = index.incrementAndGet();
        }
        if (endIndex == -1) {
            Results.Errors errors = new Results.Errors();
            errors.unterminated(context.identifier.getName(), s2.substring(startIndex - 1), context.line.get());
            return errors;
        }
        String raw = s2.substring(startIndex, endIndex);
        s2 = this.replaceUnicodeCharacters(raw);
        if ((s2 = this.replaceSpecialCharacters(s2)) == null) {
            Results.Errors errors = new Results.Errors();
            errors.invalidValue(context.identifier.getName(), raw, context.line.get());
            return errors;
        }
        return s2;
    }

    String replaceUnicodeCharacters(String value) {
        Matcher unicodeMatcher = UNICODE_REGEX.matcher(value);
        while (unicodeMatcher.find()) {
            value = value.replace(unicodeMatcher.group(), new String(Character.toChars(Integer.parseInt(unicodeMatcher.group(1), 16))));
        }
        return value;
    }

    String replaceSpecialCharacters(String s2) {
        for (int i2 = 0; i2 < s2.length() - 1; ++i2) {
            char ch = s2.charAt(i2);
            char next = s2.charAt(i2 + 1);
            if (ch == '\\' && next == '\\') {
                ++i2;
                continue;
            }
            if (ch != '\\' || next == 'b' || next == 'f' || next == 'n' || next == 't' || next == 'r' || next == '\"' || next == '\\') continue;
            return null;
        }
        return s2.replace("\\n", "\n").replace("\\\"", "\"").replace("\\t", "\t").replace("\\r", "\r").replace("\\\\", "\\").replace("\\/", "/").replace("\\b", "\b").replace("\\f", "\f");
    }

    @Override
    public boolean canWrite(Object value) {
        return value instanceof String || value instanceof Character || value instanceof URL || value instanceof URI || value instanceof Enum;
    }

    @Override
    public void write(Object value, WriterContext context) {
        context.write('\"');
        this.escapeUnicode(value.toString(), context);
        context.write('\"');
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    private void escapeUnicode(String in, WriterContext context) {
        for (int i2 = 0; i2 < in.length(); ++i2) {
            int codePoint = in.codePointAt(i2);
            if (codePoint < specialCharacterEscapes.length && specialCharacterEscapes[codePoint] != null) {
                context.write(specialCharacterEscapes[codePoint]);
                continue;
            }
            context.write(in.charAt(i2));
        }
    }

    private StringValueReaderWriter() {
    }

    public String toString() {
        return "string";
    }

    static {
        StringValueReaderWriter.specialCharacterEscapes[8] = "\\b";
        StringValueReaderWriter.specialCharacterEscapes[9] = "\\t";
        StringValueReaderWriter.specialCharacterEscapes[10] = "\\n";
        StringValueReaderWriter.specialCharacterEscapes[12] = "\\f";
        StringValueReaderWriter.specialCharacterEscapes[13] = "\\r";
        StringValueReaderWriter.specialCharacterEscapes[34] = "\\\"";
        StringValueReaderWriter.specialCharacterEscapes[92] = "\\\\";
    }
}

