/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.Context;
import com.moandjiezana.toml.Results;
import com.moandjiezana.toml.ValueReader;
import com.moandjiezana.toml.ValueReaders;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class ArrayValueReader
implements ValueReader {
    static final ArrayValueReader ARRAY_VALUE_READER = new ArrayValueReader();

    @Override
    public boolean canRead(String s2) {
        return s2.startsWith("[");
    }

    @Override
    public Object read(String s2, AtomicInteger index, Context context) {
        AtomicInteger line = context.line;
        int startLine = line.get();
        int startIndex = index.get();
        ArrayList<Object> arrayItems = new ArrayList<Object>();
        boolean terminated = false;
        boolean inComment = false;
        Results.Errors errors = new Results.Errors();
        int i2 = index.incrementAndGet();
        while (i2 < s2.length()) {
            char c = s2.charAt(i2);
            if (c == '#' && !inComment) {
                inComment = true;
            } else if (c == '\n') {
                inComment = false;
                line.incrementAndGet();
            } else if (!inComment && !Character.isWhitespace(c) && c != ',') {
                Object converted;
                if (c == '[') {
                    converted = this.read(s2, index, context);
                    if (converted instanceof Results.Errors) {
                        errors.add((Results.Errors)converted);
                    } else if (!this.isHomogenousArray(converted, arrayItems)) {
                        errors.heterogenous(context.identifier.getName(), line.get());
                    } else {
                        arrayItems.add(converted);
                    }
                } else {
                    if (c == ']') {
                        terminated = true;
                        break;
                    }
                    converted = ValueReaders.VALUE_READERS.convert(s2, index, context);
                    if (converted instanceof Results.Errors) {
                        errors.add((Results.Errors)converted);
                    } else if (!this.isHomogenousArray(converted, arrayItems)) {
                        errors.heterogenous(context.identifier.getName(), line.get());
                    } else {
                        arrayItems.add(converted);
                    }
                }
            }
            i2 = index.incrementAndGet();
        }
        if (!terminated) {
            errors.unterminated(context.identifier.getName(), s2.substring(startIndex, s2.length()), startLine);
        }
        if (errors.hasErrors()) {
            return errors;
        }
        return arrayItems;
    }

    private boolean isHomogenousArray(Object o, List<?> values2) {
        return values2.isEmpty() || values2.get(0).getClass().isAssignableFrom(o.getClass()) || o.getClass().isAssignableFrom(values2.get(0).getClass());
    }

    private ArrayValueReader() {
    }
}

