/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.query.AbstractQuery;
import de.greenrobot.dao.query.AbstractQueryData;

public class DeleteQuery<T>
extends AbstractQuery<T> {
    private final QueryData<T> queryData;
    private SQLiteStatement compiledStatement;

    static <T2> DeleteQuery<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        QueryData queryData = new QueryData(dao, sql, DeleteQuery.toStringArray(initialValues));
        return (DeleteQuery)queryData.forCurrentThread();
    }

    private DeleteQuery(QueryData<T> queryData, AbstractDao<T, ?> dao, String sql, String[] initialValues) {
        super(dao, sql, initialValues);
        this.queryData = queryData;
    }

    public DeleteQuery<T> forCurrentThread() {
        return this.queryData.forCurrentThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDeleteWithoutDetachingEntities() {
        this.checkThread();
        SQLiteDatabase db = this.dao.getDatabase();
        if (db.isDbLockedByCurrentThread()) {
            this.executeDeleteWithoutDetachingEntitiesInsideTx();
        } else {
            db.beginTransaction();
            try {
                this.executeDeleteWithoutDetachingEntitiesInsideTx();
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
    }

    private void executeDeleteWithoutDetachingEntitiesInsideTx() {
        if (this.compiledStatement != null) {
            this.compiledStatement.clearBindings();
        } else {
            this.compiledStatement = this.dao.getDatabase().compileStatement(this.sql);
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            String value = this.parameters[i];
            if (value != null) {
                this.compiledStatement.bindString(i + 1, value);
                continue;
            }
            this.compiledStatement.bindNull(i + 1);
        }
        this.compiledStatement.execute();
    }

    private static final class QueryData<T2>
    extends AbstractQueryData<T2, DeleteQuery<T2>> {
        private QueryData(AbstractDao<T2, ?> dao, String sql, String[] initialValues) {
            super(dao, sql, initialValues);
        }

        @Override
        protected DeleteQuery<T2> createQuery() {
            return new DeleteQuery(this, this.dao, this.sql, (String[])this.initialValues.clone());
        }
    }
}

