/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.event;

import de.greenrobot.event.EventBusException;
import de.greenrobot.event.SubscriberMethod;
import de.greenrobot.event.ThreadMode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SubscriberMethodFinder {
    private static final Map<String, List<SubscriberMethod>> methodCache = new HashMap<String, List<SubscriberMethod>>();
    private static final Map<Class<?>, Class<?>> skipMethodNameVerificationForClasses = new ConcurrentHashMap();

    SubscriberMethodFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SubscriberMethod> findSubscriberMethods(Class<?> subscriberClass, String eventMethodName) {
        String name;
        List<SubscriberMethod> subscriberMethods;
        String key = subscriberClass.getName() + '.' + eventMethodName;
        Map<String, List<SubscriberMethod>> map = methodCache;
        synchronized (map) {
            subscriberMethods = methodCache.get(key);
        }
        if (subscriberMethods != null) {
            return subscriberMethods;
        }
        subscriberMethods = new ArrayList<SubscriberMethod>();
        HashSet<String> eventTypesFound = new HashSet<String>();
        StringBuilder methodKeyBuilder = new StringBuilder();
        for (Class<?> clazz = subscriberClass; !(clazz == null || (name = clazz.getName()).startsWith("java.") || name.startsWith("javax.") || name.startsWith("android.")); clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                ThreadMode threadMode;
                Class<?>[] parameterTypes;
                String methodName = method.getName();
                if (!methodName.startsWith(eventMethodName) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                String modifierString = methodName.substring(eventMethodName.length());
                if (modifierString.length() == 0) {
                    threadMode = ThreadMode.PostThread;
                } else if (modifierString.equals("MainThread")) {
                    threadMode = ThreadMode.MainThread;
                } else if (modifierString.equals("BackgroundThread")) {
                    threadMode = ThreadMode.BackgroundThread;
                } else if (modifierString.equals("Async")) {
                    threadMode = ThreadMode.Async;
                } else {
                    if (skipMethodNameVerificationForClasses.containsKey(clazz)) continue;
                    throw new EventBusException("Illegal onEvent method, check for typos: " + method);
                }
                Class<?> eventType = parameterTypes[0];
                methodKeyBuilder.setLength(0);
                methodKeyBuilder.append(methodName);
                methodKeyBuilder.append('>').append(eventType.getName());
                String methodKey = methodKeyBuilder.toString();
                if (!eventTypesFound.add(methodKey)) continue;
                subscriberMethods.add(new SubscriberMethod(method, threadMode, eventType));
            }
        }
        if (subscriberMethods.isEmpty()) {
            throw new EventBusException("Subscriber " + subscriberClass + " has no methods called " + eventMethodName);
        }
        Map<String, List<SubscriberMethod>> map2 = methodCache;
        synchronized (map2) {
            methodCache.put(key, subscriberMethods);
        }
        return subscriberMethods;
    }

    static void clearCaches() {
        methodCache.clear();
    }

    static void skipMethodNameVerificationFor(Class<?> clazz) {
        if (!methodCache.isEmpty()) {
            throw new IllegalStateException("This method must be called before registering anything");
        }
        skipMethodNameVerificationForClasses.put(clazz, clazz);
    }

    public static void clearSkipMethodNameVerifications() {
        skipMethodNameVerificationForClasses.clear();
    }
}

