/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Picture;
import android.graphics.RectF;
import android.util.Log;
import com.caverock.androidsvg.CSSParser;
import com.caverock.androidsvg.PreserveAspectRatio;
import com.caverock.androidsvg.SVGAndroidRenderer;
import com.caverock.androidsvg.SVGExternalFileResolver;
import com.caverock.androidsvg.SVGParseException;
import com.caverock.androidsvg.SVGParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

public class SVG {
    private static final String TAG = "AndroidSVG";
    private static final String VERSION = "1.2.2-beta-1";
    protected static final String SUPPORTED_SVG_VERSION = "1.2";
    private static final int DEFAULT_PICTURE_WIDTH = 512;
    private static final int DEFAULT_PICTURE_HEIGHT = 512;
    private static final double SQRT2 = 1.414213562373095;
    private Svg rootElement = null;
    private String title = "";
    private String desc = "";
    private SVGExternalFileResolver fileResolver = null;
    private float renderDPI = 96.0f;
    private CSSParser.Ruleset cssRules = new CSSParser.Ruleset();
    Map<String, SvgObject> elementsById = new HashMap<String, SvgObject>();
    protected static final long SPECIFIED_FILL = 1L;
    protected static final long SPECIFIED_FILL_RULE = 2L;
    protected static final long SPECIFIED_FILL_OPACITY = 4L;
    protected static final long SPECIFIED_STROKE = 8L;
    protected static final long SPECIFIED_STROKE_OPACITY = 16L;
    protected static final long SPECIFIED_STROKE_WIDTH = 32L;
    protected static final long SPECIFIED_STROKE_LINECAP = 64L;
    protected static final long SPECIFIED_STROKE_LINEJOIN = 128L;
    protected static final long SPECIFIED_STROKE_MITERLIMIT = 256L;
    protected static final long SPECIFIED_STROKE_DASHARRAY = 512L;
    protected static final long SPECIFIED_STROKE_DASHOFFSET = 1024L;
    protected static final long SPECIFIED_OPACITY = 2048L;
    protected static final long SPECIFIED_COLOR = 4096L;
    protected static final long SPECIFIED_FONT_FAMILY = 8192L;
    protected static final long SPECIFIED_FONT_SIZE = 16384L;
    protected static final long SPECIFIED_FONT_WEIGHT = 32768L;
    protected static final long SPECIFIED_FONT_STYLE = 65536L;
    protected static final long SPECIFIED_TEXT_DECORATION = 131072L;
    protected static final long SPECIFIED_TEXT_ANCHOR = 262144L;
    protected static final long SPECIFIED_OVERFLOW = 524288L;
    protected static final long SPECIFIED_CLIP = 0x100000L;
    protected static final long SPECIFIED_MARKER_START = 0x200000L;
    protected static final long SPECIFIED_MARKER_MID = 0x400000L;
    protected static final long SPECIFIED_MARKER_END = 0x800000L;
    protected static final long SPECIFIED_DISPLAY = 0x1000000L;
    protected static final long SPECIFIED_VISIBILITY = 0x2000000L;
    protected static final long SPECIFIED_STOP_COLOR = 0x4000000L;
    protected static final long SPECIFIED_STOP_OPACITY = 0x8000000L;
    protected static final long SPECIFIED_CLIP_PATH = 0x10000000L;
    protected static final long SPECIFIED_CLIP_RULE = 0x20000000L;
    protected static final long SPECIFIED_MASK = 0x40000000L;
    protected static final long SPECIFIED_SOLID_COLOR = 0x80000000L;
    protected static final long SPECIFIED_SOLID_OPACITY = 0x100000000L;
    protected static final long SPECIFIED_VIEWPORT_FILL = 0x200000000L;
    protected static final long SPECIFIED_VIEWPORT_FILL_OPACITY = 0x400000000L;
    protected static final long SPECIFIED_VECTOR_EFFECT = 0x800000000L;
    protected static final long SPECIFIED_DIRECTION = 0x1000000000L;
    protected static final long SPECIFIED_ALL = -1L;
    protected static final long SPECIFIED_NON_INHERITING = 68133849088L;

    protected SVG() {
    }

    public static SVG getFromInputStream(InputStream is) throws SVGParseException {
        SVGParser parser = new SVGParser();
        return parser.parse(is);
    }

    public static SVG getFromString(String svg) throws SVGParseException {
        SVGParser parser = new SVGParser();
        return parser.parse(new ByteArrayInputStream(svg.getBytes()));
    }

    public static SVG getFromResource(Context context, int resourceId) throws SVGParseException {
        return SVG.getFromResource(context.getResources(), resourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVG getFromResource(Resources resources, int resourceId) throws SVGParseException {
        SVGParser parser = new SVGParser();
        BufferedInputStream in = new BufferedInputStream(resources.openRawResource(resourceId));
        try {
            SVG sVG = parser.parse(in);
            return sVG;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVG getFromAsset(AssetManager assetManager, String filename) throws SVGParseException, IOException {
        SVGParser parser = new SVGParser();
        BufferedInputStream is = new BufferedInputStream(assetManager.open(filename));
        try {
            SVG sVG = parser.parse(is);
            return sVG;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {}
        }
    }

    public void registerExternalFileResolver(SVGExternalFileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setRenderDPI(float dpi) {
        this.renderDPI = dpi;
    }

    public float getRenderDPI() {
        return this.renderDPI;
    }

    public Picture renderToPicture() {
        Length width = this.rootElement.width;
        if (width != null) {
            Length height;
            float w = width.floatValue(this.renderDPI);
            Box rootViewBox = this.rootElement.viewBox;
            float h = rootViewBox != null ? w * rootViewBox.height / rootViewBox.width : ((height = this.rootElement.height) != null ? height.floatValue(this.renderDPI) : w);
            return this.renderToPicture((int)Math.ceil(w), (int)Math.ceil(h));
        }
        return this.renderToPicture(512, 512);
    }

    public Picture renderToPicture(int widthInPixels, int heightInPixels) {
        Picture picture = new Picture();
        Canvas canvas = picture.beginRecording(widthInPixels, heightInPixels);
        Box viewPort = new Box(0.0f, 0.0f, widthInPixels, heightInPixels);
        SVGAndroidRenderer renderer = new SVGAndroidRenderer(canvas, viewPort, this.renderDPI);
        renderer.renderDocument(this, null, null, false);
        picture.endRecording();
        return picture;
    }

    public Picture renderViewToPicture(String viewId, int widthInPixels, int heightInPixels) {
        SvgObject obj = this.getElementById(viewId);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof View)) {
            return null;
        }
        View view = (View)obj;
        if (view.viewBox == null) {
            Log.w((String)TAG, (String)"View element is missing a viewBox attribute.");
            return null;
        }
        Picture picture = new Picture();
        Canvas canvas = picture.beginRecording(widthInPixels, heightInPixels);
        Box viewPort = new Box(0.0f, 0.0f, widthInPixels, heightInPixels);
        SVGAndroidRenderer renderer = new SVGAndroidRenderer(canvas, viewPort, this.renderDPI);
        renderer.renderDocument(this, view.viewBox, view.preserveAspectRatio, false);
        picture.endRecording();
        return picture;
    }

    public void renderToCanvas(Canvas canvas) {
        this.renderToCanvas(canvas, null);
    }

    public void renderToCanvas(Canvas canvas, RectF viewPort) {
        Box svgViewPort = viewPort != null ? Box.fromLimits(viewPort.left, viewPort.top, viewPort.right, viewPort.bottom) : new Box(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        SVGAndroidRenderer renderer = new SVGAndroidRenderer(canvas, svgViewPort, this.renderDPI);
        renderer.renderDocument(this, null, null, true);
    }

    public void renderViewToCanvas(String viewId, Canvas canvas) {
        this.renderViewToCanvas(viewId, canvas, null);
    }

    public void renderViewToCanvas(String viewId, Canvas canvas, RectF viewPort) {
        SvgObject obj = this.getElementById(viewId);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof View)) {
            return;
        }
        View view = (View)obj;
        if (view.viewBox == null) {
            Log.w((String)TAG, (String)"View element is missing a viewBox attribute.");
            return;
        }
        Box svgViewPort = viewPort != null ? Box.fromLimits(viewPort.left, viewPort.top, viewPort.right, viewPort.bottom) : new Box(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        SVGAndroidRenderer renderer = new SVGAndroidRenderer(canvas, svgViewPort, this.renderDPI);
        renderer.renderDocument(this, view.viewBox, view.preserveAspectRatio, true);
    }

    public static String getVersion() {
        return VERSION;
    }

    public String getDocumentTitle() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.title;
    }

    public String getDocumentDescription() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.desc;
    }

    public String getDocumentSVGVersion() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.rootElement.version;
    }

    public Set<String> getViewList() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        List<SvgObject> viewElems = this.getElementsByTagName(View.class);
        HashSet<String> viewIds = new HashSet<String>(viewElems.size());
        for (SvgObject elem : viewElems) {
            View view = (View)elem;
            if (view.id != null) {
                viewIds.add(view.id);
                continue;
            }
            Log.w((String)TAG, (String)"getViewList(): found a <view> without an id attribute");
        }
        return viewIds;
    }

    public float getDocumentWidth() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.getDocumentDimensions((float)this.renderDPI).width;
    }

    public void setDocumentWidth(float pixels) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.width = new Length(pixels);
    }

    public void setDocumentWidth(String value) throws SVGParseException {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        try {
            this.rootElement.width = SVGParser.parseLength(value);
        }
        catch (SAXException e) {
            throw new SVGParseException(e.getMessage());
        }
    }

    public float getDocumentHeight() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.getDocumentDimensions((float)this.renderDPI).height;
    }

    public void setDocumentHeight(float pixels) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.height = new Length(pixels);
    }

    public void setDocumentHeight(String value) throws SVGParseException {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        try {
            this.rootElement.height = SVGParser.parseLength(value);
        }
        catch (SAXException e) {
            throw new SVGParseException(e.getMessage());
        }
    }

    public void setDocumentViewBox(float minX, float minY, float width, float height) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.viewBox = new Box(minX, minY, width, height);
    }

    public RectF getDocumentViewBox() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        if (this.rootElement.viewBox == null) {
            return null;
        }
        return this.rootElement.viewBox.toRectF();
    }

    public void setDocumentPreserveAspectRatio(PreserveAspectRatio preserveAspectRatio) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.preserveAspectRatio = preserveAspectRatio;
    }

    public PreserveAspectRatio getDocumentPreserveAspectRatio() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        if (this.rootElement.preserveAspectRatio == null) {
            return null;
        }
        return this.rootElement.preserveAspectRatio;
    }

    public float getDocumentAspectRatio() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        Length w = this.rootElement.width;
        Length h = this.rootElement.height;
        if (w != null && h != null && w.unit != Unit.percent && h.unit != Unit.percent) {
            if (w.isZero() || h.isZero()) {
                return -1.0f;
            }
            return w.floatValue(this.renderDPI) / h.floatValue(this.renderDPI);
        }
        if (this.rootElement.viewBox != null && this.rootElement.viewBox.width != 0.0f && this.rootElement.viewBox.height != 0.0f) {
            return this.rootElement.viewBox.width / this.rootElement.viewBox.height;
        }
        return -1.0f;
    }

    protected Svg getRootElement() {
        return this.rootElement;
    }

    protected void setRootElement(Svg rootElement) {
        this.rootElement = rootElement;
    }

    protected SvgObject resolveIRI(String iri) {
        if (iri == null) {
            return null;
        }
        if (iri.length() > 1 && iri.startsWith("#")) {
            return this.getElementById(iri.substring(1));
        }
        return null;
    }

    private Box getDocumentDimensions(float dpi) {
        float hOut;
        Length w = this.rootElement.width;
        Length h = this.rootElement.height;
        if (w == null || w.isZero() || w.unit == Unit.percent || w.unit == Unit.em || w.unit == Unit.ex) {
            return new Box(-1.0f, -1.0f, -1.0f, -1.0f);
        }
        float wOut = w.floatValue(dpi);
        if (h != null) {
            if (h.isZero() || h.unit == Unit.percent || h.unit == Unit.em || h.unit == Unit.ex) {
                return new Box(-1.0f, -1.0f, -1.0f, -1.0f);
            }
            hOut = h.floatValue(dpi);
        } else {
            hOut = this.rootElement.viewBox != null ? wOut * this.rootElement.viewBox.height / this.rootElement.viewBox.width : wOut;
        }
        return new Box(0.0f, 0.0f, wOut, hOut);
    }

    protected void addCSSRules(CSSParser.Ruleset ruleset) {
        this.cssRules.addAll(ruleset);
    }

    protected List<CSSParser.Rule> getCSSRules() {
        return this.cssRules.getRules();
    }

    protected boolean hasCSSRules() {
        return !this.cssRules.isEmpty();
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setDesc(String desc) {
        this.desc = desc;
    }

    protected SVGExternalFileResolver getFileResolver() {
        return this.fileResolver;
    }

    void putElement(SvgElementBase element) {
        SvgObject old;
        String id = element.id;
        if (id != null && id.length() > 0 && (old = this.elementsById.put(id, element)) != null) {
            Log.w((String)TAG, (String)("Duplicate ID \"" + id + "\": element " + element + " overwrote " + old));
        }
    }

    protected SvgObject getElementById(String id) {
        if (id.equals(this.rootElement.id)) {
            return this.rootElement;
        }
        return this.elementsById.get(id);
    }

    protected List<SvgObject> getElementsByTagName(Class clazz) {
        return this.getElementsByTagName(this.rootElement, clazz);
    }

    private List<SvgObject> getElementsByTagName(SvgContainer obj, Class clazz) {
        ArrayList<SvgObject> result = new ArrayList<SvgObject>();
        if (obj.getClass() == clazz) {
            result.add((SvgObject)((Object)obj));
        }
        for (SvgObject child : obj.getChildren()) {
            if (child.getClass() == clazz) {
                result.add(child);
            }
            if (!(child instanceof SvgContainer)) continue;
            this.getElementsByTagName((SvgContainer)((Object)child), clazz);
        }
        return result;
    }

    protected static class PathDefinition
    implements PathInterface {
        private byte[] commands = new byte[64];
        private int commandsLength;
        private float[] coords = new float[64];
        private int coordsLength;
        private static final byte MOVETO = 0;
        private static final byte LINETO = 1;
        private static final byte CUBICTO = 2;
        private static final byte QUADTO = 3;
        private static final byte ARCTO = 4;
        private static final byte CLOSE = 8;

        public boolean isEmpty() {
            return this.commandsLength == 0;
        }

        private void addCommand(byte value) {
            if (this.commandsLength == this.commands.length) {
                byte[] newCommands = new byte[this.commands.length * 2];
                System.arraycopy(this.commands, 0, newCommands, 0, this.commands.length);
                this.commands = newCommands;
            }
            this.commands[this.commandsLength] = value;
            ++this.commandsLength;
        }

        private void addCoord(float value) {
            if (this.coordsLength == this.coords.length) {
                float[] newCoords = new float[this.coords.length * 2];
                System.arraycopy(this.coords, 0, newCoords, 0, this.coords.length);
                this.coords = newCoords;
            }
            this.coords[this.coordsLength] = value;
            ++this.coordsLength;
        }

        @Override
        public void moveTo(float x, float y) {
            this.addCommand((byte)0);
            this.addCoord(x);
            this.addCoord(y);
        }

        @Override
        public void lineTo(float x, float y) {
            this.addCommand((byte)1);
            this.addCoord(x);
            this.addCoord(y);
        }

        @Override
        public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.addCommand((byte)2);
            this.addCoord(x1);
            this.addCoord(y1);
            this.addCoord(x2);
            this.addCoord(y2);
            this.addCoord(x3);
            this.addCoord(y3);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.addCommand((byte)3);
            this.addCoord(x1);
            this.addCoord(y1);
            this.addCoord(x2);
            this.addCoord(y2);
        }

        @Override
        public void arcTo(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) {
            int arc = 4 | (largeArcFlag ? 2 : 0) | (sweepFlag ? 1 : 0);
            this.addCommand((byte)arc);
            this.addCoord(rx);
            this.addCoord(ry);
            this.addCoord(xAxisRotation);
            this.addCoord(x);
            this.addCoord(y);
        }

        @Override
        public void close() {
            this.addCommand((byte)8);
        }

        public void enumeratePath(PathInterface handler) {
            int coordPos = 0;
            block7: for (int commandPos = 0; commandPos < this.commandsLength; ++commandPos) {
                byte command = this.commands[commandPos];
                switch (command) {
                    case 0: {
                        handler.moveTo(this.coords[coordPos++], this.coords[coordPos++]);
                        continue block7;
                    }
                    case 1: {
                        handler.lineTo(this.coords[coordPos++], this.coords[coordPos++]);
                        continue block7;
                    }
                    case 2: {
                        handler.cubicTo(this.coords[coordPos++], this.coords[coordPos++], this.coords[coordPos++], this.coords[coordPos++], this.coords[coordPos++], this.coords[coordPos++]);
                        continue block7;
                    }
                    case 3: {
                        handler.quadTo(this.coords[coordPos++], this.coords[coordPos++], this.coords[coordPos++], this.coords[coordPos++]);
                        continue block7;
                    }
                    case 8: {
                        handler.close();
                        continue block7;
                    }
                    default: {
                        boolean largeArcFlag = (command & 2) != 0;
                        boolean sweepFlag = (command & 1) != 0;
                        handler.arcTo(this.coords[coordPos++], this.coords[coordPos++], this.coords[coordPos++], largeArcFlag, sweepFlag, this.coords[coordPos++], this.coords[coordPos++]);
                    }
                }
            }
        }
    }

    protected static interface PathInterface {
        public void moveTo(float var1, float var2);

        public void lineTo(float var1, float var2);

        public void cubicTo(float var1, float var2, float var3, float var4, float var5, float var6);

        public void quadTo(float var1, float var2, float var3, float var4);

        public void arcTo(float var1, float var2, float var3, boolean var4, boolean var5, float var6, float var7);

        public void close();
    }

    protected static class SolidColor
    extends SvgElementBase
    implements SvgContainer {
        public Length solidColor;
        public Length solidOpacity;

        protected SolidColor() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void addChild(SvgObject elem) throws SAXException {
        }
    }

    protected static class Mask
    extends SvgConditionalContainer
    implements NotDirectlyRendered {
        public Boolean maskUnitsAreUser;
        public Boolean maskContentUnitsAreUser;
        public Length x;
        public Length y;
        public Length width;
        public Length height;

        protected Mask() {
        }
    }

    protected static class View
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        protected View() {
        }
    }

    protected static class Image
    extends SvgPreserveAspectRatioContainer
    implements HasTransform {
        public String href;
        public Length x;
        public Length y;
        public Length width;
        public Length height;
        public Matrix transform;

        protected Image() {
        }

        @Override
        public void setTransform(Matrix transform) {
            this.transform = transform;
        }
    }

    protected static class Pattern
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        public Boolean patternUnitsAreUser;
        public Boolean patternContentUnitsAreUser;
        public Matrix patternTransform;
        public Length x;
        public Length y;
        public Length width;
        public Length height;
        public String href;

        protected Pattern() {
        }
    }

    protected static class ClipPath
    extends Group
    implements NotDirectlyRendered {
        public Boolean clipPathUnitsAreUser;

        protected ClipPath() {
        }
    }

    protected static class SvgRadialGradient
    extends GradientElement {
        public Length cx;
        public Length cy;
        public Length r;
        public Length fx;
        public Length fy;

        protected SvgRadialGradient() {
        }
    }

    protected static class SvgLinearGradient
    extends GradientElement {
        public Length x1;
        public Length y1;
        public Length x2;
        public Length y2;

        protected SvgLinearGradient() {
        }
    }

    protected static class Stop
    extends SvgElementBase
    implements SvgContainer {
        public Float offset;

        protected Stop() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void addChild(SvgObject elem) throws SAXException {
        }
    }

    protected static class GradientElement
    extends SvgElementBase
    implements SvgContainer {
        public List<SvgObject> children = new ArrayList<SvgObject>();
        public Boolean gradientUnitsAreUser;
        public Matrix gradientTransform;
        public GradientSpread spreadMethod;
        public String href;

        protected GradientElement() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return this.children;
        }

        @Override
        public void addChild(SvgObject elem) throws SAXException {
            if (!(elem instanceof Stop)) {
                throw new SAXException("Gradient elements cannot contain " + elem + " elements.");
            }
            this.children.add(elem);
            this.document.putElement((SvgElementBase)elem);
        }
    }

    protected static class Marker
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        public boolean markerUnitsAreUser;
        public Length refX;
        public Length refY;
        public Length markerWidth;
        public Length markerHeight;
        public Float orient;

        protected Marker() {
        }
    }

    protected static class Symbol
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        protected Symbol() {
        }
    }

    protected static class Switch
    extends Group {
        protected Switch() {
        }
    }

    protected static class TextPath
    extends TextContainer
    implements TextChild {
        public String href;
        public Length startOffset;
        private TextRoot textRoot;

        protected TextPath() {
        }

        @Override
        public void setTextRoot(TextRoot obj) {
            this.textRoot = obj;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }
    }

    protected static class TRef
    extends TextContainer
    implements TextChild {
        public String href;
        private TextRoot textRoot;

        protected TRef() {
        }

        @Override
        public void setTextRoot(TextRoot obj) {
            this.textRoot = obj;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }
    }

    protected static class TextSequence
    extends SvgObject
    implements TextChild {
        public String text;
        private TextRoot textRoot;

        public TextSequence(String text) {
            this.text = text;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + " '" + this.text + "'";
        }

        @Override
        public void setTextRoot(TextRoot obj) {
            this.textRoot = obj;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }
    }

    protected static class TSpan
    extends TextPositionedContainer
    implements TextChild {
        private TextRoot textRoot;

        protected TSpan() {
        }

        @Override
        public void setTextRoot(TextRoot obj) {
            this.textRoot = obj;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }
    }

    protected static class Text
    extends TextPositionedContainer
    implements TextRoot,
    HasTransform {
        public Matrix transform;

        protected Text() {
        }

        @Override
        public void setTransform(Matrix transform) {
            this.transform = transform;
        }
    }

    protected static class TextPositionedContainer
    extends TextContainer {
        public List<Length> x;
        public List<Length> y;
        public List<Length> dx;
        public List<Length> dy;

        protected TextPositionedContainer() {
        }
    }

    protected static class TextContainer
    extends SvgConditionalContainer {
        protected TextContainer() {
        }

        @Override
        public void addChild(SvgObject elem) throws SAXException {
            if (!(elem instanceof TextChild)) {
                throw new SAXException("Text content elements cannot contain " + elem + " elements.");
            }
            this.children.add(elem);
            this.document.putElement((SvgElementBase)elem);
        }
    }

    protected static interface TextChild {
        public void setTextRoot(TextRoot var1);

        public TextRoot getTextRoot();
    }

    protected static interface TextRoot {
    }

    protected static class Polygon
    extends PolyLine {
        protected Polygon() {
        }
    }

    protected static class PolyLine
    extends GraphicsElement {
        public float[] points;

        protected PolyLine() {
        }
    }

    protected static class Line
    extends GraphicsElement {
        public Length x1;
        public Length y1;
        public Length x2;
        public Length y2;

        protected Line() {
        }
    }

    protected static class Ellipse
    extends GraphicsElement {
        public Length cx;
        public Length cy;
        public Length rx;
        public Length ry;

        protected Ellipse() {
        }
    }

    protected static class Circle
    extends GraphicsElement {
        public Length cx;
        public Length cy;
        public Length r;

        protected Circle() {
        }
    }

    protected static class Rect
    extends GraphicsElement {
        public Length x;
        public Length y;
        public Length width;
        public Length height;
        public Length rx;
        public Length ry;

        protected Rect() {
        }
    }

    protected static class Path
    extends GraphicsElement {
        public PathDefinition d;
        public Float pathLength;

        protected Path() {
        }
    }

    protected static class Use
    extends Group {
        public String href;
        public Length x;
        public Length y;
        public Length width;
        public Length height;

        protected Use() {
        }
    }

    protected static abstract class GraphicsElement
    extends SvgConditionalElement
    implements HasTransform {
        public Matrix transform;

        protected GraphicsElement() {
        }

        @Override
        public void setTransform(Matrix transform) {
            this.transform = transform;
        }
    }

    protected static class Defs
    extends Group
    implements NotDirectlyRendered {
        protected Defs() {
        }
    }

    protected static interface NotDirectlyRendered {
    }

    protected static class Group
    extends SvgConditionalContainer
    implements HasTransform {
        public Matrix transform;

        protected Group() {
        }

        @Override
        public void setTransform(Matrix transform) {
            this.transform = transform;
        }
    }

    protected static class Svg
    extends SvgViewBoxContainer {
        public Length x;
        public Length y;
        public Length width;
        public Length height;
        public String version;

        protected Svg() {
        }
    }

    protected static class SvgViewBoxContainer
    extends SvgPreserveAspectRatioContainer {
        public Box viewBox;

        protected SvgViewBoxContainer() {
        }
    }

    protected static class SvgPreserveAspectRatioContainer
    extends SvgConditionalContainer {
        public PreserveAspectRatio preserveAspectRatio = null;

        protected SvgPreserveAspectRatioContainer() {
        }
    }

    protected static interface HasTransform {
        public void setTransform(Matrix var1);
    }

    protected static class SvgConditionalContainer
    extends SvgElement
    implements SvgContainer,
    SvgConditional {
        public List<SvgObject> children = new ArrayList<SvgObject>();
        public Set<String> requiredFeatures = null;
        public String requiredExtensions = null;
        public Set<String> systemLanguage = null;
        public Set<String> requiredFormats = null;
        public Set<String> requiredFonts = null;

        protected SvgConditionalContainer() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return this.children;
        }

        @Override
        public void addChild(SvgObject elem) throws SAXException {
            this.children.add(elem);
            this.document.putElement((SvgElementBase)elem);
        }

        @Override
        public void setRequiredFeatures(Set<String> features) {
            this.requiredFeatures = features;
        }

        @Override
        public Set<String> getRequiredFeatures() {
            return this.requiredFeatures;
        }

        @Override
        public void setRequiredExtensions(String extensions) {
            this.requiredExtensions = extensions;
        }

        @Override
        public String getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public void setSystemLanguage(Set<String> languages) {
            this.systemLanguage = languages;
        }

        @Override
        public Set<String> getSystemLanguage() {
            return null;
        }

        @Override
        public void setRequiredFormats(Set<String> mimeTypes) {
            this.requiredFormats = mimeTypes;
        }

        @Override
        public Set<String> getRequiredFormats() {
            return this.requiredFormats;
        }

        @Override
        public void setRequiredFonts(Set<String> fontNames) {
            this.requiredFonts = fontNames;
        }

        @Override
        public Set<String> getRequiredFonts() {
            return this.requiredFonts;
        }
    }

    protected static interface SvgContainer {
        public List<SvgObject> getChildren();

        public void addChild(SvgObject var1) throws SAXException;
    }

    protected static class SvgConditionalElement
    extends SvgElement
    implements SvgConditional {
        public Set<String> requiredFeatures = null;
        public String requiredExtensions = null;
        public Set<String> systemLanguage = null;
        public Set<String> requiredFormats = null;
        public Set<String> requiredFonts = null;

        protected SvgConditionalElement() {
        }

        @Override
        public void setRequiredFeatures(Set<String> features) {
            this.requiredFeatures = features;
        }

        @Override
        public Set<String> getRequiredFeatures() {
            return this.requiredFeatures;
        }

        @Override
        public void setRequiredExtensions(String extensions) {
            this.requiredExtensions = extensions;
        }

        @Override
        public String getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public void setSystemLanguage(Set<String> languages) {
            this.systemLanguage = languages;
        }

        @Override
        public Set<String> getSystemLanguage() {
            return this.systemLanguage;
        }

        @Override
        public void setRequiredFormats(Set<String> mimeTypes) {
            this.requiredFormats = mimeTypes;
        }

        @Override
        public Set<String> getRequiredFormats() {
            return this.requiredFormats;
        }

        @Override
        public void setRequiredFonts(Set<String> fontNames) {
            this.requiredFonts = fontNames;
        }

        @Override
        public Set<String> getRequiredFonts() {
            return this.requiredFonts;
        }
    }

    protected static interface SvgConditional {
        public void setRequiredFeatures(Set<String> var1);

        public Set<String> getRequiredFeatures();

        public void setRequiredExtensions(String var1);

        public String getRequiredExtensions();

        public void setSystemLanguage(Set<String> var1);

        public Set<String> getSystemLanguage();

        public void setRequiredFormats(Set<String> var1);

        public Set<String> getRequiredFormats();

        public void setRequiredFonts(Set<String> var1);

        public Set<String> getRequiredFonts();
    }

    protected static class SvgElement
    extends SvgElementBase {
        public Box boundingBox = null;

        protected SvgElement() {
        }
    }

    protected static class SvgElementBase
    extends SvgObject {
        public String id = null;
        public Boolean spacePreserve = null;
        public Style baseStyle = null;
        public Style style = null;
        public List<String> classNames = null;

        protected SvgElementBase() {
        }
    }

    protected static class SvgObject {
        public SVG document;
        public SvgContainer parent;

        protected SvgObject() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    protected static class CSSClipRect {
        public Length top;
        public Length right;
        public Length bottom;
        public Length left;

        public CSSClipRect(Length top, Length right, Length bottom, Length left) {
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.left = left;
        }
    }

    protected static class Length
    implements Cloneable {
        float value = 0.0f;
        Unit unit = Unit.px;

        public Length(float value, Unit unit) {
            this.value = value;
            this.unit = unit;
        }

        public Length(float value) {
            this.value = value;
            this.unit = Unit.px;
        }

        public float floatValue() {
            return this.value;
        }

        public float floatValueX(SVGAndroidRenderer renderer) {
            switch (this.unit) {
                case px: {
                    return this.value;
                }
                case em: {
                    return this.value * renderer.getCurrentFontSize();
                }
                case ex: {
                    return this.value * renderer.getCurrentFontXHeight();
                }
                case in: {
                    return this.value * renderer.getDPI();
                }
                case cm: {
                    return this.value * renderer.getDPI() / 2.54f;
                }
                case mm: {
                    return this.value * renderer.getDPI() / 25.4f;
                }
                case pt: {
                    return this.value * renderer.getDPI() / 72.0f;
                }
                case pc: {
                    return this.value * renderer.getDPI() / 6.0f;
                }
                case percent: {
                    Box viewPortUser = renderer.getCurrentViewPortInUserUnits();
                    if (viewPortUser == null) {
                        return this.value;
                    }
                    return this.value * viewPortUser.width / 100.0f;
                }
            }
            return this.value;
        }

        public float floatValueY(SVGAndroidRenderer renderer) {
            if (this.unit == Unit.percent) {
                Box viewPortUser = renderer.getCurrentViewPortInUserUnits();
                if (viewPortUser == null) {
                    return this.value;
                }
                return this.value * viewPortUser.height / 100.0f;
            }
            return this.floatValueX(renderer);
        }

        public float floatValue(SVGAndroidRenderer renderer) {
            if (this.unit == Unit.percent) {
                Box viewPortUser = renderer.getCurrentViewPortInUserUnits();
                if (viewPortUser == null) {
                    return this.value;
                }
                float w = viewPortUser.width;
                float h = viewPortUser.height;
                if (w == h) {
                    return this.value * w / 100.0f;
                }
                float n = (float)(Math.sqrt(w * w + h * h) / 1.414213562373095);
                return this.value * n / 100.0f;
            }
            return this.floatValueX(renderer);
        }

        public float floatValue(SVGAndroidRenderer renderer, float max) {
            if (this.unit == Unit.percent) {
                return this.value * max / 100.0f;
            }
            return this.floatValueX(renderer);
        }

        public float floatValue(float dpi) {
            switch (this.unit) {
                case px: {
                    return this.value;
                }
                case in: {
                    return this.value * dpi;
                }
                case cm: {
                    return this.value * dpi / 2.54f;
                }
                case mm: {
                    return this.value * dpi / 25.4f;
                }
                case pt: {
                    return this.value * dpi / 72.0f;
                }
                case pc: {
                    return this.value * dpi / 6.0f;
                }
            }
            return this.value;
        }

        public boolean isZero() {
            return this.value == 0.0f;
        }

        public boolean isNegative() {
            return this.value < 0.0f;
        }

        public String toString() {
            return String.valueOf(this.value) + (Object)((Object)this.unit);
        }
    }

    protected static class PaintReference
    extends SvgPaint {
        public String href;
        public SvgPaint fallback;

        public PaintReference(String href, SvgPaint fallback) {
            this.href = href;
            this.fallback = fallback;
        }

        public String toString() {
            return this.href + " " + this.fallback;
        }
    }

    protected static class CurrentColor
    extends SvgPaint {
        private static CurrentColor instance = new CurrentColor();

        private CurrentColor() {
        }

        public static CurrentColor getInstance() {
            return instance;
        }
    }

    protected static class Colour
    extends SvgPaint {
        public int colour;
        public static final Colour BLACK = new Colour(0);

        public Colour(int val) {
            this.colour = val;
        }

        public String toString() {
            return String.format("#%06x", this.colour);
        }
    }

    protected static abstract class SvgPaint
    implements Cloneable {
        protected SvgPaint() {
        }
    }

    protected static class Style
    implements Cloneable {
        public long specifiedFlags = 0L;
        public SvgPaint fill;
        public FillRule fillRule;
        public float fillOpacity;
        public SvgPaint stroke;
        public float strokeOpacity;
        public Length strokeWidth;
        public LineCaps strokeLineCap;
        public LineJoin strokeLineJoin;
        public float strokeMiterLimit;
        public Length[] strokeDashArray;
        public Length strokeDashOffset;
        public float opacity;
        public Colour color;
        public List<String> fontFamily;
        public Length fontSize;
        public Integer fontWeight;
        public FontStyle fontStyle;
        public TextDecoration textDecoration;
        public TextDirection direction;
        public TextAnchor textAnchor;
        public Boolean overflow;
        public CSSClipRect clip;
        public String markerStart;
        public String markerMid;
        public String markerEnd;
        public Boolean display;
        public Boolean visibility;
        public SvgPaint stopColor;
        public float stopOpacity;
        public String clipPath;
        public FillRule clipRule;
        public String mask;
        public SvgPaint solidColor;
        public float solidOpacity;
        public SvgPaint viewportFill;
        public Float viewportFillOpacity;
        public VectorEffect vectorEffect;
        public static final int FONT_WEIGHT_NORMAL = 400;
        public static final int FONT_WEIGHT_BOLD = 700;
        public static final int FONT_WEIGHT_LIGHTER = -1;
        public static final int FONT_WEIGHT_BOLDER = 1;

        protected Style() {
        }

        public static Style getDefaultStyle() {
            Style def = new Style();
            def.specifiedFlags = -1L;
            def.fill = Colour.BLACK;
            def.fillRule = FillRule.NonZero;
            def.fillOpacity = 1.0f;
            def.stroke = null;
            def.strokeOpacity = 1.0f;
            def.strokeWidth = new Length(1.0f);
            def.strokeLineCap = LineCaps.Butt;
            def.strokeLineJoin = LineJoin.Miter;
            def.strokeMiterLimit = 4.0f;
            def.strokeDashArray = null;
            def.strokeDashOffset = new Length(0.0f);
            def.opacity = 1.0f;
            def.color = Colour.BLACK;
            def.fontFamily = null;
            def.fontSize = new Length(12.0f, Unit.pt);
            def.fontWeight = 400;
            def.fontStyle = FontStyle.Normal;
            def.textDecoration = TextDecoration.None;
            def.direction = TextDirection.LTR;
            def.textAnchor = TextAnchor.Start;
            def.overflow = true;
            def.clip = null;
            def.markerStart = null;
            def.markerMid = null;
            def.markerEnd = null;
            def.display = Boolean.TRUE;
            def.visibility = Boolean.TRUE;
            def.stopColor = Colour.BLACK;
            def.stopOpacity = 1.0f;
            def.clipPath = null;
            def.clipRule = FillRule.NonZero;
            def.mask = null;
            def.solidColor = null;
            def.solidOpacity = 1.0f;
            def.viewportFill = null;
            def.viewportFillOpacity = Float.valueOf(1.0f);
            def.vectorEffect = VectorEffect.None;
            return def;
        }

        public void resetNonInheritingProperties() {
            this.resetNonInheritingProperties(false);
        }

        public void resetNonInheritingProperties(boolean isRootSVG) {
            this.display = Boolean.TRUE;
            this.overflow = isRootSVG ? Boolean.TRUE : Boolean.FALSE;
            this.clip = null;
            this.clipPath = null;
            this.opacity = 1.0f;
            this.stopColor = Colour.BLACK;
            this.stopOpacity = 1.0f;
            this.mask = null;
            this.solidColor = null;
            this.solidOpacity = 1.0f;
            this.viewportFill = null;
            this.viewportFillOpacity = Float.valueOf(1.0f);
            this.vectorEffect = VectorEffect.None;
        }

        protected Object clone() {
            try {
                Style obj = (Style)super.clone();
                if (this.strokeDashArray != null) {
                    obj.strokeDashArray = (Length[])this.strokeDashArray.clone();
                }
                return obj;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.toString());
            }
        }

        public static enum VectorEffect {
            None,
            NonScalingStroke;

        }

        public static enum TextDirection {
            LTR,
            RTL;

        }

        public static enum TextDecoration {
            None,
            Underline,
            Overline,
            LineThrough,
            Blink;

        }

        public static enum TextAnchor {
            Start,
            Middle,
            End;

        }

        public static enum FontStyle {
            Normal,
            Italic,
            Oblique;

        }

        public static enum LineJoin {
            Miter,
            Round,
            Bevel;

        }

        public static enum LineCaps {
            Butt,
            Round,
            Square;

        }

        public static enum FillRule {
            NonZero,
            EvenOdd;

        }
    }

    protected static class Box
    implements Cloneable {
        public float minX;
        public float minY;
        public float width;
        public float height;

        public Box(float minX, float minY, float width, float height) {
            this.minX = minX;
            this.minY = minY;
            this.width = width;
            this.height = height;
        }

        public static Box fromLimits(float minX, float minY, float maxX, float maxY) {
            return new Box(minX, minY, maxX - minX, maxY - minY);
        }

        public RectF toRectF() {
            return new RectF(this.minX, this.minY, this.maxX(), this.maxY());
        }

        public float maxX() {
            return this.minX + this.width;
        }

        public float maxY() {
            return this.minY + this.height;
        }

        public void union(Box other) {
            if (other.minX < this.minX) {
                this.minX = other.minX;
            }
            if (other.minY < this.minY) {
                this.minY = other.minY;
            }
            if (other.maxX() > this.maxX()) {
                this.width = other.maxX() - this.minX;
            }
            if (other.maxY() > this.maxY()) {
                this.height = other.maxY() - this.minY;
            }
        }

        public String toString() {
            return "[" + this.minX + " " + this.minY + " " + this.width + " " + this.height + "]";
        }
    }

    protected static enum GradientSpread {
        pad,
        reflect,
        repeat;

    }

    protected static enum Unit {
        px,
        em,
        ex,
        in,
        cm,
        mm,
        pt,
        pc,
        percent;

    }
}

