/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.os.Build;
import android.util.Log;
import com.caverock.androidsvg.SVGExternalFileResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class SimpleAssetResolver
extends SVGExternalFileResolver {
    private static final String TAG = SimpleAssetResolver.class.getSimpleName();
    private AssetManager assetManager;
    private static final Set<String> supportedFormats = new HashSet<String>(8);

    public SimpleAssetResolver(AssetManager assetManager) {
        supportedFormats.add("image/svg+xml");
        supportedFormats.add("image/jpeg");
        supportedFormats.add("image/png");
        supportedFormats.add("image/pjpeg");
        supportedFormats.add("image/gif");
        supportedFormats.add("image/bmp");
        supportedFormats.add("image/x-windows-bmp");
        if (Build.VERSION.SDK_INT >= 14) {
            supportedFormats.add("image/webp");
        }
        this.assetManager = assetManager;
    }

    @Override
    public Typeface resolveFont(String fontFamily, int fontWeight, String fontStyle) {
        Log.i((String)TAG, (String)("resolveFont(" + fontFamily + "," + fontWeight + "," + fontStyle + ")"));
        try {
            return Typeface.createFromAsset((AssetManager)this.assetManager, (String)(fontFamily + ".ttf"));
        }
        catch (Exception e) {
            try {
                return Typeface.createFromAsset((AssetManager)this.assetManager, (String)(fontFamily + ".otf"));
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    @Override
    public Bitmap resolveImage(String filename) {
        Log.i((String)TAG, (String)("resolveImage(" + filename + ")"));
        try {
            InputStream istream = this.assetManager.open(filename);
            return BitmapFactory.decodeStream((InputStream)istream);
        }
        catch (IOException e1) {
            return null;
        }
    }

    @Override
    public boolean isFormatSupported(String mimeType) {
        return supportedFormats.contains(mimeType);
    }
}

