/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.util.Log;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.xml.sax.SAXException;

public class CSSParser {
    private static final String TAG = "AndroidSVG CSSParser";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private MediaType rendererMediaType = null;
    private boolean inMediaRule = false;

    public CSSParser(MediaType rendererMediaType) {
        this.rendererMediaType = rendererMediaType;
    }

    public Ruleset parse(String sheet) throws SAXException {
        CSSTextScanner scan = new CSSTextScanner(sheet);
        scan.skipWhitespace();
        return this.parseRuleset(scan);
    }

    public static boolean mediaMatches(String mediaListStr, MediaType rendererMediaType) throws SAXException {
        CSSTextScanner scan = new CSSTextScanner(mediaListStr);
        scan.skipWhitespace();
        List<MediaType> mediaList = CSSParser.parseMediaList(scan);
        if (!scan.empty()) {
            throw new SAXException("Invalid @media type list");
        }
        return CSSParser.mediaMatches(mediaList, rendererMediaType);
    }

    private static void warn(String format, Object ... args) {
        Log.w((String)TAG, (String)String.format(format, args));
    }

    private static boolean mediaMatches(List<MediaType> mediaList, MediaType rendererMediaType) {
        for (MediaType type : mediaList) {
            if (type != MediaType.all && type != rendererMediaType) continue;
            return true;
        }
        return false;
    }

    private static List<MediaType> parseMediaList(CSSTextScanner scan) throws SAXException {
        ArrayList<MediaType> typeList = new ArrayList<MediaType>();
        while (!scan.empty()) {
            String type = scan.nextToken(',');
            try {
                typeList.add(MediaType.valueOf(type));
            }
            catch (IllegalArgumentException e) {
                throw new SAXException("Invalid @media type list");
            }
            if (scan.skipCommaWhitespace()) continue;
            break;
        }
        return typeList;
    }

    private void parseAtRule(Ruleset ruleset, CSSTextScanner scan) throws SAXException {
        String atKeyword = scan.nextIdentifier();
        scan.skipWhitespace();
        if (atKeyword == null) {
            throw new SAXException("Invalid '@' rule in <style> element");
        }
        if (!this.inMediaRule && atKeyword.equals("media")) {
            List<MediaType> mediaList = CSSParser.parseMediaList(scan);
            if (!scan.consume('{')) {
                throw new SAXException("Invalid @media rule: missing rule set");
            }
            scan.skipWhitespace();
            if (CSSParser.mediaMatches(mediaList, this.rendererMediaType)) {
                this.inMediaRule = true;
                ruleset.addAll(this.parseRuleset(scan));
                this.inMediaRule = false;
            } else {
                this.parseRuleset(scan);
            }
            if (!scan.consume('}')) {
                throw new SAXException("Invalid @media rule: expected '}' at end of rule set");
            }
        } else {
            CSSParser.warn("Ignoring @%s rule", atKeyword);
            this.skipAtRule(scan);
        }
        scan.skipWhitespace();
    }

    private void skipAtRule(CSSTextScanner scan) {
        int depth = 0;
        while (!scan.empty()) {
            int ch = scan.nextChar();
            if (ch == 59 && depth == 0) {
                return;
            }
            if (ch == 123) {
                ++depth;
                continue;
            }
            if (ch != 125 || depth <= 0 || --depth != 0) continue;
            return;
        }
    }

    private Ruleset parseRuleset(CSSTextScanner scan) throws SAXException {
        Ruleset ruleset = new Ruleset();
        while (!scan.empty()) {
            if (scan.consume("<!--") || scan.consume("-->")) continue;
            if (scan.consume('@')) {
                this.parseAtRule(ruleset, scan);
                continue;
            }
            if (this.parseRule(ruleset, scan)) continue;
        }
        return ruleset;
    }

    private boolean parseRule(Ruleset ruleset, CSSTextScanner scan) throws SAXException {
        List<Selector> selectors = this.parseSelectorGroup(scan);
        if (selectors != null && !selectors.isEmpty()) {
            if (!scan.consume('{')) {
                throw new SAXException("Malformed rule block in <style> element: missing '{'");
            }
            scan.skipWhitespace();
            SVG.Style ruleStyle = this.parseDeclarations(scan);
            scan.skipWhitespace();
            for (Selector selector : selectors) {
                ruleset.add(new Rule(selector, ruleStyle));
            }
            return true;
        }
        return false;
    }

    private List<Selector> parseSelectorGroup(CSSTextScanner scan) throws SAXException {
        if (scan.empty()) {
            return null;
        }
        ArrayList<Selector> selectorGroup = new ArrayList<Selector>(1);
        Selector selector = new Selector();
        while (!scan.empty() && scan.nextSimpleSelector(selector)) {
            if (!scan.skipCommaWhitespace()) continue;
            selectorGroup.add(selector);
            selector = new Selector();
        }
        if (!selector.isEmpty()) {
            selectorGroup.add(selector);
        }
        return selectorGroup;
    }

    private SVG.Style parseDeclarations(CSSTextScanner scan) throws SAXException {
        SVG.Style ruleStyle = new SVG.Style();
        do {
            String propertyName = scan.nextIdentifier();
            scan.skipWhitespace();
            if (!scan.consume(':')) break;
            scan.skipWhitespace();
            String propertyValue = scan.nextPropertyValue();
            if (propertyValue == null) break;
            scan.skipWhitespace();
            if (scan.consume('!')) {
                scan.skipWhitespace();
                if (!scan.consume("important")) {
                    throw new SAXException("Malformed rule set in <style> element: found unexpected '!'");
                }
                scan.skipWhitespace();
            }
            scan.consume(';');
            SVGParser.processStyleProperty(ruleStyle, propertyName, propertyValue);
            scan.skipWhitespace();
            if (!scan.consume('}')) continue;
            return ruleStyle;
        } while (!scan.empty());
        throw new SAXException("Malformed rule set in <style> element");
    }

    protected static List<String> parseClassAttribute(String val) throws SAXException {
        CSSTextScanner scan = new CSSTextScanner(val);
        ArrayList<String> classNameList = null;
        while (!scan.empty()) {
            String className = scan.nextIdentifier();
            if (className == null) {
                throw new SAXException("Invalid value for \"class\" attribute: " + val);
            }
            if (classNameList == null) {
                classNameList = new ArrayList<String>();
            }
            classNameList.add(className);
            scan.skipWhitespace();
        }
        return classNameList;
    }

    protected static boolean ruleMatch(Selector selector, SVG.SvgElementBase obj) {
        ArrayList<SVG.SvgContainer> ancestors = new ArrayList<SVG.SvgContainer>();
        SVG.SvgContainer parent = obj.parent;
        while (parent != null) {
            ancestors.add(0, parent);
            parent = ((SVG.SvgObject)((Object)parent)).parent;
        }
        int ancestorsPos = ancestors.size() - 1;
        if (selector.size() == 1) {
            return CSSParser.selectorMatch(selector.get(0), ancestors, ancestorsPos, obj);
        }
        return CSSParser.ruleMatch(selector, selector.size() - 1, ancestors, ancestorsPos, obj);
    }

    private static boolean ruleMatch(Selector selector, int selPartPos, List<SVG.SvgContainer> ancestors, int ancestorsPos, SVG.SvgElementBase obj) {
        SimpleSelector sel = selector.get(selPartPos);
        if (!CSSParser.selectorMatch(sel, ancestors, ancestorsPos, obj)) {
            return false;
        }
        if (sel.combinator == Combinator.DESCENDANT) {
            if (selPartPos == 0) {
                return true;
            }
            while (ancestorsPos >= 0) {
                if (CSSParser.ruleMatchOnAncestors(selector, selPartPos - 1, ancestors, ancestorsPos)) {
                    return true;
                }
                --ancestorsPos;
            }
            return false;
        }
        if (sel.combinator == Combinator.CHILD) {
            return CSSParser.ruleMatchOnAncestors(selector, selPartPos - 1, ancestors, ancestorsPos);
        }
        int childPos = CSSParser.getChildPosition(ancestors, ancestorsPos, obj);
        if (childPos <= 0) {
            return false;
        }
        SVG.SvgElementBase prevSibling = (SVG.SvgElementBase)obj.parent.getChildren().get(childPos - 1);
        return CSSParser.ruleMatch(selector, selPartPos - 1, ancestors, ancestorsPos, prevSibling);
    }

    private static boolean ruleMatchOnAncestors(Selector selector, int selPartPos, List<SVG.SvgContainer> ancestors, int ancestorsPos) {
        SVG.SvgElementBase obj;
        SimpleSelector sel = selector.get(selPartPos);
        if (!CSSParser.selectorMatch(sel, ancestors, ancestorsPos, obj = (SVG.SvgElementBase)((Object)ancestors.get(ancestorsPos)))) {
            return false;
        }
        if (sel.combinator == Combinator.DESCENDANT) {
            if (selPartPos == 0) {
                return true;
            }
            while (ancestorsPos > 0) {
                if (!CSSParser.ruleMatchOnAncestors(selector, selPartPos - 1, ancestors, --ancestorsPos)) continue;
                return true;
            }
            return false;
        }
        if (sel.combinator == Combinator.CHILD) {
            return CSSParser.ruleMatchOnAncestors(selector, selPartPos - 1, ancestors, ancestorsPos - 1);
        }
        int childPos = CSSParser.getChildPosition(ancestors, ancestorsPos, obj);
        if (childPos <= 0) {
            return false;
        }
        SVG.SvgElementBase prevSibling = (SVG.SvgElementBase)obj.parent.getChildren().get(childPos - 1);
        return CSSParser.ruleMatch(selector, selPartPos - 1, ancestors, ancestorsPos, prevSibling);
    }

    private static int getChildPosition(List<SVG.SvgContainer> ancestors, int ancestorsPos, SVG.SvgElementBase obj) {
        if (ancestorsPos < 0) {
            return -1;
        }
        if (ancestors.get(ancestorsPos) != obj.parent) {
            return -1;
        }
        int childPos = 0;
        for (SVG.SvgObject child : obj.parent.getChildren()) {
            if (child == obj) {
                return childPos;
            }
            ++childPos;
        }
        return -1;
    }

    private static boolean selectorMatch(SimpleSelector sel, List<SVG.SvgContainer> ancestors, int ancestorsPos, SVG.SvgElementBase obj) {
        if (sel.tag != null && (sel.tag.equalsIgnoreCase("G") ? !(obj instanceof SVG.Group) : !sel.tag.equals(obj.getClass().getSimpleName().toLowerCase(Locale.US)))) {
            return false;
        }
        if (sel.attribs != null) {
            for (Attrib attr : sel.attribs) {
                if (attr.name == ID) {
                    if (attr.value.equals(obj.id)) continue;
                    return false;
                }
                if (attr.name == CLASS) {
                    if (obj.classNames == null) {
                        return false;
                    }
                    if (obj.classNames.contains(attr.value)) continue;
                    return false;
                }
                return false;
            }
        }
        if (sel.pseudos != null) {
            for (String pseudo : sel.pseudos) {
                if (pseudo.equals("first-child")) {
                    if (CSSParser.getChildPosition(ancestors, ancestorsPos, obj) == 0) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    private static class CSSTextScanner
    extends SVGParser.TextScanner {
        public CSSTextScanner(String input) {
            super(input.replaceAll("(?s)/\\*.*?\\*/", ""));
        }

        public String nextIdentifier() {
            int end = this.scanForIdentifier();
            if (end == this.position) {
                return null;
            }
            String result = this.input.substring(this.position, end);
            this.position = end;
            return result;
        }

        private int scanForIdentifier() {
            if (this.empty()) {
                return this.position;
            }
            int start = this.position;
            int lastValidPos = this.position;
            int ch = this.input.charAt(this.position);
            if (ch == 45) {
                ch = this.advanceChar();
            }
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 95) {
                ch = this.advanceChar();
                while (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 45 || ch == 95) {
                    ch = this.advanceChar();
                }
                lastValidPos = this.position;
            }
            this.position = start;
            return lastValidPos;
        }

        public boolean nextSimpleSelector(Selector selector) throws SAXException {
            if (this.empty()) {
                return false;
            }
            int start = this.position;
            Combinator combinator = null;
            SimpleSelector selectorPart = null;
            if (!selector.isEmpty()) {
                if (this.consume('>')) {
                    combinator = Combinator.CHILD;
                    this.skipWhitespace();
                } else if (this.consume('+')) {
                    combinator = Combinator.FOLLOWS;
                    this.skipWhitespace();
                }
            }
            if (this.consume('*')) {
                selectorPart = new SimpleSelector(combinator, null);
            } else {
                String tag = this.nextIdentifier();
                if (tag != null) {
                    selectorPart = new SimpleSelector(combinator, tag);
                    selector.addedElement();
                }
            }
            while (!this.empty()) {
                String value;
                if (this.consume('.')) {
                    if (selectorPart == null) {
                        selectorPart = new SimpleSelector(combinator, null);
                    }
                    if ((value = this.nextIdentifier()) == null) {
                        throw new SAXException("Invalid \".class\" selector in <style> element");
                    }
                    selectorPart.addAttrib(CSSParser.CLASS, AttribOp.EQUALS, value);
                    selector.addedAttributeOrPseudo();
                    continue;
                }
                if (this.consume('#')) {
                    if (selectorPart == null) {
                        selectorPart = new SimpleSelector(combinator, null);
                    }
                    if ((value = this.nextIdentifier()) == null) {
                        throw new SAXException("Invalid \"#id\" selector in <style> element");
                    }
                    selectorPart.addAttrib(CSSParser.ID, AttribOp.EQUALS, value);
                    selector.addedIdAttribute();
                }
                if (selectorPart == null) break;
                if (this.consume('[')) {
                    this.skipWhitespace();
                    String attrName = this.nextIdentifier();
                    String attrValue = null;
                    if (attrName == null) {
                        throw new SAXException("Invalid attribute selector in <style> element");
                    }
                    this.skipWhitespace();
                    AttribOp op = null;
                    if (this.consume('=')) {
                        op = AttribOp.EQUALS;
                    } else if (this.consume("~=")) {
                        op = AttribOp.INCLUDES;
                    } else if (this.consume("|=")) {
                        op = AttribOp.DASHMATCH;
                    }
                    if (op != null) {
                        this.skipWhitespace();
                        attrValue = this.nextAttribValue();
                        if (attrValue == null) {
                            throw new SAXException("Invalid attribute selector in <style> element");
                        }
                        this.skipWhitespace();
                    }
                    if (!this.consume(']')) {
                        throw new SAXException("Invalid attribute selector in <style> element");
                    }
                    selectorPart.addAttrib(attrName, op == null ? AttribOp.EXISTS : op, attrValue);
                    selector.addedAttributeOrPseudo();
                    continue;
                }
                if (!this.consume(':')) break;
                int pseudoStart = this.position;
                if (this.nextIdentifier() == null) break;
                if (this.consume('(')) {
                    this.skipWhitespace();
                    if (this.nextIdentifier() != null) {
                        this.skipWhitespace();
                        if (!this.consume(')')) {
                            this.position = pseudoStart - 1;
                            break;
                        }
                    }
                }
                selectorPart.addPseudo(this.input.substring(pseudoStart, this.position));
                selector.addedAttributeOrPseudo();
                break;
            }
            if (selectorPart != null) {
                selector.add(selectorPart);
                return true;
            }
            this.position = start;
            return false;
        }

        private String nextAttribValue() {
            if (this.empty()) {
                return null;
            }
            String result = this.nextQuotedString();
            if (result != null) {
                return result;
            }
            return this.nextIdentifier();
        }

        public String nextPropertyValue() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            int lastValidPos = this.position;
            int ch = this.input.charAt(this.position);
            while (ch != -1 && ch != 59 && ch != 125 && ch != 33 && !this.isEOL(ch)) {
                if (!this.isWhitespace(ch)) {
                    lastValidPos = this.position + 1;
                }
                ch = this.advanceChar();
            }
            if (this.position > start) {
                return this.input.substring(start, lastValidPos);
            }
            this.position = start;
            return null;
        }
    }

    public static class Selector {
        public List<SimpleSelector> selector = null;
        public int specificity = 0;

        public void add(SimpleSelector part) {
            if (this.selector == null) {
                this.selector = new ArrayList<SimpleSelector>();
            }
            this.selector.add(part);
        }

        public int size() {
            return this.selector == null ? 0 : this.selector.size();
        }

        public SimpleSelector get(int i) {
            return this.selector.get(i);
        }

        public boolean isEmpty() {
            return this.selector == null ? true : this.selector.isEmpty();
        }

        public void addedIdAttribute() {
            this.specificity += 10000;
        }

        public void addedAttributeOrPseudo() {
            this.specificity += 100;
        }

        public void addedElement() {
            ++this.specificity;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (SimpleSelector sel : this.selector) {
                sb.append(sel).append(' ');
            }
            return sb.append('(').append(this.specificity).append(')').toString();
        }
    }

    public static class Rule {
        public Selector selector = null;
        public SVG.Style style = null;

        public Rule(Selector selector, SVG.Style style) {
            this.selector = selector;
            this.style = style;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            return sb.append(this.selector).append(" {}").toString();
        }
    }

    public static class Ruleset {
        private List<Rule> rules = null;

        public void add(Rule rule) {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
            }
            for (int i = 0; i < this.rules.size(); ++i) {
                Rule nextRule = this.rules.get(i);
                if (nextRule.selector.specificity <= rule.selector.specificity) continue;
                this.rules.add(i, rule);
                return;
            }
            this.rules.add(rule);
        }

        public void addAll(Ruleset rules) {
            if (rules.rules == null) {
                return;
            }
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>(rules.rules.size());
            }
            for (Rule rule : rules.rules) {
                this.rules.add(rule);
            }
        }

        public List<Rule> getRules() {
            return this.rules;
        }

        public boolean isEmpty() {
            return this.rules == null || this.rules.isEmpty();
        }

        public String toString() {
            if (this.rules == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (Rule rule : this.rules) {
                sb.append(rule.toString()).append('\n');
            }
            return sb.toString();
        }
    }

    private static class SimpleSelector {
        public Combinator combinator = null;
        public String tag = null;
        public List<Attrib> attribs = null;
        public List<String> pseudos = null;

        public SimpleSelector(Combinator combinator, String tag) {
            this.combinator = combinator != null ? combinator : Combinator.DESCENDANT;
            this.tag = tag;
        }

        public void addAttrib(String attrName, AttribOp op, String attrValue) {
            if (this.attribs == null) {
                this.attribs = new ArrayList<Attrib>();
            }
            this.attribs.add(new Attrib(attrName, op, attrValue));
        }

        public void addPseudo(String pseudo) {
            if (this.pseudos == null) {
                this.pseudos = new ArrayList<String>();
            }
            this.pseudos.add(pseudo);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.combinator == Combinator.CHILD) {
                sb.append("> ");
            } else if (this.combinator == Combinator.FOLLOWS) {
                sb.append("+ ");
            }
            sb.append(this.tag == null ? "*" : this.tag);
            if (this.attribs != null) {
                for (Attrib attr : this.attribs) {
                    sb.append('[').append(attr.name);
                    switch (attr.operation) {
                        case EQUALS: {
                            sb.append('=').append(attr.value);
                            break;
                        }
                        case INCLUDES: {
                            sb.append("~=").append(attr.value);
                            break;
                        }
                        case DASHMATCH: {
                            sb.append("|=").append(attr.value);
                            break;
                        }
                    }
                    sb.append(']');
                }
            }
            if (this.pseudos != null) {
                for (String pseu : this.pseudos) {
                    sb.append(':').append(pseu);
                }
            }
            return sb.toString();
        }
    }

    public static class Attrib {
        public String name = null;
        public AttribOp operation;
        public String value = null;

        public Attrib(String name, AttribOp op, String value) {
            this.name = name;
            this.operation = op;
            this.value = value;
        }
    }

    private static enum AttribOp {
        EXISTS,
        EQUALS,
        INCLUDES,
        DASHMATCH;

    }

    private static enum Combinator {
        DESCENDANT,
        CHILD,
        FOLLOWS;

    }

    public static enum MediaType {
        all,
        aural,
        braille,
        embossed,
        handheld,
        print,
        projection,
        screen,
        tty,
        tv;

    }
}

