/*
 * Decompiled with CFR 0.152.
 */
package de.graphml.writer.yed.graphics;

import de.graphml.writer.model.ElementWriter;
import de.graphml.writer.yed.YedConstants;
import de.graphml.writer.yed.graphics.LeafRenderable;
import java.util.ArrayList;
import java.util.List;

public class Path
implements LeafRenderable,
YedConstants {
    public Double sx = 0.0;
    public Double sy = 0.0;
    public Double tx = 0.0;
    public Double ty = 0.0;
    private List<Point> points;

    @Override
    public void writeTo(ElementWriter w) {
        w.startElement("http://www.yworks.com/xml/graphml", "Path");
        w.writeAttribute("sx", this.sx);
        w.writeAttribute("sy", this.sy);
        w.writeAttribute("tx", this.tx);
        w.writeAttribute("ty", this.ty);
        if (this.points != null) {
            for (Point point : this.points) {
                w.startElement("http://www.yworks.com/xml/graphml", "Point");
                w.writeAttribute("x", point.x);
                w.writeAttribute("y", point.y);
                w.endElement();
            }
        }
        w.endElement();
    }

    public void addPoint(double x, double y) {
        if (this.points == null) {
            this.points = new ArrayList<Point>();
        }
        this.points.add(new Point(x, y));
    }

    public void clearPoints() {
        if (this.points != null) {
            this.points.clear();
        }
    }

    public static class Point {
        public double x;
        public double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

