/*
 * Decompiled with CFR 0.152.
 */
package de.graphml.writer.yed.graphics;

import de.graphml.writer.model.ElementWriter;
import de.graphml.writer.yed.YedConstants;
import de.graphml.writer.yed.graphics.AbstractNodeGraphicsBase;
import de.graphml.writer.yed.graphics.NodeGraphics;
import de.graphml.writer.yed.graphics.NodeLabel;

public class GenericNode
extends AbstractNodeGraphicsBase
implements NodeGraphics,
YedConstants {
    public Configuration configuration;

    public GenericNode() {
        this.geometry.width = 80.0;
        this.geometry.height = 40.0;
    }

    public GenericNode(Configuration configuration) {
        this();
        this.configuration = configuration;
    }

    public GenericNode withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public void writeTo(ElementWriter w) {
        w.startElement("http://www.yworks.com/xml/graphml", "GenericNode");
        w.writeAttribute("configuration", this.configuration.value);
        this.writeGraphics(w);
        w.endElement();
    }

    public static GenericNode as(Configuration configuration, String text) {
        GenericNode node = new GenericNode(configuration);
        node.addLabel(new NodeLabel(text));
        return node;
    }

    public GenericNode withConfigurationAndLabelText(Configuration configuration, String text) {
        this.withConfiguration(configuration);
        this.withLabelText(text);
        return this;
    }

    public static enum Configuration {
        FLOWCHART_DIRECT_DATA("com.yworks.flowchart.directData"),
        FLOWCHART_PROCESS("com.yworks.flowchart.process"),
        FLOWCHART_DATABASE("com.yworks.flowchart.dataBase"),
        FLOWCHART_DECISION("com.yworks.flowchart.decision"),
        FLOWCHART_DOCUMENT("com.yworks.flowchart.document"),
        FLOWCHART_START1("com.yworks.flowchart.start1"),
        FLOWCHART_START2("com.yworks.flowchart.start2"),
        FLOWCHART_DATA("com.yworks.flowchart.data"),
        FLOWCHART_PREDEFINED_PROCESS("com.yworks.flowchart.predefinedProcess"),
        FLOWCHART_STORED_DATA("com.yworks.flowchart.storedData"),
        FLOWCHART_INTERNAL_STORAGE("com.yworks.flowchart.internalStorage"),
        FLOWCHART_SEQUENTIAL_DATA("com.yworks.flowchart.sequentialData"),
        FLOWCHART_MANUAL_INPUT("com.yworks.flowchart.manualInput"),
        FLOWCHART_CARD("com.yworks.flowchart.card"),
        FLOWCHART_PAPER_TYPE("com.yworks.flowchart.paperType"),
        FLOWCHART_CLOUD("com.yworks.flowchart.cloud"),
        FLOWCHART_DELAY("com.yworks.flowchart.delay"),
        FLOWCHART_DISPLAY("com.yworks.flowchart.display"),
        FLOWCHART_MANUAL_OPERATION("com.yworks.flowchart.manualOperation"),
        FLOWCHART_PREPARATION("com.yworks.flowchart.preparation"),
        FLOWCHART_LOOP_LIMIT("com.yworks.flowchart.loopLimit"),
        FLOWCHART_LOOP_LIMIT_END("com.yworks.flowchart.loopLimitEnd"),
        FLOWCHART_TERMINATOR("com.yworks.flowchart.terminator"),
        FLOWCHART_ON_PAGE_REFERENCE("com.yworks.flowchart.onPageReference"),
        FLOWCHART_OFF_PAGE_REFERENCE("com.yworks.flowchart.offPageReference"),
        FLOWCHART_ANNOTATION("com.yworks.flowchart.annotation"),
        FLOWCHART_USER_MESSAGE("com.yworks.flowchart.userMessage"),
        FLOWCHART_NETWORK_MESSAGE("com.yworks.flowchart.networkMessage");

        public final String value;

        private Configuration(String value) {
            this.value = value;
        }
    }
}

