/*
 * Decompiled with CFR 0.152.
 */
package de.graphml.writer.yed.graphics;

import de.graphml.writer.model.ElementWriter;
import de.graphml.writer.yed.YedConstants;
import de.graphml.writer.yed.graphics.AbstractBaseLabel;
import de.graphml.writer.yed.graphics.LabelModel;
import de.graphml.writer.yed.graphics.LeafRenderable;
import de.graphml.writer.yed.style.ModelName;
import de.graphml.writer.yed.style.ModelPosition;

public class EdgeLabel
extends AbstractBaseLabel
implements LeafRenderable,
YedConstants {
    private LabelModel labelModel;

    public EdgeLabel() {
    }

    public EdgeLabel(String text) {
        this.text = text;
    }

    public void setLabelModel(LabelModel labelModel) {
        this.labelModel = labelModel;
        this.modelName = ModelName.CUSTOM;
    }

    @Override
    public void writeTo(ElementWriter w) {
        if (this.text == null) {
            return;
        }
        w.startElement("http://www.yworks.com/xml/graphml", "EdgeLabel");
        this.writerAttributes(w);
        w.writeAttribute("preferredPlacement", "anywhere");
        w.writeAttribute("configuration", "AutoFlippingLabel");
        w.writeAttribute("ratio", "0.5");
        w.writeAttribute("distance", "2.0");
        w.writeText(this.text);
        if (this.labelModel != null) {
            w.startElement("http://www.yworks.com/xml/graphml", "LabelModel");
            this.labelModel.writeTo(w);
            w.endElement();
        }
        w.startElement("http://www.yworks.com/xml/graphml", "ModelParameter");
        if (this.labelModel != null) {
            this.labelModel.writeParameter(w);
        }
        w.endElement();
        w.endElement();
    }

    public static EdgeLabel centered(String text) {
        return EdgeLabel.withModelAndPosition(text, ModelName.CENTERED, ModelPosition.CENTER);
    }

    public static EdgeLabel sourceCenter(String text) {
        return EdgeLabel.withModelAndPosition(text, ModelName.THREE_CENTER, ModelPosition.THREE_SOURCE_CENTER);
    }

    public static EdgeLabel sourceHead(String text) {
        return EdgeLabel.withModelAndPosition(text, ModelName.SIX_POS, ModelPosition.SIX_POS_SOURCE_HEAD);
    }

    public static EdgeLabel targetCenter(String text) {
        return EdgeLabel.withModelAndPosition(text, ModelName.THREE_CENTER, ModelPosition.THREE_TARGET_CENTER);
    }

    public static EdgeLabel targetHead(String text) {
        return EdgeLabel.withModelAndPosition(text, ModelName.SIX_POS, ModelPosition.SIX_POS_TARGET_HEAD);
    }

    public static EdgeLabel withModelAndPosition(String text, ModelName modelName, ModelPosition modelPosition) {
        EdgeLabel label = new EdgeLabel(text);
        label.modelName = modelName;
        label.modelPosition = modelPosition;
        return label;
    }
}

