/*
 * Decompiled with CFR 0.152.
 */
package de.graphml.writer;

import de.graphml.writer.model.DefaultKeys;
import de.graphml.writer.model.Edge;
import de.graphml.writer.model.ElementWriter;
import de.graphml.writer.model.Graph;
import de.graphml.writer.model.Key;
import de.graphml.writer.model.Node;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GraphWriter {
    protected XMLStreamWriter xtw;
    protected int openElements = 0;
    protected int idSequence;
    protected final ElementWriter elementWriter = new InternalWriter();

    public GraphWriter(OutputStream fileOutputStream, String name) {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        try {
            this.xtw = xof.createXMLStreamWriter(fileOutputStream, name);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNextId() {
        int id = this.idSequence++;
        return String.valueOf(id);
    }

    public void node(Node node, String id) {
        node.writeStart(this.elementWriter, id);
        node.writeEnd(this.elementWriter);
    }

    public void startNode(Node node, String id) {
        node.writeStart(this.elementWriter, id);
    }

    public void endNode(Node node) {
        node.writeEnd(this.elementWriter);
    }

    public void edge(Edge edge, String id, String source, String target) {
        edge.writeStart(this.elementWriter, id, source, target);
        edge.writeEnd(this.elementWriter);
    }

    public void startDocument() {
        try {
            this.xtw.writeStartDocument("utf-8", "1.0");
            this.xtw.setPrefix("html", "http://www.w3.org/TR/REC-html40");
            this.elementWriter.startElement("graphml");
            this.xtw.writeNamespace("xmlns", "http://graphml.graphdrawing.org/xmlns");
            this.xtw.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.xtw.writeNamespace("y", "http://www.yworks.com/xml/graphml");
            this.xtw.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://graphml.graphdrawing.org/xmlns");
            for (DefaultKeys key : DefaultKeys.values()) {
                key.writeTo(this.elementWriter);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeKeys(Collection<Key> keys) {
        for (Key key : keys) {
            key.writeTo(this.elementWriter);
        }
    }

    public String startGraph(Graph graph) {
        String nextId = this.getNextId();
        this.startGraph(graph, nextId);
        return nextId;
    }

    public void startGraph(Graph graph, String id) {
        graph.writeStart(this.elementWriter, id);
    }

    public void endGraph(Graph graph) {
        graph.writeEnd(this.elementWriter);
    }

    public void endDocument() {
        while (this.openElements > 0) {
            this.elementWriter.endElement();
        }
        try {
            this.xtw.writeEndDocument();
            this.xtw.flush();
            this.xtw.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private class InternalWriter
    implements ElementWriter {
        private InternalWriter() {
        }

        @Override
        public void endElement() {
            if (GraphWriter.this.openElements == 0) {
                throw new IllegalStateException("no open element found");
            }
            try {
                --GraphWriter.this.openElements;
                GraphWriter.this.xtw.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeText(String description) {
            try {
                GraphWriter.this.xtw.writeCharacters(description);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void startData(Key key) {
            this.startElement("data");
            this.writeAttribute("key", key.getId());
        }

        @Override
        public void startElement(String localName) {
            ++GraphWriter.this.openElements;
            try {
                GraphWriter.this.xtw.writeStartElement(localName);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName) {
            ++GraphWriter.this.openElements;
            try {
                GraphWriter.this.xtw.writeStartElement(namespaceURI, localName);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeAttribute(String localName, String value) {
            if (value == null) {
                return;
            }
            try {
                GraphWriter.this.xtw.writeAttribute(localName, value);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeAttribute(String localName, Boolean value) {
            if (value == null) {
                return;
            }
            try {
                GraphWriter.this.xtw.writeAttribute(localName, String.valueOf(value));
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeAttribute(String localName, Double value) {
            if (value == null) {
                return;
            }
            try {
                GraphWriter.this.xtw.writeAttribute(localName, String.valueOf(value));
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeAttribute(String localName, Integer value) {
            if (value == null) {
                return;
            }
            try {
                GraphWriter.this.xtw.writeAttribute(localName, String.valueOf(value));
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

