/*
 * Decompiled with CFR 0.152.
 */
package de.grammarcraft.xtend.flow.annotations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.grammarcraft.xtend.flow.FunctionUnitWithOnlyOneInputPort;
import de.grammarcraft.xtend.flow.FunctionUnitWithOnlyOneOutputPort;
import de.grammarcraft.xtend.flow.IFunctionUnit;
import de.grammarcraft.xtend.flow.InputPort;
import de.grammarcraft.xtend.flow.OutputPort;
import de.grammarcraft.xtend.flow.annotations.FlowAnnotationSignature;
import de.grammarcraft.xtend.flow.data.None;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FunctionUnitProcessor
extends AbstractClassProcessor {
    private static final String defaultInputPortName = "start";

    public void doRegisterGlobals(final ClassDeclaration annotatedClass, final RegisterGlobalsContext context) {
        FlowAnnotationSignature flowAnnotation = new FlowAnnotationSignature(annotatedClass);
        boolean _and = false;
        Iterable<? extends AnnotationReference> _inputPortAnnotations = flowAnnotation.getInputPortAnnotations();
        Iterable<? extends AnnotationReference> _doubledAnnotations = FunctionUnitProcessor.doubledAnnotations(_inputPortAnnotations);
        boolean _isEmpty = IterableExtensions.isEmpty(_doubledAnnotations);
        if (!_isEmpty) {
            _and = false;
        } else {
            boolean _isOperationUnit;
            boolean _or = false;
            boolean _isFunctionUnit = flowAnnotation.isFunctionUnit();
            _or = _isFunctionUnit ? true : (_isOperationUnit = flowAnnotation.isOperationUnit());
            _and = _or;
        }
        if (_and) {
            Iterable<? extends AnnotationReference> _inputPortAnnotations_1 = flowAnnotation.getInputPortAnnotations();
            boolean _isEmpty_1 = IterableExtensions.isEmpty(_inputPortAnnotations_1);
            if (_isEmpty_1) {
                String _defaultInputPortInterfaceName = FunctionUnitProcessor.defaultInputPortInterfaceName(annotatedClass);
                context.registerInterface(_defaultInputPortInterfaceName);
            } else {
                Iterable<? extends AnnotationReference> _inputPortAnnotations_2 = flowAnnotation.getInputPortAnnotations();
                Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

                    public void apply(AnnotationReference inputPortAnnotation) {
                        String _portName = FunctionUnitProcessor.portName(inputPortAnnotation);
                        String _inputPortInterfaceName = FunctionUnitProcessor.getInputPortInterfaceName(annotatedClass, _portName);
                        context.registerInterface(_inputPortInterfaceName);
                    }
                };
                IterableExtensions.forEach(_inputPortAnnotations_2, (Procedures.Procedure1)_function);
            }
        }
    }

    private static String defaultInputPortInterfaceName(ClassDeclaration annotatedClass) {
        return FunctionUnitProcessor.getInputPortInterfaceName(annotatedClass, defaultInputPortName);
    }

    private static String getInputPortInterfaceName(ClassDeclaration annotatedClass, String portName) {
        StringConcatenation _builder = new StringConcatenation();
        String _qualifiedName = annotatedClass.getQualifiedName();
        _builder.append((Object)_qualifiedName, "");
        _builder.append((Object)"_InputPort_");
        _builder.append((Object)portName, "");
        return _builder.toString();
    }

    private static String portName(AnnotationReference annotationReference) {
        Object _value = annotationReference.getValue("name");
        return ((String)_value).trim();
    }

    private static TypeReference portType(AnnotationReference annotationReference) {
        Object _value = annotationReference.getValue("type");
        return (TypeReference)_value;
    }

    private static TypeReference[] portTypeParameters(AnnotationReference annotationReference) {
        Object _value = annotationReference.getValue("typeArguments");
        return (TypeReference[])_value;
    }

    private static Iterable<? extends AnnotationReference> doubledAnnotations(final Iterable<? extends AnnotationReference> portAnnotations) {
        Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                return FunctionUnitProcessor.doubledAnnotation(it, portAnnotations);
            }
        };
        return IterableExtensions.filter(portAnnotations, (Functions.Function1)_function);
    }

    private static boolean doubledAnnotation(final AnnotationReference portAnnotation, Iterable<? extends AnnotationReference> portAnnotations) {
        Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                String _portName = FunctionUnitProcessor.portName(it);
                String _portName_1 = FunctionUnitProcessor.portName(portAnnotation);
                return Objects.equal((Object)_portName, (Object)_portName_1);
            }
        };
        Iterable _filter = IterableExtensions.filter(portAnnotations, (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)_filter);
        return _size > 1;
    }

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        boolean _not;
        FlowAnnotationSignature flowAnnotation = new FlowAnnotationSignature((ClassDeclaration)annotatedClass);
        boolean hasContextErrors = false;
        boolean _checkForContextErrors = this.checkForContextErrors(context, annotatedClass, flowAnnotation);
        hasContextErrors = _checkForContextErrors;
        if (hasContextErrors) {
            context.addWarning((Element)annotatedClass, "due to port annotation errors, no code can be generated");
            return;
        }
        this.checkForContextWarnings(context, annotatedClass, flowAnnotation);
        annotatedClass.setFinal(true);
        StringConcatenation _builder = new StringConcatenation();
        String _docComment = annotatedClass.getDocComment();
        _builder.append((Object)_docComment, "");
        _builder.newLineIfNotEmpty();
        String _xifexpression = null;
        boolean _or = false;
        String _docComment_1 = annotatedClass.getDocComment();
        boolean _equals = Objects.equal((Object)_docComment_1, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _isEmpty;
            String _docComment_2 = annotatedClass.getDocComment();
            _or = _isEmpty = _docComment_2.isEmpty();
        }
        boolean bl = _not = !_or;
        if (_not) {
            _xifexpression = "<br><br>";
        }
        _builder.append((Object)_xifexpression, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Implements a function unit as defined by Flow Design paradigm.<br>");
        _builder.newLine();
        Iterable<? extends AnnotationReference> _inputPortAnnotations = flowAnnotation.getInputPortAnnotations();
        boolean _isEmpty_1 = IterableExtensions.isEmpty(_inputPortAnnotations);
        if (_isEmpty_1) {
            _builder.append((Object)"It may be started triggering the implicit input port \"");
            _builder.append((Object)defaultInputPortName, "");
            _builder.append((Object)"\" sending 'None' to it ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"(the port is implicit as no one specified explicitely).");
            _builder.newLine();
        } else {
            _builder.append((Object)"It consumes input messages over the input ports<br>");
            _builder.newLine();
            Iterable<? extends AnnotationReference> _inputPortAnnotations_1 = flowAnnotation.getInputPortAnnotations();
            Functions.Function1<AnnotationReference, String> _function = new Functions.Function1<AnnotationReference, String>(){

                public String apply(AnnotationReference it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"\"");
                    String _portName = FunctionUnitProcessor.portName(it);
                    _builder.append((Object)_portName, "");
                    _builder.append((Object)"\" of type \"");
                    TypeReference _portType = FunctionUnitProcessor.portType(it);
                    _builder.append((Object)_portType, "");
                    _builder.append((Object)"\"");
                    return _builder.toString();
                }
            };
            Iterable _map = IterableExtensions.map(_inputPortAnnotations_1, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"<br>- \n");
            _builder.append((Object)_join, "");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"<br>");
        _builder.newLine();
        Iterable<? extends AnnotationReference> _outputPortAnnotations = flowAnnotation.getOutputPortAnnotations();
        boolean _isEmpty_2 = IterableExtensions.isEmpty(_outputPortAnnotations);
        if (_isEmpty_2) {
            _builder.append((Object)"And has no output ports (as no one has been specified).");
            _builder.newLine();
        } else {
            _builder.append((Object)"And issues computation results over the output ports.<br>");
            _builder.newLine();
            Iterable<? extends AnnotationReference> _outputPortAnnotations_1 = flowAnnotation.getOutputPortAnnotations();
            Functions.Function1<AnnotationReference, String> _function_1 = new Functions.Function1<AnnotationReference, String>(){

                public String apply(AnnotationReference it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"\"");
                    String _portName = FunctionUnitProcessor.portName(it);
                    _builder.append((Object)_portName, "");
                    _builder.append((Object)"\" of type \"");
                    TypeReference _portType = FunctionUnitProcessor.portType(it);
                    _builder.append((Object)_portType, "");
                    _builder.append((Object)"\"");
                    return _builder.toString();
                }
            };
            Iterable _map_1 = IterableExtensions.map(_outputPortAnnotations_1, (Functions.Function1)_function_1);
            String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"<br>\n- ");
            _builder.append((Object)_join_1, "");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"<br>");
        _builder.newLine();
        annotatedClass.setDocComment(_builder.toString());
        FunctionUnitProcessor.addClassCommentToConstructors(annotatedClass, context);
        this.addInterfaces(annotatedClass, flowAnnotation, context);
        FunctionUnitProcessor.addNamingStuff(annotatedClass, context);
        this.addIntegrationErrorPort(annotatedClass, context);
        this.addInputPorts(annotatedClass, flowAnnotation, context);
        this.addOutputPorts(annotatedClass, flowAnnotation, context);
        this.addFlowOperators(annotatedClass, flowAnnotation, context);
    }

    private static void addClassCommentToConstructors(final MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Iterable _declaredConstructors = annotatedClass.getDeclaredConstructors();
        Procedures.Procedure1<MutableConstructorDeclaration> _function = new Procedures.Procedure1<MutableConstructorDeclaration>(){

            public void apply(MutableConstructorDeclaration it) {
                boolean _not;
                StringConcatenation _builder = new StringConcatenation();
                String _docComment = it.getDocComment();
                _builder.append((Object)_docComment, "");
                _builder.newLineIfNotEmpty();
                String _xifexpression = null;
                boolean _or = false;
                String _docComment_1 = it.getDocComment();
                boolean _equals = Objects.equal((Object)_docComment_1, null);
                if (_equals) {
                    _or = true;
                } else {
                    boolean _isEmpty;
                    String _docComment_2 = it.getDocComment();
                    _or = _isEmpty = _docComment_2.isEmpty();
                }
                boolean bl = _not = !_or;
                if (_not) {
                    _xifexpression = "<br><br>";
                }
                _builder.append((Object)_xifexpression, "");
                _builder.newLineIfNotEmpty();
                String _docComment_3 = annotatedClass.getDocComment();
                _builder.append((Object)_docComment_3, "");
                _builder.newLineIfNotEmpty();
                it.setDocComment(_builder.toString());
            }
        };
        IterableExtensions.forEach((Iterable)_declaredConstructors, (Procedures.Procedure1)_function);
    }

    private void addInterfaces(MutableClassDeclaration annotatedClass, FlowAnnotationSignature flowAnnotation, @Extension TransformationContext context) {
        boolean _equals_1;
        ArrayList<TypeReference> interfacesToBeAdded = new ArrayList<TypeReference>();
        TypeReference _newTypeReference = context.newTypeReference(IFunctionUnit.class, new TypeReference[0]);
        interfacesToBeAdded.add(_newTypeReference);
        Iterable<? extends AnnotationReference> _inputPortAnnotations = flowAnnotation.getInputPortAnnotations();
        boolean _isEmpty = IterableExtensions.isEmpty(_inputPortAnnotations);
        if (_isEmpty) {
            TypeReference _newTypeReference_1 = context.newTypeReference(None.class, new TypeReference[0]);
            TypeReference _newTypeReference_2 = context.newTypeReference(FunctionUnitWithOnlyOneInputPort.class, new TypeReference[]{_newTypeReference_1});
            interfacesToBeAdded.add(_newTypeReference_2);
        } else {
            boolean _equals;
            Iterable<? extends AnnotationReference> _inputPortAnnotations_1 = flowAnnotation.getInputPortAnnotations();
            int _size = IterableExtensions.size(_inputPortAnnotations_1);
            boolean bl = _equals = _size == 1;
            if (_equals) {
                Iterable<? extends AnnotationReference> _inputPortAnnotations_2 = flowAnnotation.getInputPortAnnotations();
                AnnotationReference inputPortAnnotation = (AnnotationReference)IterableExtensions.head(_inputPortAnnotations_2);
                TypeReference _portType = FunctionUnitProcessor.portType(inputPortAnnotation);
                Type _type = _portType.getType();
                TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(inputPortAnnotation);
                TypeReference _newTypeReference_3 = context.newTypeReference(_type, _portTypeParameters);
                TypeReference _newTypeReference_4 = context.newTypeReference(FunctionUnitWithOnlyOneInputPort.class, new TypeReference[]{_newTypeReference_3});
                interfacesToBeAdded.add(_newTypeReference_4);
            }
        }
        Iterable<? extends AnnotationReference> _outputPortAnnotations = flowAnnotation.getOutputPortAnnotations();
        int _size_1 = IterableExtensions.size(_outputPortAnnotations);
        boolean bl = _equals_1 = _size_1 == 1;
        if (_equals_1) {
            Iterable<? extends AnnotationReference> _outputPortAnnotations_1 = flowAnnotation.getOutputPortAnnotations();
            AnnotationReference outputPortAnnotation = (AnnotationReference)IterableExtensions.head(_outputPortAnnotations_1);
            TypeReference _portType_1 = FunctionUnitProcessor.portType(outputPortAnnotation);
            Type _type_1 = _portType_1.getType();
            TypeReference[] _portTypeParameters_1 = FunctionUnitProcessor.portTypeParameters(outputPortAnnotation);
            TypeReference _newTypeReference_5 = context.newTypeReference(_type_1, _portTypeParameters_1);
            TypeReference _newTypeReference_6 = context.newTypeReference(FunctionUnitWithOnlyOneOutputPort.class, new TypeReference[]{_newTypeReference_5});
            interfacesToBeAdded.add(_newTypeReference_6);
        }
        annotatedClass.setImplementedInterfaces(interfacesToBeAdded);
    }

    private void checkForContextWarnings(final @Extension TransformationContext context, MutableClassDeclaration annotatedClass, FlowAnnotationSignature flowAnnotation) {
        Functions.Function1<MutableMethodDeclaration, Boolean> _function;
        Iterable _declaredMethods;
        Iterable _filter;
        int _size;
        boolean _greaterThan;
        boolean _isIntegrationUnit;
        Iterable<? extends AnnotationReference> _outputPortAnnotations = flowAnnotation.getOutputPortAnnotations();
        boolean _isEmpty = IterableExtensions.isEmpty(_outputPortAnnotations);
        if (_isEmpty) {
            context.addWarning((Element)annotatedClass, "no output port defined");
        }
        boolean _and = false;
        boolean _or = false;
        boolean _isFunctionBoard = flowAnnotation.isFunctionBoard();
        _or = _isFunctionBoard ? true : (_isIntegrationUnit = flowAnnotation.isIntegrationUnit());
        _and = !_or ? false : (_greaterThan = (_size = IterableExtensions.size((Iterable)(_filter = IterableExtensions.filter((Iterable)(_declaredMethods = annotatedClass.getDeclaredMethods()), (Functions.Function1)(_function = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

            public Boolean apply(MutableMethodDeclaration it) {
                Visibility _visibility = it.getVisibility();
                return !Objects.equal((Object)_visibility, (Object)Visibility.PRIVATE);
            }
        }))))) > 0);
        if (_and) {
            Iterable _declaredMethods_1 = annotatedClass.getDeclaredMethods();
            Functions.Function1<MutableMethodDeclaration, Boolean> _function_1 = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

                public Boolean apply(MutableMethodDeclaration it) {
                    Visibility _visibility = it.getVisibility();
                    return !Objects.equal((Object)_visibility, (Object)Visibility.PRIVATE);
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_declaredMethods_1, (Functions.Function1)_function_1);
            Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    context.addWarning((Element)it, "a FunctionBoard must not have other than private methods");
                }
            };
            IterableExtensions.forEach((Iterable)_filter_1, (Procedures.Procedure1)_function_2);
        }
    }

    private boolean checkForContextErrors(final @Extension TransformationContext context, final MutableClassDeclaration annotatedClass, FlowAnnotationSignature flowAnnotation) {
        boolean _isFlowUnit;
        Iterable<? extends AnnotationReference> _outputPortAnnotations;
        Iterable<? extends AnnotationReference> doubledOutputAnnotations;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean contextError = false;
        Object _inputPortAnnotationArgument = flowAnnotation.getInputPortAnnotationArgument();
        Class<?> _class = null;
        if (_inputPortAnnotationArgument != null) {
            _class = _inputPortAnnotationArgument.getClass();
        }
        boolean bl = _notEquals = !Objects.equal(_class, AnnotationReference[].class);
        if (_notEquals) {
            context.addError((Element)annotatedClass, "array of input port annotations expected");
            contextError = true;
        }
        Object _outputPortAnnotationArgument = flowAnnotation.getOutputPortAnnotationArgument();
        Class<?> _class_1 = null;
        if (_outputPortAnnotationArgument != null) {
            _class_1 = _outputPortAnnotationArgument.getClass();
        }
        boolean bl2 = _notEquals_1 = !Objects.equal(_class_1, AnnotationReference[].class);
        if (_notEquals_1) {
            context.addError((Element)annotatedClass, "array of output port annotations expected");
            contextError = true;
        }
        if (contextError) {
            return true;
        }
        Iterable<? extends AnnotationReference> _inputPortAnnotations = flowAnnotation.getInputPortAnnotations();
        Iterable<? extends AnnotationReference> doubledInputAnnotations = FunctionUnitProcessor.doubledAnnotations(_inputPortAnnotations);
        boolean _isEmpty = IterableExtensions.isEmpty(doubledInputAnnotations);
        boolean bl3 = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

                public void apply(AnnotationReference it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"input port \"");
                    String _portName = FunctionUnitProcessor.portName(it);
                    _builder.append((Object)_portName, "");
                    _builder.append((Object)"\" is declared twice");
                    context.addError((Element)annotatedClass, _builder.toString());
                }
            };
            IterableExtensions.forEach(doubledInputAnnotations, (Procedures.Procedure1)_function);
            contextError = true;
        }
        boolean bl4 = _not_1 = !(_isEmpty_1 = IterableExtensions.isEmpty(doubledOutputAnnotations = FunctionUnitProcessor.doubledAnnotations(_outputPortAnnotations = flowAnnotation.getOutputPortAnnotations())));
        if (_not_1) {
            Procedures.Procedure1<AnnotationReference> _function_1 = new Procedures.Procedure1<AnnotationReference>(){

                public void apply(AnnotationReference it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"output port \"");
                    String _portName = FunctionUnitProcessor.portName(it);
                    _builder.append((Object)_portName, "");
                    _builder.append((Object)"\" is declared twice");
                    context.addError((Element)annotatedClass, _builder.toString());
                }
            };
            IterableExtensions.forEach(doubledOutputAnnotations, (Procedures.Procedure1)_function_1);
            contextError = true;
        }
        boolean _and = false;
        AnnotationReference _unitModifier = flowAnnotation.getUnitModifier();
        boolean _equals = Objects.equal((Object)_unitModifier, null);
        _and = !_equals ? false : (_isFlowUnit = flowAnnotation.isFlowUnit());
        if (_and) {
            context.addError((Element)annotatedClass, "modifier @Operation or @Integration required");
        }
        return contextError;
    }

    private static void addNamingStuff(final MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

            public void apply(MutableFieldDeclaration it) {
                it.setVisibility(Visibility.PRIVATE);
                TypeReference _newTypeReference = context.newTypeReference(String.class, new TypeReference[0]);
                it.setType(_newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"\"");
                        String _simpleName = annotatedClass.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)"\"");
                        return _builder;
                    }
                };
                it.setInitializer(_function);
            }
        };
        annotatedClass.addField("_name", (Procedures.Procedure1)_function);
        Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                it.setVisibility(Visibility.PUBLIC);
                TypeReference _newTypeReference = context.newTypeReference(String.class, new TypeReference[0]);
                it.setReturnType(_newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"return this._name;");
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("toString", (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                it.setVisibility(Visibility.PUBLIC);
                TypeReference _newTypeReference = context.newTypeReference(String.class, new TypeReference[0]);
                it.addParameter("newValue", _newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"this._name = newValue;");
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("setName", (Procedures.Procedure1)_function_2);
    }

    private MutableMethodDeclaration addIntegrationErrorPort(MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        MutableMethodDeclaration _xblockexpression = null;
        String integrationErrorPortName = "integrationError";
        Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

            public void apply(MutableFieldDeclaration it) {
                it.setFinal(true);
                it.setVisibility(Visibility.PRIVATE);
                TypeReference _newTypeReference = context.newTypeReference(Exception.class, new TypeReference[0]);
                TypeReference _newTypeReference_1 = context.newTypeReference(OutputPort.class, new TypeReference[]{_newTypeReference});
                it.setType(_newTypeReference_1);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"new ");
                        String _name = OutputPort.class.getName();
                        _builder.append((Object)_name, "");
                        _builder.append((Object)"<");
                        String _name_1 = Exception.class.getName();
                        _builder.append((Object)_name_1, "");
                        _builder.append((Object)">(\"integrationError\", ");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<");
                        String _name_2 = Exception.class.getName();
                        _builder.append((Object)_name_2, "    ");
                        _builder.append((Object)">() {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"@Override");
                        _builder.newLine();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"public void apply(final ");
                        String _name_3 = Exception.class.getName();
                        _builder.append((Object)_name_3, "      ");
                        _builder.append((Object)" ex) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"        ");
                        _builder.append((Object)"String _message = ex.getMessage();");
                        _builder.newLine();
                        _builder.append((Object)"        ");
                        _builder.append((Object)"String _plus = (\"FATAL ERROR: \" + _message);");
                        _builder.newLine();
                        _builder.append((Object)"        ");
                        String _name_4 = InputOutput.class.getName();
                        _builder.append((Object)_name_4, "        ");
                        _builder.append((Object)".<String>println(_plus);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)")");
                        _builder.newLine();
                        return _builder;
                    }
                };
                it.setInitializer(_function);
            }
        };
        annotatedClass.addField("integrationError", (Procedures.Procedure1)_function);
        Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                TypeReference _newTypeReference = context.newTypeReference(Exception.class, new TypeReference[0]);
                TypeReference _newTypeReference_1 = context.newTypeReference(OutputPort.class, new TypeReference[]{_newTypeReference});
                it.setReturnType(_newTypeReference_1);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"return this.");
                        _builder.append((Object)"integrationError", "");
                        _builder.append((Object)";");
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("integrationError", (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                String parameterName = "integrationException";
                TypeReference _newTypeReference = context.newTypeReference(Exception.class, new TypeReference[0]);
                it.addParameter("integrationException", _newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"this.");
                        _builder.append((Object)"integrationError", "");
                        _builder.append((Object)".operator_lessEqualsThan(");
                        _builder.append((Object)"integrationException", "");
                        _builder.append((Object)");");
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        _xblockexpression = annotatedClass.addMethod("forwardIntegrationError", (Procedures.Procedure1)_function_2);
        return _xblockexpression;
    }

    private MutableMethodDeclaration addInputPorts(final MutableClassDeclaration annotatedClass, final FlowAnnotationSignature flowAnnotation, final @Extension TransformationContext context) {
        MutableMethodDeclaration _xifexpression = null;
        Iterable<? extends AnnotationReference> _inputPortAnnotations = flowAnnotation.getInputPortAnnotations();
        boolean _isEmpty = IterableExtensions.isEmpty(_inputPortAnnotations);
        if (_isEmpty) {
            boolean _isOperationUnit;
            MutableMethodDeclaration _xblockexpression = null;
            String portName = defaultInputPortName;
            String inputPortInterfaceName = FunctionUnitProcessor.defaultInputPortInterfaceName((ClassDeclaration)annotatedClass);
            TypeReference msgType = context.newTypeReference(None.class, new TypeReference[0]);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"process$");
            _builder.append((Object)defaultInputPortName, "");
            String processInputMethodName = _builder.toString();
            boolean _or = false;
            boolean _isFunctionUnit = flowAnnotation.isFunctionUnit();
            _or = _isFunctionUnit ? true : (_isOperationUnit = flowAnnotation.isOperationUnit());
            boolean isOperationUnit = _or;
            _xifexpression = _xblockexpression = this.addInputPort(annotatedClass, defaultInputPortName, msgType, processInputMethodName, inputPortInterfaceName, isOperationUnit, context);
        } else {
            Iterable<? extends AnnotationReference> _inputPortAnnotations_1 = flowAnnotation.getInputPortAnnotations();
            Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

                public void apply(AnnotationReference inputPortAnnotation) {
                    boolean _isOperationUnit;
                    String portName = FunctionUnitProcessor.portName(inputPortAnnotation);
                    String inputPortInterfaceName = FunctionUnitProcessor.getInputPortInterfaceName((ClassDeclaration)annotatedClass, portName);
                    TypeReference _portType = FunctionUnitProcessor.portType(inputPortAnnotation);
                    Type _type = _portType.getType();
                    TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(inputPortAnnotation);
                    TypeReference msgType = context.newTypeReference(_type, _portTypeParameters);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"process$");
                    _builder.append((Object)portName, "");
                    String processInputMethodName = _builder.toString();
                    boolean _or = false;
                    boolean _isFunctionUnit = flowAnnotation.isFunctionUnit();
                    _or = _isFunctionUnit ? true : (_isOperationUnit = flowAnnotation.isOperationUnit());
                    boolean isOperationUnit = _or;
                    FunctionUnitProcessor.this.addInputPort(annotatedClass, portName, msgType, processInputMethodName, inputPortInterfaceName, isOperationUnit, context);
                }
            };
            IterableExtensions.forEach(_inputPortAnnotations_1, (Procedures.Procedure1)_function);
        }
        return _xifexpression;
    }

    private MutableMethodDeclaration addInputPort(final MutableClassDeclaration annotatedClass, final String portName, final TypeReference msgType, final String processInputMethodName, String inputPortInterfaceName, final boolean isOperationUnit, final @Extension TransformationContext context) {
        MutableMethodDeclaration _xblockexpression = null;
        Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

            public void apply(MutableFieldDeclaration it) {
                it.setFinal(true);
                it.setVisibility(Visibility.PRIVATE);
                TypeReference _newTypeReference = context.newTypeReference(InputPort.class, new TypeReference[]{msgType});
                it.setType(_newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"new org.eclipse.xtext.xbase.lib.Functions.Function0<de.grammarcraft.xtend.flow.InputPort<");
                        _builder.append((Object)msgType, "");
                        _builder.append((Object)">>() {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"public de.grammarcraft.xtend.flow.InputPort<");
                        _builder.append((Object)msgType, "    ");
                        _builder.append((Object)"> apply() {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"org.eclipse.xtend2.lib.StringConcatenation _builder = new org.eclipse.xtend2.lib.StringConcatenation();");
                        _builder.newLine();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"_builder.append(");
                        String _simpleName = annotatedClass.getSimpleName();
                        _builder.append((Object)_simpleName, "      ");
                        _builder.append((Object)".this, \"\");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"_builder.append(\".");
                        _builder.append((Object)portName, "      ");
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"final org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception> _function_1 = new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception>() {");
                        _builder.newLine();
                        _builder.append((Object)"        ");
                        _builder.append((Object)"public void apply(final Exception it) {");
                        _builder.newLine();
                        _builder.append((Object)"          ");
                        String _simpleName_1 = annotatedClass.getSimpleName();
                        _builder.append((Object)_simpleName_1, "          ");
                        _builder.append((Object)".this.forwardIntegrationError(it);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"        ");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"};");
                        _builder.newLine();
                        if (isOperationUnit) {
                            _builder.append((Object)"      ");
                            _builder.append((Object)"final org.eclipse.xtext.xbase.lib.Procedures.Procedure1<");
                            _builder.append((Object)msgType, "      ");
                            _builder.append((Object)"> _function = new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<");
                            _builder.append((Object)msgType, "      ");
                            _builder.append((Object)">() {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"      ");
                            _builder.append((Object)"  ");
                            _builder.append((Object)"public void apply(final ");
                            _builder.append((Object)msgType, "        ");
                            _builder.append((Object)" msg) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"      ");
                            _builder.append((Object)"    ");
                            String _simpleName_2 = annotatedClass.getSimpleName();
                            _builder.append((Object)_simpleName_2, "          ");
                            _builder.append((Object)".this.");
                            _builder.append((Object)processInputMethodName, "          ");
                            _builder.append((Object)"(msg);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"      ");
                            _builder.append((Object)"  ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"      ");
                            _builder.append((Object)"};");
                            _builder.newLine();
                            _builder.append((Object)"      ");
                            _builder.append((Object)"de.grammarcraft.xtend.flow.InputPort<");
                            _builder.append((Object)msgType, "      ");
                            _builder.append((Object)"> _inputPort = new de.grammarcraft.xtend.flow.InputPort<");
                            _builder.append((Object)msgType, "      ");
                            _builder.append((Object)">(_builder.toString(), _function, _function_1);");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"      ");
                            _builder.append((Object)"de.grammarcraft.xtend.flow.InputPort<");
                            _builder.append((Object)msgType, "      ");
                            _builder.append((Object)"> _inputPort = new de.grammarcraft.xtend.flow.InputPort<");
                            _builder.append((Object)msgType, "      ");
                            _builder.append((Object)">(_builder.toString(), _function_1);");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)"      ");
                        _builder.append((Object)"return _inputPort;");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"}.apply();");
                        _builder.newLine();
                        return _builder;
                    }
                };
                it.setInitializer(_function);
            }
        };
        annotatedClass.addField(portName, (Procedures.Procedure1)_function);
        Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                TypeReference _newTypeReference = context.newTypeReference(InputPort.class, new TypeReference[]{msgType});
                it.setReturnType(_newTypeReference);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Input port '");
                _builder.append((Object)portName, "");
                _builder.append((Object)"' of function unit '");
                String _simpleName = annotatedClass.getSimpleName();
                _builder.append((Object)_simpleName, "");
                _builder.append((Object)"', receives messages of ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"type '");
                _builder.append((Object)msgType, "");
                _builder.append((Object)"' for further processing by this function unit.");
                _builder.newLineIfNotEmpty();
                it.setDocComment(_builder.toString());
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"return this.");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod(portName, (Procedures.Procedure1)_function_1);
        MutableMethodDeclaration _xifexpression = null;
        if (isOperationUnit) {
            MutableMethodDeclaration _xblockexpression_1 = null;
            MutableInterfaceDeclaration interfaceType = context.findInterface(inputPortInterfaceName);
            Iterable _implementedInterfaces = annotatedClass.getImplementedInterfaces();
            TypeReference _newTypeReference = context.newTypeReference((Type)interfaceType, new TypeReference[0]);
            Iterable _plus = Iterables.concat((Iterable)_implementedInterfaces, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_newTypeReference})));
            annotatedClass.setImplementedInterfaces(_plus);
            Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Implement this method to process input arriving via input port \"");
                    _builder.append((Object)portName, "");
                    _builder.append((Object)"\".");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"Message coming in has type \"");
                    _builder.append((Object)msgType, "");
                    _builder.append((Object)"\".");
                    _builder.newLineIfNotEmpty();
                    it.setDocComment(_builder.toString());
                    it.addParameter("msg", msgType);
                }
            };
            _xifexpression = _xblockexpression_1 = interfaceType.addMethod(processInputMethodName, (Procedures.Procedure1)_function_2);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private void addOutputPorts(final MutableClassDeclaration annotatedClass, FlowAnnotationSignature flowAnnotation, final @Extension TransformationContext context) {
        Iterable<? extends AnnotationReference> _outputPortAnnotations = flowAnnotation.getOutputPortAnnotations();
        Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

            public void apply(AnnotationReference outputPortAnnotation) {
                final String portName = FunctionUnitProcessor.portName(outputPortAnnotation);
                TypeReference _portType = FunctionUnitProcessor.portType(outputPortAnnotation);
                Type _type = _portType.getType();
                TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(outputPortAnnotation);
                final TypeReference msgType = context.newTypeReference(_type, _portTypeParameters);
                Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

                    public void apply(MutableFieldDeclaration it) {
                        it.setFinal(true);
                        it.setVisibility(Visibility.PRIVATE);
                        TypeReference _newTypeReference = context.newTypeReference(OutputPort.class, new TypeReference[]{msgType});
                        it.setType(_newTypeReference);
                        CompilationStrategy _function = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"new org.eclipse.xtext.xbase.lib.Functions.Function0<de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "");
                                _builder.append((Object)">>() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"public de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "    ");
                                _builder.append((Object)"> apply() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"org.eclipse.xtend2.lib.StringConcatenation _builder = new org.eclipse.xtend2.lib.StringConcatenation();");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"_builder.append(");
                                String _simpleName = annotatedClass.getSimpleName();
                                _builder.append((Object)_simpleName, "        ");
                                _builder.append((Object)".this, \"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"_builder.append(\".");
                                _builder.append((Object)portName, "        ");
                                _builder.append((Object)"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"final org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception> _function = new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception>() {");
                                _builder.newLine();
                                _builder.append((Object)"          ");
                                _builder.append((Object)"public void apply(final Exception it) {");
                                _builder.newLine();
                                _builder.append((Object)"            ");
                                String _simpleName_1 = annotatedClass.getSimpleName();
                                _builder.append((Object)_simpleName_1, "            ");
                                _builder.append((Object)".this.forwardIntegrationError(it);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"          ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"};");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "        ");
                                _builder.append((Object)"> _outputPort = new de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "        ");
                                _builder.append((Object)">(_builder.toString(), _function);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"return _outputPort;");
                                _builder.newLine();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"}.apply();");
                                _builder.newLine();
                                return _builder;
                            }
                        };
                        it.setInitializer(_function);
                    }
                };
                annotatedClass.addField(portName, (Procedures.Procedure1)_function);
                Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                    public void apply(MutableMethodDeclaration it) {
                        it.setFinal(true);
                        TypeReference _newTypeReference = context.newTypeReference(OutputPort.class, new TypeReference[]{msgType});
                        it.setReturnType(_newTypeReference);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"Output port '");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)"' of function unit '");
                        String _simpleName = annotatedClass.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)"', issues messages of ");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"type '");
                        _builder.append((Object)msgType, "");
                        _builder.append((Object)"' as computation result of this function unit.");
                        _builder.newLineIfNotEmpty();
                        it.setDocComment(_builder.toString());
                        CompilationStrategy _function = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"return this.");
                                _builder.append((Object)portName, "");
                                _builder.append((Object)";");
                                _builder.newLineIfNotEmpty();
                                return _builder;
                            }
                        };
                        it.setBody(_function);
                    }
                };
                annotatedClass.addMethod(portName, (Procedures.Procedure1)_function_1);
            }
        };
        IterableExtensions.forEach(_outputPortAnnotations, (Procedures.Procedure1)_function);
    }

    private MutableMethodDeclaration addFlowOperators(MutableClassDeclaration annotatedClass, FlowAnnotationSignature flowAnnotation, @Extension TransformationContext context) {
        boolean _equals_1;
        MutableMethodDeclaration _xblockexpression = null;
        Iterable<? extends AnnotationReference> _inputPortAnnotations = flowAnnotation.getInputPortAnnotations();
        boolean _isEmpty = IterableExtensions.isEmpty(_inputPortAnnotations);
        if (_isEmpty) {
            String portName = defaultInputPortName;
            TypeReference msgType = context.newTypeReference(None.class, new TypeReference[0]);
            this.addInputPortFlowOperators(annotatedClass, defaultInputPortName, msgType, context);
        } else {
            boolean _equals;
            Iterable<? extends AnnotationReference> _inputPortAnnotations_1 = flowAnnotation.getInputPortAnnotations();
            int _size = IterableExtensions.size(_inputPortAnnotations_1);
            boolean bl = _equals = _size == 1;
            if (_equals) {
                Iterable<? extends AnnotationReference> _inputPortAnnotations_2 = flowAnnotation.getInputPortAnnotations();
                AnnotationReference _head = (AnnotationReference)IterableExtensions.head(_inputPortAnnotations_2);
                String portName_1 = FunctionUnitProcessor.portName(_head);
                Iterable<? extends AnnotationReference> _inputPortAnnotations_3 = flowAnnotation.getInputPortAnnotations();
                AnnotationReference _head_1 = (AnnotationReference)IterableExtensions.head(_inputPortAnnotations_3);
                TypeReference _portType = FunctionUnitProcessor.portType(_head_1);
                Type _type = _portType.getType();
                Iterable<? extends AnnotationReference> _inputPortAnnotations_4 = flowAnnotation.getInputPortAnnotations();
                AnnotationReference _head_2 = (AnnotationReference)IterableExtensions.head(_inputPortAnnotations_4);
                TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(_head_2);
                TypeReference msgType_1 = context.newTypeReference(_type, _portTypeParameters);
                this.addInputPortFlowOperators(annotatedClass, portName_1, msgType_1, context);
            }
        }
        MutableMethodDeclaration _xifexpression = null;
        Iterable<? extends AnnotationReference> _outputPortAnnotations = flowAnnotation.getOutputPortAnnotations();
        int _size_1 = IterableExtensions.size(_outputPortAnnotations);
        boolean bl = _equals_1 = _size_1 == 1;
        if (_equals_1) {
            MutableMethodDeclaration _xblockexpression_1 = null;
            Iterable<? extends AnnotationReference> _outputPortAnnotations_1 = flowAnnotation.getOutputPortAnnotations();
            AnnotationReference _head_3 = (AnnotationReference)IterableExtensions.head(_outputPortAnnotations_1);
            String portName_2 = FunctionUnitProcessor.portName(_head_3);
            Iterable<? extends AnnotationReference> _outputPortAnnotations_2 = flowAnnotation.getOutputPortAnnotations();
            AnnotationReference _head_4 = (AnnotationReference)IterableExtensions.head(_outputPortAnnotations_2);
            TypeReference _portType_1 = FunctionUnitProcessor.portType(_head_4);
            Type _type_1 = _portType_1.getType();
            Iterable<? extends AnnotationReference> _outputPortAnnotations_3 = flowAnnotation.getOutputPortAnnotations();
            AnnotationReference _head_5 = (AnnotationReference)IterableExtensions.head(_outputPortAnnotations_3);
            TypeReference[] _portTypeParameters_1 = FunctionUnitProcessor.portTypeParameters(_head_5);
            TypeReference msgType_2 = context.newTypeReference(_type_1, _portTypeParameters_1);
            _xifexpression = _xblockexpression_1 = this.addOutputPortFlowOperators(annotatedClass, portName_2, msgType_2, context);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private MutableMethodDeclaration addInputPortFlowOperators(MutableClassDeclaration annotatedClass, final String portName, final TypeReference msgType, final @Extension TransformationContext context) {
        MutableMethodDeclaration _xblockexpression = null;
        Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                TypeReference _newTypeReference = context.newTypeReference(InputPort.class, new TypeReference[]{msgType});
                it.setReturnType(_newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"return this.");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("theOneAndOnlyInputPort", (Procedures.Procedure1)_function);
        Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Flow DSL operator \"&lt;=\" for forwarding a message of type '");
                String _name = msgType.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"' value to ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"the one and only input port '");
                _builder.append((Object)portName, "");
                _builder.append((Object)"' for being processed.<br>");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"example:<pre> ");
                _builder.newLine();
                _builder.append((Object)"  ");
                _builder.append((Object)"input <= \"some string\"");
                _builder.newLine();
                _builder.append((Object)"</pre>");
                _builder.newLine();
                it.setDocComment(_builder.toString());
                String parameterVarName = "msg";
                it.addParameter("msg", msgType);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"this.");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)".operator_lessEqualsThan(");
                        _builder.append((Object)"msg", "");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("operator_lessEqualsThan", (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Flow DSL operator \"&lt;=\" for forwarding a message value of type '");
                String _name = msgType.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"' to ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"the one and only input port '");
                _builder.append((Object)portName, "");
                _builder.append((Object)"' for being processed.<br>");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"For computing the message to be forwarded the right side closure is applied.");
                _builder.newLine();
                _builder.append((Object)"example:<pre> ");
                _builder.newLine();
                _builder.append((Object)"  ");
                _builder.append((Object)"input &lt;= [ if (state&gt;0) \"some string\" else \"some other string\"");
                _builder.newLine();
                _builder.append((Object)"</pre>");
                _builder.newLine();
                it.setDocComment(_builder.toString());
                String msgClosureVarName = "msgClosure";
                TypeReference _newWildcardTypeReference = context.newWildcardTypeReference(msgType);
                TypeReference _newTypeReference = context.newTypeReference(Functions.Function0.class, new TypeReference[]{_newWildcardTypeReference});
                it.addParameter("msgClosure", _newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)msgType, "");
                        _builder.append((Object)" _apply = ");
                        _builder.append((Object)"msgClosure", "");
                        _builder.append((Object)".apply();");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"this.");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)".operator_lessEqualsThan(_apply);");
                        _builder.newLineIfNotEmpty();
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        _xblockexpression = annotatedClass.addMethod("operator_lessEqualsThan", (Procedures.Procedure1)_function_2);
        return _xblockexpression;
    }

    private MutableMethodDeclaration addOutputPortFlowOperators(MutableClassDeclaration annotatedClass, final String portName, final TypeReference msgType, final @Extension TransformationContext context) {
        MutableMethodDeclaration _xblockexpression = null;
        Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Flow DSL operator \"-&gt;\" for letting all message issued by the one and only output port '");
                _builder.append((Object)portName, "");
                _builder.append((Object)"' being ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"processed by the right side closure.");
                _builder.newLine();
                _builder.append((Object)"Typically this is used to process the message for a side effect like printing on standard out. ");
                _builder.newLine();
                _builder.append((Object)"example:<pre>");
                _builder.newLine();
                _builder.append((Object)"  ");
                _builder.append((Object)"fu -&gt; [msg|println(\"message received: \" + msg\")]");
                _builder.newLine();
                _builder.append((Object)"</pre>");
                _builder.newLine();
                it.setDocComment(_builder.toString());
                String msgProessingClosureVarName = "msgProcessingClosure";
                TypeReference _newWildcardTypeReferenceWithLowerBound = context.newWildcardTypeReferenceWithLowerBound(msgType);
                TypeReference operationType = context.newTypeReference(Procedures.Procedure1.class, new TypeReference[]{_newWildcardTypeReferenceWithLowerBound});
                it.addParameter("msgProcessingClosure", operationType);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"this.");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)".operator_mappedTo(");
                        _builder.append((Object)"msgProcessingClosure", "");
                        _builder.append((Object)");");
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function);
        Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Flow DSL operator \"-&gt;\" for connecting two function units. ");
                _builder.newLine();
                _builder.append((Object)"Connects the left one function unit's one and only one output port '");
                _builder.append((Object)portName, "");
                _builder.append((Object)"' with ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"the right side funtion unit which has one and only one input port.<br>");
                _builder.newLine();
                _builder.append((Object)"example:<pre>");
                _builder.newLine();
                _builder.append((Object)"  ");
                _builder.append((Object)"fu -&gt; fu'");
                _builder.newLine();
                _builder.append((Object)"</pre>");
                _builder.newLine();
                it.setDocComment(_builder.toString());
                String rightSideFunctionUnitVarName = "rightSideFunctionUnit";
                TypeReference _newTypeReference = context.newTypeReference(FunctionUnitWithOnlyOneInputPort.class, new TypeReference[]{msgType});
                it.addParameter("rightSideFunctionUnit", _newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"de.grammarcraft.xtend.flow.InputPort<");
                        _builder.append((Object)msgType, "");
                        _builder.append((Object)"> _theOneAndOnlyInputPort = ");
                        _builder.append((Object)"rightSideFunctionUnit", "");
                        _builder.append((Object)".theOneAndOnlyInputPort();");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.eclipse.xtext.xbase.lib.Procedures.Procedure1<? super ");
                        _builder.append((Object)msgType, "");
                        _builder.append((Object)"> _inputProcessingOperation = _theOneAndOnlyInputPort.inputProcessingOperation();");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"this.");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)".operator_mappedTo(_inputProcessingOperation);");
                        _builder.newLineIfNotEmpty();
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Flow DSL operator \"-&gt;\" for connecting two function units. ");
                _builder.newLine();
                _builder.append((Object)"Connects the left one function unit's one and only one output port '");
                _builder.append((Object)portName, "");
                _builder.append((Object)"' with ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"the right side function unit's named input port.<br>");
                _builder.newLine();
                _builder.append((Object)"example:<pre>");
                _builder.newLine();
                _builder.append((Object)"  ");
                _builder.append((Object)"fu -&gt; fu'.input");
                _builder.newLine();
                _builder.append((Object)"</pre>");
                _builder.newLine();
                it.setDocComment(_builder.toString());
                String rightSideFunctionUnitInputPortVarName = "rightSideFunctionUnitInputPort";
                TypeReference _newTypeReference = context.newTypeReference(InputPort.class, new TypeReference[]{msgType});
                it.addParameter("rightSideFunctionUnitInputPort", _newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"this.");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)".operator_mappedTo(");
                        _builder.append((Object)"rightSideFunctionUnitInputPort", "");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function_2);
        Procedures.Procedure1<MutableMethodDeclaration> _function_3 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Flow DSL operator \"-&gt;\" for connecting two function units. ");
                _builder.newLine();
                _builder.append((Object)"Connects the left side function unit's one and only one output port '");
                _builder.append((Object)portName, "");
                _builder.append((Object)"' with ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"the right side function unit's named output port.<br>");
                _builder.newLine();
                _builder.append((Object)"This is normally only used in integrating function units for connecting an integrated function unit with");
                _builder.newLine();
                _builder.append((Object)"an output port of the integrating function unit.");
                _builder.newLine();
                _builder.append((Object)"example:<pre>");
                _builder.newLine();
                _builder.append((Object)"  ");
                _builder.append((Object)"fu -&gt; output");
                _builder.newLine();
                _builder.append((Object)"</pre>");
                _builder.newLine();
                it.setDocComment(_builder.toString());
                String rightSideFunctionUnitOutputPortVarName = "rightSideFunctionUnitOutputPort";
                TypeReference _newTypeReference = context.newTypeReference(OutputPort.class, new TypeReference[]{msgType});
                it.addParameter("rightSideFunctionUnitOutputPort", _newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"this.");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)".operator_mappedTo(");
                        _builder.append((Object)"rightSideFunctionUnitOutputPort", "");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        _xblockexpression = annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function_3);
        return _xblockexpression;
    }
}

