/*
 * Decompiled with CFR 0.152.
 */
package de.grammarcraft.xtend.flow.annotations;

import com.google.common.base.Objects;
import de.grammarcraft.xtend.flow.annotations.FunctionBoard;
import de.grammarcraft.xtend.flow.annotations.FunctionUnit;
import de.grammarcraft.xtend.flow.annotations.Integration;
import de.grammarcraft.xtend.flow.annotations.Operation;
import de.grammarcraft.xtend.flow.annotations.Unit;
import java.util.Collections;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class FlowAnnotationSignature {
    private final AnnotationReference unitAnnotation;
    private final AnnotationReference unitModifier;
    private final Iterable<? extends AnnotationReference> inputPortAnnotations;
    private final Iterable<? extends AnnotationReference> outputPortAnnotations;
    private final Object inputPortAnnotationArgument;
    private final Object outputPortAnnotationArgument;

    public FlowAnnotationSignature(ClassDeclaration annotatedClass) {
        boolean _equals_1;
        boolean _equals;
        Iterable _annotations = annotatedClass.getAnnotations();
        AnnotationReference _findFirst = null;
        if (_annotations != null) {
            Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                public Boolean apply(AnnotationReference it) {
                    boolean _isFlowUnitAnnotation;
                    boolean _isFunctionBoardAnnotation;
                    boolean _or = false;
                    boolean _or_1 = false;
                    boolean _isFunctionUnitAnnotation = FlowAnnotationSignature.isFunctionUnitAnnotation(it);
                    _or_1 = _isFunctionUnitAnnotation ? true : (_isFunctionBoardAnnotation = FlowAnnotationSignature.isFunctionBoardAnnotation(it));
                    _or = _or_1 ? true : (_isFlowUnitAnnotation = FlowAnnotationSignature.isFlowUnitAnnotation(it));
                    return _or;
                }
            };
            _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)_function);
        }
        this.unitAnnotation = _findFirst;
        Iterable _annotations_1 = annotatedClass.getAnnotations();
        AnnotationReference _findFirst_1 = null;
        if (_annotations_1 != null) {
            Functions.Function1<AnnotationReference, Boolean> _function_1 = new Functions.Function1<AnnotationReference, Boolean>(){

                public Boolean apply(AnnotationReference it) {
                    boolean _isIntegrationAnnotation;
                    boolean _or = false;
                    boolean _isOperationAnnotation = FlowAnnotationSignature.isOperationAnnotation(it);
                    _or = _isOperationAnnotation ? true : (_isIntegrationAnnotation = FlowAnnotationSignature.isIntegrationAnnotation(it));
                    return _or;
                }
            };
            _findFirst_1 = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations_1, (Functions.Function1)_function_1);
        }
        this.unitModifier = _findFirst_1;
        Object _value = null;
        if (this.unitAnnotation != null) {
            _value = this.unitAnnotation.getValue("inputPorts");
        }
        this.inputPortAnnotationArgument = _value;
        Class<?> _class = null;
        if (this.inputPortAnnotationArgument != null) {
            _class = this.inputPortAnnotationArgument.getClass();
        }
        this.inputPortAnnotations = (_equals = Objects.equal(_class, AnnotationReference[].class)) ? (Iterable)Conversions.doWrapArray((Object)((AnnotationReference[])this.inputPortAnnotationArgument)) : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AnnotationReference[0]));
        Object _value_1 = null;
        if (this.unitAnnotation != null) {
            _value_1 = this.unitAnnotation.getValue("outputPorts");
        }
        this.outputPortAnnotationArgument = _value_1;
        Class<?> _class_1 = null;
        if (this.outputPortAnnotationArgument != null) {
            _class_1 = this.outputPortAnnotationArgument.getClass();
        }
        this.outputPortAnnotations = (_equals_1 = Objects.equal(_class_1, AnnotationReference[].class)) ? (Iterable)Conversions.doWrapArray((Object)((AnnotationReference[])this.outputPortAnnotationArgument)) : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AnnotationReference[0]));
    }

    private static boolean isFunctionUnitAnnotation(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = FunctionUnit.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    private static boolean isFunctionBoardAnnotation(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = FunctionBoard.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    private static boolean isFlowUnitAnnotation(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = Unit.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    private static boolean isOperationAnnotation(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = Operation.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    private static boolean isIntegrationAnnotation(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = Integration.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    public boolean isFunctionUnit() {
        return FlowAnnotationSignature.isFunctionUnitAnnotation(this.unitAnnotation);
    }

    public boolean isFunctionBoard() {
        return FlowAnnotationSignature.isFunctionBoardAnnotation(this.unitAnnotation);
    }

    public boolean isFlowUnit() {
        return FlowAnnotationSignature.isFlowUnitAnnotation(this.unitAnnotation);
    }

    public boolean hasOperationModifier() {
        return FlowAnnotationSignature.isOperationAnnotation(this.unitModifier);
    }

    public boolean hasIntegrationModifier() {
        return FlowAnnotationSignature.isIntegrationAnnotation(this.unitModifier);
    }

    public boolean isIntegrationUnit() {
        boolean _hasIntegrationModifier;
        boolean _and = false;
        boolean _isFlowUnit = this.isFlowUnit();
        _and = !_isFlowUnit ? false : (_hasIntegrationModifier = this.hasIntegrationModifier());
        return _and;
    }

    public boolean isOperationUnit() {
        boolean _hasOperationModifier;
        boolean _and = false;
        boolean _isFlowUnit = this.isFlowUnit();
        _and = !_isFlowUnit ? false : (_hasOperationModifier = this.hasOperationModifier());
        return _and;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unitAnnotation == null ? 0 : this.unitAnnotation.hashCode());
        result = 31 * result + (this.unitModifier == null ? 0 : this.unitModifier.hashCode());
        result = 31 * result + (this.inputPortAnnotations == null ? 0 : this.inputPortAnnotations.hashCode());
        result = 31 * result + (this.outputPortAnnotations == null ? 0 : this.outputPortAnnotations.hashCode());
        result = 31 * result + (this.inputPortAnnotationArgument == null ? 0 : this.inputPortAnnotationArgument.hashCode());
        result = 31 * result + (this.outputPortAnnotationArgument == null ? 0 : this.outputPortAnnotationArgument.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowAnnotationSignature other = (FlowAnnotationSignature)obj;
        if (this.unitAnnotation == null ? other.unitAnnotation != null : !this.unitAnnotation.equals(other.unitAnnotation)) {
            return false;
        }
        if (this.unitModifier == null ? other.unitModifier != null : !this.unitModifier.equals(other.unitModifier)) {
            return false;
        }
        if (this.inputPortAnnotations == null ? other.inputPortAnnotations != null : !this.inputPortAnnotations.equals(other.inputPortAnnotations)) {
            return false;
        }
        if (this.outputPortAnnotations == null ? other.outputPortAnnotations != null : !this.outputPortAnnotations.equals(other.outputPortAnnotations)) {
            return false;
        }
        if (this.inputPortAnnotationArgument == null ? other.inputPortAnnotationArgument != null : !this.inputPortAnnotationArgument.equals(other.inputPortAnnotationArgument)) {
            return false;
        }
        return !(this.outputPortAnnotationArgument == null ? other.outputPortAnnotationArgument != null : !this.outputPortAnnotationArgument.equals(other.outputPortAnnotationArgument));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("unitAnnotation", (Object)this.unitAnnotation);
        b.add("unitModifier", (Object)this.unitModifier);
        b.add("inputPortAnnotations", this.inputPortAnnotations);
        b.add("outputPortAnnotations", this.outputPortAnnotations);
        b.add("inputPortAnnotationArgument", this.inputPortAnnotationArgument);
        b.add("outputPortAnnotationArgument", this.outputPortAnnotationArgument);
        return b.toString();
    }

    @Pure
    public AnnotationReference getUnitAnnotation() {
        return this.unitAnnotation;
    }

    @Pure
    public AnnotationReference getUnitModifier() {
        return this.unitModifier;
    }

    @Pure
    public Iterable<? extends AnnotationReference> getInputPortAnnotations() {
        return this.inputPortAnnotations;
    }

    @Pure
    public Iterable<? extends AnnotationReference> getOutputPortAnnotations() {
        return this.outputPortAnnotations;
    }

    @Pure
    public Object getInputPortAnnotationArgument() {
        return this.inputPortAnnotationArgument;
    }

    @Pure
    public Object getOutputPortAnnotationArgument() {
        return this.outputPortAnnotationArgument;
    }
}

