package de.grammarcraft.xtend.flow.unitlib;

import de.grammarcraft.xtend.flow.FunctionUnitWithOnlyOneInputPort;
import de.grammarcraft.xtend.flow.FunctionUnitWithOnlyOneOutputPort;
import de.grammarcraft.xtend.flow.IFunctionUnit;
import de.grammarcraft.xtend.flow.InputPort;
import de.grammarcraft.xtend.flow.OutputPort;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class MapIt<InputType extends Object, OutputType extends Object> implements IFunctionUnit, FunctionUnitWithOnlyOneInputPort<InputType>, FunctionUnitWithOnlyOneOutputPort<OutputType> {
  private final String name;
  
  private final InputPort<InputType> input = new Function0<InputPort<InputType>>() {
    public InputPort<InputType> apply() {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(MapIt.this, "");
      _builder.append(".input");
      final Procedure1<InputType> _function = new Procedure1<InputType>() {
        @Override
        public void apply(final InputType it) {
          MapIt.this.processInput(it);
        }
      };
      final Procedure1<Exception> _function_1 = new Procedure1<Exception>() {
        @Override
        public void apply(final Exception it) {
          MapIt.this.forwardIntegrationError(it);
        }
      };
      InputPort<InputType> _inputPort = new InputPort<InputType>(_builder.toString(), _function, _function_1);
      return _inputPort;
    }
  }.apply();
  
  private final OutputPort<OutputType> output = new Function0<OutputPort<OutputType>>() {
    public OutputPort<OutputType> apply() {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(MapIt.this, "");
      _builder.append(".output");
      final Procedure1<Exception> _function = new Procedure1<Exception>() {
        @Override
        public void apply(final Exception it) {
          MapIt.this.forwardIntegrationError(it);
        }
      };
      OutputPort<OutputType> _outputPort = new OutputPort<OutputType>(_builder.toString(), _function);
      return _outputPort;
    }
  }.apply();
  
  private final OutputPort<Exception> integrationError = new Function0<OutputPort<Exception>>() {
    public OutputPort<Exception> apply() {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(MapIt.this, "");
      _builder.append(".integrationError");
      final Procedure1<Exception> _function = new Procedure1<Exception>() {
        @Override
        public void apply(final Exception it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("FATAL ERROR: ");
          String _message = it.getMessage();
          _builder.append(_message, "");
          InputOutput.<String>println(_builder.toString());
        }
      };
      OutputPort<Exception> _outputPort = new OutputPort<Exception>(_builder.toString(), _function);
      return _outputPort;
    }
  }.apply();
  
  private final Function1<? super InputType, ? extends OutputType> operation;
  
  /**
   * Creates an operation unit in the sense of Flow Design which performs a mapping of input message
   * to an output message by applying the given operation which must be a function.
   * @param operation the function to be applied for mapping
   */
  public MapIt(final Function1<? super InputType, ? extends OutputType> operation) {
    this("MapIt", operation);
  }
  
  /**
   * Creates an operation unit in the sense of Flow Design which performs a mapping of input message
   * to an output message by applying the given operation which must be a function.
   * @param name the function unit name to be used for this instance
   * @param operation the function to be applied for mapping
   */
  public MapIt(final String unitName, final Function1<? super InputType, ? extends OutputType> operation) {
    this.name = this.name;
    this.operation = operation;
  }
  
  @Override
  public String toString() {
    return this.name;
  }
  
  public InputPort<InputType> in() {
    return this.input;
  }
  
  public OutputPort<OutputType> out() {
    return this.output;
  }
  
  @Override
  public InputPort<InputType> theOneAndOnlyInputPort() {
    return this.input;
  }
  
  @Override
  public OutputPort<Exception> integrationError() {
    return this.integrationError;
  }
  
  @Override
  public void forwardIntegrationError(final Exception ex) {
    this.integrationError.operator_lessEqualsThan(ex);
  }
  
  private void processInput(final InputType msg) {
    OutputType _apply = this.operation.apply(msg);
    this.output.operator_lessEqualsThan(_apply);
  }
  
  @Override
  public void operator_lessEqualsThan(final InputType msg) {
    OutputType _apply = this.operation.apply(msg);
    this.output.operator_lessEqualsThan(_apply);
  }
  
  @Override
  public void operator_lessEqualsThan(final Function0<? extends InputType> msgClosure) {
    InputType _apply = msgClosure.apply();
    OutputType _apply_1 = this.operation.apply(_apply);
    this.output.operator_lessEqualsThan(_apply_1);
  }
  
  @Override
  public void operator_mappedTo(final Procedure1<? super OutputType> closure) {
    this.output.operator_mappedTo(closure);
  }
  
  @Override
  public void operator_mappedTo(final InputPort<OutputType> foreignInputPort) {
    Procedure1<? super OutputType> _inputProcessingOperation = foreignInputPort.inputProcessingOperation();
    this.output.operator_mappedTo(_inputProcessingOperation);
  }
  
  @Override
  public void operator_mappedTo(final FunctionUnitWithOnlyOneInputPort<OutputType> rightSideFunctionUnit) {
    InputPort<OutputType> _theOneAndOnlyInputPort = rightSideFunctionUnit.theOneAndOnlyInputPort();
    Procedure1<? super OutputType> _inputProcessingOperation = _theOneAndOnlyInputPort.inputProcessingOperation();
    this.output.operator_mappedTo(_inputProcessingOperation);
  }
  
  @Override
  public void operator_mappedTo(final OutputPort<OutputType> rightSideFunctionUnitOutputPort) {
    this.output.operator_mappedTo(rightSideFunctionUnitOutputPort);
  }
}
