/**
 * Copyright (c) 2014 Denis Kuniss (http://www.grammarcraft.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package de.grammarcraft.xtend.flow.annotations;

import de.grammarcraft.xtend.flow.annotations.FunctionUnitProcessor;
import de.grammarcraft.xtend.flow.annotations.Port;
import org.eclipse.xtend.lib.macro.Active;

/**
 * Represents an Function Unit in the sense of the Flow Design paradigm.
 * It defines input ports for receiving data and output ports to forward computation results to
 * other function units or for applying side effects.
 */
@Active(FunctionUnitProcessor.class)
public @interface Unit {
  /**
   * Defines on or more named Input Ports the function unit receives typed input data
   * over from other function units.<br>
   * Each of the declared ports may be connected to other function unit's output ports using the
   * wiring operator: other_fu.out -> this_fu.a.<br>
   * Each input port <i>a</i> message may be forwarded using the forward operator:
   * this_fu.a <= message.<br>
   * For integration units an integrated function unit input port may be connected to this unit's
   * input port forwarding input messages to those integrated function unit:
   * this_fu.i -> integrated_fu.in.
   */
  public Port[] inputPorts() default {};
  /**
   * Defines one or more named and typed Output Ports the computation results of this function unit are
   * forwarded over to other function units or to be processed for side effects.<br
   * Each of the declared port <i>o</i> may be connected to other function unit's out ports using the
   * wiring operator: this_fu.o -> other_fu.in.<br>
   * For integration units an integrated function unit output port may be connected to this unit's
   * output port forwarding computation result messages of those  unit to this function unit's
   * output port: integrated_fu.out -> this_fu.o.
   */
  public Port[] outputPorts() default {};
}
