/**
 * Copyright (c) 2014 Denis Kuniss (http://www.grammarcraft.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package de.grammarcraft.xtend.flow.annotations;

import com.google.common.base.Objects;
import de.grammarcraft.xtend.flow.annotations.FunctionBoard;
import de.grammarcraft.xtend.flow.annotations.FunctionUnit;
import de.grammarcraft.xtend.flow.annotations.Integration;
import de.grammarcraft.xtend.flow.annotations.Operation;
import de.grammarcraft.xtend.flow.annotations.Unit;
import java.util.Collections;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
@SuppressWarnings("all")
public class FlowAnnotationSignature {
  private final AnnotationReference unitAnnotation;
  
  private final AnnotationReference unitModifier;
  
  private final Iterable<? extends AnnotationReference> inputPortAnnotations;
  
  private final Iterable<? extends AnnotationReference> outputPortAnnotations;
  
  private final Object inputPortAnnotationArgument;
  
  private final Object outputPortAnnotationArgument;
  
  public FlowAnnotationSignature(final ClassDeclaration annotatedClass) {
    Iterable<? extends AnnotationReference> _annotations = annotatedClass.getAnnotations();
    AnnotationReference _findFirst = null;
    if (_annotations!=null) {
      final Function1<AnnotationReference, Boolean> _function = new Function1<AnnotationReference, Boolean>() {
        @Override
        public Boolean apply(final AnnotationReference it) {
          boolean _or = false;
          boolean _or_1 = false;
          boolean _isFunctionUnitAnnotation = FlowAnnotationSignature.isFunctionUnitAnnotation(it);
          if (_isFunctionUnitAnnotation) {
            _or_1 = true;
          } else {
            boolean _isFunctionBoardAnnotation = FlowAnnotationSignature.isFunctionBoardAnnotation(it);
            _or_1 = _isFunctionBoardAnnotation;
          }
          if (_or_1) {
            _or = true;
          } else {
            boolean _isFlowUnitAnnotation = FlowAnnotationSignature.isFlowUnitAnnotation(it);
            _or = _isFlowUnitAnnotation;
          }
          return Boolean.valueOf(_or);
        }
      };
      _findFirst=IterableExtensions.findFirst(_annotations, _function);
    }
    this.unitAnnotation = _findFirst;
    Iterable<? extends AnnotationReference> _annotations_1 = annotatedClass.getAnnotations();
    AnnotationReference _findFirst_1 = null;
    if (_annotations_1!=null) {
      final Function1<AnnotationReference, Boolean> _function_1 = new Function1<AnnotationReference, Boolean>() {
        @Override
        public Boolean apply(final AnnotationReference it) {
          boolean _or = false;
          boolean _isOperationAnnotation = FlowAnnotationSignature.isOperationAnnotation(it);
          if (_isOperationAnnotation) {
            _or = true;
          } else {
            boolean _isIntegrationAnnotation = FlowAnnotationSignature.isIntegrationAnnotation(it);
            _or = _isIntegrationAnnotation;
          }
          return Boolean.valueOf(_or);
        }
      };
      _findFirst_1=IterableExtensions.findFirst(_annotations_1, _function_1);
    }
    this.unitModifier = _findFirst_1;
    Object _value = null;
    if (this.unitAnnotation!=null) {
      _value=this.unitAnnotation.getValue("inputPorts");
    }
    this.inputPortAnnotationArgument = _value;
    Class<?> _class = null;
    if (this.inputPortAnnotationArgument!=null) {
      _class=this.inputPortAnnotationArgument.getClass();
    }
    boolean _equals = Objects.equal(_class, AnnotationReference[].class);
    if (_equals) {
      this.inputPortAnnotations = ((Iterable<? extends AnnotationReference>)Conversions.doWrapArray(((AnnotationReference[]) this.inputPortAnnotationArgument)));
    } else {
      this.inputPortAnnotations = Collections.<AnnotationReference>unmodifiableList(CollectionLiterals.<AnnotationReference>newArrayList());
    }
    Object _value_1 = null;
    if (this.unitAnnotation!=null) {
      _value_1=this.unitAnnotation.getValue("outputPorts");
    }
    this.outputPortAnnotationArgument = _value_1;
    Class<?> _class_1 = null;
    if (this.outputPortAnnotationArgument!=null) {
      _class_1=this.outputPortAnnotationArgument.getClass();
    }
    boolean _equals_1 = Objects.equal(_class_1, AnnotationReference[].class);
    if (_equals_1) {
      this.outputPortAnnotations = ((Iterable<? extends AnnotationReference>)Conversions.doWrapArray(((AnnotationReference[]) this.outputPortAnnotationArgument)));
    } else {
      this.outputPortAnnotations = Collections.<AnnotationReference>unmodifiableList(CollectionLiterals.<AnnotationReference>newArrayList());
    }
  }
  
  private static boolean isFunctionUnitAnnotation(final AnnotationReference annotation) {
    AnnotationTypeDeclaration _annotationTypeDeclaration = null;
    if (annotation!=null) {
      _annotationTypeDeclaration=annotation.getAnnotationTypeDeclaration();
    }
    String _qualifiedName = null;
    if (_annotationTypeDeclaration!=null) {
      _qualifiedName=_annotationTypeDeclaration.getQualifiedName();
    }
    String _name = FunctionUnit.class.getName();
    return Objects.equal(_qualifiedName, _name);
  }
  
  private static boolean isFunctionBoardAnnotation(final AnnotationReference annotation) {
    AnnotationTypeDeclaration _annotationTypeDeclaration = null;
    if (annotation!=null) {
      _annotationTypeDeclaration=annotation.getAnnotationTypeDeclaration();
    }
    String _qualifiedName = null;
    if (_annotationTypeDeclaration!=null) {
      _qualifiedName=_annotationTypeDeclaration.getQualifiedName();
    }
    String _name = FunctionBoard.class.getName();
    return Objects.equal(_qualifiedName, _name);
  }
  
  private static boolean isFlowUnitAnnotation(final AnnotationReference annotation) {
    AnnotationTypeDeclaration _annotationTypeDeclaration = null;
    if (annotation!=null) {
      _annotationTypeDeclaration=annotation.getAnnotationTypeDeclaration();
    }
    String _qualifiedName = null;
    if (_annotationTypeDeclaration!=null) {
      _qualifiedName=_annotationTypeDeclaration.getQualifiedName();
    }
    String _name = Unit.class.getName();
    return Objects.equal(_qualifiedName, _name);
  }
  
  private static boolean isOperationAnnotation(final AnnotationReference annotation) {
    AnnotationTypeDeclaration _annotationTypeDeclaration = null;
    if (annotation!=null) {
      _annotationTypeDeclaration=annotation.getAnnotationTypeDeclaration();
    }
    String _qualifiedName = null;
    if (_annotationTypeDeclaration!=null) {
      _qualifiedName=_annotationTypeDeclaration.getQualifiedName();
    }
    String _name = Operation.class.getName();
    return Objects.equal(_qualifiedName, _name);
  }
  
  private static boolean isIntegrationAnnotation(final AnnotationReference annotation) {
    AnnotationTypeDeclaration _annotationTypeDeclaration = null;
    if (annotation!=null) {
      _annotationTypeDeclaration=annotation.getAnnotationTypeDeclaration();
    }
    String _qualifiedName = null;
    if (_annotationTypeDeclaration!=null) {
      _qualifiedName=_annotationTypeDeclaration.getQualifiedName();
    }
    String _name = Integration.class.getName();
    return Objects.equal(_qualifiedName, _name);
  }
  
  public boolean isFunctionUnit() {
    return FlowAnnotationSignature.isFunctionUnitAnnotation(this.unitAnnotation);
  }
  
  public boolean isFunctionBoard() {
    return FlowAnnotationSignature.isFunctionBoardAnnotation(this.unitAnnotation);
  }
  
  public boolean isFlowUnit() {
    return FlowAnnotationSignature.isFlowUnitAnnotation(this.unitAnnotation);
  }
  
  public boolean hasOperationModifier() {
    return FlowAnnotationSignature.isOperationAnnotation(this.unitModifier);
  }
  
  public boolean hasIntegrationModifier() {
    return FlowAnnotationSignature.isIntegrationAnnotation(this.unitModifier);
  }
  
  /**
   * @return true if the processed class is annotated with @Integration @Unit
   */
  public boolean isIntegrationUnit() {
    boolean _and = false;
    boolean _isFlowUnit = this.isFlowUnit();
    if (!_isFlowUnit) {
      _and = false;
    } else {
      boolean _hasIntegrationModifier = this.hasIntegrationModifier();
      _and = _hasIntegrationModifier;
    }
    return _and;
  }
  
  /**
   * @return true if the processed class is annotated with @Operation @Unit
   */
  public boolean isOperationUnit() {
    boolean _and = false;
    boolean _isFlowUnit = this.isFlowUnit();
    if (!_isFlowUnit) {
      _and = false;
    } else {
      boolean _hasOperationModifier = this.hasOperationModifier();
      _and = _hasOperationModifier;
    }
    return _and;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.unitAnnotation== null) ? 0 : this.unitAnnotation.hashCode());
    result = prime * result + ((this.unitModifier== null) ? 0 : this.unitModifier.hashCode());
    result = prime * result + ((this.inputPortAnnotations== null) ? 0 : this.inputPortAnnotations.hashCode());
    result = prime * result + ((this.outputPortAnnotations== null) ? 0 : this.outputPortAnnotations.hashCode());
    result = prime * result + ((this.inputPortAnnotationArgument== null) ? 0 : this.inputPortAnnotationArgument.hashCode());
    result = prime * result + ((this.outputPortAnnotationArgument== null) ? 0 : this.outputPortAnnotationArgument.hashCode());
    return result;
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    FlowAnnotationSignature other = (FlowAnnotationSignature) obj;
    if (this.unitAnnotation == null) {
      if (other.unitAnnotation != null)
        return false;
    } else if (!this.unitAnnotation.equals(other.unitAnnotation))
      return false;
    if (this.unitModifier == null) {
      if (other.unitModifier != null)
        return false;
    } else if (!this.unitModifier.equals(other.unitModifier))
      return false;
    if (this.inputPortAnnotations == null) {
      if (other.inputPortAnnotations != null)
        return false;
    } else if (!this.inputPortAnnotations.equals(other.inputPortAnnotations))
      return false;
    if (this.outputPortAnnotations == null) {
      if (other.outputPortAnnotations != null)
        return false;
    } else if (!this.outputPortAnnotations.equals(other.outputPortAnnotations))
      return false;
    if (this.inputPortAnnotationArgument == null) {
      if (other.inputPortAnnotationArgument != null)
        return false;
    } else if (!this.inputPortAnnotationArgument.equals(other.inputPortAnnotationArgument))
      return false;
    if (this.outputPortAnnotationArgument == null) {
      if (other.outputPortAnnotationArgument != null)
        return false;
    } else if (!this.outputPortAnnotationArgument.equals(other.outputPortAnnotationArgument))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("unitAnnotation", this.unitAnnotation);
    b.add("unitModifier", this.unitModifier);
    b.add("inputPortAnnotations", this.inputPortAnnotations);
    b.add("outputPortAnnotations", this.outputPortAnnotations);
    b.add("inputPortAnnotationArgument", this.inputPortAnnotationArgument);
    b.add("outputPortAnnotationArgument", this.outputPortAnnotationArgument);
    return b.toString();
  }
  
  @Pure
  public AnnotationReference getUnitAnnotation() {
    return this.unitAnnotation;
  }
  
  @Pure
  public AnnotationReference getUnitModifier() {
    return this.unitModifier;
  }
  
  @Pure
  public Iterable<? extends AnnotationReference> getInputPortAnnotations() {
    return this.inputPortAnnotations;
  }
  
  @Pure
  public Iterable<? extends AnnotationReference> getOutputPortAnnotations() {
    return this.outputPortAnnotations;
  }
  
  @Pure
  public Object getInputPortAnnotationArgument() {
    return this.inputPortAnnotationArgument;
  }
  
  @Pure
  public Object getOutputPortAnnotationArgument() {
    return this.outputPortAnnotationArgument;
  }
}
