/**
 * Copyright (c) 2014 Denis Kuniss (http://www.grammarcraft.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package de.grammarcraft.xtend.flow.annotations;

/**
 * Defines a Port in the sense of Flow Design. Over the port the associated Function Unit
 * receives input data for processing from other function units or forwards computation
 * results to other function units down stream.<br>
 * The port has a <i>name</i> and a <i>type</i> with optional type arguments.
 * This name and type is used for creating appropriate port types, getter, setter, and operation methods
 * allowing those ports to be wired up with other function unit ports.<br>
 * Example:<br>
 * <code>@Port(name="in", type=String)</code> is defining a port with name <i>in</i> of
 * type <i>java.lang.String</i><br>
 * <code>@Port(name="in", type=Map, typeArguments=#[Integer,String])</code> is defining a port
 * with name <i>in</i> of the generic type <i>Map&lt;Integer,String&gt;</i><br>
 */
public @interface Port {
  public String name();
  public Class<?> type();
  public Class<?>[] typeArguments() default {};
}
