/**
 * Copyright (c) 2014 Denis Kuniss (http://www.grammarcraft.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package de.grammarcraft.xtend.flow.annotations;

/**
 * {@link Unit} modifier marking a Function Unit as an operation in the sense of the Flow Design paradigm.
 * The term <i>operation</i> has the same meaning as in the IODA architecture.<br>
 * Operation units are implementing the real functionality of the software system. They are the basic
 * components of a software system wired together by {@link Integration} {@link Unit}s.
 * Only operation units contain logic and control flow implementations.<br>
 * For every declared port <i>a</i> in this list of inputPorts a method <i>process$a</i> with a parameter
 * of the port's type must be implemented for processing the incoming messages.<br>
 */
public @interface Operation {
}
