/**
 * Copyright (c) 2014 Denis Kuniss (http://www.grammarcraft.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package de.grammarcraft.xtend.flow.annotations;

/**
 * {@link Unit} modifier marking a Function Unit as an integration in the sense of the Flow Design paradigm.
 * The term <i>integration</i> has the same meaning as in the IODA architecture.<br>
 * Integration unit's only purpose is to integrate other function units by wiring them together defining
 * the data flow between them. Integration units never contain logic and control flow implementations.<br>
 * Typically, they only contain function unit instantiations and a constructor with wiring operations.
 */
public @interface Integration {
}
