/*
 * Decompiled with CFR 0.152.
 */
package de.grammarcraft.xtend.flow.annotations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.grammarcraft.xtend.flow.FunctionUnitWithOnlyOneInputPort;
import de.grammarcraft.xtend.flow.FunctionUnitWithOnlyOneOutputPort;
import de.grammarcraft.xtend.flow.IFunctionUnit;
import de.grammarcraft.xtend.flow.InputPort;
import de.grammarcraft.xtend.flow.OutputPort;
import de.grammarcraft.xtend.flow.annotations.FunctionBoard;
import de.grammarcraft.xtend.flow.annotations.FunctionUnit;
import de.grammarcraft.xtend.flow.annotations.Integration;
import de.grammarcraft.xtend.flow.annotations.Operation;
import de.grammarcraft.xtend.flow.annotations.Unit;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FunctionUnitProcessor
extends AbstractClassProcessor {
    private AnnotationReference mainAnnotation;
    private AnnotationReference unitModifier;
    private Iterable<? extends AnnotationReference> inputPortAnnotations;
    private Iterable<? extends AnnotationReference> outputPortAnnotations;
    private Iterable<? extends AnnotationReference> doubledInputAnnotations;
    private Iterable<? extends AnnotationReference> doubledOutputAnnotations;
    private Object inputPortAnnotationArgument;
    private Object outputPortAnnotationArgument;

    private static boolean isFunctionUnit(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = FunctionUnit.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    private static boolean isFunctionBoard(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = FunctionBoard.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    private static boolean isFlowUnit(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = Unit.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    private static boolean isOperation(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = Operation.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    private static boolean isIntegration(AnnotationReference annotation) {
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (annotation != null) {
            _annotationTypeDeclaration = annotation.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        String _name = Integration.class.getName();
        return Objects.equal((Object)_qualifiedName, (Object)_name);
    }

    private boolean isIntegrationUnit() {
        boolean _isIntegration;
        boolean _and = false;
        boolean _isFlowUnit = FunctionUnitProcessor.isFlowUnit(this.mainAnnotation);
        _and = !_isFlowUnit ? false : (_isIntegration = FunctionUnitProcessor.isIntegration(this.unitModifier));
        return _and;
    }

    private boolean isOperationUnit() {
        boolean _isOperation;
        boolean _and = false;
        boolean _isFlowUnit = FunctionUnitProcessor.isFlowUnit(this.mainAnnotation);
        _and = !_isFlowUnit ? false : (_isOperation = FunctionUnitProcessor.isOperation(this.unitModifier));
        return _and;
    }

    public void doRegisterGlobals(final ClassDeclaration annotatedClass, final RegisterGlobalsContext context) {
        boolean _equals_1;
        boolean _equals;
        Iterable _annotations = annotatedClass.getAnnotations();
        AnnotationReference _findFirst = null;
        if (_annotations != null) {
            Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                public Boolean apply(AnnotationReference it) {
                    boolean _isFlowUnit;
                    boolean _isFunctionBoard;
                    boolean _or = false;
                    boolean _or_1 = false;
                    boolean _isFunctionUnit = FunctionUnitProcessor.isFunctionUnit(it);
                    _or_1 = _isFunctionUnit ? true : (_isFunctionBoard = FunctionUnitProcessor.isFunctionBoard(it));
                    _or = _or_1 ? true : (_isFlowUnit = FunctionUnitProcessor.isFlowUnit(it));
                    return _or;
                }
            };
            _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)_function);
        }
        this.mainAnnotation = _findFirst;
        Iterable _annotations_1 = annotatedClass.getAnnotations();
        AnnotationReference _findFirst_1 = null;
        if (_annotations_1 != null) {
            Functions.Function1<AnnotationReference, Boolean> _function_1 = new Functions.Function1<AnnotationReference, Boolean>(){

                public Boolean apply(AnnotationReference it) {
                    boolean _isIntegration;
                    boolean _or = false;
                    boolean _isOperation = FunctionUnitProcessor.isOperation(it);
                    _or = _isOperation ? true : (_isIntegration = FunctionUnitProcessor.isIntegration(it));
                    return _or;
                }
            };
            _findFirst_1 = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations_1, (Functions.Function1)_function_1);
        }
        this.unitModifier = _findFirst_1;
        Object _value = null;
        if (this.mainAnnotation != null) {
            _value = this.mainAnnotation.getValue("inputPorts");
        }
        this.inputPortAnnotationArgument = _value;
        Class<?> _class = null;
        if (this.inputPortAnnotationArgument != null) {
            _class = this.inputPortAnnotationArgument.getClass();
        }
        if (_equals = Objects.equal(_class, AnnotationReference[].class)) {
            this.inputPortAnnotations = (Iterable)Conversions.doWrapArray((Object)((AnnotationReference[])this.inputPortAnnotationArgument));
            Iterable<? extends AnnotationReference> _doubledAnnotations = FunctionUnitProcessor.doubledAnnotations(this.inputPortAnnotations);
            this.doubledInputAnnotations = _doubledAnnotations;
            boolean _and = false;
            boolean _isEmpty = IterableExtensions.isEmpty(this.doubledInputAnnotations);
            if (!_isEmpty) {
                _and = false;
            } else {
                boolean _isOperationUnit;
                boolean _or = false;
                boolean _isFunctionUnit = FunctionUnitProcessor.isFunctionUnit(this.mainAnnotation);
                _or = _isFunctionUnit ? true : (_isOperationUnit = this.isOperationUnit());
                _and = _or;
            }
            if (_and) {
                Procedures.Procedure1<AnnotationReference> _function_2 = new Procedures.Procedure1<AnnotationReference>(){

                    public void apply(AnnotationReference inputPortAnnotation) {
                        String _inputPortInterfaceName = FunctionUnitProcessor.getInputPortInterfaceName(annotatedClass, inputPortAnnotation);
                        context.registerInterface(_inputPortInterfaceName);
                    }
                };
                IterableExtensions.forEach(this.inputPortAnnotations, (Procedures.Procedure1)_function_2);
            }
        }
        Object _value_1 = null;
        if (this.mainAnnotation != null) {
            _value_1 = this.mainAnnotation.getValue("outputPorts");
        }
        this.outputPortAnnotationArgument = _value_1;
        Class<?> _class_1 = null;
        if (this.outputPortAnnotationArgument != null) {
            _class_1 = this.outputPortAnnotationArgument.getClass();
        }
        if (_equals_1 = Objects.equal(_class_1, AnnotationReference[].class)) {
            this.outputPortAnnotations = (Iterable)Conversions.doWrapArray((Object)((AnnotationReference[])this.outputPortAnnotationArgument));
            Iterable<? extends AnnotationReference> _doubledAnnotations_1 = FunctionUnitProcessor.doubledAnnotations(this.outputPortAnnotations);
            this.doubledOutputAnnotations = _doubledAnnotations_1;
        }
    }

    private static String getInputPortInterfaceName(ClassDeclaration annotatedClass, AnnotationReference inputPortAnnotation) {
        StringConcatenation _builder = new StringConcatenation();
        String _qualifiedName = annotatedClass.getQualifiedName();
        _builder.append((Object)_qualifiedName, "");
        _builder.append((Object)"_InputPort_");
        String _portName = FunctionUnitProcessor.portName(inputPortAnnotation);
        _builder.append((Object)_portName, "");
        return _builder.toString();
    }

    private static String portName(AnnotationReference annotationReference) {
        Object _value = annotationReference.getValue("name");
        return ((String)_value).trim();
    }

    private static TypeReference portType(AnnotationReference annotationReference) {
        Object _value = annotationReference.getValue("type");
        return (TypeReference)_value;
    }

    private static TypeReference[] portTypeParameters(AnnotationReference annotationReference) {
        Object _value = annotationReference.getValue("typeArguments");
        return (TypeReference[])_value;
    }

    private static Iterable<? extends AnnotationReference> doubledAnnotations(final Iterable<? extends AnnotationReference> portAnnotations) {
        Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                return FunctionUnitProcessor.doubledAnnotation(it, portAnnotations);
            }
        };
        return IterableExtensions.filter(portAnnotations, (Functions.Function1)_function);
    }

    private static boolean doubledAnnotation(final AnnotationReference portAnnotation, Iterable<? extends AnnotationReference> portAnnotations) {
        Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                String _portName = FunctionUnitProcessor.portName(it);
                String _portName_1 = FunctionUnitProcessor.portName(portAnnotation);
                return Objects.equal((Object)_portName, (Object)_portName_1);
            }
        };
        Iterable _filter = IterableExtensions.filter(portAnnotations, (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)_filter);
        return _size > 1;
    }

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        boolean _not;
        boolean hasContextErrors = false;
        boolean _checkForContextErrors = this.checkForContextErrors(context, annotatedClass);
        hasContextErrors = _checkForContextErrors;
        if (hasContextErrors) {
            context.addWarning((Element)annotatedClass, "due to port annotation errors, no code can be generated");
            return;
        }
        this.checkForContextWarnings(context, annotatedClass);
        annotatedClass.setFinal(true);
        StringConcatenation _builder = new StringConcatenation();
        String _docComment = annotatedClass.getDocComment();
        _builder.append((Object)_docComment, "");
        _builder.newLineIfNotEmpty();
        String _xifexpression = null;
        boolean _or = false;
        String _docComment_1 = annotatedClass.getDocComment();
        boolean _equals = Objects.equal((Object)_docComment_1, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _isEmpty;
            String _docComment_2 = annotatedClass.getDocComment();
            _or = _isEmpty = _docComment_2.isEmpty();
        }
        boolean bl = _not = !_or;
        if (_not) {
            _xifexpression = "<br><br>";
        }
        _builder.append((Object)_xifexpression, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Implements a function unit as defined by Flow Design paradigm.<br>");
        _builder.newLine();
        _builder.append((Object)"It consumes input messages over the input ports<br>");
        _builder.newLine();
        _builder.append((Object)"    ");
        Functions.Function1<AnnotationReference, String> _function = new Functions.Function1<AnnotationReference, String>(){

            public String apply(AnnotationReference it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"\"");
                String _portName = FunctionUnitProcessor.portName(it);
                _builder.append((Object)_portName, "");
                _builder.append((Object)"\" of type \"");
                TypeReference _portType = FunctionUnitProcessor.portType(it);
                _builder.append((Object)_portType, "");
                _builder.append((Object)"\"");
                return _builder.toString();
            }
        };
        Iterable _map = IterableExtensions.map(this.inputPortAnnotations, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"<br>\n");
        _builder.append((Object)_join, "    ");
        _builder.append((Object)"<br>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"And issues computation results over the output ports<br>");
        _builder.newLine();
        _builder.append((Object)"    ");
        Functions.Function1<AnnotationReference, String> _function_1 = new Functions.Function1<AnnotationReference, String>(){

            public String apply(AnnotationReference it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"\"");
                String _portName = FunctionUnitProcessor.portName(it);
                _builder.append((Object)_portName, "");
                _builder.append((Object)"\" of type \"");
                TypeReference _portType = FunctionUnitProcessor.portType(it);
                _builder.append((Object)_portType, "");
                _builder.append((Object)"\"");
                return _builder.toString();
            }
        };
        Iterable _map_1 = IterableExtensions.map(this.outputPortAnnotations, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"<br>\n");
        _builder.append((Object)_join_1, "    ");
        _builder.append((Object)"<br>");
        _builder.newLineIfNotEmpty();
        annotatedClass.setDocComment(_builder.toString());
        FunctionUnitProcessor.addClassCommentToConstructors(annotatedClass, context);
        this.addInterfaces(annotatedClass, context);
        FunctionUnitProcessor.addNamingStuff(annotatedClass, context);
        this.addIntegrationErrorPort(annotatedClass, context);
        this.addInputPorts(annotatedClass, context);
        this.addOutputPorts(annotatedClass, context);
        this.addFlowOperators(annotatedClass, context);
    }

    private static void addClassCommentToConstructors(final MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Iterable _declaredConstructors = annotatedClass.getDeclaredConstructors();
        Procedures.Procedure1<MutableConstructorDeclaration> _function = new Procedures.Procedure1<MutableConstructorDeclaration>(){

            public void apply(MutableConstructorDeclaration it) {
                boolean _not;
                StringConcatenation _builder = new StringConcatenation();
                String _docComment = it.getDocComment();
                _builder.append((Object)_docComment, "");
                _builder.newLineIfNotEmpty();
                String _xifexpression = null;
                boolean _or = false;
                String _docComment_1 = it.getDocComment();
                boolean _equals = Objects.equal((Object)_docComment_1, null);
                if (_equals) {
                    _or = true;
                } else {
                    boolean _isEmpty;
                    String _docComment_2 = it.getDocComment();
                    _or = _isEmpty = _docComment_2.isEmpty();
                }
                boolean bl = _not = !_or;
                if (_not) {
                    _xifexpression = "<br><br>";
                }
                _builder.append((Object)_xifexpression, "");
                _builder.newLineIfNotEmpty();
                String _docComment_3 = annotatedClass.getDocComment();
                _builder.append((Object)_docComment_3, "");
                _builder.newLineIfNotEmpty();
                it.setDocComment(_builder.toString());
            }
        };
        IterableExtensions.forEach((Iterable)_declaredConstructors, (Procedures.Procedure1)_function);
    }

    private void addInterfaces(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        int _size_1;
        boolean _equals_1;
        boolean _equals;
        ArrayList<TypeReference> interfacesToBeAdded = new ArrayList<TypeReference>();
        TypeReference _newTypeReference = context.newTypeReference(IFunctionUnit.class, new TypeReference[0]);
        interfacesToBeAdded.add(_newTypeReference);
        boolean _or = false;
        int _size = IterableExtensions.size(this.inputPortAnnotations);
        boolean bl = _equals = _size == 1;
        _or = _equals ? true : (_equals_1 = (_size_1 = IterableExtensions.size(this.outputPortAnnotations)) == 1);
        if (_or) {
            int _size_3;
            boolean _equals_3;
            boolean _equals_2;
            int _size_2 = IterableExtensions.size(this.inputPortAnnotations);
            boolean bl2 = _equals_2 = _size_2 == 1;
            if (_equals_2) {
                AnnotationReference inputPortAnnotation = (AnnotationReference)IterableExtensions.head(this.inputPortAnnotations);
                TypeReference _portType = FunctionUnitProcessor.portType(inputPortAnnotation);
                Type _type = _portType.getType();
                TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(inputPortAnnotation);
                TypeReference _newTypeReference_1 = context.newTypeReference(_type, _portTypeParameters);
                TypeReference _newTypeReference_2 = context.newTypeReference(FunctionUnitWithOnlyOneInputPort.class, new TypeReference[]{_newTypeReference_1});
                interfacesToBeAdded.add(_newTypeReference_2);
            }
            boolean bl3 = _equals_3 = (_size_3 = IterableExtensions.size(this.outputPortAnnotations)) == 1;
            if (_equals_3) {
                AnnotationReference outputPortAnnotation = (AnnotationReference)IterableExtensions.head(this.outputPortAnnotations);
                TypeReference _portType_1 = FunctionUnitProcessor.portType(outputPortAnnotation);
                Type _type_1 = _portType_1.getType();
                TypeReference[] _portTypeParameters_1 = FunctionUnitProcessor.portTypeParameters(outputPortAnnotation);
                TypeReference _newTypeReference_3 = context.newTypeReference(_type_1, _portTypeParameters_1);
                TypeReference _newTypeReference_4 = context.newTypeReference(FunctionUnitWithOnlyOneOutputPort.class, new TypeReference[]{_newTypeReference_3});
                interfacesToBeAdded.add(_newTypeReference_4);
            }
        }
        annotatedClass.setImplementedInterfaces(interfacesToBeAdded);
    }

    private void checkForContextWarnings(final @Extension TransformationContext context, MutableClassDeclaration annotatedClass) {
        Functions.Function1<MutableMethodDeclaration, Boolean> _function;
        Iterable _declaredMethods;
        Iterable _filter;
        int _size;
        boolean _greaterThan;
        boolean _isIntegrationUnit;
        boolean _isEmpty_1;
        boolean _isEmpty = IterableExtensions.isEmpty(this.inputPortAnnotations);
        if (_isEmpty) {
            context.addWarning((Element)annotatedClass, "no input port defined");
        }
        if (_isEmpty_1 = IterableExtensions.isEmpty(this.outputPortAnnotations)) {
            context.addWarning((Element)annotatedClass, "no output port defined");
        }
        boolean _and = false;
        boolean _or = false;
        boolean _isFunctionBoard = FunctionUnitProcessor.isFunctionBoard(this.mainAnnotation);
        _or = _isFunctionBoard ? true : (_isIntegrationUnit = this.isIntegrationUnit());
        _and = !_or ? false : (_greaterThan = (_size = IterableExtensions.size((Iterable)(_filter = IterableExtensions.filter((Iterable)(_declaredMethods = annotatedClass.getDeclaredMethods()), (Functions.Function1)(_function = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

            public Boolean apply(MutableMethodDeclaration it) {
                Visibility _visibility = it.getVisibility();
                return !Objects.equal((Object)_visibility, (Object)Visibility.PRIVATE);
            }
        }))))) > 0);
        if (_and) {
            Iterable _declaredMethods_1 = annotatedClass.getDeclaredMethods();
            Functions.Function1<MutableMethodDeclaration, Boolean> _function_1 = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

                public Boolean apply(MutableMethodDeclaration it) {
                    Visibility _visibility = it.getVisibility();
                    return !Objects.equal((Object)_visibility, (Object)Visibility.PRIVATE);
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_declaredMethods_1, (Functions.Function1)_function_1);
            Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    context.addWarning((Element)it, "a FunctionBoard must not have other than private methods");
                }
            };
            IterableExtensions.forEach((Iterable)_filter_1, (Procedures.Procedure1)_function_2);
        }
    }

    private boolean checkForContextErrors(final @Extension TransformationContext context, final MutableClassDeclaration annotatedClass) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean contextError = false;
        Class<?> _class = null;
        if (this.inputPortAnnotationArgument != null) {
            _class = this.inputPortAnnotationArgument.getClass();
        }
        boolean bl = _notEquals = !Objects.equal(_class, AnnotationReference[].class);
        if (_notEquals) {
            context.addError((Element)annotatedClass, "array of input port annotations expected");
            contextError = true;
        }
        Class<?> _class_1 = null;
        if (this.outputPortAnnotationArgument != null) {
            _class_1 = this.outputPortAnnotationArgument.getClass();
        }
        boolean bl2 = _notEquals_1 = !Objects.equal(_class_1, AnnotationReference[].class);
        if (_notEquals_1) {
            context.addError((Element)annotatedClass, "array of output port annotations expected");
            contextError = true;
        }
        if (contextError) {
            return true;
        }
        boolean _isEmpty = IterableExtensions.isEmpty(this.doubledInputAnnotations);
        boolean bl3 = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

                public void apply(AnnotationReference it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"input port \"");
                    String _portName = FunctionUnitProcessor.portName(it);
                    _builder.append((Object)_portName, "");
                    _builder.append((Object)"\" is declared twice");
                    context.addError((Element)annotatedClass, _builder.toString());
                }
            };
            IterableExtensions.forEach(this.doubledInputAnnotations, (Procedures.Procedure1)_function);
            contextError = true;
        }
        boolean bl4 = _not_1 = !(_isEmpty_1 = IterableExtensions.isEmpty(this.doubledOutputAnnotations));
        if (_not_1) {
            Procedures.Procedure1<AnnotationReference> _function_1 = new Procedures.Procedure1<AnnotationReference>(){

                public void apply(AnnotationReference it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"output port \"");
                    String _portName = FunctionUnitProcessor.portName(it);
                    _builder.append((Object)_portName, "");
                    _builder.append((Object)"\" is declared twice");
                    context.addError((Element)annotatedClass, _builder.toString());
                }
            };
            IterableExtensions.forEach(this.doubledOutputAnnotations, (Procedures.Procedure1)_function_1);
            contextError = true;
        }
        return contextError;
    }

    private static void addNamingStuff(final MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

            public void apply(MutableFieldDeclaration it) {
                it.setVisibility(Visibility.PRIVATE);
                TypeReference _newTypeReference = context.newTypeReference(String.class, new TypeReference[0]);
                it.setType(_newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"\"");
                        String _simpleName = annotatedClass.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)"\"");
                        return _builder;
                    }
                };
                it.setInitializer(_function);
            }
        };
        annotatedClass.addField("_name", (Procedures.Procedure1)_function);
        Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                it.setVisibility(Visibility.PUBLIC);
                TypeReference _newTypeReference = context.newTypeReference(String.class, new TypeReference[0]);
                it.setReturnType(_newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"return this._name;");
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("toString", (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                it.setVisibility(Visibility.PUBLIC);
                TypeReference _newTypeReference = context.newTypeReference(String.class, new TypeReference[0]);
                it.addParameter("newValue", _newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"this._name = newValue;");
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("setName", (Procedures.Procedure1)_function_2);
    }

    private MutableMethodDeclaration addIntegrationErrorPort(MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        MutableMethodDeclaration _xblockexpression = null;
        String integrationErrorPortName = "integrationError";
        Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

            public void apply(MutableFieldDeclaration it) {
                it.setFinal(true);
                it.setVisibility(Visibility.PRIVATE);
                TypeReference _newTypeReference = context.newTypeReference(Exception.class, new TypeReference[0]);
                TypeReference _newTypeReference_1 = context.newTypeReference(OutputPort.class, new TypeReference[]{_newTypeReference});
                it.setType(_newTypeReference_1);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"new ");
                        String _name = OutputPort.class.getName();
                        _builder.append((Object)_name, "");
                        _builder.append((Object)"<");
                        String _name_1 = Exception.class.getName();
                        _builder.append((Object)_name_1, "");
                        _builder.append((Object)">(\"integrationError\", ");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<");
                        String _name_2 = Exception.class.getName();
                        _builder.append((Object)_name_2, "    ");
                        _builder.append((Object)">() {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"@Override");
                        _builder.newLine();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"public void apply(final ");
                        String _name_3 = Exception.class.getName();
                        _builder.append((Object)_name_3, "      ");
                        _builder.append((Object)" ex) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"        ");
                        _builder.append((Object)"String _message = ex.getMessage();");
                        _builder.newLine();
                        _builder.append((Object)"        ");
                        _builder.append((Object)"String _plus = (\"FATAL ERROR: \" + _message);");
                        _builder.newLine();
                        _builder.append((Object)"        ");
                        String _name_4 = InputOutput.class.getName();
                        _builder.append((Object)_name_4, "        ");
                        _builder.append((Object)".<String>println(_plus);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"      ");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)")");
                        _builder.newLine();
                        return _builder;
                    }
                };
                it.setInitializer(_function);
            }
        };
        annotatedClass.addField("integrationError", (Procedures.Procedure1)_function);
        Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                TypeReference _newTypeReference = context.newTypeReference(Exception.class, new TypeReference[0]);
                TypeReference _newTypeReference_1 = context.newTypeReference(OutputPort.class, new TypeReference[]{_newTypeReference});
                it.setReturnType(_newTypeReference_1);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"return this.");
                        _builder.append((Object)"integrationError", "");
                        _builder.append((Object)";");
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        annotatedClass.addMethod("integrationError", (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

            public void apply(MutableMethodDeclaration it) {
                it.setFinal(true);
                String parameterName = "integrationException";
                TypeReference _newTypeReference = context.newTypeReference(Exception.class, new TypeReference[0]);
                it.addParameter("integrationException", _newTypeReference);
                CompilationStrategy _function = new CompilationStrategy(){

                    public CharSequence compile(CompilationStrategy.CompilationContext it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"this.");
                        _builder.append((Object)"integrationError", "");
                        _builder.append((Object)".operator_lessEqualsThan(");
                        _builder.append((Object)"integrationException", "");
                        _builder.append((Object)");");
                        return _builder;
                    }
                };
                it.setBody(_function);
            }
        };
        _xblockexpression = annotatedClass.addMethod("forwardIntegrationError", (Procedures.Procedure1)_function_2);
        return _xblockexpression;
    }

    private void addInputPorts(final MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

            public void apply(AnnotationReference inputPortAnnotation) {
                boolean _isOperationUnit;
                final String portName = FunctionUnitProcessor.portName(inputPortAnnotation);
                String inputPortInterfaceName = FunctionUnitProcessor.getInputPortInterfaceName((ClassDeclaration)annotatedClass, inputPortAnnotation);
                TypeReference _portType = FunctionUnitProcessor.portType(inputPortAnnotation);
                Type _type = _portType.getType();
                TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(inputPortAnnotation);
                final TypeReference msgType = context.newTypeReference(_type, _portTypeParameters);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"process$");
                _builder.append((Object)portName, "");
                final String processInputMethodName = _builder.toString();
                Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

                    public void apply(MutableFieldDeclaration it) {
                        it.setFinal(true);
                        it.setVisibility(Visibility.PRIVATE);
                        TypeReference _newTypeReference = context.newTypeReference(InputPort.class, new TypeReference[]{msgType});
                        it.setType(_newTypeReference);
                        CompilationStrategy _function = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                boolean _isIntegrationUnit;
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"new org.eclipse.xtext.xbase.lib.Functions.Function0<de.grammarcraft.xtend.flow.InputPort<");
                                _builder.append((Object)msgType, "");
                                _builder.append((Object)">>() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"public de.grammarcraft.xtend.flow.InputPort<");
                                _builder.append((Object)msgType, "    ");
                                _builder.append((Object)"> apply() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"      ");
                                _builder.append((Object)"org.eclipse.xtend2.lib.StringConcatenation _builder = new org.eclipse.xtend2.lib.StringConcatenation();");
                                _builder.newLine();
                                _builder.append((Object)"      ");
                                _builder.append((Object)"_builder.append(");
                                String _simpleName = annotatedClass.getSimpleName();
                                _builder.append((Object)_simpleName, "      ");
                                _builder.append((Object)".this, \"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"      ");
                                _builder.append((Object)"_builder.append(\".");
                                _builder.append((Object)portName, "      ");
                                _builder.append((Object)"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"      ");
                                _builder.append((Object)"final org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception> _function_1 = new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception>() {");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"public void apply(final Exception it) {");
                                _builder.newLine();
                                _builder.append((Object)"          ");
                                String _simpleName_1 = annotatedClass.getSimpleName();
                                _builder.append((Object)_simpleName_1, "          ");
                                _builder.append((Object)".this.forwardIntegrationError(it);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"      ");
                                _builder.append((Object)"};");
                                _builder.newLine();
                                boolean _or = false;
                                boolean _isFunctionBoard = FunctionUnitProcessor.isFunctionBoard(FunctionUnitProcessor.this.mainAnnotation);
                                _or = _isFunctionBoard ? true : (_isIntegrationUnit = FunctionUnitProcessor.this.isIntegrationUnit());
                                if (_or) {
                                    _builder.append((Object)"      ");
                                    _builder.append((Object)"de.grammarcraft.xtend.flow.InputPort<");
                                    _builder.append((Object)msgType, "      ");
                                    _builder.append((Object)"> _inputPort = new de.grammarcraft.xtend.flow.InputPort<");
                                    _builder.append((Object)msgType, "      ");
                                    _builder.append((Object)">(_builder.toString(), _function_1);");
                                    _builder.newLineIfNotEmpty();
                                } else {
                                    _builder.append((Object)"      ");
                                    _builder.append((Object)"final org.eclipse.xtext.xbase.lib.Procedures.Procedure1<");
                                    _builder.append((Object)msgType, "      ");
                                    _builder.append((Object)"> _function = new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<");
                                    _builder.append((Object)msgType, "      ");
                                    _builder.append((Object)">() {");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"      ");
                                    _builder.append((Object)"  ");
                                    _builder.append((Object)"public void apply(final ");
                                    _builder.append((Object)msgType, "        ");
                                    _builder.append((Object)" msg) {");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"      ");
                                    _builder.append((Object)"    ");
                                    String _simpleName_2 = annotatedClass.getSimpleName();
                                    _builder.append((Object)_simpleName_2, "          ");
                                    _builder.append((Object)".this.");
                                    _builder.append((Object)processInputMethodName, "          ");
                                    _builder.append((Object)"(msg);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"      ");
                                    _builder.append((Object)"  ");
                                    _builder.append((Object)"}");
                                    _builder.newLine();
                                    _builder.append((Object)"      ");
                                    _builder.append((Object)"};");
                                    _builder.newLine();
                                    _builder.append((Object)"      ");
                                    _builder.append((Object)"de.grammarcraft.xtend.flow.InputPort<");
                                    _builder.append((Object)msgType, "      ");
                                    _builder.append((Object)"> _inputPort = new de.grammarcraft.xtend.flow.InputPort<");
                                    _builder.append((Object)msgType, "      ");
                                    _builder.append((Object)">(_builder.toString(), _function, _function_1);");
                                    _builder.newLineIfNotEmpty();
                                }
                                _builder.append((Object)"      ");
                                _builder.append((Object)"return _inputPort;");
                                _builder.newLine();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"}.apply();");
                                _builder.newLine();
                                return _builder;
                            }
                        };
                        it.setInitializer(_function);
                    }
                };
                annotatedClass.addField(portName, (Procedures.Procedure1)_function);
                Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                    public void apply(MutableMethodDeclaration it) {
                        it.setFinal(true);
                        TypeReference _newTypeReference = context.newTypeReference(InputPort.class, new TypeReference[]{msgType});
                        it.setReturnType(_newTypeReference);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"Input port '");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)"' of function unit '");
                        String _simpleName = annotatedClass.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)"', receives messages of ");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"type '");
                        _builder.append((Object)msgType, "");
                        _builder.append((Object)"' for further processing by this function unit.");
                        _builder.newLineIfNotEmpty();
                        it.setDocComment(_builder.toString());
                        CompilationStrategy _function = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"return this.");
                                _builder.append((Object)portName, "");
                                _builder.append((Object)";");
                                _builder.newLineIfNotEmpty();
                                return _builder;
                            }
                        };
                        it.setBody(_function);
                    }
                };
                annotatedClass.addMethod(portName, (Procedures.Procedure1)_function_1);
                boolean _or = false;
                boolean _isFunctionUnit = FunctionUnitProcessor.isFunctionUnit(FunctionUnitProcessor.this.mainAnnotation);
                _or = _isFunctionUnit ? true : (_isOperationUnit = FunctionUnitProcessor.this.isOperationUnit());
                if (_or) {
                    MutableInterfaceDeclaration interfaceType = context.findInterface(inputPortInterfaceName);
                    Iterable _implementedInterfaces = annotatedClass.getImplementedInterfaces();
                    TypeReference _newTypeReference = context.newTypeReference((Type)interfaceType, new TypeReference[0]);
                    Iterable _plus = Iterables.concat((Iterable)_implementedInterfaces, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_newTypeReference})));
                    annotatedClass.setImplementedInterfaces(_plus);
                    Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                        public void apply(MutableMethodDeclaration it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Implement this method to process input arriving via input port \"");
                            _builder.append((Object)portName, "");
                            _builder.append((Object)"\".");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"Message coming in has type \"");
                            _builder.append((Object)msgType, "");
                            _builder.append((Object)"\".");
                            _builder.newLineIfNotEmpty();
                            it.setDocComment(_builder.toString());
                            it.addParameter("msg", msgType);
                        }
                    };
                    interfaceType.addMethod(processInputMethodName, (Procedures.Procedure1)_function_2);
                }
            }
        };
        IterableExtensions.forEach(this.inputPortAnnotations, (Procedures.Procedure1)_function);
    }

    private void addOutputPorts(final MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

            public void apply(AnnotationReference outputPortAnnotation) {
                final String portName = FunctionUnitProcessor.portName(outputPortAnnotation);
                TypeReference _portType = FunctionUnitProcessor.portType(outputPortAnnotation);
                Type _type = _portType.getType();
                TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(outputPortAnnotation);
                final TypeReference msgType = context.newTypeReference(_type, _portTypeParameters);
                Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

                    public void apply(MutableFieldDeclaration it) {
                        it.setFinal(true);
                        it.setVisibility(Visibility.PRIVATE);
                        TypeReference _newTypeReference = context.newTypeReference(OutputPort.class, new TypeReference[]{msgType});
                        it.setType(_newTypeReference);
                        CompilationStrategy _function = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"new org.eclipse.xtext.xbase.lib.Functions.Function0<de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "");
                                _builder.append((Object)">>() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"public de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "    ");
                                _builder.append((Object)"> apply() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"org.eclipse.xtend2.lib.StringConcatenation _builder = new org.eclipse.xtend2.lib.StringConcatenation();");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"_builder.append(");
                                String _simpleName = annotatedClass.getSimpleName();
                                _builder.append((Object)_simpleName, "        ");
                                _builder.append((Object)".this, \"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"_builder.append(\".");
                                _builder.append((Object)portName, "        ");
                                _builder.append((Object)"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"final org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception> _function = new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception>() {");
                                _builder.newLine();
                                _builder.append((Object)"          ");
                                _builder.append((Object)"public void apply(final Exception it) {");
                                _builder.newLine();
                                _builder.append((Object)"            ");
                                String _simpleName_1 = annotatedClass.getSimpleName();
                                _builder.append((Object)_simpleName_1, "            ");
                                _builder.append((Object)".this.forwardIntegrationError(it);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"          ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"};");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "        ");
                                _builder.append((Object)"> _outputPort = new de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "        ");
                                _builder.append((Object)">(_builder.toString(), _function);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"return _outputPort;");
                                _builder.newLine();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"}.apply();");
                                _builder.newLine();
                                return _builder;
                            }
                        };
                        it.setInitializer(_function);
                    }
                };
                annotatedClass.addField(portName, (Procedures.Procedure1)_function);
                Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                    public void apply(MutableMethodDeclaration it) {
                        it.setFinal(true);
                        TypeReference _newTypeReference = context.newTypeReference(OutputPort.class, new TypeReference[]{msgType});
                        it.setReturnType(_newTypeReference);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"Output port '");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)"' of function unit '");
                        String _simpleName = annotatedClass.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)"', issues messages of ");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"type '");
                        _builder.append((Object)msgType, "");
                        _builder.append((Object)"' as computation result of this function unit.");
                        _builder.newLineIfNotEmpty();
                        it.setDocComment(_builder.toString());
                        CompilationStrategy _function = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"return this.");
                                _builder.append((Object)portName, "");
                                _builder.append((Object)";");
                                _builder.newLineIfNotEmpty();
                                return _builder;
                            }
                        };
                        it.setBody(_function);
                    }
                };
                annotatedClass.addMethod(portName, (Procedures.Procedure1)_function_1);
            }
        };
        IterableExtensions.forEach(this.outputPortAnnotations, (Procedures.Procedure1)_function);
    }

    private MutableMethodDeclaration addFlowOperators(MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        boolean _equals_1;
        boolean _equals;
        MutableMethodDeclaration _xblockexpression = null;
        int _size = IterableExtensions.size(this.inputPortAnnotations);
        boolean bl = _equals = _size == 1;
        if (_equals) {
            AnnotationReference _head = (AnnotationReference)IterableExtensions.head(this.inputPortAnnotations);
            final String portName = FunctionUnitProcessor.portName(_head);
            AnnotationReference _head_1 = (AnnotationReference)IterableExtensions.head(this.inputPortAnnotations);
            TypeReference _portType = FunctionUnitProcessor.portType(_head_1);
            Type _type = _portType.getType();
            AnnotationReference _head_2 = (AnnotationReference)IterableExtensions.head(this.inputPortAnnotations);
            TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(_head_2);
            final TypeReference msgType = context.newTypeReference(_type, _portTypeParameters);
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setFinal(true);
                    TypeReference _newTypeReference = context.newTypeReference(InputPort.class, new TypeReference[]{msgType});
                    it.setReturnType(_newTypeReference);
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"return this.");
                            _builder.append((Object)portName, "");
                            _builder.append((Object)";");
                            _builder.newLineIfNotEmpty();
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                }
            };
            annotatedClass.addMethod("theOneAndOnlyInputPort", (Procedures.Procedure1)_function);
            Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setFinal(true);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Flow DSL operator \"&lt;=\" for forwarding a message of type '");
                    String _name = msgType.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)"' value to ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"the one and only input port '");
                    _builder.append((Object)portName, "");
                    _builder.append((Object)"' for being processed.<br>");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"example:<pre> ");
                    _builder.newLine();
                    _builder.append((Object)"  ");
                    _builder.append((Object)"input <= \"some string\"");
                    _builder.newLine();
                    _builder.append((Object)"</pre>");
                    _builder.newLine();
                    it.setDocComment(_builder.toString());
                    String parameterVarName = "msg";
                    it.addParameter("msg", msgType);
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"this.");
                            _builder.append((Object)portName, "");
                            _builder.append((Object)".operator_lessEqualsThan(");
                            _builder.append((Object)"msg", "");
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                }
            };
            annotatedClass.addMethod("operator_lessEqualsThan", (Procedures.Procedure1)_function_1);
            Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setFinal(true);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Flow DSL operator \"&lt;=\" for forwarding a message value of type '");
                    String _name = msgType.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)"' to ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"the one and only input port '");
                    _builder.append((Object)portName, "");
                    _builder.append((Object)"' for being processed.<br>");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"For computing the message to be forwarded the right side closure is applied.");
                    _builder.newLine();
                    _builder.append((Object)"example:<pre> ");
                    _builder.newLine();
                    _builder.append((Object)"  ");
                    _builder.append((Object)"input &lt;= [ if (state&gt;0) \"some string\" else \"some other string\"");
                    _builder.newLine();
                    _builder.append((Object)"</pre>");
                    _builder.newLine();
                    it.setDocComment(_builder.toString());
                    String msgClosureVarName = "msgClosure";
                    TypeReference _newWildcardTypeReference = context.newWildcardTypeReference(msgType);
                    TypeReference _newTypeReference = context.newTypeReference(Functions.Function0.class, new TypeReference[]{_newWildcardTypeReference});
                    it.addParameter("msgClosure", _newTypeReference);
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)msgType, "");
                            _builder.append((Object)" _apply = ");
                            _builder.append((Object)"msgClosure", "");
                            _builder.append((Object)".apply();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"this.");
                            _builder.append((Object)portName, "");
                            _builder.append((Object)".operator_lessEqualsThan(_apply);");
                            _builder.newLineIfNotEmpty();
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                }
            };
            annotatedClass.addMethod("operator_lessEqualsThan", (Procedures.Procedure1)_function_2);
        }
        MutableMethodDeclaration _xifexpression = null;
        int _size_1 = IterableExtensions.size(this.outputPortAnnotations);
        boolean bl2 = _equals_1 = _size_1 == 1;
        if (_equals_1) {
            MutableMethodDeclaration _xblockexpression_1 = null;
            AnnotationReference _head_3 = (AnnotationReference)IterableExtensions.head(this.outputPortAnnotations);
            final String portName_1 = FunctionUnitProcessor.portName(_head_3);
            AnnotationReference _head_4 = (AnnotationReference)IterableExtensions.head(this.outputPortAnnotations);
            TypeReference _portType_1 = FunctionUnitProcessor.portType(_head_4);
            Type _type_1 = _portType_1.getType();
            AnnotationReference _head_5 = (AnnotationReference)IterableExtensions.head(this.outputPortAnnotations);
            TypeReference[] _portTypeParameters_1 = FunctionUnitProcessor.portTypeParameters(_head_5);
            final TypeReference msgType_1 = context.newTypeReference(_type_1, _portTypeParameters_1);
            Procedures.Procedure1<MutableMethodDeclaration> _function_3 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setFinal(true);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Flow DSL operator \"-&gt;\" for letting all message issued by the one and only output port '");
                    _builder.append((Object)portName_1, "");
                    _builder.append((Object)"' being ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"processed by the right side closure.");
                    _builder.newLine();
                    _builder.append((Object)"Typically this is used to process the message for a side effect like printing on standard out. ");
                    _builder.newLine();
                    _builder.append((Object)"example:<pre>");
                    _builder.newLine();
                    _builder.append((Object)"  ");
                    _builder.append((Object)"fu -&gt; [msg|println(\"message received: \" + msg\")]");
                    _builder.newLine();
                    _builder.append((Object)"</pre>");
                    _builder.newLine();
                    it.setDocComment(_builder.toString());
                    String msgProessingClosureVarName = "msgProcessingClosure";
                    TypeReference _newWildcardTypeReferenceWithLowerBound = context.newWildcardTypeReferenceWithLowerBound(msgType_1);
                    TypeReference operationType = context.newTypeReference(Procedures.Procedure1.class, new TypeReference[]{_newWildcardTypeReferenceWithLowerBound});
                    it.addParameter("msgProcessingClosure", operationType);
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"this.");
                            _builder.append((Object)portName_1, "");
                            _builder.append((Object)".operator_mappedTo(");
                            _builder.append((Object)"msgProcessingClosure", "");
                            _builder.append((Object)");");
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                }
            };
            annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function_3);
            Procedures.Procedure1<MutableMethodDeclaration> _function_4 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setFinal(true);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Flow DSL operator \"-&gt;\" for connecting two function units. ");
                    _builder.newLine();
                    _builder.append((Object)"Connects the left one function unit's one and only one output port '");
                    _builder.append((Object)portName_1, "");
                    _builder.append((Object)"' with ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"the right side funtion unit which has one and only one input port.<br>");
                    _builder.newLine();
                    _builder.append((Object)"example:<pre>");
                    _builder.newLine();
                    _builder.append((Object)"  ");
                    _builder.append((Object)"fu -&gt; fu'");
                    _builder.newLine();
                    _builder.append((Object)"</pre>");
                    _builder.newLine();
                    it.setDocComment(_builder.toString());
                    String rightSideFunctionUnitVarName = "rightSideFunctionUnit";
                    TypeReference _newTypeReference = context.newTypeReference(FunctionUnitWithOnlyOneInputPort.class, new TypeReference[]{msgType_1});
                    it.addParameter("rightSideFunctionUnit", _newTypeReference);
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"de.grammarcraft.xtend.flow.InputPort<");
                            _builder.append((Object)msgType_1, "");
                            _builder.append((Object)"> _theOneAndOnlyInputPort = ");
                            _builder.append((Object)"rightSideFunctionUnit", "");
                            _builder.append((Object)".theOneAndOnlyInputPort();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"org.eclipse.xtext.xbase.lib.Procedures.Procedure1<? super ");
                            _builder.append((Object)msgType_1, "");
                            _builder.append((Object)"> _inputProcessingOperation = _theOneAndOnlyInputPort.inputProcessingOperation();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"this.");
                            _builder.append((Object)portName_1, "");
                            _builder.append((Object)".operator_mappedTo(_inputProcessingOperation);");
                            _builder.newLineIfNotEmpty();
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                }
            };
            annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function_4);
            Procedures.Procedure1<MutableMethodDeclaration> _function_5 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setFinal(true);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Flow DSL operator \"-&gt;\" for connecting two function units. ");
                    _builder.newLine();
                    _builder.append((Object)"Connects the left one function unit's one and only one output port '");
                    _builder.append((Object)portName_1, "");
                    _builder.append((Object)"' with ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"the right side function unit's named input port.<br>");
                    _builder.newLine();
                    _builder.append((Object)"example:<pre>");
                    _builder.newLine();
                    _builder.append((Object)"  ");
                    _builder.append((Object)"fu -&gt; fu'.input");
                    _builder.newLine();
                    _builder.append((Object)"</pre>");
                    _builder.newLine();
                    it.setDocComment(_builder.toString());
                    String rightSideFunctionUnitInputPortVarName = "rightSideFunctionUnitInputPort";
                    TypeReference _newTypeReference = context.newTypeReference(InputPort.class, new TypeReference[]{msgType_1});
                    it.addParameter("rightSideFunctionUnitInputPort", _newTypeReference);
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"this.");
                            _builder.append((Object)portName_1, "");
                            _builder.append((Object)".operator_mappedTo(");
                            _builder.append((Object)"rightSideFunctionUnitInputPort", "");
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                }
            };
            annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function_5);
            Procedures.Procedure1<MutableMethodDeclaration> _function_6 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setFinal(true);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Flow DSL operator \"-&gt;\" for connecting two function units. ");
                    _builder.newLine();
                    _builder.append((Object)"Connects the left side function unit's one and only one output port '");
                    _builder.append((Object)portName_1, "");
                    _builder.append((Object)"' with ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"the right side function unit's named output port.<br>");
                    _builder.newLine();
                    _builder.append((Object)"This is normally only used in integrating function units for connecting an integrated function unit with");
                    _builder.newLine();
                    _builder.append((Object)"an output port of the integrating function unit.");
                    _builder.newLine();
                    _builder.append((Object)"example:<pre>");
                    _builder.newLine();
                    _builder.append((Object)"  ");
                    _builder.append((Object)"fu -&gt; output");
                    _builder.newLine();
                    _builder.append((Object)"</pre>");
                    _builder.newLine();
                    it.setDocComment(_builder.toString());
                    String rightSideFunctionUnitOutputPortVarName = "rightSideFunctionUnitOutputPort";
                    TypeReference _newTypeReference = context.newTypeReference(OutputPort.class, new TypeReference[]{msgType_1});
                    it.addParameter("rightSideFunctionUnitOutputPort", _newTypeReference);
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"this.");
                            _builder.append((Object)portName_1, "");
                            _builder.append((Object)".operator_mappedTo(");
                            _builder.append((Object)"rightSideFunctionUnitOutputPort", "");
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                }
            };
            _xifexpression = _xblockexpression_1 = annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function_6);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

