/*
 * Decompiled with CFR 0.152.
 */
package de.grammarcraft.xtend.flow;

import com.google.common.base.Objects;
import de.grammarcraft.xtend.flow.FunctionUnitWithOnlyOneInputPort;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class InputPort<MessageType> {
    private final String name;
    private final Procedures.Procedure1<? super MessageType> processInputOperation;
    private final List<Procedures.Procedure1<? super MessageType>> inputOperations = new ArrayList<Procedures.Procedure1<? super MessageType>>();
    private final Procedures.Procedure1<? super Exception> integrationErrorOperation;

    public InputPort(String name, Procedures.Procedure1<? super MessageType> processInputOperation, Procedures.Procedure1<? super Exception> integrationErrorOperation) {
        this.name = name;
        this.processInputOperation = processInputOperation;
        this.integrationErrorOperation = integrationErrorOperation;
    }

    public InputPort(String name, Procedures.Procedure1<? super Exception> integrationErrorOperation) {
        Procedures.Procedure1 _function;
        this.name = name;
        this.processInputOperation = _function = new Procedures.Procedure1<MessageType>(){

            public void apply(MessageType it) {
                InputPort.this.forward(it);
            }
        };
        this.integrationErrorOperation = integrationErrorOperation;
    }

    private void forward(final MessageType msg) {
        boolean _not;
        boolean _isEmpty = this.inputOperations.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1 _function = new Procedures.Procedure1<Procedures.Procedure1<? super MessageType>>(){

                public void apply(Procedures.Procedure1<? super MessageType> operation) {
                    operation.apply(msg);
                }
            };
            IterableExtensions.forEach(this.inputOperations, (Procedures.Procedure1)_function);
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"no binding defined for '");
            _builder.append((Object)this, "");
            _builder.append((Object)"' - message '");
            _builder.append(msg, "");
            _builder.append((Object)"' could not be delivered.");
            RuntimeException _runtimeException = new RuntimeException(_builder.toString());
            this.integrationErrorOperation.apply((Object)_runtimeException);
        }
    }

    public String toString() {
        return this.name;
    }

    private void processInput(MessageType msg) {
        boolean _equals = Objects.equal(this.processInputOperation, null);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"no binding defined for '");
            _builder.append((Object)this, "");
            _builder.append((Object)"' - message '");
            _builder.append(msg, "");
            _builder.append((Object)"' could not be processed.");
            RuntimeException _runtimeException = new RuntimeException(_builder.toString());
            this.integrationErrorOperation.apply((Object)_runtimeException);
        } else {
            this.processInputOperation.apply(msg);
        }
    }

    public void operator_lessEqualsThan(MessageType msg) {
        this.processInput(msg);
    }

    public void operator_lessEqualsThan(Functions.Function0<? extends MessageType> msgClosure) {
        Object _apply = msgClosure.apply();
        this.processInput(_apply);
    }

    public Procedures.Procedure1<? super MessageType> inputProcessingOperation() {
        return this.processInputOperation;
    }

    public void operator_mappedTo(InputPort<MessageType> integratedInputPort) {
        Procedures.Procedure1<MessageType> _inputProcessingOperation = integratedInputPort.inputProcessingOperation();
        this.inputOperations.add(_inputProcessingOperation);
    }

    public void operator_mappedTo(FunctionUnitWithOnlyOneInputPort<MessageType> integratedFunctionUnit) {
        InputPort<MessageType> _theOneAndOnlyInputPort = integratedFunctionUnit.theOneAndOnlyInputPort();
        Procedures.Procedure1<MessageType> _inputProcessingOperation = _theOneAndOnlyInputPort.inputProcessingOperation();
        this.inputOperations.add(_inputProcessingOperation);
    }
}

