/**
 * Copyright (c) 2014 Denis Kuniss (http://www.grammarcraft.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package de.grammarcraft.xtend.flow;

import de.grammarcraft.xtend.flow.IFunctionUnit;
import de.grammarcraft.xtend.flow.OutputPort;
import java.util.List;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public abstract class IntegrationErrorHandling {
  public static void onIntegrationErrorAt(final List<? extends IFunctionUnit> functionUnits, final Procedure1<? super Exception> errorOperation) {
    final Procedure1<IFunctionUnit> _function = new Procedure1<IFunctionUnit>() {
      @Override
      public void apply(final IFunctionUnit it) {
        OutputPort<Exception> _integrationError = it.integrationError();
        _integrationError.operator_mappedTo(errorOperation);
      }
    };
    IterableExtensions.forEach(functionUnits, _function);
  }
}
