package de.grammarcraft.xtend.flow;

import de.grammarcraft.xtend.flow.InputPort;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

/**
 * Marks an function unit as having one and only one input port.<br>
 * This input port is returned by the dedicated interface method.
 */
@SuppressWarnings("all")
public interface FunctionUnitWithOnlyOneInputPort<MessageType extends Object> {
  /**
   * @return the one and only {@link InputPort}
   */
  public abstract InputPort<MessageType> theOneAndOnlyInputPort();
  
  /**
   * Flow DSL operator "&lt;=" for forwarding a message value to the one and only input port for being processed.<br>
   * example:<pre>
   *   input <= "some string"
   * </pre>
   * @param msg the message to be forwarded
   */
  public abstract void operator_lessEqualsThan(final MessageType msg);
  
  /**
   * Flow DSL operator "&lt;=" for forwarding a message value to the one and only input port for being processed.<br>
   * example:<pre>
   *   input &lt;= [ if (state&gt;0) "some string" else "some other string"
   * </pre>
   * @param msgClosure the closure to be applied to compute the message to be forwarded
   */
  public abstract void operator_lessEqualsThan(final Function0<? extends MessageType> msgClosure);
}
