/*
 * Decompiled with CFR 0.152.
 */
package de.grammarcraft.xtend.flow.annotations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.grammarcraft.xtend.flow.FunctionUnitBase;
import de.grammarcraft.xtend.flow.OutputPort;
import de.grammarcraft.xtend.flow.annotations.Wiring;
import java.util.Collections;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FunctionUnitProcessor
extends AbstractClassProcessor {
    private Iterable<? extends AnnotationReference> inputPortAnnotations;
    private Iterable<? extends AnnotationReference> outputPortAnnotations;
    private Iterable<? extends AnnotationReference> doubledInputAnnotations;
    private Iterable<? extends AnnotationReference> doubledOutputAnnotations;
    private Object inputPortAnnotationArgument;
    private Object outputPortAnnotationArgument;

    public void doRegisterGlobals(final ClassDeclaration annotatedClass, final RegisterGlobalsContext context) {
        boolean _equals_1;
        boolean _equals;
        Iterable _annotations = annotatedClass.getAnnotations();
        AnnotationReference _findFirst = null;
        if (_annotations != null) {
            Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                public Boolean apply(AnnotationReference it) {
                    AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                    String _simpleName = _annotationTypeDeclaration.getSimpleName();
                    return Objects.equal((Object)_simpleName, (Object)"FunctionUnit");
                }
            };
            _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)_function);
        }
        AnnotationReference functionUnitAnnotation = _findFirst;
        Object _value = null;
        if (functionUnitAnnotation != null) {
            _value = functionUnitAnnotation.getValue("inputPorts");
        }
        this.inputPortAnnotationArgument = _value;
        Class<?> _class = null;
        if (this.inputPortAnnotationArgument != null) {
            _class = this.inputPortAnnotationArgument.getClass();
        }
        if (_equals = Objects.equal(_class, AnnotationReference[].class)) {
            this.inputPortAnnotations = (Iterable)Conversions.doWrapArray((Object)((AnnotationReference[])this.inputPortAnnotationArgument));
            Iterable<? extends AnnotationReference> _doubledAnnotations = FunctionUnitProcessor.doubledAnnotations(this.inputPortAnnotations);
            this.doubledInputAnnotations = _doubledAnnotations;
            boolean _isEmpty = IterableExtensions.isEmpty(this.doubledInputAnnotations);
            if (_isEmpty) {
                Procedures.Procedure1<AnnotationReference> _function_1 = new Procedures.Procedure1<AnnotationReference>(){

                    public void apply(AnnotationReference inputPortAnnotation) {
                        String _inputPortInterfaceName = FunctionUnitProcessor.getInputPortInterfaceName(annotatedClass, inputPortAnnotation);
                        context.registerInterface(_inputPortInterfaceName);
                    }
                };
                IterableExtensions.forEach(this.inputPortAnnotations, (Procedures.Procedure1)_function_1);
            }
        }
        Object _value_1 = null;
        if (functionUnitAnnotation != null) {
            _value_1 = functionUnitAnnotation.getValue("outputPorts");
        }
        this.outputPortAnnotationArgument = _value_1;
        Class<?> _class_1 = null;
        if (this.outputPortAnnotationArgument != null) {
            _class_1 = this.outputPortAnnotationArgument.getClass();
        }
        if (_equals_1 = Objects.equal(_class_1, AnnotationReference[].class)) {
            this.outputPortAnnotations = (Iterable)Conversions.doWrapArray((Object)((AnnotationReference[])this.outputPortAnnotationArgument));
            Iterable<? extends AnnotationReference> _doubledAnnotations_1 = FunctionUnitProcessor.doubledAnnotations(this.outputPortAnnotations);
            this.doubledOutputAnnotations = _doubledAnnotations_1;
        }
    }

    private static String getInputPortInterfaceName(ClassDeclaration annotatedClass, AnnotationReference inputPortAnnotation) {
        StringConcatenation _builder = new StringConcatenation();
        String _qualifiedName = annotatedClass.getQualifiedName();
        _builder.append((Object)_qualifiedName, "");
        _builder.append((Object)"_InputPort_");
        String _portName = FunctionUnitProcessor.portName(inputPortAnnotation);
        _builder.append((Object)_portName, "");
        return _builder.toString();
    }

    private static String portName(AnnotationReference annotationReference) {
        Object _value = annotationReference.getValue("name");
        return ((String)_value).trim();
    }

    private static TypeReference portType(AnnotationReference annotationReference) {
        Object _value = annotationReference.getValue("type");
        return (TypeReference)_value;
    }

    private static TypeReference[] portTypeParameters(AnnotationReference annotationReference) {
        Object _value = annotationReference.getValue("typeArguments");
        return (TypeReference[])_value;
    }

    private static Iterable<? extends AnnotationReference> doubledAnnotations(final Iterable<? extends AnnotationReference> portAnnotations) {
        Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                return FunctionUnitProcessor.doubledAnnotation(it, portAnnotations);
            }
        };
        return IterableExtensions.filter(portAnnotations, (Functions.Function1)_function);
    }

    private static boolean doubledAnnotation(final AnnotationReference portAnnotation, Iterable<? extends AnnotationReference> portAnnotations) {
        Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                String _portName = FunctionUnitProcessor.portName(it);
                String _portName_1 = FunctionUnitProcessor.portName(portAnnotation);
                return Objects.equal((Object)_portName, (Object)_portName_1);
            }
        };
        Iterable _filter = IterableExtensions.filter(portAnnotations, (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)_filter);
        return _size > 1;
    }

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        boolean hasContextErrors = false;
        boolean _checkForContextErrors = this.checkForContextErrors(context, annotatedClass);
        hasContextErrors = _checkForContextErrors;
        if (hasContextErrors) {
            context.addWarning((Element)annotatedClass, "due to port annotation errors, no code can be generated");
            return;
        }
        this.checkForContextWarnings(context, annotatedClass);
        TypeReference _newTypeReference = context.newTypeReference(FunctionUnitBase.class, new TypeReference[0]);
        annotatedClass.setExtendedClass(_newTypeReference);
        annotatedClass.setFinal(true);
        FunctionUnitProcessor.extendConstructor(annotatedClass, context);
        this.addInputPorts(annotatedClass, context);
        this.addOutputPorts(annotatedClass, context);
    }

    private boolean checkForContextErrors(final @Extension TransformationContext context, final MutableClassDeclaration annotatedClass) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean contextError = false;
        Class<?> _class = null;
        if (this.inputPortAnnotationArgument != null) {
            _class = this.inputPortAnnotationArgument.getClass();
        }
        boolean bl = _notEquals = !Objects.equal(_class, AnnotationReference[].class);
        if (_notEquals) {
            context.addError((Element)annotatedClass, "array of input port annotations expected");
            contextError = true;
        }
        Class<?> _class_1 = null;
        if (this.outputPortAnnotationArgument != null) {
            _class_1 = this.outputPortAnnotationArgument.getClass();
        }
        boolean bl2 = _notEquals_1 = !Objects.equal(_class_1, AnnotationReference[].class);
        if (_notEquals_1) {
            context.addError((Element)annotatedClass, "array of output port annotations expected");
            contextError = true;
        }
        if (contextError) {
            return true;
        }
        boolean _isEmpty = IterableExtensions.isEmpty(this.doubledInputAnnotations);
        boolean bl3 = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

                public void apply(AnnotationReference it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"input port \"");
                    String _portName = FunctionUnitProcessor.portName(it);
                    _builder.append((Object)_portName, "");
                    _builder.append((Object)"\" is declared twice");
                    context.addError((Element)annotatedClass, _builder.toString());
                }
            };
            IterableExtensions.forEach(this.doubledInputAnnotations, (Procedures.Procedure1)_function);
            contextError = true;
        }
        boolean bl4 = _not_1 = !(_isEmpty_1 = IterableExtensions.isEmpty(this.doubledOutputAnnotations));
        if (_not_1) {
            Procedures.Procedure1<AnnotationReference> _function_1 = new Procedures.Procedure1<AnnotationReference>(){

                public void apply(AnnotationReference it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"output port \"");
                    String _portName = FunctionUnitProcessor.portName(it);
                    _builder.append((Object)_portName, "");
                    _builder.append((Object)"\" is declared twice");
                    context.addError((Element)annotatedClass, _builder.toString());
                }
            };
            IterableExtensions.forEach(this.doubledOutputAnnotations, (Procedures.Procedure1)_function_1);
            contextError = true;
        }
        return contextError;
    }

    private void checkForContextWarnings(@Extension TransformationContext context, MutableClassDeclaration annotatedClass) {
        boolean _isEmpty_1;
        boolean _isEmpty = IterableExtensions.isEmpty(this.inputPortAnnotations);
        if (_isEmpty) {
            context.addWarning((Element)annotatedClass, "no input port defined");
        }
        if (_isEmpty_1 = IterableExtensions.isEmpty(this.outputPortAnnotations)) {
            context.addWarning((Element)annotatedClass, "no output port defined");
        }
    }

    private static MutableConstructorDeclaration extendConstructor(final MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        Iterable _declaredConstructors;
        boolean _isEmpty;
        MutableMethodDeclaration wiringMethod;
        boolean _greaterThan;
        Functions.Function1<MutableMethodDeclaration, Boolean> _function;
        MutableConstructorDeclaration _xblockexpression = null;
        Iterable _declaredMethods = annotatedClass.getDeclaredMethods();
        Iterable wiringMethods = IterableExtensions.filter((Iterable)_declaredMethods, (Functions.Function1)(_function = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

            public Boolean apply(MutableMethodDeclaration it) {
                Iterable _annotations = it.getAnnotations();
                Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

                    public Boolean apply(AnnotationReference it) {
                        AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                        String _simpleName = _annotationTypeDeclaration.getSimpleName();
                        String _simpleName_1 = Wiring.class.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)_simpleName_1);
                    }
                };
                return IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)_function);
            }
        }));
        int _size = IterableExtensions.size((Iterable)wiringMethods);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    context.addWarning((Element)it, "only one method may be marked with @Wiring annotation");
                }
            };
            IterableExtensions.forEach((Iterable)wiringMethods, (Procedures.Procedure1)_function_1);
        }
        if ((wiringMethod = (MutableMethodDeclaration)IterableExtensions.head((Iterable)wiringMethods)) != null) {
            wiringMethod.markAsRead();
        }
        boolean hasConstructorsDeclared = !(_isEmpty = IterableExtensions.isEmpty((Iterable)(_declaredConstructors = annotatedClass.getDeclaredConstructors())));
        MutableConstructorDeclaration _xifexpression = null;
        if (hasConstructorsDeclared) {
            Iterable _declaredConstructors_1 = annotatedClass.getDeclaredConstructors();
            Procedures.Procedure1<MutableConstructorDeclaration> _function_2 = new Procedures.Procedure1<MutableConstructorDeclaration>(){

                public void apply(MutableConstructorDeclaration it) {
                    final Expression oldBody = it.getBody();
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            boolean _notEquals;
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"super(\"");
                            String _simpleName = annotatedClass.getSimpleName();
                            _builder.append((Object)_simpleName, "");
                            _builder.append((Object)"\");");
                            _builder.newLineIfNotEmpty();
                            boolean bl = _notEquals = !Objects.equal((Object)wiringMethod, null);
                            if (_notEquals) {
                                String _simpleName_1 = wiringMethod.getSimpleName();
                                _builder.append((Object)_simpleName_1, "");
                                _builder.append((Object)"();");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"// currently there is no way in xtend to insert generated java code (generated from xtend constructor code)");
                            _builder.newLine();
                            _builder.append((Object)"// therefore the following is xtend code and must be like native Java code (e.g. having semicolons) to avoid java compiler errors");
                            _builder.newLine();
                            _builder.append((Object)oldBody, "");
                            _builder.newLineIfNotEmpty();
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                }
            };
            IterableExtensions.forEach((Iterable)_declaredConstructors_1, (Procedures.Procedure1)_function_2);
        } else {
            Procedures.Procedure1<MutableConstructorDeclaration> _function_3 = new Procedures.Procedure1<MutableConstructorDeclaration>(){

                public void apply(MutableConstructorDeclaration it) {
                    CompilationStrategy _function = new CompilationStrategy(){

                        public CharSequence compile(CompilationStrategy.CompilationContext it) {
                            boolean _notEquals;
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"super(\"");
                            String _simpleName = annotatedClass.getSimpleName();
                            _builder.append((Object)_simpleName, "");
                            _builder.append((Object)"\");");
                            _builder.newLineIfNotEmpty();
                            boolean bl = _notEquals = !Objects.equal((Object)wiringMethod, null);
                            if (_notEquals) {
                                String _simpleName_1 = wiringMethod.getSimpleName();
                                _builder.append((Object)_simpleName_1, "");
                                _builder.append((Object)"();");
                            }
                            _builder.newLineIfNotEmpty();
                            return _builder;
                        }
                    };
                    it.setBody(_function);
                }
            };
            _xifexpression = annotatedClass.addConstructor((Procedures.Procedure1)_function_3);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private void addInputPorts(final MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

            public void apply(AnnotationReference inputPortAnnotation) {
                boolean _equals;
                final String portName = FunctionUnitProcessor.portName(inputPortAnnotation);
                String inputPortInterfaceName = FunctionUnitProcessor.getInputPortInterfaceName((ClassDeclaration)annotatedClass, inputPortAnnotation);
                TypeReference _portType = FunctionUnitProcessor.portType(inputPortAnnotation);
                Type _type = _portType.getType();
                TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(inputPortAnnotation);
                final TypeReference msgType = context.newTypeReference(_type, _portTypeParameters);
                Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

                    public void apply(MutableFieldDeclaration it) {
                        it.setFinal(true);
                        it.setVisibility(Visibility.PUBLIC);
                        TypeReference _newWildcardTypeReferenceWithLowerBound = context.newWildcardTypeReferenceWithLowerBound(msgType);
                        TypeReference _newTypeReference = context.newTypeReference(Procedures.Procedure1.class, new TypeReference[]{_newWildcardTypeReferenceWithLowerBound});
                        it.setType(_newTypeReference);
                        CompilationStrategy _function = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"new org.eclipse.xtext.xbase.lib.Functions.Function0<org.eclipse.xtext.xbase.lib.Procedures.Procedure1<? super ");
                                _builder.append((Object)msgType, "");
                                _builder.append((Object)">>() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"public org.eclipse.xtext.xbase.lib.Procedures.Procedure1<? super ");
                                _builder.append((Object)msgType, "    ");
                                _builder.append((Object)"> apply() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"      ");
                                _builder.append((Object)"final org.eclipse.xtext.xbase.lib.Procedures.Procedure1<");
                                _builder.append((Object)msgType, "      ");
                                _builder.append((Object)"> _function = new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<");
                                _builder.append((Object)msgType, "      ");
                                _builder.append((Object)">() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"public void apply(final ");
                                _builder.append((Object)msgType, "        ");
                                _builder.append((Object)" msg) {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"          ");
                                String _simpleName = annotatedClass.getSimpleName();
                                _builder.append((Object)_simpleName, "          ");
                                _builder.append((Object)".this.");
                                _builder.append((Object)portName, "          ");
                                _builder.append((Object)"(msg);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"      ");
                                _builder.append((Object)"};");
                                _builder.newLine();
                                _builder.append((Object)"      ");
                                _builder.append((Object)"return _function;");
                                _builder.newLine();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"}.apply();");
                                _builder.newLine();
                                return _builder;
                            }
                        };
                        it.setInitializer(_function);
                    }
                };
                annotatedClass.addField(portName, (Procedures.Procedure1)_function);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"process");
                String _firstUpper = StringExtensions.toFirstUpper((String)portName);
                _builder.append((Object)_firstUpper, "");
                final String processInputMethodName = _builder.toString();
                String msgParameterName = "msg";
                Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                    public void apply(MutableMethodDeclaration it) {
                        it.setFinal(true);
                        it.addParameter("msg", msgType);
                        CompilationStrategy _function = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)processInputMethodName, "");
                                _builder.append((Object)"(");
                                _builder.append((Object)"msg", "");
                                _builder.append((Object)");");
                                return _builder;
                            }
                        };
                        it.setBody(_function);
                    }
                };
                annotatedClass.addMethod(portName, (Procedures.Procedure1)_function_1);
                MutableInterfaceDeclaration interfaceType = context.findInterface(inputPortInterfaceName);
                Iterable _implementedInterfaces = annotatedClass.getImplementedInterfaces();
                TypeReference _newTypeReference = context.newTypeReference((Type)interfaceType, new TypeReference[0]);
                Iterable _plus = Iterables.concat((Iterable)_implementedInterfaces, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_newTypeReference})));
                annotatedClass.setImplementedInterfaces(_plus);
                Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                    public void apply(MutableMethodDeclaration it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"Implement this method to process input arriving via input port \"");
                        _builder.append((Object)portName, "");
                        _builder.append((Object)"\".");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"Message coming in have type \"");
                        _builder.append((Object)msgType, "");
                        _builder.append((Object)"\".");
                        _builder.newLineIfNotEmpty();
                        it.setDocComment(_builder.toString());
                        it.addParameter("msg", msgType);
                    }
                };
                interfaceType.addMethod(processInputMethodName, (Procedures.Procedure1)_function_2);
                int _size = IterableExtensions.size((Iterable)FunctionUnitProcessor.this.inputPortAnnotations);
                boolean bl = _equals = _size == 1;
                if (_equals) {
                    Procedures.Procedure1<MutableMethodDeclaration> _function_3 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                        public void apply(MutableMethodDeclaration it) {
                            TypeReference _newWildcardTypeReferenceWithLowerBound = context.newWildcardTypeReferenceWithLowerBound(msgType);
                            TypeReference _newTypeReference = context.newTypeReference(Procedures.Procedure1.class, new TypeReference[]{_newWildcardTypeReferenceWithLowerBound});
                            it.setReturnType(_newTypeReference);
                            CompilationStrategy _function = new CompilationStrategy(){

                                public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                    StringConcatenation _builder = new StringConcatenation();
                                    _builder.append((Object)"return this.");
                                    _builder.append((Object)portName, "");
                                    _builder.append((Object)";");
                                    _builder.newLineIfNotEmpty();
                                    return _builder;
                                }
                            };
                            it.setBody(_function);
                        }
                    };
                    annotatedClass.addMethod("getTheOneAndOnlyInputPort", (Procedures.Procedure1)_function_3);
                }
            }
        };
        IterableExtensions.forEach(this.inputPortAnnotations, (Procedures.Procedure1)_function);
    }

    private void addOutputPorts(final MutableClassDeclaration annotatedClass, final @Extension TransformationContext context) {
        Procedures.Procedure1<AnnotationReference> _function = new Procedures.Procedure1<AnnotationReference>(){

            public void apply(AnnotationReference outputPortAnnotation) {
                boolean _equals;
                final String portName = FunctionUnitProcessor.portName(outputPortAnnotation);
                TypeReference _portType = FunctionUnitProcessor.portType(outputPortAnnotation);
                Type _type = _portType.getType();
                TypeReference[] _portTypeParameters = FunctionUnitProcessor.portTypeParameters(outputPortAnnotation);
                final TypeReference msgType = context.newTypeReference(_type, _portTypeParameters);
                Procedures.Procedure1<MutableFieldDeclaration> _function = new Procedures.Procedure1<MutableFieldDeclaration>(){

                    public void apply(MutableFieldDeclaration it) {
                        it.setFinal(true);
                        it.setVisibility(Visibility.PUBLIC);
                        TypeReference _newTypeReference = context.newTypeReference(OutputPort.class, new TypeReference[]{msgType});
                        it.setType(_newTypeReference);
                        CompilationStrategy _function = new CompilationStrategy(){

                            public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"new org.eclipse.xtext.xbase.lib.Functions.Function0<de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "");
                                _builder.append((Object)">>() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"public de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "    ");
                                _builder.append((Object)"> apply() {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"org.eclipse.xtend2.lib.StringConcatenation _builder = new org.eclipse.xtend2.lib.StringConcatenation();");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"_builder.append(");
                                String _simpleName = annotatedClass.getSimpleName();
                                _builder.append((Object)_simpleName, "        ");
                                _builder.append((Object)".this, \"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"_builder.append(\".");
                                _builder.append((Object)portName, "        ");
                                _builder.append((Object)"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"final org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception> _function = new org.eclipse.xtext.xbase.lib.Procedures.Procedure1<Exception>() {");
                                _builder.newLine();
                                _builder.append((Object)"          ");
                                _builder.append((Object)"public void apply(final Exception it) {");
                                _builder.newLine();
                                _builder.append((Object)"            ");
                                String _simpleName_1 = annotatedClass.getSimpleName();
                                _builder.append((Object)_simpleName_1, "            ");
                                _builder.append((Object)".this.forwardIntegrationError(it);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"          ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"};");
                                _builder.newLine();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "        ");
                                _builder.append((Object)"> _outputPort = new de.grammarcraft.xtend.flow.OutputPort<");
                                _builder.append((Object)msgType, "        ");
                                _builder.append((Object)">(_builder.toString(), _function);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"        ");
                                _builder.append((Object)"return _outputPort;");
                                _builder.newLine();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"}.apply();");
                                _builder.newLine();
                                return _builder;
                            }
                        };
                        it.setInitializer(_function);
                    }
                };
                annotatedClass.addField(portName, (Procedures.Procedure1)_function);
                int _size = IterableExtensions.size((Iterable)FunctionUnitProcessor.this.outputPortAnnotations);
                boolean bl = _equals = _size == 1;
                if (_equals) {
                    Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                        public void apply(MutableMethodDeclaration it) {
                            TypeReference _newWildcardTypeReferenceWithLowerBound = context.newWildcardTypeReferenceWithLowerBound(msgType);
                            TypeReference operationType = context.newTypeReference(Procedures.Procedure1.class, new TypeReference[]{_newWildcardTypeReferenceWithLowerBound});
                            it.addParameter("operation", operationType);
                            CompilationStrategy _function = new CompilationStrategy(){

                                public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                    StringConcatenation _builder = new StringConcatenation();
                                    _builder.append((Object)"this.");
                                    _builder.append((Object)portName, "");
                                    _builder.append((Object)".operator_mappedTo(operation);");
                                    return _builder;
                                }
                            };
                            it.setBody(_function);
                        }
                    };
                    annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function_1);
                    Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                        public void apply(MutableMethodDeclaration it) {
                            TypeReference _newTypeReference = context.newTypeReference(FunctionUnitBase.class, new TypeReference[0]);
                            it.addParameter("fu", _newTypeReference);
                            CompilationStrategy _function = new CompilationStrategy(){

                                public CharSequence compile(CompilationStrategy.CompilationContext it) {
                                    StringConcatenation _builder = new StringConcatenation();
                                    _builder.append((Object)"this.");
                                    _builder.append((Object)portName, "");
                                    _builder.append((Object)".operator_mappedTo(fu.<");
                                    _builder.append((Object)msgType, "");
                                    _builder.append((Object)">getTheOneAndOnlyInputPort());");
                                    return _builder;
                                }
                            };
                            it.setBody(_function);
                        }
                    };
                    annotatedClass.addMethod("operator_mappedTo", (Procedures.Procedure1)_function_2);
                }
            }
        };
        IterableExtensions.forEach(this.outputPortAnnotations, (Procedures.Procedure1)_function);
    }
}

